/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.detective.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details on the criteria used to define the filter for investigation results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FilterCriteria implements SdkPojo, Serializable, ToCopyableBuilder<FilterCriteria.Builder, FilterCriteria> {
    private static final SdkField<StringFilter> SEVERITY_FIELD = SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
            .memberName("Severity").getter(getter(FilterCriteria::severity)).setter(setter(Builder::severity))
            .constructor(StringFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()).build();

    private static final SdkField<StringFilter> STATUS_FIELD = SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
            .memberName("Status").getter(getter(FilterCriteria::status)).setter(setter(Builder::status))
            .constructor(StringFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<StringFilter> STATE_FIELD = SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
            .memberName("State").getter(getter(FilterCriteria::state)).setter(setter(Builder::state))
            .constructor(StringFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<StringFilter> ENTITY_ARN_FIELD = SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
            .memberName("EntityArn").getter(getter(FilterCriteria::entityArn)).setter(setter(Builder::entityArn))
            .constructor(StringFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityArn").build()).build();

    private static final SdkField<DateFilter> CREATED_TIME_FIELD = SdkField.<DateFilter> builder(MarshallingType.SDK_POJO)
            .memberName("CreatedTime").getter(getter(FilterCriteria::createdTime)).setter(setter(Builder::createdTime))
            .constructor(DateFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEVERITY_FIELD, STATUS_FIELD,
            STATE_FIELD, ENTITY_ARN_FIELD, CREATED_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final StringFilter severity;

    private final StringFilter status;

    private final StringFilter state;

    private final StringFilter entityArn;

    private final DateFilter createdTime;

    private FilterCriteria(BuilderImpl builder) {
        this.severity = builder.severity;
        this.status = builder.status;
        this.state = builder.state;
        this.entityArn = builder.entityArn;
        this.createdTime = builder.createdTime;
    }

    /**
     * <p>
     * Filter the investigation results based on the severity.
     * </p>
     * 
     * @return Filter the investigation results based on the severity.
     */
    public final StringFilter severity() {
        return severity;
    }

    /**
     * <p>
     * Filter the investigation results based on the status.
     * </p>
     * 
     * @return Filter the investigation results based on the status.
     */
    public final StringFilter status() {
        return status;
    }

    /**
     * <p>
     * Filter the investigation results based on the state.
     * </p>
     * 
     * @return Filter the investigation results based on the state.
     */
    public final StringFilter state() {
        return state;
    }

    /**
     * <p>
     * Filter the investigation results based on the Amazon Resource Name (ARN) of the entity.
     * </p>
     * 
     * @return Filter the investigation results based on the Amazon Resource Name (ARN) of the entity.
     */
    public final StringFilter entityArn() {
        return entityArn;
    }

    /**
     * <p>
     * Filter the investigation results based on when the investigation was created.
     * </p>
     * 
     * @return Filter the investigation results based on when the investigation was created.
     */
    public final DateFilter createdTime() {
        return createdTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(severity());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(entityArn());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterCriteria)) {
            return false;
        }
        FilterCriteria other = (FilterCriteria) obj;
        return Objects.equals(severity(), other.severity()) && Objects.equals(status(), other.status())
                && Objects.equals(state(), other.state()) && Objects.equals(entityArn(), other.entityArn())
                && Objects.equals(createdTime(), other.createdTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FilterCriteria").add("Severity", severity()).add("Status", status()).add("State", state())
                .add("EntityArn", entityArn()).add("CreatedTime", createdTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Severity":
            return Optional.ofNullable(clazz.cast(severity()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "EntityArn":
            return Optional.ofNullable(clazz.cast(entityArn()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Severity", SEVERITY_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("State", STATE_FIELD);
        map.put("EntityArn", ENTITY_ARN_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FilterCriteria, T> g) {
        return obj -> g.apply((FilterCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FilterCriteria> {
        /**
         * <p>
         * Filter the investigation results based on the severity.
         * </p>
         * 
         * @param severity
         *        Filter the investigation results based on the severity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severity(StringFilter severity);

        /**
         * <p>
         * Filter the investigation results based on the severity.
         * </p>
         * This is a convenience method that creates an instance of the {@link StringFilter.Builder} avoiding the need
         * to create one manually via {@link StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StringFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #severity(StringFilter)}.
         * 
         * @param severity
         *        a consumer that will call methods on {@link StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #severity(StringFilter)
         */
        default Builder severity(Consumer<StringFilter.Builder> severity) {
            return severity(StringFilter.builder().applyMutation(severity).build());
        }

        /**
         * <p>
         * Filter the investigation results based on the status.
         * </p>
         * 
         * @param status
         *        Filter the investigation results based on the status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(StringFilter status);

        /**
         * <p>
         * Filter the investigation results based on the status.
         * </p>
         * This is a convenience method that creates an instance of the {@link StringFilter.Builder} avoiding the need
         * to create one manually via {@link StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StringFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #status(StringFilter)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(StringFilter)
         */
        default Builder status(Consumer<StringFilter.Builder> status) {
            return status(StringFilter.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * Filter the investigation results based on the state.
         * </p>
         * 
         * @param state
         *        Filter the investigation results based on the state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(StringFilter state);

        /**
         * <p>
         * Filter the investigation results based on the state.
         * </p>
         * This is a convenience method that creates an instance of the {@link StringFilter.Builder} avoiding the need
         * to create one manually via {@link StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StringFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #state(StringFilter)}.
         * 
         * @param state
         *        a consumer that will call methods on {@link StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #state(StringFilter)
         */
        default Builder state(Consumer<StringFilter.Builder> state) {
            return state(StringFilter.builder().applyMutation(state).build());
        }

        /**
         * <p>
         * Filter the investigation results based on the Amazon Resource Name (ARN) of the entity.
         * </p>
         * 
         * @param entityArn
         *        Filter the investigation results based on the Amazon Resource Name (ARN) of the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityArn(StringFilter entityArn);

        /**
         * <p>
         * Filter the investigation results based on the Amazon Resource Name (ARN) of the entity.
         * </p>
         * This is a convenience method that creates an instance of the {@link StringFilter.Builder} avoiding the need
         * to create one manually via {@link StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StringFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #entityArn(StringFilter)}.
         * 
         * @param entityArn
         *        a consumer that will call methods on {@link StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entityArn(StringFilter)
         */
        default Builder entityArn(Consumer<StringFilter.Builder> entityArn) {
            return entityArn(StringFilter.builder().applyMutation(entityArn).build());
        }

        /**
         * <p>
         * Filter the investigation results based on when the investigation was created.
         * </p>
         * 
         * @param createdTime
         *        Filter the investigation results based on when the investigation was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(DateFilter createdTime);

        /**
         * <p>
         * Filter the investigation results based on when the investigation was created.
         * </p>
         * This is a convenience method that creates an instance of the {@link DateFilter.Builder} avoiding the need to
         * create one manually via {@link DateFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DateFilter.Builder#build()} is called immediately and its result
         * is passed to {@link #createdTime(DateFilter)}.
         * 
         * @param createdTime
         *        a consumer that will call methods on {@link DateFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createdTime(DateFilter)
         */
        default Builder createdTime(Consumer<DateFilter.Builder> createdTime) {
            return createdTime(DateFilter.builder().applyMutation(createdTime).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private StringFilter severity;

        private StringFilter status;

        private StringFilter state;

        private StringFilter entityArn;

        private DateFilter createdTime;

        private BuilderImpl() {
        }

        private BuilderImpl(FilterCriteria model) {
            severity(model.severity);
            status(model.status);
            state(model.state);
            entityArn(model.entityArn);
            createdTime(model.createdTime);
        }

        public final StringFilter.Builder getSeverity() {
            return severity != null ? severity.toBuilder() : null;
        }

        public final void setSeverity(StringFilter.BuilderImpl severity) {
            this.severity = severity != null ? severity.build() : null;
        }

        @Override
        public final Builder severity(StringFilter severity) {
            this.severity = severity;
            return this;
        }

        public final StringFilter.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(StringFilter.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(StringFilter status) {
            this.status = status;
            return this;
        }

        public final StringFilter.Builder getState() {
            return state != null ? state.toBuilder() : null;
        }

        public final void setState(StringFilter.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        public final Builder state(StringFilter state) {
            this.state = state;
            return this;
        }

        public final StringFilter.Builder getEntityArn() {
            return entityArn != null ? entityArn.toBuilder() : null;
        }

        public final void setEntityArn(StringFilter.BuilderImpl entityArn) {
            this.entityArn = entityArn != null ? entityArn.build() : null;
        }

        @Override
        public final Builder entityArn(StringFilter entityArn) {
            this.entityArn = entityArn;
            return this;
        }

        public final DateFilter.Builder getCreatedTime() {
            return createdTime != null ? createdTime.toBuilder() : null;
        }

        public final void setCreatedTime(DateFilter.BuilderImpl createdTime) {
            this.createdTime = createdTime != null ? createdTime.build() : null;
        }

        @Override
        public final Builder createdTime(DateFilter createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        @Override
        public FilterCriteria build() {
            return new FilterCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
