/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.detective.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListIndicatorsRequest extends DetectiveRequest implements
        ToCopyableBuilder<ListIndicatorsRequest.Builder, ListIndicatorsRequest> {
    private static final SdkField<String> GRAPH_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GraphArn").getter(getter(ListIndicatorsRequest::graphArn)).setter(setter(Builder::graphArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GraphArn").build()).build();

    private static final SdkField<String> INVESTIGATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InvestigationId").getter(getter(ListIndicatorsRequest::investigationId))
            .setter(setter(Builder::investigationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvestigationId").build()).build();

    private static final SdkField<String> INDICATOR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndicatorType").getter(getter(ListIndicatorsRequest::indicatorTypeAsString))
            .setter(setter(Builder::indicatorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndicatorType").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListIndicatorsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListIndicatorsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRAPH_ARN_FIELD,
            INVESTIGATION_ID_FIELD, INDICATOR_TYPE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String graphArn;

    private final String investigationId;

    private final String indicatorType;

    private final String nextToken;

    private final Integer maxResults;

    private ListIndicatorsRequest(BuilderImpl builder) {
        super(builder);
        this.graphArn = builder.graphArn;
        this.investigationId = builder.investigationId;
        this.indicatorType = builder.indicatorType;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the behavior graph.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the behavior graph.
     */
    public final String graphArn() {
        return graphArn;
    }

    /**
     * <p>
     * The investigation ID of the investigation report.
     * </p>
     * 
     * @return The investigation ID of the investigation report.
     */
    public final String investigationId() {
        return investigationId;
    }

    /**
     * <p>
     * For the list of indicators of compromise that are generated by Detective investigations, see <a
     * href="https://docs.aws.amazon.com/detective/latest/userguide/detective-investigation-about.html">Detective
     * investigations</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #indicatorType}
     * will return {@link IndicatorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #indicatorTypeAsString}.
     * </p>
     * 
     * @return For the list of indicators of compromise that are generated by Detective investigations, see <a
     *         href="https://docs.aws.amazon.com/detective/latest/userguide/detective-investigation-about.html"
     *         >Detective investigations</a>.
     * @see IndicatorType
     */
    public final IndicatorType indicatorType() {
        return IndicatorType.fromValue(indicatorType);
    }

    /**
     * <p>
     * For the list of indicators of compromise that are generated by Detective investigations, see <a
     * href="https://docs.aws.amazon.com/detective/latest/userguide/detective-investigation-about.html">Detective
     * investigations</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #indicatorType}
     * will return {@link IndicatorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #indicatorTypeAsString}.
     * </p>
     * 
     * @return For the list of indicators of compromise that are generated by Detective investigations, see <a
     *         href="https://docs.aws.amazon.com/detective/latest/userguide/detective-investigation-about.html"
     *         >Detective investigations</a>.
     * @see IndicatorType
     */
    public final String indicatorTypeAsString() {
        return indicatorType;
    }

    /**
     * <p>
     * Lists if there are more results available. The value of nextToken is a unique pagination token for each page.
     * Repeat the call using the returned token to retrieve the next page. Keep all other arguments unchanged.
     * </p>
     * <p>
     * Each pagination token expires after 24 hours. Using an expired pagination token will return a Validation
     * Exception error.
     * </p>
     * 
     * @return Lists if there are more results available. The value of nextToken is a unique pagination token for each
     *         page. Repeat the call using the returned token to retrieve the next page. Keep all other arguments
     *         unchanged.</p>
     *         <p>
     *         Each pagination token expires after 24 hours. Using an expired pagination token will return a Validation
     *         Exception error.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Lists the maximum number of indicators in a page.
     * </p>
     * 
     * @return Lists the maximum number of indicators in a page.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(graphArn());
        hashCode = 31 * hashCode + Objects.hashCode(investigationId());
        hashCode = 31 * hashCode + Objects.hashCode(indicatorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIndicatorsRequest)) {
            return false;
        }
        ListIndicatorsRequest other = (ListIndicatorsRequest) obj;
        return Objects.equals(graphArn(), other.graphArn()) && Objects.equals(investigationId(), other.investigationId())
                && Objects.equals(indicatorTypeAsString(), other.indicatorTypeAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListIndicatorsRequest").add("GraphArn", graphArn()).add("InvestigationId", investigationId())
                .add("IndicatorType", indicatorTypeAsString()).add("NextToken", nextToken()).add("MaxResults", maxResults())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GraphArn":
            return Optional.ofNullable(clazz.cast(graphArn()));
        case "InvestigationId":
            return Optional.ofNullable(clazz.cast(investigationId()));
        case "IndicatorType":
            return Optional.ofNullable(clazz.cast(indicatorTypeAsString()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GraphArn", GRAPH_ARN_FIELD);
        map.put("InvestigationId", INVESTIGATION_ID_FIELD);
        map.put("IndicatorType", INDICATOR_TYPE_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListIndicatorsRequest, T> g) {
        return obj -> g.apply((ListIndicatorsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DetectiveRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListIndicatorsRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the behavior graph.
         * </p>
         * 
         * @param graphArn
         *        The Amazon Resource Name (ARN) of the behavior graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder graphArn(String graphArn);

        /**
         * <p>
         * The investigation ID of the investigation report.
         * </p>
         * 
         * @param investigationId
         *        The investigation ID of the investigation report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder investigationId(String investigationId);

        /**
         * <p>
         * For the list of indicators of compromise that are generated by Detective investigations, see <a
         * href="https://docs.aws.amazon.com/detective/latest/userguide/detective-investigation-about.html">Detective
         * investigations</a>.
         * </p>
         * 
         * @param indicatorType
         *        For the list of indicators of compromise that are generated by Detective investigations, see <a
         *        href="https://docs.aws.amazon.com/detective/latest/userguide/detective-investigation-about.html"
         *        >Detective investigations</a>.
         * @see IndicatorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndicatorType
         */
        Builder indicatorType(String indicatorType);

        /**
         * <p>
         * For the list of indicators of compromise that are generated by Detective investigations, see <a
         * href="https://docs.aws.amazon.com/detective/latest/userguide/detective-investigation-about.html">Detective
         * investigations</a>.
         * </p>
         * 
         * @param indicatorType
         *        For the list of indicators of compromise that are generated by Detective investigations, see <a
         *        href="https://docs.aws.amazon.com/detective/latest/userguide/detective-investigation-about.html"
         *        >Detective investigations</a>.
         * @see IndicatorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndicatorType
         */
        Builder indicatorType(IndicatorType indicatorType);

        /**
         * <p>
         * Lists if there are more results available. The value of nextToken is a unique pagination token for each page.
         * Repeat the call using the returned token to retrieve the next page. Keep all other arguments unchanged.
         * </p>
         * <p>
         * Each pagination token expires after 24 hours. Using an expired pagination token will return a Validation
         * Exception error.
         * </p>
         * 
         * @param nextToken
         *        Lists if there are more results available. The value of nextToken is a unique pagination token for
         *        each page. Repeat the call using the returned token to retrieve the next page. Keep all other
         *        arguments unchanged.</p>
         *        <p>
         *        Each pagination token expires after 24 hours. Using an expired pagination token will return a
         *        Validation Exception error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Lists the maximum number of indicators in a page.
         * </p>
         * 
         * @param maxResults
         *        Lists the maximum number of indicators in a page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DetectiveRequest.BuilderImpl implements Builder {
        private String graphArn;

        private String investigationId;

        private String indicatorType;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIndicatorsRequest model) {
            super(model);
            graphArn(model.graphArn);
            investigationId(model.investigationId);
            indicatorType(model.indicatorType);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getGraphArn() {
            return graphArn;
        }

        public final void setGraphArn(String graphArn) {
            this.graphArn = graphArn;
        }

        @Override
        public final Builder graphArn(String graphArn) {
            this.graphArn = graphArn;
            return this;
        }

        public final String getInvestigationId() {
            return investigationId;
        }

        public final void setInvestigationId(String investigationId) {
            this.investigationId = investigationId;
        }

        @Override
        public final Builder investigationId(String investigationId) {
            this.investigationId = investigationId;
            return this;
        }

        public final String getIndicatorType() {
            return indicatorType;
        }

        public final void setIndicatorType(String indicatorType) {
            this.indicatorType = indicatorType;
        }

        @Override
        public final Builder indicatorType(String indicatorType) {
            this.indicatorType = indicatorType;
            return this;
        }

        @Override
        public final Builder indicatorType(IndicatorType indicatorType) {
            this.indicatorType(indicatorType == null ? null : indicatorType.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListIndicatorsRequest build() {
            return new ListIndicatorsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
