/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.detective.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details new Autonomous System Organizations (ASOs) used either at the resource or account level.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NewAsoDetail implements SdkPojo, Serializable, ToCopyableBuilder<NewAsoDetail.Builder, NewAsoDetail> {
    private static final SdkField<String> ASO_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Aso")
            .getter(getter(NewAsoDetail::aso)).setter(setter(Builder::aso))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aso").build()).build();

    private static final SdkField<Boolean> IS_NEW_FOR_ENTIRE_ACCOUNT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsNewForEntireAccount").getter(getter(NewAsoDetail::isNewForEntireAccount))
            .setter(setter(Builder::isNewForEntireAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsNewForEntireAccount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASO_FIELD,
            IS_NEW_FOR_ENTIRE_ACCOUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String aso;

    private final Boolean isNewForEntireAccount;

    private NewAsoDetail(BuilderImpl builder) {
        this.aso = builder.aso;
        this.isNewForEntireAccount = builder.isNewForEntireAccount;
    }

    /**
     * <p>
     * Details about the new Autonomous System Organization (ASO).
     * </p>
     * 
     * @return Details about the new Autonomous System Organization (ASO).
     */
    public final String aso() {
        return aso;
    }

    /**
     * <p>
     * Checks if the Autonomous System Organization (ASO) is new for the entire account.
     * </p>
     * 
     * @return Checks if the Autonomous System Organization (ASO) is new for the entire account.
     */
    public final Boolean isNewForEntireAccount() {
        return isNewForEntireAccount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(aso());
        hashCode = 31 * hashCode + Objects.hashCode(isNewForEntireAccount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NewAsoDetail)) {
            return false;
        }
        NewAsoDetail other = (NewAsoDetail) obj;
        return Objects.equals(aso(), other.aso()) && Objects.equals(isNewForEntireAccount(), other.isNewForEntireAccount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NewAsoDetail").add("Aso", aso()).add("IsNewForEntireAccount", isNewForEntireAccount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Aso":
            return Optional.ofNullable(clazz.cast(aso()));
        case "IsNewForEntireAccount":
            return Optional.ofNullable(clazz.cast(isNewForEntireAccount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Aso", ASO_FIELD);
        map.put("IsNewForEntireAccount", IS_NEW_FOR_ENTIRE_ACCOUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NewAsoDetail, T> g) {
        return obj -> g.apply((NewAsoDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NewAsoDetail> {
        /**
         * <p>
         * Details about the new Autonomous System Organization (ASO).
         * </p>
         * 
         * @param aso
         *        Details about the new Autonomous System Organization (ASO).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aso(String aso);

        /**
         * <p>
         * Checks if the Autonomous System Organization (ASO) is new for the entire account.
         * </p>
         * 
         * @param isNewForEntireAccount
         *        Checks if the Autonomous System Organization (ASO) is new for the entire account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isNewForEntireAccount(Boolean isNewForEntireAccount);
    }

    static final class BuilderImpl implements Builder {
        private String aso;

        private Boolean isNewForEntireAccount;

        private BuilderImpl() {
        }

        private BuilderImpl(NewAsoDetail model) {
            aso(model.aso);
            isNewForEntireAccount(model.isNewForEntireAccount);
        }

        public final String getAso() {
            return aso;
        }

        public final void setAso(String aso) {
            this.aso = aso;
        }

        @Override
        public final Builder aso(String aso) {
            this.aso = aso;
            return this;
        }

        public final Boolean getIsNewForEntireAccount() {
            return isNewForEntireAccount;
        }

        public final void setIsNewForEntireAccount(Boolean isNewForEntireAccount) {
            this.isNewForEntireAccount = isNewForEntireAccount;
        }

        @Override
        public final Builder isNewForEntireAccount(Boolean isNewForEntireAccount) {
            this.isNewForEntireAccount = isNewForEntireAccount;
            return this;
        }

        @Override
        public NewAsoDetail build() {
            return new NewAsoDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
