/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.detective.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.detective.model.DetectiveResponse;
import software.amazon.awssdk.services.detective.model.EntityType;
import software.amazon.awssdk.services.detective.model.Severity;
import software.amazon.awssdk.services.detective.model.State;
import software.amazon.awssdk.services.detective.model.Status;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetInvestigationResponse
extends DetectiveResponse
implements ToCopyableBuilder<Builder, GetInvestigationResponse> {
    private static final SdkField<String> GRAPH_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GraphArn").getter(GetInvestigationResponse.getter(GetInvestigationResponse::graphArn)).setter(GetInvestigationResponse.setter(Builder::graphArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GraphArn").build()}).build();
    private static final SdkField<String> INVESTIGATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InvestigationId").getter(GetInvestigationResponse.getter(GetInvestigationResponse::investigationId)).setter(GetInvestigationResponse.setter(Builder::investigationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvestigationId").build()}).build();
    private static final SdkField<String> ENTITY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EntityArn").getter(GetInvestigationResponse.getter(GetInvestigationResponse::entityArn)).setter(GetInvestigationResponse.setter(Builder::entityArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityArn").build()}).build();
    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EntityType").getter(GetInvestigationResponse.getter(GetInvestigationResponse::entityTypeAsString)).setter(GetInvestigationResponse.setter(Builder::entityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityType").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(GetInvestigationResponse.getter(GetInvestigationResponse::createdTime)).setter(GetInvestigationResponse.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> SCOPE_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ScopeStartTime").getter(GetInvestigationResponse.getter(GetInvestigationResponse::scopeStartTime)).setter(GetInvestigationResponse.setter(Builder::scopeStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScopeStartTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> SCOPE_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ScopeEndTime").getter(GetInvestigationResponse.getter(GetInvestigationResponse::scopeEndTime)).setter(GetInvestigationResponse.setter(Builder::scopeEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScopeEndTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetInvestigationResponse.getter(GetInvestigationResponse::statusAsString)).setter(GetInvestigationResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Severity").getter(GetInvestigationResponse.getter(GetInvestigationResponse::severityAsString)).setter(GetInvestigationResponse.setter(Builder::severity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(GetInvestigationResponse.getter(GetInvestigationResponse::stateAsString)).setter(GetInvestigationResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRAPH_ARN_FIELD, INVESTIGATION_ID_FIELD, ENTITY_ARN_FIELD, ENTITY_TYPE_FIELD, CREATED_TIME_FIELD, SCOPE_START_TIME_FIELD, SCOPE_END_TIME_FIELD, STATUS_FIELD, SEVERITY_FIELD, STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetInvestigationResponse.memberNameToFieldInitializer();
    private final String graphArn;
    private final String investigationId;
    private final String entityArn;
    private final String entityType;
    private final Instant createdTime;
    private final Instant scopeStartTime;
    private final Instant scopeEndTime;
    private final String status;
    private final String severity;
    private final String state;

    private GetInvestigationResponse(BuilderImpl builder) {
        super(builder);
        this.graphArn = builder.graphArn;
        this.investigationId = builder.investigationId;
        this.entityArn = builder.entityArn;
        this.entityType = builder.entityType;
        this.createdTime = builder.createdTime;
        this.scopeStartTime = builder.scopeStartTime;
        this.scopeEndTime = builder.scopeEndTime;
        this.status = builder.status;
        this.severity = builder.severity;
        this.state = builder.state;
    }

    public final String graphArn() {
        return this.graphArn;
    }

    public final String investigationId() {
        return this.investigationId;
    }

    public final String entityArn() {
        return this.entityArn;
    }

    public final EntityType entityType() {
        return EntityType.fromValue(this.entityType);
    }

    public final String entityTypeAsString() {
        return this.entityType;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final Instant scopeStartTime() {
        return this.scopeStartTime;
    }

    public final Instant scopeEndTime() {
        return this.scopeEndTime;
    }

    public final Status status() {
        return Status.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Severity severity() {
        return Severity.fromValue(this.severity);
    }

    public final String severityAsString() {
        return this.severity;
    }

    public final State state() {
        return State.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.graphArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.investigationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.severityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInvestigationResponse)) {
            return false;
        }
        GetInvestigationResponse other = (GetInvestigationResponse)((Object)obj);
        return Objects.equals(this.graphArn(), other.graphArn()) && Objects.equals(this.investigationId(), other.investigationId()) && Objects.equals(this.entityArn(), other.entityArn()) && Objects.equals(this.entityTypeAsString(), other.entityTypeAsString()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.scopeStartTime(), other.scopeStartTime()) && Objects.equals(this.scopeEndTime(), other.scopeEndTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.severityAsString(), other.severityAsString()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetInvestigationResponse").add("GraphArn", (Object)this.graphArn()).add("InvestigationId", (Object)this.investigationId()).add("EntityArn", (Object)this.entityArn()).add("EntityType", (Object)this.entityTypeAsString()).add("CreatedTime", (Object)this.createdTime()).add("ScopeStartTime", (Object)this.scopeStartTime()).add("ScopeEndTime", (Object)this.scopeEndTime()).add("Status", (Object)this.statusAsString()).add("Severity", (Object)this.severityAsString()).add("State", (Object)this.stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GraphArn": {
                return Optional.ofNullable(clazz.cast(this.graphArn()));
            }
            case "InvestigationId": {
                return Optional.ofNullable(clazz.cast(this.investigationId()));
            }
            case "EntityArn": {
                return Optional.ofNullable(clazz.cast(this.entityArn()));
            }
            case "EntityType": {
                return Optional.ofNullable(clazz.cast(this.entityTypeAsString()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "ScopeStartTime": {
                return Optional.ofNullable(clazz.cast(this.scopeStartTime()));
            }
            case "ScopeEndTime": {
                return Optional.ofNullable(clazz.cast(this.scopeEndTime()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Severity": {
                return Optional.ofNullable(clazz.cast(this.severityAsString()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GraphArn", GRAPH_ARN_FIELD);
        map.put("InvestigationId", INVESTIGATION_ID_FIELD);
        map.put("EntityArn", ENTITY_ARN_FIELD);
        map.put("EntityType", ENTITY_TYPE_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("ScopeStartTime", SCOPE_START_TIME_FIELD);
        map.put("ScopeEndTime", SCOPE_END_TIME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Severity", SEVERITY_FIELD);
        map.put("State", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetInvestigationResponse, T> g) {
        return obj -> g.apply((GetInvestigationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DetectiveResponse.BuilderImpl
    implements Builder {
        private String graphArn;
        private String investigationId;
        private String entityArn;
        private String entityType;
        private Instant createdTime;
        private Instant scopeStartTime;
        private Instant scopeEndTime;
        private String status;
        private String severity;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInvestigationResponse model) {
            super(model);
            this.graphArn(model.graphArn);
            this.investigationId(model.investigationId);
            this.entityArn(model.entityArn);
            this.entityType(model.entityType);
            this.createdTime(model.createdTime);
            this.scopeStartTime(model.scopeStartTime);
            this.scopeEndTime(model.scopeEndTime);
            this.status(model.status);
            this.severity(model.severity);
            this.state(model.state);
        }

        public final String getGraphArn() {
            return this.graphArn;
        }

        public final void setGraphArn(String graphArn) {
            this.graphArn = graphArn;
        }

        @Override
        public final Builder graphArn(String graphArn) {
            this.graphArn = graphArn;
            return this;
        }

        public final String getInvestigationId() {
            return this.investigationId;
        }

        public final void setInvestigationId(String investigationId) {
            this.investigationId = investigationId;
        }

        @Override
        public final Builder investigationId(String investigationId) {
            this.investigationId = investigationId;
            return this;
        }

        public final String getEntityArn() {
            return this.entityArn;
        }

        public final void setEntityArn(String entityArn) {
            this.entityArn = entityArn;
        }

        @Override
        public final Builder entityArn(String entityArn) {
            this.entityArn = entityArn;
            return this;
        }

        public final String getEntityType() {
            return this.entityType;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        @Override
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        @Override
        public final Builder entityType(EntityType entityType) {
            this.entityType(entityType == null ? null : entityType.toString());
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getScopeStartTime() {
            return this.scopeStartTime;
        }

        public final void setScopeStartTime(Instant scopeStartTime) {
            this.scopeStartTime = scopeStartTime;
        }

        @Override
        public final Builder scopeStartTime(Instant scopeStartTime) {
            this.scopeStartTime = scopeStartTime;
            return this;
        }

        public final Instant getScopeEndTime() {
            return this.scopeEndTime;
        }

        public final void setScopeEndTime(Instant scopeEndTime) {
            this.scopeEndTime = scopeEndTime;
        }

        @Override
        public final Builder scopeEndTime(Instant scopeEndTime) {
            this.scopeEndTime = scopeEndTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getSeverity() {
            return this.severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(Severity severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(State state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public GetInvestigationResponse build() {
            return new GetInvestigationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DetectiveResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetInvestigationResponse> {
        public Builder graphArn(String var1);

        public Builder investigationId(String var1);

        public Builder entityArn(String var1);

        public Builder entityType(String var1);

        public Builder entityType(EntityType var1);

        public Builder createdTime(Instant var1);

        public Builder scopeStartTime(Instant var1);

        public Builder scopeEndTime(Instant var1);

        public Builder status(String var1);

        public Builder status(Status var1);

        public Builder severity(String var1);

        public Builder severity(Severity var1);

        public Builder state(String var1);

        public Builder state(State var1);
    }
}

