/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.detective.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.detective.model.DetectiveRequest;
import software.amazon.awssdk.services.detective.model.State;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateInvestigationStateRequest
extends DetectiveRequest
implements ToCopyableBuilder<Builder, UpdateInvestigationStateRequest> {
    private static final SdkField<String> GRAPH_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GraphArn").getter(UpdateInvestigationStateRequest.getter(UpdateInvestigationStateRequest::graphArn)).setter(UpdateInvestigationStateRequest.setter(Builder::graphArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GraphArn").build()}).build();
    private static final SdkField<String> INVESTIGATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InvestigationId").getter(UpdateInvestigationStateRequest.getter(UpdateInvestigationStateRequest::investigationId)).setter(UpdateInvestigationStateRequest.setter(Builder::investigationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvestigationId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(UpdateInvestigationStateRequest.getter(UpdateInvestigationStateRequest::stateAsString)).setter(UpdateInvestigationStateRequest.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRAPH_ARN_FIELD, INVESTIGATION_ID_FIELD, STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateInvestigationStateRequest.memberNameToFieldInitializer();
    private final String graphArn;
    private final String investigationId;
    private final String state;

    private UpdateInvestigationStateRequest(BuilderImpl builder) {
        super(builder);
        this.graphArn = builder.graphArn;
        this.investigationId = builder.investigationId;
        this.state = builder.state;
    }

    public final String graphArn() {
        return this.graphArn;
    }

    public final String investigationId() {
        return this.investigationId;
    }

    public final State state() {
        return State.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.graphArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.investigationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateInvestigationStateRequest)) {
            return false;
        }
        UpdateInvestigationStateRequest other = (UpdateInvestigationStateRequest)((Object)obj);
        return Objects.equals(this.graphArn(), other.graphArn()) && Objects.equals(this.investigationId(), other.investigationId()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateInvestigationStateRequest").add("GraphArn", (Object)this.graphArn()).add("InvestigationId", (Object)this.investigationId()).add("State", (Object)this.stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GraphArn": {
                return Optional.ofNullable(clazz.cast(this.graphArn()));
            }
            case "InvestigationId": {
                return Optional.ofNullable(clazz.cast(this.investigationId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("GraphArn", GRAPH_ARN_FIELD);
        map.put("InvestigationId", INVESTIGATION_ID_FIELD);
        map.put("State", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateInvestigationStateRequest, T> g) {
        return obj -> g.apply((UpdateInvestigationStateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DetectiveRequest.BuilderImpl
    implements Builder {
        private String graphArn;
        private String investigationId;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateInvestigationStateRequest model) {
            super(model);
            this.graphArn(model.graphArn);
            this.investigationId(model.investigationId);
            this.state(model.state);
        }

        public final String getGraphArn() {
            return this.graphArn;
        }

        public final void setGraphArn(String graphArn) {
            this.graphArn = graphArn;
        }

        @Override
        public final Builder graphArn(String graphArn) {
            this.graphArn = graphArn;
            return this;
        }

        public final String getInvestigationId() {
            return this.investigationId;
        }

        public final void setInvestigationId(String investigationId) {
            this.investigationId = investigationId;
        }

        @Override
        public final Builder investigationId(String investigationId) {
            this.investigationId = investigationId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(State state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateInvestigationStateRequest build() {
            return new UpdateInvestigationStateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DetectiveRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateInvestigationStateRequest> {
        public Builder graphArn(String var1);

        public Builder investigationId(String var1);

        public Builder state(String var1);

        public Builder state(State var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

