/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.detective.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.detective.model.DetectiveResponse;
import software.amazon.awssdk.services.detective.model.Indicator;
import software.amazon.awssdk.services.detective.model.IndicatorsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListIndicatorsResponse
extends DetectiveResponse
implements ToCopyableBuilder<Builder, ListIndicatorsResponse> {
    private static final SdkField<String> GRAPH_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GraphArn").getter(ListIndicatorsResponse.getter(ListIndicatorsResponse::graphArn)).setter(ListIndicatorsResponse.setter(Builder::graphArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GraphArn").build()}).build();
    private static final SdkField<String> INVESTIGATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InvestigationId").getter(ListIndicatorsResponse.getter(ListIndicatorsResponse::investigationId)).setter(ListIndicatorsResponse.setter(Builder::investigationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvestigationId").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListIndicatorsResponse.getter(ListIndicatorsResponse::nextToken)).setter(ListIndicatorsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<Indicator>> INDICATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Indicators").getter(ListIndicatorsResponse.getter(ListIndicatorsResponse::indicators)).setter(ListIndicatorsResponse.setter(Builder::indicators)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Indicators").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Indicator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRAPH_ARN_FIELD, INVESTIGATION_ID_FIELD, NEXT_TOKEN_FIELD, INDICATORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListIndicatorsResponse.memberNameToFieldInitializer();
    private final String graphArn;
    private final String investigationId;
    private final String nextToken;
    private final List<Indicator> indicators;

    private ListIndicatorsResponse(BuilderImpl builder) {
        super(builder);
        this.graphArn = builder.graphArn;
        this.investigationId = builder.investigationId;
        this.nextToken = builder.nextToken;
        this.indicators = builder.indicators;
    }

    public final String graphArn() {
        return this.graphArn;
    }

    public final String investigationId() {
        return this.investigationId;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasIndicators() {
        return this.indicators != null && !(this.indicators instanceof SdkAutoConstructList);
    }

    public final List<Indicator> indicators() {
        return this.indicators;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.graphArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.investigationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIndicators() ? this.indicators() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIndicatorsResponse)) {
            return false;
        }
        ListIndicatorsResponse other = (ListIndicatorsResponse)((Object)obj);
        return Objects.equals(this.graphArn(), other.graphArn()) && Objects.equals(this.investigationId(), other.investigationId()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasIndicators() == other.hasIndicators() && Objects.equals(this.indicators(), other.indicators());
    }

    public final String toString() {
        return ToString.builder((String)"ListIndicatorsResponse").add("GraphArn", (Object)this.graphArn()).add("InvestigationId", (Object)this.investigationId()).add("NextToken", (Object)this.nextToken()).add("Indicators", this.hasIndicators() ? this.indicators() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GraphArn": {
                return Optional.ofNullable(clazz.cast(this.graphArn()));
            }
            case "InvestigationId": {
                return Optional.ofNullable(clazz.cast(this.investigationId()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Indicators": {
                return Optional.ofNullable(clazz.cast(this.indicators()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GraphArn", GRAPH_ARN_FIELD);
        map.put("InvestigationId", INVESTIGATION_ID_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Indicators", INDICATORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListIndicatorsResponse, T> g) {
        return obj -> g.apply((ListIndicatorsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DetectiveResponse.BuilderImpl
    implements Builder {
        private String graphArn;
        private String investigationId;
        private String nextToken;
        private List<Indicator> indicators = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListIndicatorsResponse model) {
            super(model);
            this.graphArn(model.graphArn);
            this.investigationId(model.investigationId);
            this.nextToken(model.nextToken);
            this.indicators(model.indicators);
        }

        public final String getGraphArn() {
            return this.graphArn;
        }

        public final void setGraphArn(String graphArn) {
            this.graphArn = graphArn;
        }

        @Override
        public final Builder graphArn(String graphArn) {
            this.graphArn = graphArn;
            return this;
        }

        public final String getInvestigationId() {
            return this.investigationId;
        }

        public final void setInvestigationId(String investigationId) {
            this.investigationId = investigationId;
        }

        @Override
        public final Builder investigationId(String investigationId) {
            this.investigationId = investigationId;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<Indicator.Builder> getIndicators() {
            List<Indicator.Builder> result = IndicatorsCopier.copyToBuilder(this.indicators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIndicators(Collection<Indicator.BuilderImpl> indicators) {
            this.indicators = IndicatorsCopier.copyFromBuilder(indicators);
        }

        @Override
        public final Builder indicators(Collection<Indicator> indicators) {
            this.indicators = IndicatorsCopier.copy(indicators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder indicators(Indicator ... indicators) {
            this.indicators(Arrays.asList(indicators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder indicators(Consumer<Indicator.Builder> ... indicators) {
            this.indicators(Stream.of(indicators).map(c -> (Indicator)((Indicator.Builder)Indicator.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListIndicatorsResponse build() {
            return new ListIndicatorsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DetectiveResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListIndicatorsResponse> {
        public Builder graphArn(String var1);

        public Builder investigationId(String var1);

        public Builder nextToken(String var1);

        public Builder indicators(Collection<Indicator> var1);

        public Builder indicators(Indicator ... var1);

        public Builder indicators(Consumer<Indicator.Builder> ... var1);
    }
}

