/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteNetworkProfileRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteNetworkProfileRequest.Builder, DeleteNetworkProfileRequest> {
    private final String arn;

    private DeleteNetworkProfileRequest(BuilderImpl builder) {
        this.arn = builder.arn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the network profile you want to delete.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the network profile you want to delete.
     */
    public String arn() {
        return arn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((arn() == null) ? 0 : arn().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteNetworkProfileRequest)) {
            return false;
        }
        DeleteNetworkProfileRequest other = (DeleteNetworkProfileRequest) obj;
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (arn() != null) {
            sb.append("Arn: ").append(arn()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteNetworkProfileRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the network profile you want to delete.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the network profile you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);
    }

    private static final class BuilderImpl implements Builder {
        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteNetworkProfileRequest model) {
            setArn(model.arn);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public DeleteNetworkProfileRequest build() {
            return new DeleteNetworkProfileRequest(this);
        }
    }
}
