/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the result of a get device request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetDeviceResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetDeviceResponse.Builder, GetDeviceResponse> {
    private final Device device;

    private GetDeviceResponse(BuilderImpl builder) {
        this.device = builder.device;
    }

    /**
     * <p>
     * An object containing information about the requested device.
     * </p>
     * 
     * @return An object containing information about the requested device.
     */
    public Device device() {
        return device;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((device() == null) ? 0 : device().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeviceResponse)) {
            return false;
        }
        GetDeviceResponse other = (GetDeviceResponse) obj;
        if (other.device() == null ^ this.device() == null) {
            return false;
        }
        if (other.device() != null && !other.device().equals(this.device())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (device() != null) {
            sb.append("Device: ").append(device()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetDeviceResponse> {
        /**
         * <p>
         * An object containing information about the requested device.
         * </p>
         * 
         * @param device
         *        An object containing information about the requested device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder device(Device device);
    }

    private static final class BuilderImpl implements Builder {
        private Device device;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeviceResponse model) {
            setDevice(model.device);
        }

        public final Device getDevice() {
            return device;
        }

        @Override
        public final Builder device(Device device) {
            this.device = device;
            return this;
        }

        public final void setDevice(Device device) {
            this.device = device;
        }

        @Override
        public GetDeviceResponse build() {
            return new GetDeviceResponse(this);
        }
    }
}
