/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the return values of the list of offerings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListOfferingsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListOfferingsResponse.Builder, ListOfferingsResponse> {
    private final List<Offering> offerings;

    private final String nextToken;

    private ListOfferingsResponse(BuilderImpl builder) {
        this.offerings = builder.offerings;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A value representing the list offering results.
     * </p>
     * 
     * @return A value representing the list offering results.
     */
    public List<Offering> offerings() {
        return offerings;
    }

    /**
     * <p>
     * An identifier that was returned from the previous call to this operation, which can be used to return the next
     * set of items in the list.
     * </p>
     * 
     * @return An identifier that was returned from the previous call to this operation, which can be used to return the
     *         next set of items in the list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((offerings() == null) ? 0 : offerings().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOfferingsResponse)) {
            return false;
        }
        ListOfferingsResponse other = (ListOfferingsResponse) obj;
        if (other.offerings() == null ^ this.offerings() == null) {
            return false;
        }
        if (other.offerings() != null && !other.offerings().equals(this.offerings())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (offerings() != null) {
            sb.append("Offerings: ").append(offerings()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListOfferingsResponse> {
        /**
         * <p>
         * A value representing the list offering results.
         * </p>
         * 
         * @param offerings
         *        A value representing the list offering results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offerings(Collection<Offering> offerings);

        /**
         * <p>
         * A value representing the list offering results.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setOfferings(java.util.Collection)} or {@link #withOfferings(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param offerings
         *        A value representing the list offering results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offerings(Offering... offerings);

        /**
         * <p>
         * An identifier that was returned from the previous call to this operation, which can be used to return the
         * next set of items in the list.
         * </p>
         * 
         * @param nextToken
         *        An identifier that was returned from the previous call to this operation, which can be used to return
         *        the next set of items in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<Offering> offerings;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOfferingsResponse model) {
            setOfferings(model.offerings);
            setNextToken(model.nextToken);
        }

        public final Collection<Offering> getOfferings() {
            return offerings;
        }

        @Override
        public final Builder offerings(Collection<Offering> offerings) {
            this.offerings = OfferingsCopier.copy(offerings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder offerings(Offering... offerings) {
            if (this.offerings == null) {
                this.offerings = new ArrayList<>(offerings.length);
            }
            for (Offering e : offerings) {
                this.offerings.add(e);
            }
            return this;
        }

        public final void setOfferings(Collection<Offering> offerings) {
            this.offerings = OfferingsCopier.copy(offerings);
        }

        @SafeVarargs
        public final void setOfferings(Offering... offerings) {
            if (this.offerings == null) {
                this.offerings = new ArrayList<>(offerings.length);
            }
            for (Offering e : offerings) {
                this.offerings.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListOfferingsResponse build() {
            return new ListOfferingsResponse(this);
        }
    }
}
