/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the result of a list samples request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListSamplesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListSamplesResponse.Builder, ListSamplesResponse> {
    private final List<Sample> samples;

    private final String nextToken;

    private ListSamplesResponse(BuilderImpl builder) {
        this.samples = builder.samples;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about the samples.
     * </p>
     * 
     * @return Information about the samples.
     */
    public List<Sample> samples() {
        return samples;
    }

    /**
     * <p>
     * If the number of items that are returned is significantly large, this is an identifier that is also returned,
     * which can be used in a subsequent call to this operation to return the next set of items in the list.
     * </p>
     * 
     * @return If the number of items that are returned is significantly large, this is an identifier that is also
     *         returned, which can be used in a subsequent call to this operation to return the next set of items in the
     *         list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((samples() == null) ? 0 : samples().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSamplesResponse)) {
            return false;
        }
        ListSamplesResponse other = (ListSamplesResponse) obj;
        if (other.samples() == null ^ this.samples() == null) {
            return false;
        }
        if (other.samples() != null && !other.samples().equals(this.samples())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (samples() != null) {
            sb.append("Samples: ").append(samples()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListSamplesResponse> {
        /**
         * <p>
         * Information about the samples.
         * </p>
         * 
         * @param samples
         *        Information about the samples.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samples(Collection<Sample> samples);

        /**
         * <p>
         * Information about the samples.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setSamples(java.util.Collection)} or {@link #withSamples(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param samples
         *        Information about the samples.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samples(Sample... samples);

        /**
         * <p>
         * If the number of items that are returned is significantly large, this is an identifier that is also returned,
         * which can be used in a subsequent call to this operation to return the next set of items in the list.
         * </p>
         * 
         * @param nextToken
         *        If the number of items that are returned is significantly large, this is an identifier that is also
         *        returned, which can be used in a subsequent call to this operation to return the next set of items in
         *        the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<Sample> samples;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSamplesResponse model) {
            setSamples(model.samples);
            setNextToken(model.nextToken);
        }

        public final Collection<Sample> getSamples() {
            return samples;
        }

        @Override
        public final Builder samples(Collection<Sample> samples) {
            this.samples = SamplesCopier.copy(samples);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder samples(Sample... samples) {
            if (this.samples == null) {
                this.samples = new ArrayList<>(samples.length);
            }
            for (Sample e : samples) {
                this.samples.add(e);
            }
            return this;
        }

        public final void setSamples(Collection<Sample> samples) {
            this.samples = SamplesCopier.copy(samples);
        }

        @SafeVarargs
        public final void setSamples(Sample... samples) {
            if (this.samples == null) {
                this.samples = new ArrayList<>(samples.length);
            }
            for (Sample e : samples) {
                this.samples.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListSamplesResponse build() {
            return new ListSamplesResponse(this);
        }
    }
}
