/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the result of a list suites request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListSuitesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListSuitesResponse.Builder, ListSuitesResponse> {
    private final List<Suite> suites;

    private final String nextToken;

    private ListSuitesResponse(BuilderImpl builder) {
        this.suites = builder.suites;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about the suites.
     * </p>
     * 
     * @return Information about the suites.
     */
    public List<Suite> suites() {
        return suites;
    }

    /**
     * <p>
     * If the number of items that are returned is significantly large, this is an identifier that is also returned,
     * which can be used in a subsequent call to this operation to return the next set of items in the list.
     * </p>
     * 
     * @return If the number of items that are returned is significantly large, this is an identifier that is also
     *         returned, which can be used in a subsequent call to this operation to return the next set of items in the
     *         list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((suites() == null) ? 0 : suites().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSuitesResponse)) {
            return false;
        }
        ListSuitesResponse other = (ListSuitesResponse) obj;
        if (other.suites() == null ^ this.suites() == null) {
            return false;
        }
        if (other.suites() != null && !other.suites().equals(this.suites())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (suites() != null) {
            sb.append("Suites: ").append(suites()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListSuitesResponse> {
        /**
         * <p>
         * Information about the suites.
         * </p>
         * 
         * @param suites
         *        Information about the suites.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suites(Collection<Suite> suites);

        /**
         * <p>
         * Information about the suites.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setSuites(java.util.Collection)} or {@link #withSuites(java.util.Collection)} if you want to override
         * the existing values.
         * </p>
         * 
         * @param suites
         *        Information about the suites.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suites(Suite... suites);

        /**
         * <p>
         * If the number of items that are returned is significantly large, this is an identifier that is also returned,
         * which can be used in a subsequent call to this operation to return the next set of items in the list.
         * </p>
         * 
         * @param nextToken
         *        If the number of items that are returned is significantly large, this is an identifier that is also
         *        returned, which can be used in a subsequent call to this operation to return the next set of items in
         *        the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<Suite> suites;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSuitesResponse model) {
            setSuites(model.suites);
            setNextToken(model.nextToken);
        }

        public final Collection<Suite> getSuites() {
            return suites;
        }

        @Override
        public final Builder suites(Collection<Suite> suites) {
            this.suites = SuitesCopier.copy(suites);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suites(Suite... suites) {
            if (this.suites == null) {
                this.suites = new ArrayList<>(suites.length);
            }
            for (Suite e : suites) {
                this.suites.add(e);
            }
            return this;
        }

        public final void setSuites(Collection<Suite> suites) {
            this.suites = SuitesCopier.copy(suites);
        }

        @SafeVarargs
        public final void setSuites(Suite... suites) {
            if (this.suites == null) {
                this.suites = new ArrayList<>(suites.length);
            }
            for (Suite e : suites) {
                this.suites.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListSuitesResponse build() {
            return new ListSuitesResponse(this);
        }
    }
}
