/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.transform.OfferingMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the metadata of a device offering.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Offering implements StructuredPojo, ToCopyableBuilder<Offering.Builder, Offering> {
    private final String id;

    private final String description;

    private final String type;

    private final String platform;

    private final List<RecurringCharge> recurringCharges;

    private Offering(BuilderImpl builder) {
        this.id = builder.id;
        this.description = builder.description;
        this.type = builder.type;
        this.platform = builder.platform;
        this.recurringCharges = builder.recurringCharges;
    }

    /**
     * <p>
     * The ID that corresponds to a device offering.
     * </p>
     * 
     * @return The ID that corresponds to a device offering.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * A string describing the offering.
     * </p>
     * 
     * @return A string describing the offering.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The type of offering (e.g., "RECURRING") for a device.
     * </p>
     * 
     * @return The type of offering (e.g., "RECURRING") for a device.
     * @see OfferingType
     */
    public String type() {
        return type;
    }

    /**
     * <p>
     * The platform of the device (e.g., ANDROID or IOS).
     * </p>
     * 
     * @return The platform of the device (e.g., ANDROID or IOS).
     * @see DevicePlatform
     */
    public String platform() {
        return platform;
    }

    /**
     * <p>
     * Specifies whether there are recurring charges for the offering.
     * </p>
     * 
     * @return Specifies whether there are recurring charges for the offering.
     */
    public List<RecurringCharge> recurringCharges() {
        return recurringCharges;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((id() == null) ? 0 : id().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((type() == null) ? 0 : type().hashCode());
        hashCode = 31 * hashCode + ((platform() == null) ? 0 : platform().hashCode());
        hashCode = 31 * hashCode + ((recurringCharges() == null) ? 0 : recurringCharges().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Offering)) {
            return false;
        }
        Offering other = (Offering) obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.platform() == null ^ this.platform() == null) {
            return false;
        }
        if (other.platform() != null && !other.platform().equals(this.platform())) {
            return false;
        }
        if (other.recurringCharges() == null ^ this.recurringCharges() == null) {
            return false;
        }
        if (other.recurringCharges() != null && !other.recurringCharges().equals(this.recurringCharges())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (type() != null) {
            sb.append("Type: ").append(type()).append(",");
        }
        if (platform() != null) {
            sb.append("Platform: ").append(platform()).append(",");
        }
        if (recurringCharges() != null) {
            sb.append("RecurringCharges: ").append(recurringCharges()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OfferingMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Offering> {
        /**
         * <p>
         * The ID that corresponds to a device offering.
         * </p>
         * 
         * @param id
         *        The ID that corresponds to a device offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * A string describing the offering.
         * </p>
         * 
         * @param description
         *        A string describing the offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The type of offering (e.g., "RECURRING") for a device.
         * </p>
         * 
         * @param type
         *        The type of offering (e.g., "RECURRING") for a device.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of offering (e.g., "RECURRING") for a device.
         * </p>
         * 
         * @param type
         *        The type of offering (e.g., "RECURRING") for a device.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingType
         */
        Builder type(OfferingType type);

        /**
         * <p>
         * The platform of the device (e.g., ANDROID or IOS).
         * </p>
         * 
         * @param platform
         *        The platform of the device (e.g., ANDROID or IOS).
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DevicePlatform
         */
        Builder platform(String platform);

        /**
         * <p>
         * The platform of the device (e.g., ANDROID or IOS).
         * </p>
         * 
         * @param platform
         *        The platform of the device (e.g., ANDROID or IOS).
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DevicePlatform
         */
        Builder platform(DevicePlatform platform);

        /**
         * <p>
         * Specifies whether there are recurring charges for the offering.
         * </p>
         * 
         * @param recurringCharges
         *        Specifies whether there are recurring charges for the offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurringCharges(Collection<RecurringCharge> recurringCharges);

        /**
         * <p>
         * Specifies whether there are recurring charges for the offering.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setRecurringCharges(java.util.Collection)} or {@link #withRecurringCharges(java.util.Collection)} if
         * you want to override the existing values.
         * </p>
         * 
         * @param recurringCharges
         *        Specifies whether there are recurring charges for the offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurringCharges(RecurringCharge... recurringCharges);
    }

    private static final class BuilderImpl implements Builder {
        private String id;

        private String description;

        private String type;

        private String platform;

        private List<RecurringCharge> recurringCharges;

        private BuilderImpl() {
        }

        private BuilderImpl(Offering model) {
            setId(model.id);
            setDescription(model.description);
            setType(model.type);
            setPlatform(model.platform);
            setRecurringCharges(model.recurringCharges);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(OfferingType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final void setType(OfferingType type) {
            this.type(type.toString());
        }

        public final String getPlatform() {
            return platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(DevicePlatform platform) {
            this.platform(platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final void setPlatform(DevicePlatform platform) {
            this.platform(platform.toString());
        }

        public final Collection<RecurringCharge> getRecurringCharges() {
            return recurringCharges;
        }

        @Override
        public final Builder recurringCharges(Collection<RecurringCharge> recurringCharges) {
            this.recurringCharges = RecurringChargesCopier.copy(recurringCharges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(RecurringCharge... recurringCharges) {
            if (this.recurringCharges == null) {
                this.recurringCharges = new ArrayList<>(recurringCharges.length);
            }
            for (RecurringCharge e : recurringCharges) {
                this.recurringCharges.add(e);
            }
            return this;
        }

        public final void setRecurringCharges(Collection<RecurringCharge> recurringCharges) {
            this.recurringCharges = RecurringChargesCopier.copy(recurringCharges);
        }

        @SafeVarargs
        public final void setRecurringCharges(RecurringCharge... recurringCharges) {
            if (this.recurringCharges == null) {
                this.recurringCharges = new ArrayList<>(recurringCharges.length);
            }
            for (RecurringCharge e : recurringCharges) {
                this.recurringCharges.add(e);
            }
        }

        @Override
        public Offering build() {
            return new Offering(this);
        }
    }
}
