/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of the purchase offering (e.g., success or failure).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class PurchaseOfferingResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<PurchaseOfferingResponse.Builder, PurchaseOfferingResponse> {
    private final OfferingTransaction offeringTransaction;

    private PurchaseOfferingResponse(BuilderImpl builder) {
        this.offeringTransaction = builder.offeringTransaction;
    }

    /**
     * <p>
     * Represents the offering transaction for the purchase result.
     * </p>
     * 
     * @return Represents the offering transaction for the purchase result.
     */
    public OfferingTransaction offeringTransaction() {
        return offeringTransaction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((offeringTransaction() == null) ? 0 : offeringTransaction().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseOfferingResponse)) {
            return false;
        }
        PurchaseOfferingResponse other = (PurchaseOfferingResponse) obj;
        if (other.offeringTransaction() == null ^ this.offeringTransaction() == null) {
            return false;
        }
        if (other.offeringTransaction() != null && !other.offeringTransaction().equals(this.offeringTransaction())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (offeringTransaction() != null) {
            sb.append("OfferingTransaction: ").append(offeringTransaction()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, PurchaseOfferingResponse> {
        /**
         * <p>
         * Represents the offering transaction for the purchase result.
         * </p>
         * 
         * @param offeringTransaction
         *        Represents the offering transaction for the purchase result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringTransaction(OfferingTransaction offeringTransaction);
    }

    private static final class BuilderImpl implements Builder {
        private OfferingTransaction offeringTransaction;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseOfferingResponse model) {
            setOfferingTransaction(model.offeringTransaction);
        }

        public final OfferingTransaction getOfferingTransaction() {
            return offeringTransaction;
        }

        @Override
        public final Builder offeringTransaction(OfferingTransaction offeringTransaction) {
            this.offeringTransaction = offeringTransaction;
            return this;
        }

        public final void setOfferingTransaction(OfferingTransaction offeringTransaction) {
            this.offeringTransaction = offeringTransaction;
        }

        @Override
        public PurchaseOfferingResponse build() {
            return new PurchaseOfferingResponse(this);
        }
    }
}
