/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.transform.SampleMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a sample of performance data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Sample implements StructuredPojo, ToCopyableBuilder<Sample.Builder, Sample> {
    private final String arn;

    private final String type;

    private final String url;

    private Sample(BuilderImpl builder) {
        this.arn = builder.arn;
        this.type = builder.type;
        this.url = builder.url;
    }

    /**
     * <p>
     * The sample's ARN.
     * </p>
     * 
     * @return The sample's ARN.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The sample's type.
     * </p>
     * <p>
     * Must be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CPU: A CPU sample type. This is expressed as the app processing CPU time (including child processes) as reported
     * by process, as a percentage.
     * </p>
     * </li>
     * <li>
     * <p>
     * MEMORY: A memory usage sample type. This is expressed as the total proportional set size of an app process, in
     * kilobytes.
     * </p>
     * </li>
     * <li>
     * <p>
     * NATIVE_AVG_DRAWTIME
     * </p>
     * </li>
     * <li>
     * <p>
     * NATIVE_FPS
     * </p>
     * </li>
     * <li>
     * <p>
     * NATIVE_FRAMES
     * </p>
     * </li>
     * <li>
     * <p>
     * NATIVE_MAX_DRAWTIME
     * </p>
     * </li>
     * <li>
     * <p>
     * NATIVE_MIN_DRAWTIME
     * </p>
     * </li>
     * <li>
     * <p>
     * OPENGL_AVG_DRAWTIME
     * </p>
     * </li>
     * <li>
     * <p>
     * OPENGL_FPS
     * </p>
     * </li>
     * <li>
     * <p>
     * OPENGL_FRAMES
     * </p>
     * </li>
     * <li>
     * <p>
     * OPENGL_MAX_DRAWTIME
     * </p>
     * </li>
     * <li>
     * <p>
     * OPENGL_MIN_DRAWTIME
     * </p>
     * </li>
     * <li>
     * <p>
     * RX
     * </p>
     * </li>
     * <li>
     * <p>
     * RX_RATE: The total number of bytes per second (TCP and UDP) that are sent, by app process.
     * </p>
     * </li>
     * <li>
     * <p>
     * THREADS: A threads sample type. This is expressed as the total number of threads per app process.
     * </p>
     * </li>
     * <li>
     * <p>
     * TX
     * </p>
     * </li>
     * <li>
     * <p>
     * TX_RATE: The total number of bytes per second (TCP and UDP) that are received, by app process.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The sample's type.</p>
     *         <p>
     *         Must be one of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         CPU: A CPU sample type. This is expressed as the app processing CPU time (including child processes) as
     *         reported by process, as a percentage.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MEMORY: A memory usage sample type. This is expressed as the total proportional set size of an app
     *         process, in kilobytes.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NATIVE_AVG_DRAWTIME
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NATIVE_FPS
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NATIVE_FRAMES
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NATIVE_MAX_DRAWTIME
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NATIVE_MIN_DRAWTIME
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OPENGL_AVG_DRAWTIME
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OPENGL_FPS
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OPENGL_FRAMES
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OPENGL_MAX_DRAWTIME
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OPENGL_MIN_DRAWTIME
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RX
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RX_RATE: The total number of bytes per second (TCP and UDP) that are sent, by app process.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         THREADS: A threads sample type. This is expressed as the total number of threads per app process.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TX
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TX_RATE: The total number of bytes per second (TCP and UDP) that are received, by app process.
     *         </p>
     *         </li>
     * @see SampleType
     */
    public String type() {
        return type;
    }

    /**
     * <p>
     * The pre-signed Amazon S3 URL that can be used with a corresponding GET request to download the sample's file.
     * </p>
     * 
     * @return The pre-signed Amazon S3 URL that can be used with a corresponding GET request to download the sample's
     *         file.
     */
    public String url() {
        return url;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((arn() == null) ? 0 : arn().hashCode());
        hashCode = 31 * hashCode + ((type() == null) ? 0 : type().hashCode());
        hashCode = 31 * hashCode + ((url() == null) ? 0 : url().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Sample)) {
            return false;
        }
        Sample other = (Sample) obj;
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.url() == null ^ this.url() == null) {
            return false;
        }
        if (other.url() != null && !other.url().equals(this.url())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (arn() != null) {
            sb.append("Arn: ").append(arn()).append(",");
        }
        if (type() != null) {
            sb.append("Type: ").append(type()).append(",");
        }
        if (url() != null) {
            sb.append("Url: ").append(url()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SampleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Sample> {
        /**
         * <p>
         * The sample's ARN.
         * </p>
         * 
         * @param arn
         *        The sample's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The sample's type.
         * </p>
         * <p>
         * Must be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CPU: A CPU sample type. This is expressed as the app processing CPU time (including child processes) as
         * reported by process, as a percentage.
         * </p>
         * </li>
         * <li>
         * <p>
         * MEMORY: A memory usage sample type. This is expressed as the total proportional set size of an app process,
         * in kilobytes.
         * </p>
         * </li>
         * <li>
         * <p>
         * NATIVE_AVG_DRAWTIME
         * </p>
         * </li>
         * <li>
         * <p>
         * NATIVE_FPS
         * </p>
         * </li>
         * <li>
         * <p>
         * NATIVE_FRAMES
         * </p>
         * </li>
         * <li>
         * <p>
         * NATIVE_MAX_DRAWTIME
         * </p>
         * </li>
         * <li>
         * <p>
         * NATIVE_MIN_DRAWTIME
         * </p>
         * </li>
         * <li>
         * <p>
         * OPENGL_AVG_DRAWTIME
         * </p>
         * </li>
         * <li>
         * <p>
         * OPENGL_FPS
         * </p>
         * </li>
         * <li>
         * <p>
         * OPENGL_FRAMES
         * </p>
         * </li>
         * <li>
         * <p>
         * OPENGL_MAX_DRAWTIME
         * </p>
         * </li>
         * <li>
         * <p>
         * OPENGL_MIN_DRAWTIME
         * </p>
         * </li>
         * <li>
         * <p>
         * RX
         * </p>
         * </li>
         * <li>
         * <p>
         * RX_RATE: The total number of bytes per second (TCP and UDP) that are sent, by app process.
         * </p>
         * </li>
         * <li>
         * <p>
         * THREADS: A threads sample type. This is expressed as the total number of threads per app process.
         * </p>
         * </li>
         * <li>
         * <p>
         * TX
         * </p>
         * </li>
         * <li>
         * <p>
         * TX_RATE: The total number of bytes per second (TCP and UDP) that are received, by app process.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The sample's type.</p>
         *        <p>
         *        Must be one of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        CPU: A CPU sample type. This is expressed as the app processing CPU time (including child processes)
         *        as reported by process, as a percentage.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        MEMORY: A memory usage sample type. This is expressed as the total proportional set size of an app
         *        process, in kilobytes.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NATIVE_AVG_DRAWTIME
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NATIVE_FPS
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NATIVE_FRAMES
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NATIVE_MAX_DRAWTIME
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NATIVE_MIN_DRAWTIME
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OPENGL_AVG_DRAWTIME
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OPENGL_FPS
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OPENGL_FRAMES
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OPENGL_MAX_DRAWTIME
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OPENGL_MIN_DRAWTIME
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RX
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RX_RATE: The total number of bytes per second (TCP and UDP) that are sent, by app process.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        THREADS: A threads sample type. This is expressed as the total number of threads per app process.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TX
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TX_RATE: The total number of bytes per second (TCP and UDP) that are received, by app process.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SampleType
         */
        Builder type(String type);

        /**
         * <p>
         * The sample's type.
         * </p>
         * <p>
         * Must be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CPU: A CPU sample type. This is expressed as the app processing CPU time (including child processes) as
         * reported by process, as a percentage.
         * </p>
         * </li>
         * <li>
         * <p>
         * MEMORY: A memory usage sample type. This is expressed as the total proportional set size of an app process,
         * in kilobytes.
         * </p>
         * </li>
         * <li>
         * <p>
         * NATIVE_AVG_DRAWTIME
         * </p>
         * </li>
         * <li>
         * <p>
         * NATIVE_FPS
         * </p>
         * </li>
         * <li>
         * <p>
         * NATIVE_FRAMES
         * </p>
         * </li>
         * <li>
         * <p>
         * NATIVE_MAX_DRAWTIME
         * </p>
         * </li>
         * <li>
         * <p>
         * NATIVE_MIN_DRAWTIME
         * </p>
         * </li>
         * <li>
         * <p>
         * OPENGL_AVG_DRAWTIME
         * </p>
         * </li>
         * <li>
         * <p>
         * OPENGL_FPS
         * </p>
         * </li>
         * <li>
         * <p>
         * OPENGL_FRAMES
         * </p>
         * </li>
         * <li>
         * <p>
         * OPENGL_MAX_DRAWTIME
         * </p>
         * </li>
         * <li>
         * <p>
         * OPENGL_MIN_DRAWTIME
         * </p>
         * </li>
         * <li>
         * <p>
         * RX
         * </p>
         * </li>
         * <li>
         * <p>
         * RX_RATE: The total number of bytes per second (TCP and UDP) that are sent, by app process.
         * </p>
         * </li>
         * <li>
         * <p>
         * THREADS: A threads sample type. This is expressed as the total number of threads per app process.
         * </p>
         * </li>
         * <li>
         * <p>
         * TX
         * </p>
         * </li>
         * <li>
         * <p>
         * TX_RATE: The total number of bytes per second (TCP and UDP) that are received, by app process.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The sample's type.</p>
         *        <p>
         *        Must be one of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        CPU: A CPU sample type. This is expressed as the app processing CPU time (including child processes)
         *        as reported by process, as a percentage.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        MEMORY: A memory usage sample type. This is expressed as the total proportional set size of an app
         *        process, in kilobytes.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NATIVE_AVG_DRAWTIME
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NATIVE_FPS
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NATIVE_FRAMES
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NATIVE_MAX_DRAWTIME
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NATIVE_MIN_DRAWTIME
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OPENGL_AVG_DRAWTIME
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OPENGL_FPS
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OPENGL_FRAMES
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OPENGL_MAX_DRAWTIME
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OPENGL_MIN_DRAWTIME
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RX
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RX_RATE: The total number of bytes per second (TCP and UDP) that are sent, by app process.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        THREADS: A threads sample type. This is expressed as the total number of threads per app process.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TX
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TX_RATE: The total number of bytes per second (TCP and UDP) that are received, by app process.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SampleType
         */
        Builder type(SampleType type);

        /**
         * <p>
         * The pre-signed Amazon S3 URL that can be used with a corresponding GET request to download the sample's file.
         * </p>
         * 
         * @param url
         *        The pre-signed Amazon S3 URL that can be used with a corresponding GET request to download the
         *        sample's file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);
    }

    private static final class BuilderImpl implements Builder {
        private String arn;

        private String type;

        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(Sample model) {
            setArn(model.arn);
            setType(model.type);
            setUrl(model.url);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SampleType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final void setType(SampleType type) {
            this.type(type.toString());
        }

        public final String getUrl() {
            return url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public Sample build() {
            return new Sample(this);
        }
    }
}
