/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.transform.ScheduleRunConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the settings for a run. Includes things like location, radio states, auxiliary apps, and network profiles.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ScheduleRunConfiguration implements StructuredPojo,
        ToCopyableBuilder<ScheduleRunConfiguration.Builder, ScheduleRunConfiguration> {
    private final String extraDataPackageArn;

    private final String networkProfileArn;

    private final String locale;

    private final Location location;

    private final Radios radios;

    private final List<String> auxiliaryApps;

    private final String billingMethod;

    private ScheduleRunConfiguration(BuilderImpl builder) {
        this.extraDataPackageArn = builder.extraDataPackageArn;
        this.networkProfileArn = builder.networkProfileArn;
        this.locale = builder.locale;
        this.location = builder.location;
        this.radios = builder.radios;
        this.auxiliaryApps = builder.auxiliaryApps;
        this.billingMethod = builder.billingMethod;
    }

    /**
     * <p>
     * The ARN of the extra data for the run. The extra data is a .zip file that AWS Device Farm will extract to
     * external data for Android or the app's sandbox for iOS.
     * </p>
     * 
     * @return The ARN of the extra data for the run. The extra data is a .zip file that AWS Device Farm will extract to
     *         external data for Android or the app's sandbox for iOS.
     */
    public String extraDataPackageArn() {
        return extraDataPackageArn;
    }

    /**
     * <p>
     * Reserved for internal use.
     * </p>
     * 
     * @return Reserved for internal use.
     */
    public String networkProfileArn() {
        return networkProfileArn;
    }

    /**
     * <p>
     * Information about the locale that is used for the run.
     * </p>
     * 
     * @return Information about the locale that is used for the run.
     */
    public String locale() {
        return locale;
    }

    /**
     * <p>
     * Information about the location that is used for the run.
     * </p>
     * 
     * @return Information about the location that is used for the run.
     */
    public Location location() {
        return location;
    }

    /**
     * <p>
     * Information about the radio states for the run.
     * </p>
     * 
     * @return Information about the radio states for the run.
     */
    public Radios radios() {
        return radios;
    }

    /**
     * <p>
     * A list of auxiliary apps for the run.
     * </p>
     * 
     * @return A list of auxiliary apps for the run.
     */
    public List<String> auxiliaryApps() {
        return auxiliaryApps;
    }

    /**
     * <p>
     * Specifies the billing method for a test run: <code>metered</code> or <code>unmetered</code>. If the parameter is
     * not specified, the default value is <code>metered</code>.
     * </p>
     * 
     * @return Specifies the billing method for a test run: <code>metered</code> or <code>unmetered</code>. If the
     *         parameter is not specified, the default value is <code>metered</code>.
     * @see BillingMethod
     */
    public String billingMethod() {
        return billingMethod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((extraDataPackageArn() == null) ? 0 : extraDataPackageArn().hashCode());
        hashCode = 31 * hashCode + ((networkProfileArn() == null) ? 0 : networkProfileArn().hashCode());
        hashCode = 31 * hashCode + ((locale() == null) ? 0 : locale().hashCode());
        hashCode = 31 * hashCode + ((location() == null) ? 0 : location().hashCode());
        hashCode = 31 * hashCode + ((radios() == null) ? 0 : radios().hashCode());
        hashCode = 31 * hashCode + ((auxiliaryApps() == null) ? 0 : auxiliaryApps().hashCode());
        hashCode = 31 * hashCode + ((billingMethod() == null) ? 0 : billingMethod().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduleRunConfiguration)) {
            return false;
        }
        ScheduleRunConfiguration other = (ScheduleRunConfiguration) obj;
        if (other.extraDataPackageArn() == null ^ this.extraDataPackageArn() == null) {
            return false;
        }
        if (other.extraDataPackageArn() != null && !other.extraDataPackageArn().equals(this.extraDataPackageArn())) {
            return false;
        }
        if (other.networkProfileArn() == null ^ this.networkProfileArn() == null) {
            return false;
        }
        if (other.networkProfileArn() != null && !other.networkProfileArn().equals(this.networkProfileArn())) {
            return false;
        }
        if (other.locale() == null ^ this.locale() == null) {
            return false;
        }
        if (other.locale() != null && !other.locale().equals(this.locale())) {
            return false;
        }
        if (other.location() == null ^ this.location() == null) {
            return false;
        }
        if (other.location() != null && !other.location().equals(this.location())) {
            return false;
        }
        if (other.radios() == null ^ this.radios() == null) {
            return false;
        }
        if (other.radios() != null && !other.radios().equals(this.radios())) {
            return false;
        }
        if (other.auxiliaryApps() == null ^ this.auxiliaryApps() == null) {
            return false;
        }
        if (other.auxiliaryApps() != null && !other.auxiliaryApps().equals(this.auxiliaryApps())) {
            return false;
        }
        if (other.billingMethod() == null ^ this.billingMethod() == null) {
            return false;
        }
        if (other.billingMethod() != null && !other.billingMethod().equals(this.billingMethod())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (extraDataPackageArn() != null) {
            sb.append("ExtraDataPackageArn: ").append(extraDataPackageArn()).append(",");
        }
        if (networkProfileArn() != null) {
            sb.append("NetworkProfileArn: ").append(networkProfileArn()).append(",");
        }
        if (locale() != null) {
            sb.append("Locale: ").append(locale()).append(",");
        }
        if (location() != null) {
            sb.append("Location: ").append(location()).append(",");
        }
        if (radios() != null) {
            sb.append("Radios: ").append(radios()).append(",");
        }
        if (auxiliaryApps() != null) {
            sb.append("AuxiliaryApps: ").append(auxiliaryApps()).append(",");
        }
        if (billingMethod() != null) {
            sb.append("BillingMethod: ").append(billingMethod()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ScheduleRunConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ScheduleRunConfiguration> {
        /**
         * <p>
         * The ARN of the extra data for the run. The extra data is a .zip file that AWS Device Farm will extract to
         * external data for Android or the app's sandbox for iOS.
         * </p>
         * 
         * @param extraDataPackageArn
         *        The ARN of the extra data for the run. The extra data is a .zip file that AWS Device Farm will extract
         *        to external data for Android or the app's sandbox for iOS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extraDataPackageArn(String extraDataPackageArn);

        /**
         * <p>
         * Reserved for internal use.
         * </p>
         * 
         * @param networkProfileArn
         *        Reserved for internal use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkProfileArn(String networkProfileArn);

        /**
         * <p>
         * Information about the locale that is used for the run.
         * </p>
         * 
         * @param locale
         *        Information about the locale that is used for the run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locale(String locale);

        /**
         * <p>
         * Information about the location that is used for the run.
         * </p>
         * 
         * @param location
         *        Information about the location that is used for the run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(Location location);

        /**
         * <p>
         * Information about the radio states for the run.
         * </p>
         * 
         * @param radios
         *        Information about the radio states for the run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder radios(Radios radios);

        /**
         * <p>
         * A list of auxiliary apps for the run.
         * </p>
         * 
         * @param auxiliaryApps
         *        A list of auxiliary apps for the run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auxiliaryApps(Collection<String> auxiliaryApps);

        /**
         * <p>
         * A list of auxiliary apps for the run.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setAuxiliaryApps(java.util.Collection)} or {@link #withAuxiliaryApps(java.util.Collection)} if you
         * want to override the existing values.
         * </p>
         * 
         * @param auxiliaryApps
         *        A list of auxiliary apps for the run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auxiliaryApps(String... auxiliaryApps);

        /**
         * <p>
         * Specifies the billing method for a test run: <code>metered</code> or <code>unmetered</code>. If the parameter
         * is not specified, the default value is <code>metered</code>.
         * </p>
         * 
         * @param billingMethod
         *        Specifies the billing method for a test run: <code>metered</code> or <code>unmetered</code>. If the
         *        parameter is not specified, the default value is <code>metered</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingMethod
         */
        Builder billingMethod(String billingMethod);

        /**
         * <p>
         * Specifies the billing method for a test run: <code>metered</code> or <code>unmetered</code>. If the parameter
         * is not specified, the default value is <code>metered</code>.
         * </p>
         * 
         * @param billingMethod
         *        Specifies the billing method for a test run: <code>metered</code> or <code>unmetered</code>. If the
         *        parameter is not specified, the default value is <code>metered</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingMethod
         */
        Builder billingMethod(BillingMethod billingMethod);
    }

    private static final class BuilderImpl implements Builder {
        private String extraDataPackageArn;

        private String networkProfileArn;

        private String locale;

        private Location location;

        private Radios radios;

        private List<String> auxiliaryApps;

        private String billingMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduleRunConfiguration model) {
            setExtraDataPackageArn(model.extraDataPackageArn);
            setNetworkProfileArn(model.networkProfileArn);
            setLocale(model.locale);
            setLocation(model.location);
            setRadios(model.radios);
            setAuxiliaryApps(model.auxiliaryApps);
            setBillingMethod(model.billingMethod);
        }

        public final String getExtraDataPackageArn() {
            return extraDataPackageArn;
        }

        @Override
        public final Builder extraDataPackageArn(String extraDataPackageArn) {
            this.extraDataPackageArn = extraDataPackageArn;
            return this;
        }

        public final void setExtraDataPackageArn(String extraDataPackageArn) {
            this.extraDataPackageArn = extraDataPackageArn;
        }

        public final String getNetworkProfileArn() {
            return networkProfileArn;
        }

        @Override
        public final Builder networkProfileArn(String networkProfileArn) {
            this.networkProfileArn = networkProfileArn;
            return this;
        }

        public final void setNetworkProfileArn(String networkProfileArn) {
            this.networkProfileArn = networkProfileArn;
        }

        public final String getLocale() {
            return locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        public final Location getLocation() {
            return location;
        }

        @Override
        public final Builder location(Location location) {
            this.location = location;
            return this;
        }

        public final void setLocation(Location location) {
            this.location = location;
        }

        public final Radios getRadios() {
            return radios;
        }

        @Override
        public final Builder radios(Radios radios) {
            this.radios = radios;
            return this;
        }

        public final void setRadios(Radios radios) {
            this.radios = radios;
        }

        public final Collection<String> getAuxiliaryApps() {
            return auxiliaryApps;
        }

        @Override
        public final Builder auxiliaryApps(Collection<String> auxiliaryApps) {
            this.auxiliaryApps = AmazonResourceNamesCopier.copy(auxiliaryApps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder auxiliaryApps(String... auxiliaryApps) {
            if (this.auxiliaryApps == null) {
                this.auxiliaryApps = new ArrayList<>(auxiliaryApps.length);
            }
            for (String e : auxiliaryApps) {
                this.auxiliaryApps.add(e);
            }
            return this;
        }

        public final void setAuxiliaryApps(Collection<String> auxiliaryApps) {
            this.auxiliaryApps = AmazonResourceNamesCopier.copy(auxiliaryApps);
        }

        @SafeVarargs
        public final void setAuxiliaryApps(String... auxiliaryApps) {
            if (this.auxiliaryApps == null) {
                this.auxiliaryApps = new ArrayList<>(auxiliaryApps.length);
            }
            for (String e : auxiliaryApps) {
                this.auxiliaryApps.add(e);
            }
        }

        public final String getBillingMethod() {
            return billingMethod;
        }

        @Override
        public final Builder billingMethod(String billingMethod) {
            this.billingMethod = billingMethod;
            return this;
        }

        @Override
        public final Builder billingMethod(BillingMethod billingMethod) {
            this.billingMethod(billingMethod.toString());
            return this;
        }

        public final void setBillingMethod(String billingMethod) {
            this.billingMethod = billingMethod;
        }

        public final void setBillingMethod(BillingMethod billingMethod) {
            this.billingMethod(billingMethod.toString());
        }

        @Override
        public ScheduleRunConfiguration build() {
            return new ScheduleRunConfiguration(this);
        }
    }
}
