/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Date;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.devicefarm.transform.SuiteMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a collection of one or more tests.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Suite implements StructuredPojo, ToCopyableBuilder<Suite.Builder, Suite> {
    private final String arn;

    private final String name;

    private final String type;

    private final Date created;

    private final String status;

    private final String result;

    private final Date started;

    private final Date stopped;

    private final Counters counters;

    private final String message;

    private final DeviceMinutes deviceMinutes;

    private Suite(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.type = builder.type;
        this.created = builder.created;
        this.status = builder.status;
        this.result = builder.result;
        this.started = builder.started;
        this.stopped = builder.stopped;
        this.counters = builder.counters;
        this.message = builder.message;
        this.deviceMinutes = builder.deviceMinutes;
    }

    /**
     * <p>
     * The suite's ARN.
     * </p>
     * 
     * @return The suite's ARN.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The suite's name.
     * </p>
     * 
     * @return The suite's name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The suite's type.
     * </p>
     * <p>
     * Must be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * BUILTIN_FUZZ: The built-in fuzz type.
     * </p>
     * </li>
     * <li>
     * <p>
     * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it and
     * capturing screenshots at the same time.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_PYTHON: The Appium Python type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_PYTHON: The Appium Python type for Web apps.
     * </p>
     * </li>
     * <li>
     * <p>
     * CALABASH: The Calabash type.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTRUMENTATION: The Instrumentation type.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATION: The uiautomation type.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATOR: The uiautomator type.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST: The XCode test type.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST_UI: The XCode UI test type.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The suite's type.</p>
     *         <p>
     *         Must be one of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         BUILTIN_FUZZ: The built-in fuzz type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it and
     *         capturing screenshots at the same time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_PYTHON: The Appium Python type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_PYTHON: The Appium Python type for Web apps.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CALABASH: The Calabash type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTRUMENTATION: The Instrumentation type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UIAUTOMATION: The uiautomation type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UIAUTOMATOR: The uiautomator type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST: The XCode test type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST_UI: The XCode UI test type.
     *         </p>
     *         </li>
     * @see TestType
     */
    public String type() {
        return type;
    }

    /**
     * <p>
     * When the suite was created.
     * </p>
     * 
     * @return When the suite was created.
     */
    public Date created() {
        return created;
    }

    /**
     * <p>
     * The suite's status.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING: A pending status.
     * </p>
     * </li>
     * <li>
     * <p>
     * PENDING_CONCURRENCY: A pending concurrency status.
     * </p>
     * </li>
     * <li>
     * <p>
     * PENDING_DEVICE: A pending device status.
     * </p>
     * </li>
     * <li>
     * <p>
     * PROCESSING: A processing status.
     * </p>
     * </li>
     * <li>
     * <p>
     * SCHEDULING: A scheduling status.
     * </p>
     * </li>
     * <li>
     * <p>
     * PREPARING: A preparing status.
     * </p>
     * </li>
     * <li>
     * <p>
     * RUNNING: A running status.
     * </p>
     * </li>
     * <li>
     * <p>
     * COMPLETED: A completed status.
     * </p>
     * </li>
     * <li>
     * <p>
     * STOPPING: A stopping status.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The suite's status.</p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         PENDING: A pending status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PENDING_CONCURRENCY: A pending concurrency status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PENDING_DEVICE: A pending device status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PROCESSING: A processing status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SCHEDULING: A scheduling status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PREPARING: A preparing status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RUNNING: A running status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         COMPLETED: A completed status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STOPPING: A stopping status.
     *         </p>
     *         </li>
     * @see ExecutionStatus
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The suite's result.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING: A pending condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * PASSED: A passing condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * WARNED: A warning condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED: A failed condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * SKIPPED: A skipped condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * ERRORED: An error condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * STOPPED: A stopped condition.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The suite's result.</p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         PENDING: A pending condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PASSED: A passing condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WARNED: A warning condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FAILED: A failed condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SKIPPED: A skipped condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ERRORED: An error condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STOPPED: A stopped condition.
     *         </p>
     *         </li>
     * @see ExecutionResult
     */
    public String result() {
        return result;
    }

    /**
     * <p>
     * The suite's start time.
     * </p>
     * 
     * @return The suite's start time.
     */
    public Date started() {
        return started;
    }

    /**
     * <p>
     * The suite's stop time.
     * </p>
     * 
     * @return The suite's stop time.
     */
    public Date stopped() {
        return stopped;
    }

    /**
     * <p>
     * The suite's result counters.
     * </p>
     * 
     * @return The suite's result counters.
     */
    public Counters counters() {
        return counters;
    }

    /**
     * <p>
     * A message about the suite's result.
     * </p>
     * 
     * @return A message about the suite's result.
     */
    public String message() {
        return message;
    }

    /**
     * <p>
     * Represents the total (metered or unmetered) minutes used by the test suite.
     * </p>
     * 
     * @return Represents the total (metered or unmetered) minutes used by the test suite.
     */
    public DeviceMinutes deviceMinutes() {
        return deviceMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((arn() == null) ? 0 : arn().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((type() == null) ? 0 : type().hashCode());
        hashCode = 31 * hashCode + ((created() == null) ? 0 : created().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((result() == null) ? 0 : result().hashCode());
        hashCode = 31 * hashCode + ((started() == null) ? 0 : started().hashCode());
        hashCode = 31 * hashCode + ((stopped() == null) ? 0 : stopped().hashCode());
        hashCode = 31 * hashCode + ((counters() == null) ? 0 : counters().hashCode());
        hashCode = 31 * hashCode + ((message() == null) ? 0 : message().hashCode());
        hashCode = 31 * hashCode + ((deviceMinutes() == null) ? 0 : deviceMinutes().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Suite)) {
            return false;
        }
        Suite other = (Suite) obj;
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.created() == null ^ this.created() == null) {
            return false;
        }
        if (other.created() != null && !other.created().equals(this.created())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.result() == null ^ this.result() == null) {
            return false;
        }
        if (other.result() != null && !other.result().equals(this.result())) {
            return false;
        }
        if (other.started() == null ^ this.started() == null) {
            return false;
        }
        if (other.started() != null && !other.started().equals(this.started())) {
            return false;
        }
        if (other.stopped() == null ^ this.stopped() == null) {
            return false;
        }
        if (other.stopped() != null && !other.stopped().equals(this.stopped())) {
            return false;
        }
        if (other.counters() == null ^ this.counters() == null) {
            return false;
        }
        if (other.counters() != null && !other.counters().equals(this.counters())) {
            return false;
        }
        if (other.message() == null ^ this.message() == null) {
            return false;
        }
        if (other.message() != null && !other.message().equals(this.message())) {
            return false;
        }
        if (other.deviceMinutes() == null ^ this.deviceMinutes() == null) {
            return false;
        }
        if (other.deviceMinutes() != null && !other.deviceMinutes().equals(this.deviceMinutes())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (arn() != null) {
            sb.append("Arn: ").append(arn()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (type() != null) {
            sb.append("Type: ").append(type()).append(",");
        }
        if (created() != null) {
            sb.append("Created: ").append(created()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (result() != null) {
            sb.append("Result: ").append(result()).append(",");
        }
        if (started() != null) {
            sb.append("Started: ").append(started()).append(",");
        }
        if (stopped() != null) {
            sb.append("Stopped: ").append(stopped()).append(",");
        }
        if (counters() != null) {
            sb.append("Counters: ").append(counters()).append(",");
        }
        if (message() != null) {
            sb.append("Message: ").append(message()).append(",");
        }
        if (deviceMinutes() != null) {
            sb.append("DeviceMinutes: ").append(deviceMinutes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SuiteMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Suite> {
        /**
         * <p>
         * The suite's ARN.
         * </p>
         * 
         * @param arn
         *        The suite's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The suite's name.
         * </p>
         * 
         * @param name
         *        The suite's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The suite's type.
         * </p>
         * <p>
         * Must be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * BUILTIN_FUZZ: The built-in fuzz type.
         * </p>
         * </li>
         * <li>
         * <p>
         * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it and
         * capturing screenshots at the same time.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_PYTHON: The Appium Python type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_PYTHON: The Appium Python type for Web apps.
         * </p>
         * </li>
         * <li>
         * <p>
         * CALABASH: The Calabash type.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTRUMENTATION: The Instrumentation type.
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATION: The uiautomation type.
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATOR: The uiautomator type.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST: The XCode test type.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST_UI: The XCode UI test type.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The suite's type.</p>
         *        <p>
         *        Must be one of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        BUILTIN_FUZZ: The built-in fuzz type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it
         *        and capturing screenshots at the same time.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_PYTHON: The Appium Python type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_PYTHON: The Appium Python type for Web apps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CALABASH: The Calabash type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTRUMENTATION: The Instrumentation type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATION: The uiautomation type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATOR: The uiautomator type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST: The XCode test type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST_UI: The XCode UI test type.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestType
         */
        Builder type(String type);

        /**
         * <p>
         * The suite's type.
         * </p>
         * <p>
         * Must be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * BUILTIN_FUZZ: The built-in fuzz type.
         * </p>
         * </li>
         * <li>
         * <p>
         * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it and
         * capturing screenshots at the same time.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_PYTHON: The Appium Python type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_PYTHON: The Appium Python type for Web apps.
         * </p>
         * </li>
         * <li>
         * <p>
         * CALABASH: The Calabash type.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTRUMENTATION: The Instrumentation type.
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATION: The uiautomation type.
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATOR: The uiautomator type.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST: The XCode test type.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST_UI: The XCode UI test type.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The suite's type.</p>
         *        <p>
         *        Must be one of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        BUILTIN_FUZZ: The built-in fuzz type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it
         *        and capturing screenshots at the same time.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_PYTHON: The Appium Python type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_PYTHON: The Appium Python type for Web apps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CALABASH: The Calabash type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTRUMENTATION: The Instrumentation type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATION: The uiautomation type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATOR: The uiautomator type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST: The XCode test type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST_UI: The XCode UI test type.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestType
         */
        Builder type(TestType type);

        /**
         * <p>
         * When the suite was created.
         * </p>
         * 
         * @param created
         *        When the suite was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder created(Date created);

        /**
         * <p>
         * The suite's status.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING: A pending status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PENDING_CONCURRENCY: A pending concurrency status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PENDING_DEVICE: A pending device status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PROCESSING: A processing status.
         * </p>
         * </li>
         * <li>
         * <p>
         * SCHEDULING: A scheduling status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PREPARING: A preparing status.
         * </p>
         * </li>
         * <li>
         * <p>
         * RUNNING: A running status.
         * </p>
         * </li>
         * <li>
         * <p>
         * COMPLETED: A completed status.
         * </p>
         * </li>
         * <li>
         * <p>
         * STOPPING: A stopping status.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The suite's status.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING: A pending status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PENDING_CONCURRENCY: A pending concurrency status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PENDING_DEVICE: A pending device status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PROCESSING: A processing status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SCHEDULING: A scheduling status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PREPARING: A preparing status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RUNNING: A running status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        COMPLETED: A completed status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOPPING: A stopping status.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The suite's status.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING: A pending status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PENDING_CONCURRENCY: A pending concurrency status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PENDING_DEVICE: A pending device status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PROCESSING: A processing status.
         * </p>
         * </li>
         * <li>
         * <p>
         * SCHEDULING: A scheduling status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PREPARING: A preparing status.
         * </p>
         * </li>
         * <li>
         * <p>
         * RUNNING: A running status.
         * </p>
         * </li>
         * <li>
         * <p>
         * COMPLETED: A completed status.
         * </p>
         * </li>
         * <li>
         * <p>
         * STOPPING: A stopping status.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The suite's status.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING: A pending status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PENDING_CONCURRENCY: A pending concurrency status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PENDING_DEVICE: A pending device status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PROCESSING: A processing status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SCHEDULING: A scheduling status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PREPARING: A preparing status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RUNNING: A running status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        COMPLETED: A completed status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOPPING: A stopping status.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder status(ExecutionStatus status);

        /**
         * <p>
         * The suite's result.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING: A pending condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * PASSED: A passing condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * WARNED: A warning condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * FAILED: A failed condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * SKIPPED: A skipped condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * ERRORED: An error condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * STOPPED: A stopped condition.
         * </p>
         * </li>
         * </ul>
         * 
         * @param result
         *        The suite's result.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING: A pending condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PASSED: A passing condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        WARNED: A warning condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FAILED: A failed condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SKIPPED: A skipped condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ERRORED: An error condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOPPED: A stopped condition.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionResult
         */
        Builder result(String result);

        /**
         * <p>
         * The suite's result.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING: A pending condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * PASSED: A passing condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * WARNED: A warning condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * FAILED: A failed condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * SKIPPED: A skipped condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * ERRORED: An error condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * STOPPED: A stopped condition.
         * </p>
         * </li>
         * </ul>
         * 
         * @param result
         *        The suite's result.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING: A pending condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PASSED: A passing condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        WARNED: A warning condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FAILED: A failed condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SKIPPED: A skipped condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ERRORED: An error condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOPPED: A stopped condition.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionResult
         */
        Builder result(ExecutionResult result);

        /**
         * <p>
         * The suite's start time.
         * </p>
         * 
         * @param started
         *        The suite's start time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder started(Date started);

        /**
         * <p>
         * The suite's stop time.
         * </p>
         * 
         * @param stopped
         *        The suite's stop time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopped(Date stopped);

        /**
         * <p>
         * The suite's result counters.
         * </p>
         * 
         * @param counters
         *        The suite's result counters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder counters(Counters counters);

        /**
         * <p>
         * A message about the suite's result.
         * </p>
         * 
         * @param message
         *        A message about the suite's result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * Represents the total (metered or unmetered) minutes used by the test suite.
         * </p>
         * 
         * @param deviceMinutes
         *        Represents the total (metered or unmetered) minutes used by the test suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceMinutes(DeviceMinutes deviceMinutes);
    }

    private static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String type;

        private Date created;

        private String status;

        private String result;

        private Date started;

        private Date stopped;

        private Counters counters;

        private String message;

        private DeviceMinutes deviceMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(Suite model) {
            setArn(model.arn);
            setName(model.name);
            setType(model.type);
            setCreated(model.created);
            setStatus(model.status);
            setResult(model.result);
            setStarted(model.started);
            setStopped(model.stopped);
            setCounters(model.counters);
            setMessage(model.message);
            setDeviceMinutes(model.deviceMinutes);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TestType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final void setType(TestType type) {
            this.type(type.toString());
        }

        public final Date getCreated() {
            return created;
        }

        @Override
        public final Builder created(Date created) {
            this.created = StandardMemberCopier.copy(created);
            return this;
        }

        public final void setCreated(Date created) {
            this.created = StandardMemberCopier.copy(created);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExecutionStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(ExecutionStatus status) {
            this.status(status.toString());
        }

        public final String getResult() {
            return result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        @Override
        public final Builder result(ExecutionResult result) {
            this.result(result.toString());
            return this;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        public final void setResult(ExecutionResult result) {
            this.result(result.toString());
        }

        public final Date getStarted() {
            return started;
        }

        @Override
        public final Builder started(Date started) {
            this.started = StandardMemberCopier.copy(started);
            return this;
        }

        public final void setStarted(Date started) {
            this.started = StandardMemberCopier.copy(started);
        }

        public final Date getStopped() {
            return stopped;
        }

        @Override
        public final Builder stopped(Date stopped) {
            this.stopped = StandardMemberCopier.copy(stopped);
            return this;
        }

        public final void setStopped(Date stopped) {
            this.stopped = StandardMemberCopier.copy(stopped);
        }

        public final Counters getCounters() {
            return counters;
        }

        @Override
        public final Builder counters(Counters counters) {
            this.counters = counters;
            return this;
        }

        public final void setCounters(Counters counters) {
            this.counters = counters;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final DeviceMinutes getDeviceMinutes() {
            return deviceMinutes;
        }

        @Override
        public final Builder deviceMinutes(DeviceMinutes deviceMinutes) {
            this.deviceMinutes = deviceMinutes;
            return this;
        }

        public final void setDeviceMinutes(DeviceMinutes deviceMinutes) {
            this.deviceMinutes = deviceMinutes;
        }

        @Override
        public Suite build() {
            return new Suite(this);
        }
    }
}
