/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to the update project operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateProjectRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UpdateProjectRequest.Builder, UpdateProjectRequest> {
    private final String arn;

    private final String name;

    private final Integer defaultJobTimeoutMinutes;

    private UpdateProjectRequest(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.defaultJobTimeoutMinutes = builder.defaultJobTimeoutMinutes;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the project whose name you wish to update.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the project whose name you wish to update.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * A string representing the new name of the project that you are updating.
     * </p>
     * 
     * @return A string representing the new name of the project that you are updating.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The number of minutes a test run in the project will execute before it times out.
     * </p>
     * 
     * @return The number of minutes a test run in the project will execute before it times out.
     */
    public Integer defaultJobTimeoutMinutes() {
        return defaultJobTimeoutMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((arn() == null) ? 0 : arn().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((defaultJobTimeoutMinutes() == null) ? 0 : defaultJobTimeoutMinutes().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProjectRequest)) {
            return false;
        }
        UpdateProjectRequest other = (UpdateProjectRequest) obj;
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.defaultJobTimeoutMinutes() == null ^ this.defaultJobTimeoutMinutes() == null) {
            return false;
        }
        if (other.defaultJobTimeoutMinutes() != null && !other.defaultJobTimeoutMinutes().equals(this.defaultJobTimeoutMinutes())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (arn() != null) {
            sb.append("Arn: ").append(arn()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (defaultJobTimeoutMinutes() != null) {
            sb.append("DefaultJobTimeoutMinutes: ").append(defaultJobTimeoutMinutes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateProjectRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the project whose name you wish to update.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the project whose name you wish to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * A string representing the new name of the project that you are updating.
         * </p>
         * 
         * @param name
         *        A string representing the new name of the project that you are updating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The number of minutes a test run in the project will execute before it times out.
         * </p>
         * 
         * @param defaultJobTimeoutMinutes
         *        The number of minutes a test run in the project will execute before it times out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultJobTimeoutMinutes(Integer defaultJobTimeoutMinutes);
    }

    private static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private Integer defaultJobTimeoutMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProjectRequest model) {
            setArn(model.arn);
            setName(model.name);
            setDefaultJobTimeoutMinutes(model.defaultJobTimeoutMinutes);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getDefaultJobTimeoutMinutes() {
            return defaultJobTimeoutMinutes;
        }

        @Override
        public final Builder defaultJobTimeoutMinutes(Integer defaultJobTimeoutMinutes) {
            this.defaultJobTimeoutMinutes = defaultJobTimeoutMinutes;
            return this;
        }

        public final void setDefaultJobTimeoutMinutes(Integer defaultJobTimeoutMinutes) {
            this.defaultJobTimeoutMinutes = defaultJobTimeoutMinutes;
        }

        @Override
        public UpdateProjectRequest build() {
            return new UpdateProjectRequest(this);
        }
    }
}
