/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.devicefarm.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * OfferingTransaction JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class OfferingTransactionUnmarshaller implements Unmarshaller<OfferingTransaction, JsonUnmarshallerContext> {

    public OfferingTransaction unmarshall(JsonUnmarshallerContext context) throws Exception {
        OfferingTransaction.Builder offeringTransactionBuilder = OfferingTransaction.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("offeringStatus", targetDepth)) {
                    context.nextToken();
                    offeringTransactionBuilder.offeringStatus(OfferingStatusUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("transactionId", targetDepth)) {
                    context.nextToken();
                    offeringTransactionBuilder.transactionId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("offeringPromotionId", targetDepth)) {
                    context.nextToken();
                    offeringTransactionBuilder.offeringPromotionId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("createdOn", targetDepth)) {
                    context.nextToken();
                    offeringTransactionBuilder.createdOn(context.getUnmarshaller(java.util.Date.class).unmarshall(context));
                }
                if (context.testExpression("cost", targetDepth)) {
                    context.nextToken();
                    offeringTransactionBuilder.cost(MonetaryAmountUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return offeringTransactionBuilder.build();
    }

    private static OfferingTransactionUnmarshaller INSTANCE;

    public static OfferingTransactionUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new OfferingTransactionUnmarshaller();
        return INSTANCE;
    }
}