/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Map;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.model.MaxSlotMapCopier;
import software.amazon.awssdk.services.devicefarm.model.PurchasedDevicesMapCopier;
import software.amazon.awssdk.services.devicefarm.model.TrialMinutes;
import software.amazon.awssdk.services.devicefarm.transform.AccountSettingsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AccountSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, AccountSettings> {
    private final String awsAccountNumber;
    private final Map<String, Integer> unmeteredDevices;
    private final Map<String, Integer> unmeteredRemoteAccessDevices;
    private final Integer maxJobTimeoutMinutes;
    private final TrialMinutes trialMinutes;
    private final Map<String, Integer> maxSlots;
    private final Integer defaultJobTimeoutMinutes;

    private AccountSettings(BuilderImpl builder) {
        this.awsAccountNumber = builder.awsAccountNumber;
        this.unmeteredDevices = builder.unmeteredDevices;
        this.unmeteredRemoteAccessDevices = builder.unmeteredRemoteAccessDevices;
        this.maxJobTimeoutMinutes = builder.maxJobTimeoutMinutes;
        this.trialMinutes = builder.trialMinutes;
        this.maxSlots = builder.maxSlots;
        this.defaultJobTimeoutMinutes = builder.defaultJobTimeoutMinutes;
    }

    public String awsAccountNumber() {
        return this.awsAccountNumber;
    }

    public Map<String, Integer> unmeteredDevices() {
        return this.unmeteredDevices;
    }

    public Map<String, Integer> unmeteredRemoteAccessDevices() {
        return this.unmeteredRemoteAccessDevices;
    }

    public Integer maxJobTimeoutMinutes() {
        return this.maxJobTimeoutMinutes;
    }

    public TrialMinutes trialMinutes() {
        return this.trialMinutes;
    }

    public Map<String, Integer> maxSlots() {
        return this.maxSlots;
    }

    public Integer defaultJobTimeoutMinutes() {
        return this.defaultJobTimeoutMinutes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.awsAccountNumber() == null ? 0 : this.awsAccountNumber().hashCode());
        hashCode = 31 * hashCode + (this.unmeteredDevices() == null ? 0 : this.unmeteredDevices().hashCode());
        hashCode = 31 * hashCode + (this.unmeteredRemoteAccessDevices() == null ? 0 : this.unmeteredRemoteAccessDevices().hashCode());
        hashCode = 31 * hashCode + (this.maxJobTimeoutMinutes() == null ? 0 : this.maxJobTimeoutMinutes().hashCode());
        hashCode = 31 * hashCode + (this.trialMinutes() == null ? 0 : this.trialMinutes().hashCode());
        hashCode = 31 * hashCode + (this.maxSlots() == null ? 0 : this.maxSlots().hashCode());
        hashCode = 31 * hashCode + (this.defaultJobTimeoutMinutes() == null ? 0 : this.defaultJobTimeoutMinutes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountSettings)) {
            return false;
        }
        AccountSettings other = (AccountSettings)obj;
        if (other.awsAccountNumber() == null ^ this.awsAccountNumber() == null) {
            return false;
        }
        if (other.awsAccountNumber() != null && !other.awsAccountNumber().equals(this.awsAccountNumber())) {
            return false;
        }
        if (other.unmeteredDevices() == null ^ this.unmeteredDevices() == null) {
            return false;
        }
        if (other.unmeteredDevices() != null && !other.unmeteredDevices().equals(this.unmeteredDevices())) {
            return false;
        }
        if (other.unmeteredRemoteAccessDevices() == null ^ this.unmeteredRemoteAccessDevices() == null) {
            return false;
        }
        if (other.unmeteredRemoteAccessDevices() != null && !other.unmeteredRemoteAccessDevices().equals(this.unmeteredRemoteAccessDevices())) {
            return false;
        }
        if (other.maxJobTimeoutMinutes() == null ^ this.maxJobTimeoutMinutes() == null) {
            return false;
        }
        if (other.maxJobTimeoutMinutes() != null && !other.maxJobTimeoutMinutes().equals(this.maxJobTimeoutMinutes())) {
            return false;
        }
        if (other.trialMinutes() == null ^ this.trialMinutes() == null) {
            return false;
        }
        if (other.trialMinutes() != null && !other.trialMinutes().equals(this.trialMinutes())) {
            return false;
        }
        if (other.maxSlots() == null ^ this.maxSlots() == null) {
            return false;
        }
        if (other.maxSlots() != null && !other.maxSlots().equals(this.maxSlots())) {
            return false;
        }
        if (other.defaultJobTimeoutMinutes() == null ^ this.defaultJobTimeoutMinutes() == null) {
            return false;
        }
        return other.defaultJobTimeoutMinutes() == null || other.defaultJobTimeoutMinutes().equals(this.defaultJobTimeoutMinutes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.awsAccountNumber() != null) {
            sb.append("AwsAccountNumber: ").append(this.awsAccountNumber()).append(",");
        }
        if (this.unmeteredDevices() != null) {
            sb.append("UnmeteredDevices: ").append(this.unmeteredDevices()).append(",");
        }
        if (this.unmeteredRemoteAccessDevices() != null) {
            sb.append("UnmeteredRemoteAccessDevices: ").append(this.unmeteredRemoteAccessDevices()).append(",");
        }
        if (this.maxJobTimeoutMinutes() != null) {
            sb.append("MaxJobTimeoutMinutes: ").append(this.maxJobTimeoutMinutes()).append(",");
        }
        if (this.trialMinutes() != null) {
            sb.append("TrialMinutes: ").append(this.trialMinutes()).append(",");
        }
        if (this.maxSlots() != null) {
            sb.append("MaxSlots: ").append(this.maxSlots()).append(",");
        }
        if (this.defaultJobTimeoutMinutes() != null) {
            sb.append("DefaultJobTimeoutMinutes: ").append(this.defaultJobTimeoutMinutes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AccountSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String awsAccountNumber;
        private Map<String, Integer> unmeteredDevices;
        private Map<String, Integer> unmeteredRemoteAccessDevices;
        private Integer maxJobTimeoutMinutes;
        private TrialMinutes trialMinutes;
        private Map<String, Integer> maxSlots;
        private Integer defaultJobTimeoutMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountSettings model) {
            this.setAwsAccountNumber(model.awsAccountNumber);
            this.setUnmeteredDevices(model.unmeteredDevices);
            this.setUnmeteredRemoteAccessDevices(model.unmeteredRemoteAccessDevices);
            this.setMaxJobTimeoutMinutes(model.maxJobTimeoutMinutes);
            this.setTrialMinutes(model.trialMinutes);
            this.setMaxSlots(model.maxSlots);
            this.setDefaultJobTimeoutMinutes(model.defaultJobTimeoutMinutes);
        }

        public final String getAwsAccountNumber() {
            return this.awsAccountNumber;
        }

        @Override
        public final Builder awsAccountNumber(String awsAccountNumber) {
            this.awsAccountNumber = awsAccountNumber;
            return this;
        }

        public final void setAwsAccountNumber(String awsAccountNumber) {
            this.awsAccountNumber = awsAccountNumber;
        }

        public final Map<String, Integer> getUnmeteredDevices() {
            return this.unmeteredDevices;
        }

        @Override
        public final Builder unmeteredDevices(Map<String, Integer> unmeteredDevices) {
            this.unmeteredDevices = PurchasedDevicesMapCopier.copy(unmeteredDevices);
            return this;
        }

        public final void setUnmeteredDevices(Map<String, Integer> unmeteredDevices) {
            this.unmeteredDevices = PurchasedDevicesMapCopier.copy(unmeteredDevices);
        }

        public final Map<String, Integer> getUnmeteredRemoteAccessDevices() {
            return this.unmeteredRemoteAccessDevices;
        }

        @Override
        public final Builder unmeteredRemoteAccessDevices(Map<String, Integer> unmeteredRemoteAccessDevices) {
            this.unmeteredRemoteAccessDevices = PurchasedDevicesMapCopier.copy(unmeteredRemoteAccessDevices);
            return this;
        }

        public final void setUnmeteredRemoteAccessDevices(Map<String, Integer> unmeteredRemoteAccessDevices) {
            this.unmeteredRemoteAccessDevices = PurchasedDevicesMapCopier.copy(unmeteredRemoteAccessDevices);
        }

        public final Integer getMaxJobTimeoutMinutes() {
            return this.maxJobTimeoutMinutes;
        }

        @Override
        public final Builder maxJobTimeoutMinutes(Integer maxJobTimeoutMinutes) {
            this.maxJobTimeoutMinutes = maxJobTimeoutMinutes;
            return this;
        }

        public final void setMaxJobTimeoutMinutes(Integer maxJobTimeoutMinutes) {
            this.maxJobTimeoutMinutes = maxJobTimeoutMinutes;
        }

        public final TrialMinutes getTrialMinutes() {
            return this.trialMinutes;
        }

        @Override
        public final Builder trialMinutes(TrialMinutes trialMinutes) {
            this.trialMinutes = trialMinutes;
            return this;
        }

        public final void setTrialMinutes(TrialMinutes trialMinutes) {
            this.trialMinutes = trialMinutes;
        }

        public final Map<String, Integer> getMaxSlots() {
            return this.maxSlots;
        }

        @Override
        public final Builder maxSlots(Map<String, Integer> maxSlots) {
            this.maxSlots = MaxSlotMapCopier.copy(maxSlots);
            return this;
        }

        public final void setMaxSlots(Map<String, Integer> maxSlots) {
            this.maxSlots = MaxSlotMapCopier.copy(maxSlots);
        }

        public final Integer getDefaultJobTimeoutMinutes() {
            return this.defaultJobTimeoutMinutes;
        }

        @Override
        public final Builder defaultJobTimeoutMinutes(Integer defaultJobTimeoutMinutes) {
            this.defaultJobTimeoutMinutes = defaultJobTimeoutMinutes;
            return this;
        }

        public final void setDefaultJobTimeoutMinutes(Integer defaultJobTimeoutMinutes) {
            this.defaultJobTimeoutMinutes = defaultJobTimeoutMinutes;
        }

        public AccountSettings build() {
            return new AccountSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AccountSettings> {
        public Builder awsAccountNumber(String var1);

        public Builder unmeteredDevices(Map<String, Integer> var1);

        public Builder unmeteredRemoteAccessDevices(Map<String, Integer> var1);

        public Builder maxJobTimeoutMinutes(Integer var1);

        public Builder trialMinutes(TrialMinutes var1);

        public Builder maxSlots(Map<String, Integer> var1);

        public Builder defaultJobTimeoutMinutes(Integer var1);
    }
}

