/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm;

import java.util.concurrent.CompletableFuture;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.config.AwsAsyncClientConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocol;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolMetadata;
import software.amazon.awssdk.core.client.AsyncClientHandler;
import software.amazon.awssdk.core.client.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.services.devicefarm.model.ArgumentException;
import software.amazon.awssdk.services.devicefarm.model.CreateDevicePoolRequest;
import software.amazon.awssdk.services.devicefarm.model.CreateDevicePoolResponse;
import software.amazon.awssdk.services.devicefarm.model.CreateNetworkProfileRequest;
import software.amazon.awssdk.services.devicefarm.model.CreateNetworkProfileResponse;
import software.amazon.awssdk.services.devicefarm.model.CreateProjectRequest;
import software.amazon.awssdk.services.devicefarm.model.CreateProjectResponse;
import software.amazon.awssdk.services.devicefarm.model.CreateRemoteAccessSessionRequest;
import software.amazon.awssdk.services.devicefarm.model.CreateRemoteAccessSessionResponse;
import software.amazon.awssdk.services.devicefarm.model.CreateUploadRequest;
import software.amazon.awssdk.services.devicefarm.model.CreateUploadResponse;
import software.amazon.awssdk.services.devicefarm.model.DeleteDevicePoolRequest;
import software.amazon.awssdk.services.devicefarm.model.DeleteDevicePoolResponse;
import software.amazon.awssdk.services.devicefarm.model.DeleteNetworkProfileRequest;
import software.amazon.awssdk.services.devicefarm.model.DeleteNetworkProfileResponse;
import software.amazon.awssdk.services.devicefarm.model.DeleteProjectRequest;
import software.amazon.awssdk.services.devicefarm.model.DeleteProjectResponse;
import software.amazon.awssdk.services.devicefarm.model.DeleteRemoteAccessSessionRequest;
import software.amazon.awssdk.services.devicefarm.model.DeleteRemoteAccessSessionResponse;
import software.amazon.awssdk.services.devicefarm.model.DeleteRunRequest;
import software.amazon.awssdk.services.devicefarm.model.DeleteRunResponse;
import software.amazon.awssdk.services.devicefarm.model.DeleteUploadRequest;
import software.amazon.awssdk.services.devicefarm.model.DeleteUploadResponse;
import software.amazon.awssdk.services.devicefarm.model.GetAccountSettingsRequest;
import software.amazon.awssdk.services.devicefarm.model.GetAccountSettingsResponse;
import software.amazon.awssdk.services.devicefarm.model.GetDevicePoolCompatibilityRequest;
import software.amazon.awssdk.services.devicefarm.model.GetDevicePoolCompatibilityResponse;
import software.amazon.awssdk.services.devicefarm.model.GetDevicePoolRequest;
import software.amazon.awssdk.services.devicefarm.model.GetDevicePoolResponse;
import software.amazon.awssdk.services.devicefarm.model.GetDeviceRequest;
import software.amazon.awssdk.services.devicefarm.model.GetDeviceResponse;
import software.amazon.awssdk.services.devicefarm.model.GetJobRequest;
import software.amazon.awssdk.services.devicefarm.model.GetJobResponse;
import software.amazon.awssdk.services.devicefarm.model.GetNetworkProfileRequest;
import software.amazon.awssdk.services.devicefarm.model.GetNetworkProfileResponse;
import software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusRequest;
import software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusResponse;
import software.amazon.awssdk.services.devicefarm.model.GetProjectRequest;
import software.amazon.awssdk.services.devicefarm.model.GetProjectResponse;
import software.amazon.awssdk.services.devicefarm.model.GetRemoteAccessSessionRequest;
import software.amazon.awssdk.services.devicefarm.model.GetRemoteAccessSessionResponse;
import software.amazon.awssdk.services.devicefarm.model.GetRunRequest;
import software.amazon.awssdk.services.devicefarm.model.GetRunResponse;
import software.amazon.awssdk.services.devicefarm.model.GetSuiteRequest;
import software.amazon.awssdk.services.devicefarm.model.GetSuiteResponse;
import software.amazon.awssdk.services.devicefarm.model.GetTestRequest;
import software.amazon.awssdk.services.devicefarm.model.GetTestResponse;
import software.amazon.awssdk.services.devicefarm.model.GetUploadRequest;
import software.amazon.awssdk.services.devicefarm.model.GetUploadResponse;
import software.amazon.awssdk.services.devicefarm.model.IdempotencyException;
import software.amazon.awssdk.services.devicefarm.model.InstallToRemoteAccessSessionRequest;
import software.amazon.awssdk.services.devicefarm.model.InstallToRemoteAccessSessionResponse;
import software.amazon.awssdk.services.devicefarm.model.LimitExceededException;
import software.amazon.awssdk.services.devicefarm.model.ListArtifactsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListArtifactsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListDevicePoolsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListDevicePoolsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListDevicesRequest;
import software.amazon.awssdk.services.devicefarm.model.ListDevicesResponse;
import software.amazon.awssdk.services.devicefarm.model.ListJobsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListJobsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListNetworkProfilesRequest;
import software.amazon.awssdk.services.devicefarm.model.ListNetworkProfilesResponse;
import software.amazon.awssdk.services.devicefarm.model.ListOfferingPromotionsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListOfferingPromotionsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListOfferingsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListOfferingsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListProjectsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListProjectsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListRemoteAccessSessionsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListRemoteAccessSessionsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListRunsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListRunsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListSamplesRequest;
import software.amazon.awssdk.services.devicefarm.model.ListSamplesResponse;
import software.amazon.awssdk.services.devicefarm.model.ListSuitesRequest;
import software.amazon.awssdk.services.devicefarm.model.ListSuitesResponse;
import software.amazon.awssdk.services.devicefarm.model.ListTestsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListTestsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListUniqueProblemsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListUniqueProblemsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListUploadsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListUploadsResponse;
import software.amazon.awssdk.services.devicefarm.model.NotEligibleException;
import software.amazon.awssdk.services.devicefarm.model.NotFoundException;
import software.amazon.awssdk.services.devicefarm.model.PurchaseOfferingRequest;
import software.amazon.awssdk.services.devicefarm.model.PurchaseOfferingResponse;
import software.amazon.awssdk.services.devicefarm.model.RenewOfferingRequest;
import software.amazon.awssdk.services.devicefarm.model.RenewOfferingResponse;
import software.amazon.awssdk.services.devicefarm.model.ScheduleRunRequest;
import software.amazon.awssdk.services.devicefarm.model.ScheduleRunResponse;
import software.amazon.awssdk.services.devicefarm.model.ServiceAccountException;
import software.amazon.awssdk.services.devicefarm.model.StopRemoteAccessSessionRequest;
import software.amazon.awssdk.services.devicefarm.model.StopRemoteAccessSessionResponse;
import software.amazon.awssdk.services.devicefarm.model.StopRunRequest;
import software.amazon.awssdk.services.devicefarm.model.StopRunResponse;
import software.amazon.awssdk.services.devicefarm.model.UpdateDevicePoolRequest;
import software.amazon.awssdk.services.devicefarm.model.UpdateDevicePoolResponse;
import software.amazon.awssdk.services.devicefarm.model.UpdateNetworkProfileRequest;
import software.amazon.awssdk.services.devicefarm.model.UpdateNetworkProfileResponse;
import software.amazon.awssdk.services.devicefarm.model.UpdateProjectRequest;
import software.amazon.awssdk.services.devicefarm.model.UpdateProjectResponse;
import software.amazon.awssdk.services.devicefarm.paginators.GetOfferingStatusPublisher;
import software.amazon.awssdk.services.devicefarm.paginators.ListArtifactsPublisher;
import software.amazon.awssdk.services.devicefarm.paginators.ListDevicePoolsPublisher;
import software.amazon.awssdk.services.devicefarm.paginators.ListDevicesPublisher;
import software.amazon.awssdk.services.devicefarm.paginators.ListJobsPublisher;
import software.amazon.awssdk.services.devicefarm.paginators.ListOfferingTransactionsPublisher;
import software.amazon.awssdk.services.devicefarm.paginators.ListOfferingsPublisher;
import software.amazon.awssdk.services.devicefarm.paginators.ListProjectsPublisher;
import software.amazon.awssdk.services.devicefarm.paginators.ListRunsPublisher;
import software.amazon.awssdk.services.devicefarm.paginators.ListSamplesPublisher;
import software.amazon.awssdk.services.devicefarm.paginators.ListSuitesPublisher;
import software.amazon.awssdk.services.devicefarm.paginators.ListTestsPublisher;
import software.amazon.awssdk.services.devicefarm.paginators.ListUniqueProblemsPublisher;
import software.amazon.awssdk.services.devicefarm.paginators.ListUploadsPublisher;
import software.amazon.awssdk.services.devicefarm.transform.CreateDevicePoolRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.CreateDevicePoolResponseUnmarshaller;
import software.amazon.awssdk.services.devicefarm.transform.CreateNetworkProfileRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.CreateNetworkProfileResponseUnmarshaller;
import software.amazon.awssdk.services.devicefarm.transform.CreateProjectRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.CreateProjectResponseUnmarshaller;
import software.amazon.awssdk.services.devicefarm.transform.CreateRemoteAccessSessionRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.CreateRemoteAccessSessionResponseUnmarshaller;
import software.amazon.awssdk.services.devicefarm.transform.CreateUploadRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.CreateUploadResponseUnmarshaller;
import software.amazon.awssdk.services.devicefarm.transform.DeleteDevicePoolRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.DeleteDevicePoolResponseUnmarshaller;
import software.amazon.awssdk.services.devicefarm.transform.DeleteNetworkProfileRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.DeleteNetworkProfileResponseUnmarshaller;
import software.amazon.awssdk.services.devicefarm.transform.DeleteProjectRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.DeleteProjectResponseUnmarshaller;
import software.amazon.awssdk.services.devicefarm.transform.DeleteRemoteAccessSessionRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.DeleteRemoteAccessSessionResponseUnmarshaller;
import software.amazon.awssdk.services.devicefarm.transform.DeleteRunRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.DeleteRunResponseUnmarshaller;
import software.amazon.awssdk.services.devicefarm.transform.DeleteUploadRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.DeleteUploadResponseUnmarshaller;
import software.amazon.awssdk.services.devicefarm.transform.GetAccountSettingsRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.GetAccountSettingsResponseUnmarshaller;
import software.amazon.awssdk.services.devicefarm.transform.GetDevicePoolCompatibilityRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.GetDevicePoolCompatibilityResponseUnmarshaller;
import software.amazon.awssdk.services.devicefarm.transform.GetDevicePoolRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.GetDevicePoolResponseUnmarshaller;
import software.amazon.awssdk.services.devicefarm.transform.GetDeviceRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.GetDeviceResponseUnmarshaller;
import software.amazon.awssdk.services.devicefarm.transform.GetJobRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.GetJobResponseUnmarshaller;
import software.amazon.awssdk.services.devicefarm.transform.GetNetworkProfileRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.GetNetworkProfileResponseUnmarshaller;
import software.amazon.awssdk.services.devicefarm.transform.GetOfferingStatusRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.GetOfferingStatusResponseUnmarshaller;
import software.amazon.awssdk.services.devicefarm.transform.GetProjectRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.GetProjectResponseUnmarshaller;
import software.amazon.awssdk.services.devicefarm.transform.GetRemoteAccessSessionRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.GetRemoteAccessSessionResponseUnmarshaller;
import software.amazon.awssdk.services.devicefarm.transform.GetRunRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.GetRunResponseUnmarshaller;
import software.amazon.awssdk.services.devicefarm.transform.GetSuiteRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.GetSuiteResponseUnmarshaller;
import software.amazon.awssdk.services.devicefarm.transform.GetTestRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.GetTestResponseUnmarshaller;
import software.amazon.awssdk.services.devicefarm.transform.GetUploadRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.GetUploadResponseUnmarshaller;
import software.amazon.awssdk.services.devicefarm.transform.InstallToRemoteAccessSessionRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.InstallToRemoteAccessSessionResponseUnmarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListArtifactsRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListArtifactsResponseUnmarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListDevicePoolsRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListDevicePoolsResponseUnmarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListDevicesRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListDevicesResponseUnmarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListJobsRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListJobsResponseUnmarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListNetworkProfilesRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListNetworkProfilesResponseUnmarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListOfferingPromotionsRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListOfferingPromotionsResponseUnmarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListOfferingTransactionsRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListOfferingTransactionsResponseUnmarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListOfferingsRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListOfferingsResponseUnmarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListProjectsRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListProjectsResponseUnmarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListRemoteAccessSessionsRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListRemoteAccessSessionsResponseUnmarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListRunsRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListRunsResponseUnmarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListSamplesRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListSamplesResponseUnmarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListSuitesRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListSuitesResponseUnmarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListTestsRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListTestsResponseUnmarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListUniqueProblemsRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListUniqueProblemsResponseUnmarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListUploadsRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListUploadsResponseUnmarshaller;
import software.amazon.awssdk.services.devicefarm.transform.PurchaseOfferingRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.PurchaseOfferingResponseUnmarshaller;
import software.amazon.awssdk.services.devicefarm.transform.RenewOfferingRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.RenewOfferingResponseUnmarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ScheduleRunRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ScheduleRunResponseUnmarshaller;
import software.amazon.awssdk.services.devicefarm.transform.StopRemoteAccessSessionRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.StopRemoteAccessSessionResponseUnmarshaller;
import software.amazon.awssdk.services.devicefarm.transform.StopRunRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.StopRunResponseUnmarshaller;
import software.amazon.awssdk.services.devicefarm.transform.UpdateDevicePoolRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.UpdateDevicePoolResponseUnmarshaller;
import software.amazon.awssdk.services.devicefarm.transform.UpdateNetworkProfileRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.UpdateNetworkProfileResponseUnmarshaller;
import software.amazon.awssdk.services.devicefarm.transform.UpdateProjectRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.UpdateProjectResponseUnmarshaller;

/**
 * Internal implementation of {@link DeviceFarmAsyncClient}.
 *
 * @see DeviceFarmAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultDeviceFarmAsyncClient implements DeviceFarmAsyncClient {
    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    protected DefaultDeviceFarmAsyncClient(AwsAsyncClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration, null);
        this.protocolFactory = init();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Creates a device pool.
     * </p>
     *
     * @param createDevicePoolRequest
     *        Represents a request to the create device pool operation.
     * @return A Java Future containing the result of the CreateDevicePool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.CreateDevicePool
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateDevicePool" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDevicePoolResponse> createDevicePool(CreateDevicePoolRequest createDevicePoolRequest) {

        HttpResponseHandler<CreateDevicePoolResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new CreateDevicePoolResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateDevicePoolRequest, CreateDevicePoolResponse>()
                .withMarshaller(new CreateDevicePoolRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createDevicePoolRequest));
    }

    /**
     * <p>
     * Creates a network profile.
     * </p>
     *
     * @param createNetworkProfileRequest
     * @return A Java Future containing the result of the CreateNetworkProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.CreateNetworkProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateNetworkProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateNetworkProfileResponse> createNetworkProfile(
            CreateNetworkProfileRequest createNetworkProfileRequest) {

        HttpResponseHandler<CreateNetworkProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new CreateNetworkProfileResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateNetworkProfileRequest, CreateNetworkProfileResponse>()
                .withMarshaller(new CreateNetworkProfileRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createNetworkProfileRequest));
    }

    /**
     * <p>
     * Creates a new project.
     * </p>
     *
     * @param createProjectRequest
     *        Represents a request to the create project operation.
     * @return A Java Future containing the result of the CreateProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.CreateProject
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateProject" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateProjectResponse> createProject(CreateProjectRequest createProjectRequest) {

        HttpResponseHandler<CreateProjectResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new CreateProjectResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateProjectRequest, CreateProjectResponse>()
                .withMarshaller(new CreateProjectRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createProjectRequest));
    }

    /**
     * <p>
     * Specifies and starts a remote access session.
     * </p>
     *
     * @param createRemoteAccessSessionRequest
     *        Creates and submits a request to start a remote access session.
     * @return A Java Future containing the result of the CreateRemoteAccessSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.CreateRemoteAccessSession
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateRemoteAccessSession"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateRemoteAccessSessionResponse> createRemoteAccessSession(
            CreateRemoteAccessSessionRequest createRemoteAccessSessionRequest) {

        HttpResponseHandler<CreateRemoteAccessSessionResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new CreateRemoteAccessSessionResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<CreateRemoteAccessSessionRequest, CreateRemoteAccessSessionResponse>()
                        .withMarshaller(new CreateRemoteAccessSessionRequestMarshaller(protocolFactory))
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(createRemoteAccessSessionRequest));
    }

    /**
     * <p>
     * Uploads an app or test scripts.
     * </p>
     *
     * @param createUploadRequest
     *        Represents a request to the create upload operation.
     * @return A Java Future containing the result of the CreateUpload operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.CreateUpload
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateUpload" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateUploadResponse> createUpload(CreateUploadRequest createUploadRequest) {

        HttpResponseHandler<CreateUploadResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new CreateUploadResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateUploadRequest, CreateUploadResponse>()
                .withMarshaller(new CreateUploadRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createUploadRequest));
    }

    /**
     * <p>
     * Deletes a device pool given the pool ARN. Does not allow deletion of curated pools owned by the system.
     * </p>
     *
     * @param deleteDevicePoolRequest
     *        Represents a request to the delete device pool operation.
     * @return A Java Future containing the result of the DeleteDevicePool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.DeleteDevicePool
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteDevicePool" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDevicePoolResponse> deleteDevicePool(DeleteDevicePoolRequest deleteDevicePoolRequest) {

        HttpResponseHandler<DeleteDevicePoolResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteDevicePoolResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteDevicePoolRequest, DeleteDevicePoolResponse>()
                .withMarshaller(new DeleteDevicePoolRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteDevicePoolRequest));
    }

    /**
     * <p>
     * Deletes a network profile.
     * </p>
     *
     * @param deleteNetworkProfileRequest
     * @return A Java Future containing the result of the DeleteNetworkProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.DeleteNetworkProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteNetworkProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteNetworkProfileResponse> deleteNetworkProfile(
            DeleteNetworkProfileRequest deleteNetworkProfileRequest) {

        HttpResponseHandler<DeleteNetworkProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteNetworkProfileResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteNetworkProfileRequest, DeleteNetworkProfileResponse>()
                .withMarshaller(new DeleteNetworkProfileRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteNetworkProfileRequest));
    }

    /**
     * <p>
     * Deletes an AWS Device Farm project, given the project ARN.
     * </p>
     * <p>
     * <b>Note</b> Deleting this resource does not stop an in-progress run.
     * </p>
     *
     * @param deleteProjectRequest
     *        Represents a request to the delete project operation.
     * @return A Java Future containing the result of the DeleteProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.DeleteProject
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteProject" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteProjectResponse> deleteProject(DeleteProjectRequest deleteProjectRequest) {

        HttpResponseHandler<DeleteProjectResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteProjectResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteProjectRequest, DeleteProjectResponse>()
                .withMarshaller(new DeleteProjectRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteProjectRequest));
    }

    /**
     * <p>
     * Deletes a completed remote access session and its results.
     * </p>
     *
     * @param deleteRemoteAccessSessionRequest
     *        Represents the request to delete the specified remote access session.
     * @return A Java Future containing the result of the DeleteRemoteAccessSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.DeleteRemoteAccessSession
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteRemoteAccessSession"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRemoteAccessSessionResponse> deleteRemoteAccessSession(
            DeleteRemoteAccessSessionRequest deleteRemoteAccessSessionRequest) {

        HttpResponseHandler<DeleteRemoteAccessSessionResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteRemoteAccessSessionResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<DeleteRemoteAccessSessionRequest, DeleteRemoteAccessSessionResponse>()
                        .withMarshaller(new DeleteRemoteAccessSessionRequestMarshaller(protocolFactory))
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(deleteRemoteAccessSessionRequest));
    }

    /**
     * <p>
     * Deletes the run, given the run ARN.
     * </p>
     * <p>
     * <b>Note</b> Deleting this resource does not stop an in-progress run.
     * </p>
     *
     * @param deleteRunRequest
     *        Represents a request to the delete run operation.
     * @return A Java Future containing the result of the DeleteRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.DeleteRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteRun" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRunResponse> deleteRun(DeleteRunRequest deleteRunRequest) {

        HttpResponseHandler<DeleteRunResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteRunResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteRunRequest, DeleteRunResponse>()
                .withMarshaller(new DeleteRunRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteRunRequest));
    }

    /**
     * <p>
     * Deletes an upload given the upload ARN.
     * </p>
     *
     * @param deleteUploadRequest
     *        Represents a request to the delete upload operation.
     * @return A Java Future containing the result of the DeleteUpload operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.DeleteUpload
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteUpload" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteUploadResponse> deleteUpload(DeleteUploadRequest deleteUploadRequest) {

        HttpResponseHandler<DeleteUploadResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteUploadResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteUploadRequest, DeleteUploadResponse>()
                .withMarshaller(new DeleteUploadRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteUploadRequest));
    }

    /**
     * <p>
     * Returns the number of unmetered iOS and/or unmetered Android devices that have been purchased by the account.
     * </p>
     *
     * @param getAccountSettingsRequest
     *        Represents the request sent to retrieve the account settings.
     * @return A Java Future containing the result of the GetAccountSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetAccountSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetAccountSettings" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetAccountSettingsResponse> getAccountSettings(GetAccountSettingsRequest getAccountSettingsRequest) {

        HttpResponseHandler<GetAccountSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetAccountSettingsResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetAccountSettingsRequest, GetAccountSettingsResponse>()
                .withMarshaller(new GetAccountSettingsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getAccountSettingsRequest));
    }

    /**
     * <p>
     * Gets information about a unique device type.
     * </p>
     *
     * @param getDeviceRequest
     *        Represents a request to the get device request.
     * @return A Java Future containing the result of the GetDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetDevice" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetDeviceResponse> getDevice(GetDeviceRequest getDeviceRequest) {

        HttpResponseHandler<GetDeviceResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetDeviceResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetDeviceRequest, GetDeviceResponse>()
                .withMarshaller(new GetDeviceRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getDeviceRequest));
    }

    /**
     * <p>
     * Gets information about a device pool.
     * </p>
     *
     * @param getDevicePoolRequest
     *        Represents a request to the get device pool operation.
     * @return A Java Future containing the result of the GetDevicePool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetDevicePool
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetDevicePool" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetDevicePoolResponse> getDevicePool(GetDevicePoolRequest getDevicePoolRequest) {

        HttpResponseHandler<GetDevicePoolResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetDevicePoolResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetDevicePoolRequest, GetDevicePoolResponse>()
                .withMarshaller(new GetDevicePoolRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getDevicePoolRequest));
    }

    /**
     * <p>
     * Gets information about compatibility with a device pool.
     * </p>
     *
     * @param getDevicePoolCompatibilityRequest
     *        Represents a request to the get device pool compatibility operation.
     * @return A Java Future containing the result of the GetDevicePoolCompatibility operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetDevicePoolCompatibility
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetDevicePoolCompatibility"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetDevicePoolCompatibilityResponse> getDevicePoolCompatibility(
            GetDevicePoolCompatibilityRequest getDevicePoolCompatibilityRequest) {

        HttpResponseHandler<GetDevicePoolCompatibilityResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetDevicePoolCompatibilityResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<GetDevicePoolCompatibilityRequest, GetDevicePoolCompatibilityResponse>()
                        .withMarshaller(new GetDevicePoolCompatibilityRequestMarshaller(protocolFactory))
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(getDevicePoolCompatibilityRequest));
    }

    /**
     * <p>
     * Gets information about a job.
     * </p>
     *
     * @param getJobRequest
     *        Represents a request to the get job operation.
     * @return A Java Future containing the result of the GetJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetJobResponse> getJob(GetJobRequest getJobRequest) {

        HttpResponseHandler<GetJobResponse> responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata()
                .withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetJobResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetJobRequest, GetJobResponse>()
                .withMarshaller(new GetJobRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getJobRequest));
    }

    /**
     * <p>
     * Returns information about a network profile.
     * </p>
     *
     * @param getNetworkProfileRequest
     * @return A Java Future containing the result of the GetNetworkProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetNetworkProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetNetworkProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetNetworkProfileResponse> getNetworkProfile(GetNetworkProfileRequest getNetworkProfileRequest) {

        HttpResponseHandler<GetNetworkProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetNetworkProfileResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetNetworkProfileRequest, GetNetworkProfileResponse>()
                .withMarshaller(new GetNetworkProfileRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getNetworkProfileRequest));
    }

    /**
     * <p>
     * Gets the current status and future status of all offerings purchased by an AWS account. The response indicates
     * how many offerings are currently available and the offerings that will be available in the next period. The API
     * returns a <code>NotEligible</code> error if the user is not permitted to invoke the operation. Please contact <a
     * href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you believe that you
     * should be able to invoke this operation.
     * </p>
     *
     * @param getOfferingStatusRequest
     *        Represents the request to retrieve the offering status for the specified customer or account.
     * @return A Java Future containing the result of the GetOfferingStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>NotEligibleException Exception gets thrown when a user is not eligible to perform the specified
     *         transaction.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetOfferingStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetOfferingStatus" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetOfferingStatusResponse> getOfferingStatus(GetOfferingStatusRequest getOfferingStatusRequest) {

        HttpResponseHandler<GetOfferingStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetOfferingStatusResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetOfferingStatusRequest, GetOfferingStatusResponse>()
                .withMarshaller(new GetOfferingStatusRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getOfferingStatusRequest));
    }

    /**
     * <p>
     * Gets the current status and future status of all offerings purchased by an AWS account. The response indicates
     * how many offerings are currently available and the offerings that will be available in the next period. The API
     * returns a <code>NotEligible</code> error if the user is not permitted to invoke the operation. Please contact <a
     * href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you believe that you
     * should be able to invoke this operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getOfferingStatus(software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.GetOfferingStatusPublisher publisher = client.getOfferingStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.GetOfferingStatusPublisher publisher = client.getOfferingStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getOfferingStatus(software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param getOfferingStatusRequest
     *        Represents the request to retrieve the offering status for the specified customer or account.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>NotEligibleException Exception gets thrown when a user is not eligible to perform the specified
     *         transaction.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetOfferingStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetOfferingStatus" target="_top">AWS
     *      API Documentation</a>
     */
    public GetOfferingStatusPublisher getOfferingStatusPaginator(GetOfferingStatusRequest getOfferingStatusRequest) {
        return new GetOfferingStatusPublisher(this, getOfferingStatusRequest);
    }

    /**
     * <p>
     * Gets information about a project.
     * </p>
     *
     * @param getProjectRequest
     *        Represents a request to the get project operation.
     * @return A Java Future containing the result of the GetProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetProject
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetProject" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetProjectResponse> getProject(GetProjectRequest getProjectRequest) {

        HttpResponseHandler<GetProjectResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetProjectResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetProjectRequest, GetProjectResponse>()
                .withMarshaller(new GetProjectRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getProjectRequest));
    }

    /**
     * <p>
     * Returns a link to a currently running remote access session.
     * </p>
     *
     * @param getRemoteAccessSessionRequest
     *        Represents the request to get information about the specified remote access session.
     * @return A Java Future containing the result of the GetRemoteAccessSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetRemoteAccessSession
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetRemoteAccessSession"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetRemoteAccessSessionResponse> getRemoteAccessSession(
            GetRemoteAccessSessionRequest getRemoteAccessSessionRequest) {

        HttpResponseHandler<GetRemoteAccessSessionResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetRemoteAccessSessionResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetRemoteAccessSessionRequest, GetRemoteAccessSessionResponse>()
                .withMarshaller(new GetRemoteAccessSessionRequestMarshaller(protocolFactory))
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getRemoteAccessSessionRequest));
    }

    /**
     * <p>
     * Gets information about a run.
     * </p>
     *
     * @param getRunRequest
     *        Represents a request to the get run operation.
     * @return A Java Future containing the result of the GetRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetRun" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetRunResponse> getRun(GetRunRequest getRunRequest) {

        HttpResponseHandler<GetRunResponse> responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata()
                .withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetRunResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetRunRequest, GetRunResponse>()
                .withMarshaller(new GetRunRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getRunRequest));
    }

    /**
     * <p>
     * Gets information about a suite.
     * </p>
     *
     * @param getSuiteRequest
     *        Represents a request to the get suite operation.
     * @return A Java Future containing the result of the GetSuite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetSuite
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetSuite" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetSuiteResponse> getSuite(GetSuiteRequest getSuiteRequest) {

        HttpResponseHandler<GetSuiteResponse> responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata()
                .withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetSuiteResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetSuiteRequest, GetSuiteResponse>()
                .withMarshaller(new GetSuiteRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getSuiteRequest));
    }

    /**
     * <p>
     * Gets information about a test.
     * </p>
     *
     * @param getTestRequest
     *        Represents a request to the get test operation.
     * @return A Java Future containing the result of the GetTest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetTest
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetTest" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetTestResponse> getTest(GetTestRequest getTestRequest) {

        HttpResponseHandler<GetTestResponse> responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata()
                .withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetTestResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetTestRequest, GetTestResponse>()
                .withMarshaller(new GetTestRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getTestRequest));
    }

    /**
     * <p>
     * Gets information about an upload.
     * </p>
     *
     * @param getUploadRequest
     *        Represents a request to the get upload operation.
     * @return A Java Future containing the result of the GetUpload operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetUpload
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetUpload" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetUploadResponse> getUpload(GetUploadRequest getUploadRequest) {

        HttpResponseHandler<GetUploadResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetUploadResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetUploadRequest, GetUploadResponse>()
                .withMarshaller(new GetUploadRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getUploadRequest));
    }

    /**
     * <p>
     * Installs an application to the device in a remote access session. For Android applications, the file must be in
     * .apk format. For iOS applications, the file must be in .ipa format.
     * </p>
     *
     * @param installToRemoteAccessSessionRequest
     *        Represents the request to install an Android application (in .apk format) or an iOS application (in .ipa
     *        format) as part of a remote access session.
     * @return A Java Future containing the result of the InstallToRemoteAccessSession operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.InstallToRemoteAccessSession
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/InstallToRemoteAccessSession"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<InstallToRemoteAccessSessionResponse> installToRemoteAccessSession(
            InstallToRemoteAccessSessionRequest installToRemoteAccessSessionRequest) {

        HttpResponseHandler<InstallToRemoteAccessSessionResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new InstallToRemoteAccessSessionResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<InstallToRemoteAccessSessionRequest, InstallToRemoteAccessSessionResponse>()
                        .withMarshaller(new InstallToRemoteAccessSessionRequestMarshaller(protocolFactory))
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(installToRemoteAccessSessionRequest));
    }

    /**
     * <p>
     * Gets information about artifacts.
     * </p>
     *
     * @param listArtifactsRequest
     *        Represents a request to the list artifacts operation.
     * @return A Java Future containing the result of the ListArtifacts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListArtifacts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListArtifacts" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListArtifactsResponse> listArtifacts(ListArtifactsRequest listArtifactsRequest) {

        HttpResponseHandler<ListArtifactsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new ListArtifactsResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListArtifactsRequest, ListArtifactsResponse>()
                .withMarshaller(new ListArtifactsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listArtifactsRequest));
    }

    /**
     * <p>
     * Gets information about artifacts.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listArtifacts(software.amazon.awssdk.services.devicefarm.model.ListArtifactsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListArtifactsPublisher publisher = client.listArtifactsPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListArtifactsPublisher publisher = client.listArtifactsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListArtifactsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListArtifactsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listArtifacts(software.amazon.awssdk.services.devicefarm.model.ListArtifactsRequest)} operation.</b>
     * </p>
     *
     * @param listArtifactsRequest
     *        Represents a request to the list artifacts operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListArtifacts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListArtifacts" target="_top">AWS API
     *      Documentation</a>
     */
    public ListArtifactsPublisher listArtifactsPaginator(ListArtifactsRequest listArtifactsRequest) {
        return new ListArtifactsPublisher(this, listArtifactsRequest);
    }

    /**
     * <p>
     * Gets information about device pools.
     * </p>
     *
     * @param listDevicePoolsRequest
     *        Represents the result of a list device pools request.
     * @return A Java Future containing the result of the ListDevicePools operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListDevicePools
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDevicePools" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListDevicePoolsResponse> listDevicePools(ListDevicePoolsRequest listDevicePoolsRequest) {

        HttpResponseHandler<ListDevicePoolsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new ListDevicePoolsResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListDevicePoolsRequest, ListDevicePoolsResponse>()
                .withMarshaller(new ListDevicePoolsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listDevicePoolsRequest));
    }

    /**
     * <p>
     * Gets information about device pools.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDevicePools(software.amazon.awssdk.services.devicefarm.model.ListDevicePoolsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListDevicePoolsPublisher publisher = client.listDevicePoolsPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListDevicePoolsPublisher publisher = client.listDevicePoolsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListDevicePoolsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListDevicePoolsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDevicePools(software.amazon.awssdk.services.devicefarm.model.ListDevicePoolsRequest)} operation.</b>
     * </p>
     *
     * @param listDevicePoolsRequest
     *        Represents the result of a list device pools request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListDevicePools
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDevicePools" target="_top">AWS API
     *      Documentation</a>
     */
    public ListDevicePoolsPublisher listDevicePoolsPaginator(ListDevicePoolsRequest listDevicePoolsRequest) {
        return new ListDevicePoolsPublisher(this, listDevicePoolsRequest);
    }

    /**
     * <p>
     * Gets information about unique device types.
     * </p>
     *
     * @param listDevicesRequest
     *        Represents the result of a list devices request.
     * @return A Java Future containing the result of the ListDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListDevices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDevices" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListDevicesResponse> listDevices(ListDevicesRequest listDevicesRequest) {

        HttpResponseHandler<ListDevicesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new ListDevicesResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListDevicesRequest, ListDevicesResponse>()
                .withMarshaller(new ListDevicesRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listDevicesRequest));
    }

    /**
     * <p>
     * Gets information about unique device types.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDevices(software.amazon.awssdk.services.devicefarm.model.ListDevicesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListDevicesPublisher publisher = client.listDevicesPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListDevicesPublisher publisher = client.listDevicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListDevicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListDevicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDevices(software.amazon.awssdk.services.devicefarm.model.ListDevicesRequest)} operation.</b>
     * </p>
     *
     * @param listDevicesRequest
     *        Represents the result of a list devices request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListDevices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDevices" target="_top">AWS API
     *      Documentation</a>
     */
    public ListDevicesPublisher listDevicesPaginator(ListDevicesRequest listDevicesRequest) {
        return new ListDevicesPublisher(this, listDevicesRequest);
    }

    /**
     * <p>
     * Gets information about jobs.
     * </p>
     *
     * @param listJobsRequest
     *        Represents a request to the list jobs operation.
     * @return A Java Future containing the result of the ListJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListJobsResponse> listJobs(ListJobsRequest listJobsRequest) {

        HttpResponseHandler<ListJobsResponse> responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata()
                .withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListJobsResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListJobsRequest, ListJobsResponse>()
                .withMarshaller(new ListJobsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listJobsRequest));
    }

    /**
     * <p>
     * Gets information about jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listJobs(software.amazon.awssdk.services.devicefarm.model.ListJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListJobsPublisher publisher = client.listJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListJobsPublisher publisher = client.listJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJobs(software.amazon.awssdk.services.devicefarm.model.ListJobsRequest)} operation.</b>
     * </p>
     *
     * @param listJobsRequest
     *        Represents a request to the list jobs operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    public ListJobsPublisher listJobsPaginator(ListJobsRequest listJobsRequest) {
        return new ListJobsPublisher(this, listJobsRequest);
    }

    /**
     * <p>
     * Returns the list of available network profiles.
     * </p>
     *
     * @param listNetworkProfilesRequest
     * @return A Java Future containing the result of the ListNetworkProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListNetworkProfiles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListNetworkProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListNetworkProfilesResponse> listNetworkProfiles(
            ListNetworkProfilesRequest listNetworkProfilesRequest) {

        HttpResponseHandler<ListNetworkProfilesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new ListNetworkProfilesResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListNetworkProfilesRequest, ListNetworkProfilesResponse>()
                .withMarshaller(new ListNetworkProfilesRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listNetworkProfilesRequest));
    }

    /**
     * <p>
     * Returns a list of offering promotions. Each offering promotion record contains the ID and description of the
     * promotion. The API returns a <code>NotEligible</code> error if the caller is not permitted to invoke the
     * operation. Contact <a href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if
     * you believe that you should be able to invoke this operation.
     * </p>
     *
     * @param listOfferingPromotionsRequest
     * @return A Java Future containing the result of the ListOfferingPromotions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>NotEligibleException Exception gets thrown when a user is not eligible to perform the specified
     *         transaction.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListOfferingPromotions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferingPromotions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListOfferingPromotionsResponse> listOfferingPromotions(
            ListOfferingPromotionsRequest listOfferingPromotionsRequest) {

        HttpResponseHandler<ListOfferingPromotionsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new ListOfferingPromotionsResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListOfferingPromotionsRequest, ListOfferingPromotionsResponse>()
                .withMarshaller(new ListOfferingPromotionsRequestMarshaller(protocolFactory))
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(listOfferingPromotionsRequest));
    }

    /**
     * <p>
     * Returns a list of all historical purchases, renewals, and system renewal transactions for an AWS account. The
     * list is paginated and ordered by a descending timestamp (most recent transactions are first). The API returns a
     * <code>NotEligible</code> error if the user is not permitted to invoke the operation. Please contact <a
     * href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you believe that you
     * should be able to invoke this operation.
     * </p>
     *
     * @param listOfferingTransactionsRequest
     *        Represents the request to list the offering transaction history.
     * @return A Java Future containing the result of the ListOfferingTransactions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>NotEligibleException Exception gets thrown when a user is not eligible to perform the specified
     *         transaction.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListOfferingTransactions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferingTransactions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListOfferingTransactionsResponse> listOfferingTransactions(
            ListOfferingTransactionsRequest listOfferingTransactionsRequest) {

        HttpResponseHandler<ListOfferingTransactionsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new ListOfferingTransactionsResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<ListOfferingTransactionsRequest, ListOfferingTransactionsResponse>()
                        .withMarshaller(new ListOfferingTransactionsRequestMarshaller(protocolFactory))
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(listOfferingTransactionsRequest));
    }

    /**
     * <p>
     * Returns a list of all historical purchases, renewals, and system renewal transactions for an AWS account. The
     * list is paginated and ordered by a descending timestamp (most recent transactions are first). The API returns a
     * <code>NotEligible</code> error if the user is not permitted to invoke the operation. Please contact <a
     * href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you believe that you
     * should be able to invoke this operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listOfferingTransactions(software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListOfferingTransactionsPublisher publisher = client.listOfferingTransactionsPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListOfferingTransactionsPublisher publisher = client.listOfferingTransactionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOfferingTransactions(software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOfferingTransactionsRequest
     *        Represents the request to list the offering transaction history.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>NotEligibleException Exception gets thrown when a user is not eligible to perform the specified
     *         transaction.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListOfferingTransactions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferingTransactions"
     *      target="_top">AWS API Documentation</a>
     */
    public ListOfferingTransactionsPublisher listOfferingTransactionsPaginator(
            ListOfferingTransactionsRequest listOfferingTransactionsRequest) {
        return new ListOfferingTransactionsPublisher(this, listOfferingTransactionsRequest);
    }

    /**
     * <p>
     * Returns a list of products or offerings that the user can manage through the API. Each offering record indicates
     * the recurring price per unit and the frequency for that offering. The API returns a <code>NotEligible</code>
     * error if the user is not permitted to invoke the operation. Please contact <a
     * href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you believe that you
     * should be able to invoke this operation.
     * </p>
     *
     * @param listOfferingsRequest
     *        Represents the request to list all offerings.
     * @return A Java Future containing the result of the ListOfferings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>NotEligibleException Exception gets thrown when a user is not eligible to perform the specified
     *         transaction.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListOfferings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferings" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListOfferingsResponse> listOfferings(ListOfferingsRequest listOfferingsRequest) {

        HttpResponseHandler<ListOfferingsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new ListOfferingsResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListOfferingsRequest, ListOfferingsResponse>()
                .withMarshaller(new ListOfferingsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listOfferingsRequest));
    }

    /**
     * <p>
     * Returns a list of products or offerings that the user can manage through the API. Each offering record indicates
     * the recurring price per unit and the frequency for that offering. The API returns a <code>NotEligible</code>
     * error if the user is not permitted to invoke the operation. Please contact <a
     * href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you believe that you
     * should be able to invoke this operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listOfferings(software.amazon.awssdk.services.devicefarm.model.ListOfferingsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListOfferingsPublisher publisher = client.listOfferingsPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListOfferingsPublisher publisher = client.listOfferingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListOfferingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListOfferingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOfferings(software.amazon.awssdk.services.devicefarm.model.ListOfferingsRequest)} operation.</b>
     * </p>
     *
     * @param listOfferingsRequest
     *        Represents the request to list all offerings.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>NotEligibleException Exception gets thrown when a user is not eligible to perform the specified
     *         transaction.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListOfferings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferings" target="_top">AWS API
     *      Documentation</a>
     */
    public ListOfferingsPublisher listOfferingsPaginator(ListOfferingsRequest listOfferingsRequest) {
        return new ListOfferingsPublisher(this, listOfferingsRequest);
    }

    /**
     * <p>
     * Gets information about projects.
     * </p>
     *
     * @param listProjectsRequest
     *        Represents a request to the list projects operation.
     * @return A Java Future containing the result of the ListProjects operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListProjects
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListProjectsResponse> listProjects(ListProjectsRequest listProjectsRequest) {

        HttpResponseHandler<ListProjectsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new ListProjectsResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListProjectsRequest, ListProjectsResponse>()
                .withMarshaller(new ListProjectsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listProjectsRequest));
    }

    /**
     * <p>
     * Gets information about projects.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listProjects(software.amazon.awssdk.services.devicefarm.model.ListProjectsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListProjectsPublisher publisher = client.listProjectsPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListProjectsPublisher publisher = client.listProjectsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListProjectsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListProjectsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjects(software.amazon.awssdk.services.devicefarm.model.ListProjectsRequest)} operation.</b>
     * </p>
     *
     * @param listProjectsRequest
     *        Represents a request to the list projects operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListProjects
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    public ListProjectsPublisher listProjectsPaginator(ListProjectsRequest listProjectsRequest) {
        return new ListProjectsPublisher(this, listProjectsRequest);
    }

    /**
     * <p>
     * Returns a list of all currently running remote access sessions.
     * </p>
     *
     * @param listRemoteAccessSessionsRequest
     *        Represents the request to return information about the remote access session.
     * @return A Java Future containing the result of the ListRemoteAccessSessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListRemoteAccessSessions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListRemoteAccessSessions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListRemoteAccessSessionsResponse> listRemoteAccessSessions(
            ListRemoteAccessSessionsRequest listRemoteAccessSessionsRequest) {

        HttpResponseHandler<ListRemoteAccessSessionsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new ListRemoteAccessSessionsResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<ListRemoteAccessSessionsRequest, ListRemoteAccessSessionsResponse>()
                        .withMarshaller(new ListRemoteAccessSessionsRequestMarshaller(protocolFactory))
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(listRemoteAccessSessionsRequest));
    }

    /**
     * <p>
     * Gets information about runs, given an AWS Device Farm project ARN.
     * </p>
     *
     * @param listRunsRequest
     *        Represents a request to the list runs operation.
     * @return A Java Future containing the result of the ListRuns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListRuns
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListRuns" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListRunsResponse> listRuns(ListRunsRequest listRunsRequest) {

        HttpResponseHandler<ListRunsResponse> responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata()
                .withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListRunsResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListRunsRequest, ListRunsResponse>()
                .withMarshaller(new ListRunsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listRunsRequest));
    }

    /**
     * <p>
     * Gets information about runs, given an AWS Device Farm project ARN.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listRuns(software.amazon.awssdk.services.devicefarm.model.ListRunsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListRunsPublisher publisher = client.listRunsPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListRunsPublisher publisher = client.listRunsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListRunsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListRunsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRuns(software.amazon.awssdk.services.devicefarm.model.ListRunsRequest)} operation.</b>
     * </p>
     *
     * @param listRunsRequest
     *        Represents a request to the list runs operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListRuns
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListRuns" target="_top">AWS API
     *      Documentation</a>
     */
    public ListRunsPublisher listRunsPaginator(ListRunsRequest listRunsRequest) {
        return new ListRunsPublisher(this, listRunsRequest);
    }

    /**
     * <p>
     * Gets information about samples, given an AWS Device Farm project ARN
     * </p>
     *
     * @param listSamplesRequest
     *        Represents a request to the list samples operation.
     * @return A Java Future containing the result of the ListSamples operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListSamples
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListSamples" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListSamplesResponse> listSamples(ListSamplesRequest listSamplesRequest) {

        HttpResponseHandler<ListSamplesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new ListSamplesResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListSamplesRequest, ListSamplesResponse>()
                .withMarshaller(new ListSamplesRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listSamplesRequest));
    }

    /**
     * <p>
     * Gets information about samples, given an AWS Device Farm project ARN
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listSamples(software.amazon.awssdk.services.devicefarm.model.ListSamplesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListSamplesPublisher publisher = client.listSamplesPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListSamplesPublisher publisher = client.listSamplesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListSamplesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListSamplesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSamples(software.amazon.awssdk.services.devicefarm.model.ListSamplesRequest)} operation.</b>
     * </p>
     *
     * @param listSamplesRequest
     *        Represents a request to the list samples operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListSamples
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListSamples" target="_top">AWS API
     *      Documentation</a>
     */
    public ListSamplesPublisher listSamplesPaginator(ListSamplesRequest listSamplesRequest) {
        return new ListSamplesPublisher(this, listSamplesRequest);
    }

    /**
     * <p>
     * Gets information about suites.
     * </p>
     *
     * @param listSuitesRequest
     *        Represents a request to the list suites operation.
     * @return A Java Future containing the result of the ListSuites operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListSuites
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListSuites" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListSuitesResponse> listSuites(ListSuitesRequest listSuitesRequest) {

        HttpResponseHandler<ListSuitesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new ListSuitesResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListSuitesRequest, ListSuitesResponse>()
                .withMarshaller(new ListSuitesRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listSuitesRequest));
    }

    /**
     * <p>
     * Gets information about suites.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listSuites(software.amazon.awssdk.services.devicefarm.model.ListSuitesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListSuitesPublisher publisher = client.listSuitesPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListSuitesPublisher publisher = client.listSuitesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListSuitesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListSuitesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSuites(software.amazon.awssdk.services.devicefarm.model.ListSuitesRequest)} operation.</b>
     * </p>
     *
     * @param listSuitesRequest
     *        Represents a request to the list suites operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListSuites
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListSuites" target="_top">AWS API
     *      Documentation</a>
     */
    public ListSuitesPublisher listSuitesPaginator(ListSuitesRequest listSuitesRequest) {
        return new ListSuitesPublisher(this, listSuitesRequest);
    }

    /**
     * <p>
     * Gets information about tests.
     * </p>
     *
     * @param listTestsRequest
     *        Represents a request to the list tests operation.
     * @return A Java Future containing the result of the ListTests operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListTests
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTests" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListTestsResponse> listTests(ListTestsRequest listTestsRequest) {

        HttpResponseHandler<ListTestsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new ListTestsResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListTestsRequest, ListTestsResponse>()
                .withMarshaller(new ListTestsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listTestsRequest));
    }

    /**
     * <p>
     * Gets information about tests.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTests(software.amazon.awssdk.services.devicefarm.model.ListTestsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListTestsPublisher publisher = client.listTestsPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListTestsPublisher publisher = client.listTestsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListTestsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListTestsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTests(software.amazon.awssdk.services.devicefarm.model.ListTestsRequest)} operation.</b>
     * </p>
     *
     * @param listTestsRequest
     *        Represents a request to the list tests operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListTests
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTests" target="_top">AWS API
     *      Documentation</a>
     */
    public ListTestsPublisher listTestsPaginator(ListTestsRequest listTestsRequest) {
        return new ListTestsPublisher(this, listTestsRequest);
    }

    /**
     * <p>
     * Gets information about unique problems.
     * </p>
     *
     * @param listUniqueProblemsRequest
     *        Represents a request to the list unique problems operation.
     * @return A Java Future containing the result of the ListUniqueProblems operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListUniqueProblems
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListUniqueProblems" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListUniqueProblemsResponse> listUniqueProblems(ListUniqueProblemsRequest listUniqueProblemsRequest) {

        HttpResponseHandler<ListUniqueProblemsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new ListUniqueProblemsResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListUniqueProblemsRequest, ListUniqueProblemsResponse>()
                .withMarshaller(new ListUniqueProblemsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listUniqueProblemsRequest));
    }

    /**
     * <p>
     * Gets information about unique problems.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listUniqueProblems(software.amazon.awssdk.services.devicefarm.model.ListUniqueProblemsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListUniqueProblemsPublisher publisher = client.listUniqueProblemsPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListUniqueProblemsPublisher publisher = client.listUniqueProblemsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListUniqueProblemsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListUniqueProblemsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUniqueProblems(software.amazon.awssdk.services.devicefarm.model.ListUniqueProblemsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listUniqueProblemsRequest
     *        Represents a request to the list unique problems operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListUniqueProblems
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListUniqueProblems" target="_top">AWS
     *      API Documentation</a>
     */
    public ListUniqueProblemsPublisher listUniqueProblemsPaginator(ListUniqueProblemsRequest listUniqueProblemsRequest) {
        return new ListUniqueProblemsPublisher(this, listUniqueProblemsRequest);
    }

    /**
     * <p>
     * Gets information about uploads, given an AWS Device Farm project ARN.
     * </p>
     *
     * @param listUploadsRequest
     *        Represents a request to the list uploads operation.
     * @return A Java Future containing the result of the ListUploads operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListUploads
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListUploads" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListUploadsResponse> listUploads(ListUploadsRequest listUploadsRequest) {

        HttpResponseHandler<ListUploadsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new ListUploadsResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListUploadsRequest, ListUploadsResponse>()
                .withMarshaller(new ListUploadsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listUploadsRequest));
    }

    /**
     * <p>
     * Gets information about uploads, given an AWS Device Farm project ARN.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listUploads(software.amazon.awssdk.services.devicefarm.model.ListUploadsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListUploadsPublisher publisher = client.listUploadsPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListUploadsPublisher publisher = client.listUploadsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListUploadsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListUploadsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUploads(software.amazon.awssdk.services.devicefarm.model.ListUploadsRequest)} operation.</b>
     * </p>
     *
     * @param listUploadsRequest
     *        Represents a request to the list uploads operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListUploads
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListUploads" target="_top">AWS API
     *      Documentation</a>
     */
    public ListUploadsPublisher listUploadsPaginator(ListUploadsRequest listUploadsRequest) {
        return new ListUploadsPublisher(this, listUploadsRequest);
    }

    /**
     * <p>
     * Immediately purchases offerings for an AWS account. Offerings renew with the latest total purchased quantity for
     * an offering, unless the renewal was overridden. The API returns a <code>NotEligible</code> error if the user is
     * not permitted to invoke the operation. Please contact <a
     * href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you believe that you
     * should be able to invoke this operation.
     * </p>
     *
     * @param purchaseOfferingRequest
     *        Represents a request for a purchase offering.
     * @return A Java Future containing the result of the PurchaseOffering operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>NotEligibleException Exception gets thrown when a user is not eligible to perform the specified
     *         transaction.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.PurchaseOffering
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/PurchaseOffering" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<PurchaseOfferingResponse> purchaseOffering(PurchaseOfferingRequest purchaseOfferingRequest) {

        HttpResponseHandler<PurchaseOfferingResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new PurchaseOfferingResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<PurchaseOfferingRequest, PurchaseOfferingResponse>()
                .withMarshaller(new PurchaseOfferingRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(purchaseOfferingRequest));
    }

    /**
     * <p>
     * Explicitly sets the quantity of devices to renew for an offering, starting from the <code>effectiveDate</code> of
     * the next period. The API returns a <code>NotEligible</code> error if the user is not permitted to invoke the
     * operation. Please contact <a
     * href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you believe that you
     * should be able to invoke this operation.
     * </p>
     *
     * @param renewOfferingRequest
     *        A request representing an offering renewal.
     * @return A Java Future containing the result of the RenewOffering operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>NotEligibleException Exception gets thrown when a user is not eligible to perform the specified
     *         transaction.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.RenewOffering
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/RenewOffering" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<RenewOfferingResponse> renewOffering(RenewOfferingRequest renewOfferingRequest) {

        HttpResponseHandler<RenewOfferingResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new RenewOfferingResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<RenewOfferingRequest, RenewOfferingResponse>()
                .withMarshaller(new RenewOfferingRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(renewOfferingRequest));
    }

    /**
     * <p>
     * Schedules a run.
     * </p>
     *
     * @param scheduleRunRequest
     *        Represents a request to the schedule run operation.
     * @return A Java Future containing the result of the ScheduleRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>IdempotencyException An entity with the same name already exists.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ScheduleRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ScheduleRun" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ScheduleRunResponse> scheduleRun(ScheduleRunRequest scheduleRunRequest) {

        HttpResponseHandler<ScheduleRunResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new ScheduleRunResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ScheduleRunRequest, ScheduleRunResponse>()
                .withMarshaller(new ScheduleRunRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(scheduleRunRequest));
    }

    /**
     * <p>
     * Ends a specified remote access session.
     * </p>
     *
     * @param stopRemoteAccessSessionRequest
     *        Represents the request to stop the remote access session.
     * @return A Java Future containing the result of the StopRemoteAccessSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.StopRemoteAccessSession
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/StopRemoteAccessSession"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StopRemoteAccessSessionResponse> stopRemoteAccessSession(
            StopRemoteAccessSessionRequest stopRemoteAccessSessionRequest) {

        HttpResponseHandler<StopRemoteAccessSessionResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new StopRemoteAccessSessionResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<StopRemoteAccessSessionRequest, StopRemoteAccessSessionResponse>()
                .withMarshaller(new StopRemoteAccessSessionRequestMarshaller(protocolFactory))
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(stopRemoteAccessSessionRequest));
    }

    /**
     * <p>
     * Initiates a stop request for the current test run. AWS Device Farm will immediately stop the run on devices where
     * tests have not started executing, and you will not be billed for these devices. On devices where tests have
     * started executing, Setup Suite and Teardown Suite tests will run to completion before stopping execution on those
     * devices. You will be billed for Setup, Teardown, and any tests that were in progress or already completed.
     * </p>
     *
     * @param stopRunRequest
     *        Represents the request to stop a specific run.
     * @return A Java Future containing the result of the StopRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.StopRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/StopRun" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StopRunResponse> stopRun(StopRunRequest stopRunRequest) {

        HttpResponseHandler<StopRunResponse> responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata()
                .withPayloadJson(true).withHasStreamingSuccessResponse(false), new StopRunResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<StopRunRequest, StopRunResponse>()
                .withMarshaller(new StopRunRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(stopRunRequest));
    }

    /**
     * <p>
     * Modifies the name, description, and rules in a device pool given the attributes and the pool ARN. Rule updates
     * are all-or-nothing, meaning they can only be updated as a whole (or not at all).
     * </p>
     *
     * @param updateDevicePoolRequest
     *        Represents a request to the update device pool operation.
     * @return A Java Future containing the result of the UpdateDevicePool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.UpdateDevicePool
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateDevicePool" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateDevicePoolResponse> updateDevicePool(UpdateDevicePoolRequest updateDevicePoolRequest) {

        HttpResponseHandler<UpdateDevicePoolResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new UpdateDevicePoolResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<UpdateDevicePoolRequest, UpdateDevicePoolResponse>()
                .withMarshaller(new UpdateDevicePoolRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateDevicePoolRequest));
    }

    /**
     * <p>
     * Updates the network profile with specific settings.
     * </p>
     *
     * @param updateNetworkProfileRequest
     * @return A Java Future containing the result of the UpdateNetworkProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.UpdateNetworkProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateNetworkProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateNetworkProfileResponse> updateNetworkProfile(
            UpdateNetworkProfileRequest updateNetworkProfileRequest) {

        HttpResponseHandler<UpdateNetworkProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new UpdateNetworkProfileResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<UpdateNetworkProfileRequest, UpdateNetworkProfileResponse>()
                .withMarshaller(new UpdateNetworkProfileRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateNetworkProfileRequest));
    }

    /**
     * <p>
     * Modifies the specified project name, given the project ARN and a new name.
     * </p>
     *
     * @param updateProjectRequest
     *        Represents a request to the update project operation.
     * @return A Java Future containing the result of the UpdateProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.UpdateProject
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateProject" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateProjectResponse> updateProject(UpdateProjectRequest updateProjectRequest) {

        HttpResponseHandler<UpdateProjectResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new UpdateProjectResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<UpdateProjectRequest, UpdateProjectResponse>()
                .withMarshaller(new UpdateProjectRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateProjectRequest));
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory init() {
        return new AwsJsonProtocolFactory(
                new JsonClientMetadata()
                        .withSupportsCbor(false)
                        .withSupportsIon(false)
                        .withBaseServiceExceptionClass(software.amazon.awssdk.services.devicefarm.model.DeviceFarmException.class)
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("NotEligibleException").withModeledClass(
                                        NotEligibleException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("ArgumentException").withModeledClass(
                                        ArgumentException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("NotFoundException").withModeledClass(
                                        NotFoundException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(
                                        LimitExceededException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("ServiceAccountException").withModeledClass(
                                        ServiceAccountException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("IdempotencyException").withModeledClass(
                                        IdempotencyException.class)), AwsJsonProtocolMetadata.builder().protocolVersion("1.1")
                        .protocol(AwsJsonProtocol.AWS_JSON).build());
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler() {
        return protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }
}
