/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.transform.CreateRemoteAccessSessionConfigurationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Creates the configuration settings for a remote access session, including the device model and type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateRemoteAccessSessionConfiguration implements StructuredPojo,
        ToCopyableBuilder<CreateRemoteAccessSessionConfiguration.Builder, CreateRemoteAccessSessionConfiguration> {
    private final String billingMethod;

    private CreateRemoteAccessSessionConfiguration(BuilderImpl builder) {
        this.billingMethod = builder.billingMethod;
    }

    /**
     * <p>
     * Returns the billing method for purposes of configuring a remote access session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #billingMethod}
     * will return {@link BillingMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #billingMethodAsString}.
     * </p>
     * 
     * @return Returns the billing method for purposes of configuring a remote access session.
     * @see BillingMethod
     */
    public BillingMethod billingMethod() {
        return BillingMethod.fromValue(billingMethod);
    }

    /**
     * <p>
     * Returns the billing method for purposes of configuring a remote access session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #billingMethod}
     * will return {@link BillingMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #billingMethodAsString}.
     * </p>
     * 
     * @return Returns the billing method for purposes of configuring a remote access session.
     * @see BillingMethod
     */
    public String billingMethodAsString() {
        return billingMethod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(billingMethodAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRemoteAccessSessionConfiguration)) {
            return false;
        }
        CreateRemoteAccessSessionConfiguration other = (CreateRemoteAccessSessionConfiguration) obj;
        return Objects.equals(billingMethodAsString(), other.billingMethodAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateRemoteAccessSessionConfiguration").add("BillingMethod", billingMethodAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "billingMethod":
            return Optional.of(clazz.cast(billingMethodAsString()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CreateRemoteAccessSessionConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, CreateRemoteAccessSessionConfiguration> {
        /**
         * <p>
         * Returns the billing method for purposes of configuring a remote access session.
         * </p>
         * 
         * @param billingMethod
         *        Returns the billing method for purposes of configuring a remote access session.
         * @see BillingMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingMethod
         */
        Builder billingMethod(String billingMethod);

        /**
         * <p>
         * Returns the billing method for purposes of configuring a remote access session.
         * </p>
         * 
         * @param billingMethod
         *        Returns the billing method for purposes of configuring a remote access session.
         * @see BillingMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingMethod
         */
        Builder billingMethod(BillingMethod billingMethod);
    }

    static final class BuilderImpl implements Builder {
        private String billingMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRemoteAccessSessionConfiguration model) {
            billingMethod(model.billingMethod);
        }

        public final String getBillingMethod() {
            return billingMethod;
        }

        @Override
        public final Builder billingMethod(String billingMethod) {
            this.billingMethod = billingMethod;
            return this;
        }

        @Override
        public final Builder billingMethod(BillingMethod billingMethod) {
            this.billingMethod(billingMethod.toString());
            return this;
        }

        public final void setBillingMethod(String billingMethod) {
            this.billingMethod = billingMethod;
        }

        @Override
        public CreateRemoteAccessSessionConfiguration build() {
            return new CreateRemoteAccessSessionConfiguration(this);
        }
    }
}
