/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Creates and submits a request to start a remote access session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateRemoteAccessSessionRequest extends DeviceFarmRequest implements
        ToCopyableBuilder<CreateRemoteAccessSessionRequest.Builder, CreateRemoteAccessSessionRequest> {
    private final String projectArn;

    private final String deviceArn;

    private final String sshPublicKey;

    private final Boolean remoteDebugEnabled;

    private final String name;

    private final String clientId;

    private final CreateRemoteAccessSessionConfiguration configuration;

    private CreateRemoteAccessSessionRequest(BuilderImpl builder) {
        super(builder);
        this.projectArn = builder.projectArn;
        this.deviceArn = builder.deviceArn;
        this.sshPublicKey = builder.sshPublicKey;
        this.remoteDebugEnabled = builder.remoteDebugEnabled;
        this.name = builder.name;
        this.clientId = builder.clientId;
        this.configuration = builder.configuration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the project for which you want to create a remote access session.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the project for which you want to create a remote access session.
     */
    public String projectArn() {
        return projectArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the device for which you want to create a remote access session.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the device for which you want to create a remote access session.
     */
    public String deviceArn() {
        return deviceArn;
    }

    /**
     * <p>
     * The public key of the <code>ssh</code> key pair you want to use for connecting to remote devices in your remote
     * debugging session. This is only required if <code>remoteDebugEnabled</code> is set to <code>true</code>.
     * </p>
     * 
     * @return The public key of the <code>ssh</code> key pair you want to use for connecting to remote devices in your
     *         remote debugging session. This is only required if <code>remoteDebugEnabled</code> is set to
     *         <code>true</code>.
     */
    public String sshPublicKey() {
        return sshPublicKey;
    }

    /**
     * <p>
     * Set to <code>true</code> if you want to access devices remotely for debugging in your remote access session.
     * </p>
     * 
     * @return Set to <code>true</code> if you want to access devices remotely for debugging in your remote access
     *         session.
     */
    public Boolean remoteDebugEnabled() {
        return remoteDebugEnabled;
    }

    /**
     * <p>
     * The name of the remote access session that you wish to create.
     * </p>
     * 
     * @return The name of the remote access session that you wish to create.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * Unique identifier for the client. If you want access to multiple devices on the same client, you should pass the
     * same <code>clientId</code> value in each call to <code>CreateRemoteAccessSession</code>. This is required only if
     * <code>remoteDebugEnabled</code> is set to true <code>true</code>.
     * </p>
     * 
     * @return Unique identifier for the client. If you want access to multiple devices on the same client, you should
     *         pass the same <code>clientId</code> value in each call to <code>CreateRemoteAccessSession</code>. This is
     *         required only if <code>remoteDebugEnabled</code> is set to true <code>true</code>.
     */
    public String clientId() {
        return clientId;
    }

    /**
     * <p>
     * The configuration information for the remote access session request.
     * </p>
     * 
     * @return The configuration information for the remote access session request.
     */
    public CreateRemoteAccessSessionConfiguration configuration() {
        return configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(projectArn());
        hashCode = 31 * hashCode + Objects.hashCode(deviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(sshPublicKey());
        hashCode = 31 * hashCode + Objects.hashCode(remoteDebugEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRemoteAccessSessionRequest)) {
            return false;
        }
        CreateRemoteAccessSessionRequest other = (CreateRemoteAccessSessionRequest) obj;
        return Objects.equals(projectArn(), other.projectArn()) && Objects.equals(deviceArn(), other.deviceArn())
                && Objects.equals(sshPublicKey(), other.sshPublicKey())
                && Objects.equals(remoteDebugEnabled(), other.remoteDebugEnabled()) && Objects.equals(name(), other.name())
                && Objects.equals(clientId(), other.clientId()) && Objects.equals(configuration(), other.configuration());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateRemoteAccessSessionRequest").add("ProjectArn", projectArn()).add("DeviceArn", deviceArn())
                .add("SshPublicKey", sshPublicKey()).add("RemoteDebugEnabled", remoteDebugEnabled()).add("Name", name())
                .add("ClientId", clientId()).add("Configuration", configuration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "projectArn":
            return Optional.of(clazz.cast(projectArn()));
        case "deviceArn":
            return Optional.of(clazz.cast(deviceArn()));
        case "sshPublicKey":
            return Optional.of(clazz.cast(sshPublicKey()));
        case "remoteDebugEnabled":
            return Optional.of(clazz.cast(remoteDebugEnabled()));
        case "name":
            return Optional.of(clazz.cast(name()));
        case "clientId":
            return Optional.of(clazz.cast(clientId()));
        case "configuration":
            return Optional.of(clazz.cast(configuration()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends DeviceFarmRequest.Builder, CopyableBuilder<Builder, CreateRemoteAccessSessionRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the project for which you want to create a remote access session.
         * </p>
         * 
         * @param projectArn
         *        The Amazon Resource Name (ARN) of the project for which you want to create a remote access session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectArn(String projectArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the device for which you want to create a remote access session.
         * </p>
         * 
         * @param deviceArn
         *        The Amazon Resource Name (ARN) of the device for which you want to create a remote access session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceArn(String deviceArn);

        /**
         * <p>
         * The public key of the <code>ssh</code> key pair you want to use for connecting to remote devices in your
         * remote debugging session. This is only required if <code>remoteDebugEnabled</code> is set to
         * <code>true</code>.
         * </p>
         * 
         * @param sshPublicKey
         *        The public key of the <code>ssh</code> key pair you want to use for connecting to remote devices in
         *        your remote debugging session. This is only required if <code>remoteDebugEnabled</code> is set to
         *        <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshPublicKey(String sshPublicKey);

        /**
         * <p>
         * Set to <code>true</code> if you want to access devices remotely for debugging in your remote access session.
         * </p>
         * 
         * @param remoteDebugEnabled
         *        Set to <code>true</code> if you want to access devices remotely for debugging in your remote access
         *        session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteDebugEnabled(Boolean remoteDebugEnabled);

        /**
         * <p>
         * The name of the remote access session that you wish to create.
         * </p>
         * 
         * @param name
         *        The name of the remote access session that you wish to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Unique identifier for the client. If you want access to multiple devices on the same client, you should pass
         * the same <code>clientId</code> value in each call to <code>CreateRemoteAccessSession</code>. This is required
         * only if <code>remoteDebugEnabled</code> is set to true <code>true</code>.
         * </p>
         * 
         * @param clientId
         *        Unique identifier for the client. If you want access to multiple devices on the same client, you
         *        should pass the same <code>clientId</code> value in each call to
         *        <code>CreateRemoteAccessSession</code>. This is required only if <code>remoteDebugEnabled</code> is
         *        set to true <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * <p>
         * The configuration information for the remote access session request.
         * </p>
         * 
         * @param configuration
         *        The configuration information for the remote access session request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(CreateRemoteAccessSessionConfiguration configuration);

        /**
         * <p>
         * The configuration information for the remote access session request.
         * </p>
         * This is a convenience that creates an instance of the {@link CreateRemoteAccessSessionConfiguration.Builder}
         * avoiding the need to create one manually via {@link CreateRemoteAccessSessionConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link CreateRemoteAccessSessionConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #configuration(CreateRemoteAccessSessionConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link CreateRemoteAccessSessionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(CreateRemoteAccessSessionConfiguration)
         */
        default Builder configuration(Consumer<CreateRemoteAccessSessionConfiguration.Builder> configuration) {
            return configuration(CreateRemoteAccessSessionConfiguration.builder().apply(configuration).build());
        }

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DeviceFarmRequest.BuilderImpl implements Builder {
        private String projectArn;

        private String deviceArn;

        private String sshPublicKey;

        private Boolean remoteDebugEnabled;

        private String name;

        private String clientId;

        private CreateRemoteAccessSessionConfiguration configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRemoteAccessSessionRequest model) {
            super(model);
            projectArn(model.projectArn);
            deviceArn(model.deviceArn);
            sshPublicKey(model.sshPublicKey);
            remoteDebugEnabled(model.remoteDebugEnabled);
            name(model.name);
            clientId(model.clientId);
            configuration(model.configuration);
        }

        public final String getProjectArn() {
            return projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        public final String getDeviceArn() {
            return deviceArn;
        }

        @Override
        public final Builder deviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
            return this;
        }

        public final void setDeviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
        }

        public final String getSshPublicKey() {
            return sshPublicKey;
        }

        @Override
        public final Builder sshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
            return this;
        }

        public final void setSshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
        }

        public final Boolean getRemoteDebugEnabled() {
            return remoteDebugEnabled;
        }

        @Override
        public final Builder remoteDebugEnabled(Boolean remoteDebugEnabled) {
            this.remoteDebugEnabled = remoteDebugEnabled;
            return this;
        }

        public final void setRemoteDebugEnabled(Boolean remoteDebugEnabled) {
            this.remoteDebugEnabled = remoteDebugEnabled;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getClientId() {
            return clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final CreateRemoteAccessSessionConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        @Override
        public final Builder configuration(CreateRemoteAccessSessionConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final void setConfiguration(CreateRemoteAccessSessionConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateRemoteAccessSessionRequest build() {
            return new CreateRemoteAccessSessionRequest(this);
        }
    }
}
