/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.transform.DeviceMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a device type that an app is tested against.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Device implements StructuredPojo, ToCopyableBuilder<Device.Builder, Device> {
    private final String arn;

    private final String name;

    private final String manufacturer;

    private final String model;

    private final String formFactor;

    private final String platform;

    private final String os;

    private final CPU cpu;

    private final Resolution resolution;

    private final Long heapSize;

    private final Long memory;

    private final String image;

    private final String carrier;

    private final String radio;

    private final Boolean remoteAccessEnabled;

    private final Boolean remoteDebugEnabled;

    private final String fleetType;

    private final String fleetName;

    private Device(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.manufacturer = builder.manufacturer;
        this.model = builder.model;
        this.formFactor = builder.formFactor;
        this.platform = builder.platform;
        this.os = builder.os;
        this.cpu = builder.cpu;
        this.resolution = builder.resolution;
        this.heapSize = builder.heapSize;
        this.memory = builder.memory;
        this.image = builder.image;
        this.carrier = builder.carrier;
        this.radio = builder.radio;
        this.remoteAccessEnabled = builder.remoteAccessEnabled;
        this.remoteDebugEnabled = builder.remoteDebugEnabled;
        this.fleetType = builder.fleetType;
        this.fleetName = builder.fleetName;
    }

    /**
     * <p>
     * The device's ARN.
     * </p>
     * 
     * @return The device's ARN.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The device's display name.
     * </p>
     * 
     * @return The device's display name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The device's manufacturer name.
     * </p>
     * 
     * @return The device's manufacturer name.
     */
    public String manufacturer() {
        return manufacturer;
    }

    /**
     * <p>
     * The device's model name.
     * </p>
     * 
     * @return The device's model name.
     */
    public String model() {
        return model;
    }

    /**
     * <p>
     * The device's form factor.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PHONE: The phone form factor.
     * </p>
     * </li>
     * <li>
     * <p>
     * TABLET: The tablet form factor.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #formFactor} will
     * return {@link DeviceFormFactor#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formFactorAsString}.
     * </p>
     * 
     * @return The device's form factor.</p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         PHONE: The phone form factor.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TABLET: The tablet form factor.
     *         </p>
     *         </li>
     * @see DeviceFormFactor
     */
    public DeviceFormFactor formFactor() {
        return DeviceFormFactor.fromValue(formFactor);
    }

    /**
     * <p>
     * The device's form factor.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PHONE: The phone form factor.
     * </p>
     * </li>
     * <li>
     * <p>
     * TABLET: The tablet form factor.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #formFactor} will
     * return {@link DeviceFormFactor#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formFactorAsString}.
     * </p>
     * 
     * @return The device's form factor.</p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         PHONE: The phone form factor.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TABLET: The tablet form factor.
     *         </p>
     *         </li>
     * @see DeviceFormFactor
     */
    public String formFactorAsString() {
        return formFactor;
    }

    /**
     * <p>
     * The device's platform.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ANDROID: The Android platform.
     * </p>
     * </li>
     * <li>
     * <p>
     * IOS: The iOS platform.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link DevicePlatform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The device's platform.</p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         ANDROID: The Android platform.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IOS: The iOS platform.
     *         </p>
     *         </li>
     * @see DevicePlatform
     */
    public DevicePlatform platform() {
        return DevicePlatform.fromValue(platform);
    }

    /**
     * <p>
     * The device's platform.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ANDROID: The Android platform.
     * </p>
     * </li>
     * <li>
     * <p>
     * IOS: The iOS platform.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link DevicePlatform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The device's platform.</p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         ANDROID: The Android platform.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IOS: The iOS platform.
     *         </p>
     *         </li>
     * @see DevicePlatform
     */
    public String platformAsString() {
        return platform;
    }

    /**
     * <p>
     * The device's operating system type.
     * </p>
     * 
     * @return The device's operating system type.
     */
    public String os() {
        return os;
    }

    /**
     * <p>
     * Information about the device's CPU.
     * </p>
     * 
     * @return Information about the device's CPU.
     */
    public CPU cpu() {
        return cpu;
    }

    /**
     * <p>
     * The resolution of the device.
     * </p>
     * 
     * @return The resolution of the device.
     */
    public Resolution resolution() {
        return resolution;
    }

    /**
     * <p>
     * The device's heap size, expressed in bytes.
     * </p>
     * 
     * @return The device's heap size, expressed in bytes.
     */
    public Long heapSize() {
        return heapSize;
    }

    /**
     * <p>
     * The device's total memory size, expressed in bytes.
     * </p>
     * 
     * @return The device's total memory size, expressed in bytes.
     */
    public Long memory() {
        return memory;
    }

    /**
     * <p>
     * The device's image name.
     * </p>
     * 
     * @return The device's image name.
     */
    public String image() {
        return image;
    }

    /**
     * <p>
     * The device's carrier.
     * </p>
     * 
     * @return The device's carrier.
     */
    public String carrier() {
        return carrier;
    }

    /**
     * <p>
     * The device's radio.
     * </p>
     * 
     * @return The device's radio.
     */
    public String radio() {
        return radio;
    }

    /**
     * <p>
     * Specifies whether remote access has been enabled for the specified device.
     * </p>
     * 
     * @return Specifies whether remote access has been enabled for the specified device.
     */
    public Boolean remoteAccessEnabled() {
        return remoteAccessEnabled;
    }

    /**
     * <p>
     * This flag is set to <code>true</code> if remote debugging is enabled for the device.
     * </p>
     * 
     * @return This flag is set to <code>true</code> if remote debugging is enabled for the device.
     */
    public Boolean remoteDebugEnabled() {
        return remoteDebugEnabled;
    }

    /**
     * <p>
     * The type of fleet to which this device belongs. Possible values for fleet type are PRIVATE and PUBLIC.
     * </p>
     * 
     * @return The type of fleet to which this device belongs. Possible values for fleet type are PRIVATE and PUBLIC.
     */
    public String fleetType() {
        return fleetType;
    }

    /**
     * <p>
     * The name of the fleet to which this device belongs.
     * </p>
     * 
     * @return The name of the fleet to which this device belongs.
     */
    public String fleetName() {
        return fleetName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(manufacturer());
        hashCode = 31 * hashCode + Objects.hashCode(model());
        hashCode = 31 * hashCode + Objects.hashCode(formFactorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(os());
        hashCode = 31 * hashCode + Objects.hashCode(cpu());
        hashCode = 31 * hashCode + Objects.hashCode(resolution());
        hashCode = 31 * hashCode + Objects.hashCode(heapSize());
        hashCode = 31 * hashCode + Objects.hashCode(memory());
        hashCode = 31 * hashCode + Objects.hashCode(image());
        hashCode = 31 * hashCode + Objects.hashCode(carrier());
        hashCode = 31 * hashCode + Objects.hashCode(radio());
        hashCode = 31 * hashCode + Objects.hashCode(remoteAccessEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(remoteDebugEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(fleetType());
        hashCode = 31 * hashCode + Objects.hashCode(fleetName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Device)) {
            return false;
        }
        Device other = (Device) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(manufacturer(), other.manufacturer()) && Objects.equals(model(), other.model())
                && Objects.equals(formFactorAsString(), other.formFactorAsString())
                && Objects.equals(platformAsString(), other.platformAsString()) && Objects.equals(os(), other.os())
                && Objects.equals(cpu(), other.cpu()) && Objects.equals(resolution(), other.resolution())
                && Objects.equals(heapSize(), other.heapSize()) && Objects.equals(memory(), other.memory())
                && Objects.equals(image(), other.image()) && Objects.equals(carrier(), other.carrier())
                && Objects.equals(radio(), other.radio()) && Objects.equals(remoteAccessEnabled(), other.remoteAccessEnabled())
                && Objects.equals(remoteDebugEnabled(), other.remoteDebugEnabled())
                && Objects.equals(fleetType(), other.fleetType()) && Objects.equals(fleetName(), other.fleetName());
    }

    @Override
    public String toString() {
        return ToString.builder("Device").add("Arn", arn()).add("Name", name()).add("Manufacturer", manufacturer())
                .add("Model", model()).add("FormFactor", formFactorAsString()).add("Platform", platformAsString())
                .add("Os", os()).add("Cpu", cpu()).add("Resolution", resolution()).add("HeapSize", heapSize())
                .add("Memory", memory()).add("Image", image()).add("Carrier", carrier()).add("Radio", radio())
                .add("RemoteAccessEnabled", remoteAccessEnabled()).add("RemoteDebugEnabled", remoteDebugEnabled())
                .add("FleetType", fleetType()).add("FleetName", fleetName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.of(clazz.cast(arn()));
        case "name":
            return Optional.of(clazz.cast(name()));
        case "manufacturer":
            return Optional.of(clazz.cast(manufacturer()));
        case "model":
            return Optional.of(clazz.cast(model()));
        case "formFactor":
            return Optional.of(clazz.cast(formFactorAsString()));
        case "platform":
            return Optional.of(clazz.cast(platformAsString()));
        case "os":
            return Optional.of(clazz.cast(os()));
        case "cpu":
            return Optional.of(clazz.cast(cpu()));
        case "resolution":
            return Optional.of(clazz.cast(resolution()));
        case "heapSize":
            return Optional.of(clazz.cast(heapSize()));
        case "memory":
            return Optional.of(clazz.cast(memory()));
        case "image":
            return Optional.of(clazz.cast(image()));
        case "carrier":
            return Optional.of(clazz.cast(carrier()));
        case "radio":
            return Optional.of(clazz.cast(radio()));
        case "remoteAccessEnabled":
            return Optional.of(clazz.cast(remoteAccessEnabled()));
        case "remoteDebugEnabled":
            return Optional.of(clazz.cast(remoteDebugEnabled()));
        case "fleetType":
            return Optional.of(clazz.cast(fleetType()));
        case "fleetName":
            return Optional.of(clazz.cast(fleetName()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeviceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Device> {
        /**
         * <p>
         * The device's ARN.
         * </p>
         * 
         * @param arn
         *        The device's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The device's display name.
         * </p>
         * 
         * @param name
         *        The device's display name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The device's manufacturer name.
         * </p>
         * 
         * @param manufacturer
         *        The device's manufacturer name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manufacturer(String manufacturer);

        /**
         * <p>
         * The device's model name.
         * </p>
         * 
         * @param model
         *        The device's model name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder model(String model);

        /**
         * <p>
         * The device's form factor.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PHONE: The phone form factor.
         * </p>
         * </li>
         * <li>
         * <p>
         * TABLET: The tablet form factor.
         * </p>
         * </li>
         * </ul>
         * 
         * @param formFactor
         *        The device's form factor.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        PHONE: The phone form factor.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TABLET: The tablet form factor.
         *        </p>
         *        </li>
         * @see DeviceFormFactor
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceFormFactor
         */
        Builder formFactor(String formFactor);

        /**
         * <p>
         * The device's form factor.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PHONE: The phone form factor.
         * </p>
         * </li>
         * <li>
         * <p>
         * TABLET: The tablet form factor.
         * </p>
         * </li>
         * </ul>
         * 
         * @param formFactor
         *        The device's form factor.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        PHONE: The phone form factor.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TABLET: The tablet form factor.
         *        </p>
         *        </li>
         * @see DeviceFormFactor
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceFormFactor
         */
        Builder formFactor(DeviceFormFactor formFactor);

        /**
         * <p>
         * The device's platform.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ANDROID: The Android platform.
         * </p>
         * </li>
         * <li>
         * <p>
         * IOS: The iOS platform.
         * </p>
         * </li>
         * </ul>
         * 
         * @param platform
         *        The device's platform.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        ANDROID: The Android platform.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IOS: The iOS platform.
         *        </p>
         *        </li>
         * @see DevicePlatform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DevicePlatform
         */
        Builder platform(String platform);

        /**
         * <p>
         * The device's platform.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ANDROID: The Android platform.
         * </p>
         * </li>
         * <li>
         * <p>
         * IOS: The iOS platform.
         * </p>
         * </li>
         * </ul>
         * 
         * @param platform
         *        The device's platform.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        ANDROID: The Android platform.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IOS: The iOS platform.
         *        </p>
         *        </li>
         * @see DevicePlatform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DevicePlatform
         */
        Builder platform(DevicePlatform platform);

        /**
         * <p>
         * The device's operating system type.
         * </p>
         * 
         * @param os
         *        The device's operating system type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder os(String os);

        /**
         * <p>
         * Information about the device's CPU.
         * </p>
         * 
         * @param cpu
         *        Information about the device's CPU.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpu(CPU cpu);

        /**
         * <p>
         * Information about the device's CPU.
         * </p>
         * This is a convenience that creates an instance of the {@link CPU.Builder} avoiding the need to create one
         * manually via {@link CPU#builder()}.
         *
         * When the {@link Consumer} completes, {@link CPU.Builder#build()} is called immediately and its result is
         * passed to {@link #cpu(CPU)}.
         * 
         * @param cpu
         *        a consumer that will call methods on {@link CPU.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cpu(CPU)
         */
        default Builder cpu(Consumer<CPU.Builder> cpu) {
            return cpu(CPU.builder().apply(cpu).build());
        }

        /**
         * <p>
         * The resolution of the device.
         * </p>
         * 
         * @param resolution
         *        The resolution of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolution(Resolution resolution);

        /**
         * <p>
         * The resolution of the device.
         * </p>
         * This is a convenience that creates an instance of the {@link Resolution.Builder} avoiding the need to create
         * one manually via {@link Resolution#builder()}.
         *
         * When the {@link Consumer} completes, {@link Resolution.Builder#build()} is called immediately and its result
         * is passed to {@link #resolution(Resolution)}.
         * 
         * @param resolution
         *        a consumer that will call methods on {@link Resolution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resolution(Resolution)
         */
        default Builder resolution(Consumer<Resolution.Builder> resolution) {
            return resolution(Resolution.builder().apply(resolution).build());
        }

        /**
         * <p>
         * The device's heap size, expressed in bytes.
         * </p>
         * 
         * @param heapSize
         *        The device's heap size, expressed in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder heapSize(Long heapSize);

        /**
         * <p>
         * The device's total memory size, expressed in bytes.
         * </p>
         * 
         * @param memory
         *        The device's total memory size, expressed in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memory(Long memory);

        /**
         * <p>
         * The device's image name.
         * </p>
         * 
         * @param image
         *        The device's image name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder image(String image);

        /**
         * <p>
         * The device's carrier.
         * </p>
         * 
         * @param carrier
         *        The device's carrier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder carrier(String carrier);

        /**
         * <p>
         * The device's radio.
         * </p>
         * 
         * @param radio
         *        The device's radio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder radio(String radio);

        /**
         * <p>
         * Specifies whether remote access has been enabled for the specified device.
         * </p>
         * 
         * @param remoteAccessEnabled
         *        Specifies whether remote access has been enabled for the specified device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteAccessEnabled(Boolean remoteAccessEnabled);

        /**
         * <p>
         * This flag is set to <code>true</code> if remote debugging is enabled for the device.
         * </p>
         * 
         * @param remoteDebugEnabled
         *        This flag is set to <code>true</code> if remote debugging is enabled for the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteDebugEnabled(Boolean remoteDebugEnabled);

        /**
         * <p>
         * The type of fleet to which this device belongs. Possible values for fleet type are PRIVATE and PUBLIC.
         * </p>
         * 
         * @param fleetType
         *        The type of fleet to which this device belongs. Possible values for fleet type are PRIVATE and PUBLIC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetType(String fleetType);

        /**
         * <p>
         * The name of the fleet to which this device belongs.
         * </p>
         * 
         * @param fleetName
         *        The name of the fleet to which this device belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetName(String fleetName);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String manufacturer;

        private String model;

        private String formFactor;

        private String platform;

        private String os;

        private CPU cpu;

        private Resolution resolution;

        private Long heapSize;

        private Long memory;

        private String image;

        private String carrier;

        private String radio;

        private Boolean remoteAccessEnabled;

        private Boolean remoteDebugEnabled;

        private String fleetType;

        private String fleetName;

        private BuilderImpl() {
        }

        private BuilderImpl(Device model) {
            arn(model.arn);
            name(model.name);
            manufacturer(model.manufacturer);
            model(model.model);
            formFactor(model.formFactor);
            platform(model.platform);
            os(model.os);
            cpu(model.cpu);
            resolution(model.resolution);
            heapSize(model.heapSize);
            memory(model.memory);
            image(model.image);
            carrier(model.carrier);
            radio(model.radio);
            remoteAccessEnabled(model.remoteAccessEnabled);
            remoteDebugEnabled(model.remoteDebugEnabled);
            fleetType(model.fleetType);
            fleetName(model.fleetName);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getManufacturer() {
            return manufacturer;
        }

        @Override
        public final Builder manufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
            return this;
        }

        public final void setManufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
        }

        public final String getModel() {
            return model;
        }

        @Override
        public final Builder model(String model) {
            this.model = model;
            return this;
        }

        public final void setModel(String model) {
            this.model = model;
        }

        public final String getFormFactor() {
            return formFactor;
        }

        @Override
        public final Builder formFactor(String formFactor) {
            this.formFactor = formFactor;
            return this;
        }

        @Override
        public final Builder formFactor(DeviceFormFactor formFactor) {
            this.formFactor(formFactor.toString());
            return this;
        }

        public final void setFormFactor(String formFactor) {
            this.formFactor = formFactor;
        }

        public final String getPlatform() {
            return platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(DevicePlatform platform) {
            this.platform(platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getOs() {
            return os;
        }

        @Override
        public final Builder os(String os) {
            this.os = os;
            return this;
        }

        public final void setOs(String os) {
            this.os = os;
        }

        public final CPU.Builder getCpu() {
            return cpu != null ? cpu.toBuilder() : null;
        }

        @Override
        public final Builder cpu(CPU cpu) {
            this.cpu = cpu;
            return this;
        }

        public final void setCpu(CPU.BuilderImpl cpu) {
            this.cpu = cpu != null ? cpu.build() : null;
        }

        public final Resolution.Builder getResolution() {
            return resolution != null ? resolution.toBuilder() : null;
        }

        @Override
        public final Builder resolution(Resolution resolution) {
            this.resolution = resolution;
            return this;
        }

        public final void setResolution(Resolution.BuilderImpl resolution) {
            this.resolution = resolution != null ? resolution.build() : null;
        }

        public final Long getHeapSize() {
            return heapSize;
        }

        @Override
        public final Builder heapSize(Long heapSize) {
            this.heapSize = heapSize;
            return this;
        }

        public final void setHeapSize(Long heapSize) {
            this.heapSize = heapSize;
        }

        public final Long getMemory() {
            return memory;
        }

        @Override
        public final Builder memory(Long memory) {
            this.memory = memory;
            return this;
        }

        public final void setMemory(Long memory) {
            this.memory = memory;
        }

        public final String getImage() {
            return image;
        }

        @Override
        public final Builder image(String image) {
            this.image = image;
            return this;
        }

        public final void setImage(String image) {
            this.image = image;
        }

        public final String getCarrier() {
            return carrier;
        }

        @Override
        public final Builder carrier(String carrier) {
            this.carrier = carrier;
            return this;
        }

        public final void setCarrier(String carrier) {
            this.carrier = carrier;
        }

        public final String getRadio() {
            return radio;
        }

        @Override
        public final Builder radio(String radio) {
            this.radio = radio;
            return this;
        }

        public final void setRadio(String radio) {
            this.radio = radio;
        }

        public final Boolean getRemoteAccessEnabled() {
            return remoteAccessEnabled;
        }

        @Override
        public final Builder remoteAccessEnabled(Boolean remoteAccessEnabled) {
            this.remoteAccessEnabled = remoteAccessEnabled;
            return this;
        }

        public final void setRemoteAccessEnabled(Boolean remoteAccessEnabled) {
            this.remoteAccessEnabled = remoteAccessEnabled;
        }

        public final Boolean getRemoteDebugEnabled() {
            return remoteDebugEnabled;
        }

        @Override
        public final Builder remoteDebugEnabled(Boolean remoteDebugEnabled) {
            this.remoteDebugEnabled = remoteDebugEnabled;
            return this;
        }

        public final void setRemoteDebugEnabled(Boolean remoteDebugEnabled) {
            this.remoteDebugEnabled = remoteDebugEnabled;
        }

        public final String getFleetType() {
            return fleetType;
        }

        @Override
        public final Builder fleetType(String fleetType) {
            this.fleetType = fleetType;
            return this;
        }

        public final void setFleetType(String fleetType) {
            this.fleetType = fleetType;
        }

        public final String getFleetName() {
            return fleetName;
        }

        @Override
        public final Builder fleetName(String fleetName) {
            this.fleetName = fleetName;
            return this;
        }

        public final void setFleetName(String fleetName) {
            this.fleetName = fleetName;
        }

        @Override
        public Device build() {
            return new Device(this);
        }
    }
}
