/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the account settings return values from the <code>GetAccountSettings</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetAccountSettingsResponse extends DeviceFarmResponse implements
        ToCopyableBuilder<GetAccountSettingsResponse.Builder, GetAccountSettingsResponse> {
    private final AccountSettings accountSettings;

    private GetAccountSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.accountSettings = builder.accountSettings;
    }

    /**
     * <p>
     * The account settings.
     * </p>
     * 
     * @return The account settings.
     */
    public AccountSettings accountSettings() {
        return accountSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountSettings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccountSettingsResponse)) {
            return false;
        }
        GetAccountSettingsResponse other = (GetAccountSettingsResponse) obj;
        return Objects.equals(accountSettings(), other.accountSettings());
    }

    @Override
    public String toString() {
        return ToString.builder("GetAccountSettingsResponse").add("AccountSettings", accountSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountSettings":
            return Optional.of(clazz.cast(accountSettings()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends DeviceFarmResponse.Builder, CopyableBuilder<Builder, GetAccountSettingsResponse> {
        /**
         * <p>
         * The account settings.
         * </p>
         * 
         * @param accountSettings
         *        The account settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountSettings(AccountSettings accountSettings);

        /**
         * <p>
         * The account settings.
         * </p>
         * This is a convenience that creates an instance of the {@link AccountSettings.Builder} avoiding the need to
         * create one manually via {@link AccountSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link AccountSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #accountSettings(AccountSettings)}.
         * 
         * @param accountSettings
         *        a consumer that will call methods on {@link AccountSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountSettings(AccountSettings)
         */
        default Builder accountSettings(Consumer<AccountSettings.Builder> accountSettings) {
            return accountSettings(AccountSettings.builder().apply(accountSettings).build());
        }
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private AccountSettings accountSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccountSettingsResponse model) {
            super(model);
            accountSettings(model.accountSettings);
        }

        public final AccountSettings.Builder getAccountSettings() {
            return accountSettings != null ? accountSettings.toBuilder() : null;
        }

        @Override
        public final Builder accountSettings(AccountSettings accountSettings) {
            this.accountSettings = accountSettings;
            return this;
        }

        public final void setAccountSettings(AccountSettings.BuilderImpl accountSettings) {
            this.accountSettings = accountSettings != null ? accountSettings.build() : null;
        }

        @Override
        public GetAccountSettingsResponse build() {
            return new GetAccountSettingsResponse(this);
        }
    }
}
