/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns the status result for a device offering.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetOfferingStatusResponse extends DeviceFarmResponse implements
        ToCopyableBuilder<GetOfferingStatusResponse.Builder, GetOfferingStatusResponse> {
    private final Map<String, OfferingStatus> current;

    private final Map<String, OfferingStatus> nextPeriod;

    private final String nextToken;

    private GetOfferingStatusResponse(BuilderImpl builder) {
        super(builder);
        this.current = builder.current;
        this.nextPeriod = builder.nextPeriod;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * When specified, gets the offering status for the current period.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return When specified, gets the offering status for the current period.
     */
    public Map<String, OfferingStatus> current() {
        return current;
    }

    /**
     * <p>
     * When specified, gets the offering status for the next period.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return When specified, gets the offering status for the next period.
     */
    public Map<String, OfferingStatus> nextPeriod() {
        return nextPeriod;
    }

    /**
     * <p>
     * An identifier that was returned from the previous call to this operation, which can be used to return the next
     * set of items in the list.
     * </p>
     * 
     * @return An identifier that was returned from the previous call to this operation, which can be used to return the
     *         next set of items in the list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(current());
        hashCode = 31 * hashCode + Objects.hashCode(nextPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOfferingStatusResponse)) {
            return false;
        }
        GetOfferingStatusResponse other = (GetOfferingStatusResponse) obj;
        return Objects.equals(current(), other.current()) && Objects.equals(nextPeriod(), other.nextPeriod())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("GetOfferingStatusResponse").add("Current", current()).add("NextPeriod", nextPeriod())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "current":
            return Optional.of(clazz.cast(current()));
        case "nextPeriod":
            return Optional.of(clazz.cast(nextPeriod()));
        case "nextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends DeviceFarmResponse.Builder, CopyableBuilder<Builder, GetOfferingStatusResponse> {
        /**
         * <p>
         * When specified, gets the offering status for the current period.
         * </p>
         * 
         * @param current
         *        When specified, gets the offering status for the current period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder current(Map<String, OfferingStatus> current);

        /**
         * <p>
         * When specified, gets the offering status for the next period.
         * </p>
         * 
         * @param nextPeriod
         *        When specified, gets the offering status for the next period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPeriod(Map<String, OfferingStatus> nextPeriod);

        /**
         * <p>
         * An identifier that was returned from the previous call to this operation, which can be used to return the
         * next set of items in the list.
         * </p>
         * 
         * @param nextToken
         *        An identifier that was returned from the previous call to this operation, which can be used to return
         *        the next set of items in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private Map<String, OfferingStatus> current;

        private Map<String, OfferingStatus> nextPeriod;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOfferingStatusResponse model) {
            super(model);
            current(model.current);
            nextPeriod(model.nextPeriod);
            nextToken(model.nextToken);
        }

        public final Map<String, OfferingStatus.Builder> getCurrent() {
            return current != null ? CollectionUtils.mapValues(current, OfferingStatus::toBuilder) : null;
        }

        @Override
        public final Builder current(Map<String, OfferingStatus> current) {
            this.current = OfferingStatusMapCopier.copy(current);
            return this;
        }

        public final void setCurrent(Map<String, OfferingStatus.BuilderImpl> current) {
            this.current = OfferingStatusMapCopier.copyFromBuilder(current);
        }

        public final Map<String, OfferingStatus.Builder> getNextPeriod() {
            return nextPeriod != null ? CollectionUtils.mapValues(nextPeriod, OfferingStatus::toBuilder) : null;
        }

        @Override
        public final Builder nextPeriod(Map<String, OfferingStatus> nextPeriod) {
            this.nextPeriod = OfferingStatusMapCopier.copy(nextPeriod);
            return this;
        }

        public final void setNextPeriod(Map<String, OfferingStatus.BuilderImpl> nextPeriod) {
            this.nextPeriod = OfferingStatusMapCopier.copyFromBuilder(nextPeriod);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetOfferingStatusResponse build() {
            return new GetOfferingStatusResponse(this);
        }
    }
}
