/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the result of a get suite request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetSuiteResponse extends DeviceFarmResponse implements ToCopyableBuilder<GetSuiteResponse.Builder, GetSuiteResponse> {
    private final Suite suite;

    private GetSuiteResponse(BuilderImpl builder) {
        super(builder);
        this.suite = builder.suite;
    }

    /**
     * <p>
     * A collection of one or more tests.
     * </p>
     * 
     * @return A collection of one or more tests.
     */
    public Suite suite() {
        return suite;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(suite());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSuiteResponse)) {
            return false;
        }
        GetSuiteResponse other = (GetSuiteResponse) obj;
        return Objects.equals(suite(), other.suite());
    }

    @Override
    public String toString() {
        return ToString.builder("GetSuiteResponse").add("Suite", suite()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "suite":
            return Optional.of(clazz.cast(suite()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends DeviceFarmResponse.Builder, CopyableBuilder<Builder, GetSuiteResponse> {
        /**
         * <p>
         * A collection of one or more tests.
         * </p>
         * 
         * @param suite
         *        A collection of one or more tests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suite(Suite suite);

        /**
         * <p>
         * A collection of one or more tests.
         * </p>
         * This is a convenience that creates an instance of the {@link Suite.Builder} avoiding the need to create one
         * manually via {@link Suite#builder()}.
         *
         * When the {@link Consumer} completes, {@link Suite.Builder#build()} is called immediately and its result is
         * passed to {@link #suite(Suite)}.
         * 
         * @param suite
         *        a consumer that will call methods on {@link Suite.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #suite(Suite)
         */
        default Builder suite(Consumer<Suite.Builder> suite) {
            return suite(Suite.builder().apply(suite).build());
        }
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private Suite suite;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSuiteResponse model) {
            super(model);
            suite(model.suite);
        }

        public final Suite.Builder getSuite() {
            return suite != null ? suite.toBuilder() : null;
        }

        @Override
        public final Builder suite(Suite suite) {
            this.suite = suite;
            return this;
        }

        public final void setSuite(Suite.BuilderImpl suite) {
            this.suite = suite != null ? suite.build() : null;
        }

        @Override
        public GetSuiteResponse build() {
            return new GetSuiteResponse(this);
        }
    }
}
