/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the result of a list device pools request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListDevicePoolsResponse extends DeviceFarmResponse implements
        ToCopyableBuilder<ListDevicePoolsResponse.Builder, ListDevicePoolsResponse> {
    private final List<DevicePool> devicePools;

    private final String nextToken;

    private ListDevicePoolsResponse(BuilderImpl builder) {
        super(builder);
        this.devicePools = builder.devicePools;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about the device pools.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the device pools.
     */
    public List<DevicePool> devicePools() {
        return devicePools;
    }

    /**
     * <p>
     * If the number of items that are returned is significantly large, this is an identifier that is also returned,
     * which can be used in a subsequent call to this operation to return the next set of items in the list.
     * </p>
     * 
     * @return If the number of items that are returned is significantly large, this is an identifier that is also
     *         returned, which can be used in a subsequent call to this operation to return the next set of items in the
     *         list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(devicePools());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDevicePoolsResponse)) {
            return false;
        }
        ListDevicePoolsResponse other = (ListDevicePoolsResponse) obj;
        return Objects.equals(devicePools(), other.devicePools()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListDevicePoolsResponse").add("DevicePools", devicePools()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "devicePools":
            return Optional.of(clazz.cast(devicePools()));
        case "nextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends DeviceFarmResponse.Builder, CopyableBuilder<Builder, ListDevicePoolsResponse> {
        /**
         * <p>
         * Information about the device pools.
         * </p>
         * 
         * @param devicePools
         *        Information about the device pools.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devicePools(Collection<DevicePool> devicePools);

        /**
         * <p>
         * Information about the device pools.
         * </p>
         * 
         * @param devicePools
         *        Information about the device pools.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devicePools(DevicePool... devicePools);

        /**
         * <p>
         * Information about the device pools.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DevicePool>.Builder} avoiding the need to
         * create one manually via {@link List<DevicePool>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DevicePool>.Builder#build()} is called immediately and its
         * result is passed to {@link #devicePools(List<DevicePool>)}.
         * 
         * @param devicePools
         *        a consumer that will call methods on {@link List<DevicePool>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #devicePools(List<DevicePool>)
         */
        Builder devicePools(Consumer<DevicePool.Builder>... devicePools);

        /**
         * <p>
         * If the number of items that are returned is significantly large, this is an identifier that is also returned,
         * which can be used in a subsequent call to this operation to return the next set of items in the list.
         * </p>
         * 
         * @param nextToken
         *        If the number of items that are returned is significantly large, this is an identifier that is also
         *        returned, which can be used in a subsequent call to this operation to return the next set of items in
         *        the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private List<DevicePool> devicePools;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDevicePoolsResponse model) {
            super(model);
            devicePools(model.devicePools);
            nextToken(model.nextToken);
        }

        public final Collection<DevicePool.Builder> getDevicePools() {
            return devicePools != null ? devicePools.stream().map(DevicePool::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder devicePools(Collection<DevicePool> devicePools) {
            this.devicePools = DevicePoolsCopier.copy(devicePools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devicePools(DevicePool... devicePools) {
            devicePools(Arrays.asList(devicePools));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devicePools(Consumer<DevicePool.Builder>... devicePools) {
            devicePools(Stream.of(devicePools).map(c -> DevicePool.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDevicePools(Collection<DevicePool.BuilderImpl> devicePools) {
            this.devicePools = DevicePoolsCopier.copyFromBuilder(devicePools);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDevicePoolsResponse build() {
            return new ListDevicePoolsResponse(this);
        }
    }
}
