/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListNetworkProfilesResponse extends DeviceFarmResponse implements
        ToCopyableBuilder<ListNetworkProfilesResponse.Builder, ListNetworkProfilesResponse> {
    private final List<NetworkProfile> networkProfiles;

    private final String nextToken;

    private ListNetworkProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.networkProfiles = builder.networkProfiles;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of the available network profiles.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of the available network profiles.
     */
    public List<NetworkProfile> networkProfiles() {
        return networkProfiles;
    }

    /**
     * <p>
     * An identifier that was returned from the previous call to this operation, which can be used to return the next
     * set of items in the list.
     * </p>
     * 
     * @return An identifier that was returned from the previous call to this operation, which can be used to return the
     *         next set of items in the list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(networkProfiles());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNetworkProfilesResponse)) {
            return false;
        }
        ListNetworkProfilesResponse other = (ListNetworkProfilesResponse) obj;
        return Objects.equals(networkProfiles(), other.networkProfiles()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListNetworkProfilesResponse").add("NetworkProfiles", networkProfiles())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "networkProfiles":
            return Optional.of(clazz.cast(networkProfiles()));
        case "nextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends DeviceFarmResponse.Builder, CopyableBuilder<Builder, ListNetworkProfilesResponse> {
        /**
         * <p>
         * A list of the available network profiles.
         * </p>
         * 
         * @param networkProfiles
         *        A list of the available network profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkProfiles(Collection<NetworkProfile> networkProfiles);

        /**
         * <p>
         * A list of the available network profiles.
         * </p>
         * 
         * @param networkProfiles
         *        A list of the available network profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkProfiles(NetworkProfile... networkProfiles);

        /**
         * <p>
         * A list of the available network profiles.
         * </p>
         * This is a convenience that creates an instance of the {@link List<NetworkProfile>.Builder} avoiding the need
         * to create one manually via {@link List<NetworkProfile>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NetworkProfile>.Builder#build()} is called immediately and
         * its result is passed to {@link #networkProfiles(List<NetworkProfile>)}.
         * 
         * @param networkProfiles
         *        a consumer that will call methods on {@link List<NetworkProfile>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkProfiles(List<NetworkProfile>)
         */
        Builder networkProfiles(Consumer<NetworkProfile.Builder>... networkProfiles);

        /**
         * <p>
         * An identifier that was returned from the previous call to this operation, which can be used to return the
         * next set of items in the list.
         * </p>
         * 
         * @param nextToken
         *        An identifier that was returned from the previous call to this operation, which can be used to return
         *        the next set of items in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private List<NetworkProfile> networkProfiles;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNetworkProfilesResponse model) {
            super(model);
            networkProfiles(model.networkProfiles);
            nextToken(model.nextToken);
        }

        public final Collection<NetworkProfile.Builder> getNetworkProfiles() {
            return networkProfiles != null ? networkProfiles.stream().map(NetworkProfile::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder networkProfiles(Collection<NetworkProfile> networkProfiles) {
            this.networkProfiles = NetworkProfilesCopier.copy(networkProfiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkProfiles(NetworkProfile... networkProfiles) {
            networkProfiles(Arrays.asList(networkProfiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkProfiles(Consumer<NetworkProfile.Builder>... networkProfiles) {
            networkProfiles(Stream.of(networkProfiles).map(c -> NetworkProfile.builder().apply(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setNetworkProfiles(Collection<NetworkProfile.BuilderImpl> networkProfiles) {
            this.networkProfiles = NetworkProfilesCopier.copyFromBuilder(networkProfiles);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListNetworkProfilesResponse build() {
            return new ListNetworkProfilesResponse(this);
        }
    }
}
