/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.transform.RunMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a test run on a set of devices with a given app package, test parameters, etc.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Run implements StructuredPojo, ToCopyableBuilder<Run.Builder, Run> {
    private final String arn;

    private final String name;

    private final String type;

    private final String platform;

    private final Instant created;

    private final String status;

    private final String result;

    private final Instant started;

    private final Instant stopped;

    private final Counters counters;

    private final String message;

    private final Integer totalJobs;

    private final Integer completedJobs;

    private final String billingMethod;

    private final DeviceMinutes deviceMinutes;

    private final NetworkProfile networkProfile;

    private final String parsingResultUrl;

    private final String resultCode;

    private final CustomerArtifactPaths customerArtifactPaths;

    private Run(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.type = builder.type;
        this.platform = builder.platform;
        this.created = builder.created;
        this.status = builder.status;
        this.result = builder.result;
        this.started = builder.started;
        this.stopped = builder.stopped;
        this.counters = builder.counters;
        this.message = builder.message;
        this.totalJobs = builder.totalJobs;
        this.completedJobs = builder.completedJobs;
        this.billingMethod = builder.billingMethod;
        this.deviceMinutes = builder.deviceMinutes;
        this.networkProfile = builder.networkProfile;
        this.parsingResultUrl = builder.parsingResultUrl;
        this.resultCode = builder.resultCode;
        this.customerArtifactPaths = builder.customerArtifactPaths;
    }

    /**
     * <p>
     * The run's ARN.
     * </p>
     * 
     * @return The run's ARN.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The run's name.
     * </p>
     * 
     * @return The run's name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The run's type.
     * </p>
     * <p>
     * Must be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * BUILTIN_FUZZ: The built-in fuzz type.
     * </p>
     * </li>
     * <li>
     * <p>
     * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it and
     * capturing screenshots at the same time.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_PYTHON: The Appium Python type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_PYTHON: The Appium Python type for Web apps.
     * </p>
     * </li>
     * <li>
     * <p>
     * CALABASH: The Calabash type.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTRUMENTATION: The Instrumentation type.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATION: The uiautomation type.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATOR: The uiautomator type.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST: The XCode test type.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST_UI: The XCode UI test type.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TestType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The run's type.</p>
     *         <p>
     *         Must be one of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         BUILTIN_FUZZ: The built-in fuzz type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it and
     *         capturing screenshots at the same time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_PYTHON: The Appium Python type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_PYTHON: The Appium Python type for Web apps.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CALABASH: The Calabash type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTRUMENTATION: The Instrumentation type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UIAUTOMATION: The uiautomation type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UIAUTOMATOR: The uiautomator type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST: The XCode test type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST_UI: The XCode UI test type.
     *         </p>
     *         </li>
     * @see TestType
     */
    public TestType type() {
        return TestType.fromValue(type);
    }

    /**
     * <p>
     * The run's type.
     * </p>
     * <p>
     * Must be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * BUILTIN_FUZZ: The built-in fuzz type.
     * </p>
     * </li>
     * <li>
     * <p>
     * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it and
     * capturing screenshots at the same time.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_PYTHON: The Appium Python type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_PYTHON: The Appium Python type for Web apps.
     * </p>
     * </li>
     * <li>
     * <p>
     * CALABASH: The Calabash type.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTRUMENTATION: The Instrumentation type.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATION: The uiautomation type.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATOR: The uiautomator type.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST: The XCode test type.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST_UI: The XCode UI test type.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TestType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The run's type.</p>
     *         <p>
     *         Must be one of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         BUILTIN_FUZZ: The built-in fuzz type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it and
     *         capturing screenshots at the same time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_PYTHON: The Appium Python type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_PYTHON: The Appium Python type for Web apps.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CALABASH: The Calabash type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTRUMENTATION: The Instrumentation type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UIAUTOMATION: The uiautomation type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UIAUTOMATOR: The uiautomator type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST: The XCode test type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST_UI: The XCode UI test type.
     *         </p>
     *         </li>
     * @see TestType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The run's platform.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ANDROID: The Android platform.
     * </p>
     * </li>
     * <li>
     * <p>
     * IOS: The iOS platform.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link DevicePlatform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The run's platform.</p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         ANDROID: The Android platform.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IOS: The iOS platform.
     *         </p>
     *         </li>
     * @see DevicePlatform
     */
    public DevicePlatform platform() {
        return DevicePlatform.fromValue(platform);
    }

    /**
     * <p>
     * The run's platform.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ANDROID: The Android platform.
     * </p>
     * </li>
     * <li>
     * <p>
     * IOS: The iOS platform.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link DevicePlatform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The run's platform.</p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         ANDROID: The Android platform.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IOS: The iOS platform.
     *         </p>
     *         </li>
     * @see DevicePlatform
     */
    public String platformAsString() {
        return platform;
    }

    /**
     * <p>
     * When the run was created.
     * </p>
     * 
     * @return When the run was created.
     */
    public Instant created() {
        return created;
    }

    /**
     * <p>
     * The run's status.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING: A pending status.
     * </p>
     * </li>
     * <li>
     * <p>
     * PENDING_CONCURRENCY: A pending concurrency status.
     * </p>
     * </li>
     * <li>
     * <p>
     * PENDING_DEVICE: A pending device status.
     * </p>
     * </li>
     * <li>
     * <p>
     * PROCESSING: A processing status.
     * </p>
     * </li>
     * <li>
     * <p>
     * SCHEDULING: A scheduling status.
     * </p>
     * </li>
     * <li>
     * <p>
     * PREPARING: A preparing status.
     * </p>
     * </li>
     * <li>
     * <p>
     * RUNNING: A running status.
     * </p>
     * </li>
     * <li>
     * <p>
     * COMPLETED: A completed status.
     * </p>
     * </li>
     * <li>
     * <p>
     * STOPPING: A stopping status.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The run's status.</p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         PENDING: A pending status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PENDING_CONCURRENCY: A pending concurrency status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PENDING_DEVICE: A pending device status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PROCESSING: A processing status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SCHEDULING: A scheduling status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PREPARING: A preparing status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RUNNING: A running status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         COMPLETED: A completed status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STOPPING: A stopping status.
     *         </p>
     *         </li>
     * @see ExecutionStatus
     */
    public ExecutionStatus status() {
        return ExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * The run's status.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING: A pending status.
     * </p>
     * </li>
     * <li>
     * <p>
     * PENDING_CONCURRENCY: A pending concurrency status.
     * </p>
     * </li>
     * <li>
     * <p>
     * PENDING_DEVICE: A pending device status.
     * </p>
     * </li>
     * <li>
     * <p>
     * PROCESSING: A processing status.
     * </p>
     * </li>
     * <li>
     * <p>
     * SCHEDULING: A scheduling status.
     * </p>
     * </li>
     * <li>
     * <p>
     * PREPARING: A preparing status.
     * </p>
     * </li>
     * <li>
     * <p>
     * RUNNING: A running status.
     * </p>
     * </li>
     * <li>
     * <p>
     * COMPLETED: A completed status.
     * </p>
     * </li>
     * <li>
     * <p>
     * STOPPING: A stopping status.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The run's status.</p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         PENDING: A pending status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PENDING_CONCURRENCY: A pending concurrency status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PENDING_DEVICE: A pending device status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PROCESSING: A processing status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SCHEDULING: A scheduling status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PREPARING: A preparing status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RUNNING: A running status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         COMPLETED: A completed status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STOPPING: A stopping status.
     *         </p>
     *         </li>
     * @see ExecutionStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The run's result.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING: A pending condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * PASSED: A passing condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * WARNED: A warning condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED: A failed condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * SKIPPED: A skipped condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * ERRORED: An error condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * STOPPED: A stopped condition.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #result} will
     * return {@link ExecutionResult#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resultAsString}.
     * </p>
     * 
     * @return The run's result.</p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         PENDING: A pending condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PASSED: A passing condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WARNED: A warning condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FAILED: A failed condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SKIPPED: A skipped condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ERRORED: An error condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STOPPED: A stopped condition.
     *         </p>
     *         </li>
     * @see ExecutionResult
     */
    public ExecutionResult result() {
        return ExecutionResult.fromValue(result);
    }

    /**
     * <p>
     * The run's result.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING: A pending condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * PASSED: A passing condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * WARNED: A warning condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED: A failed condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * SKIPPED: A skipped condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * ERRORED: An error condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * STOPPED: A stopped condition.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #result} will
     * return {@link ExecutionResult#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resultAsString}.
     * </p>
     * 
     * @return The run's result.</p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         PENDING: A pending condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PASSED: A passing condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WARNED: A warning condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FAILED: A failed condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SKIPPED: A skipped condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ERRORED: An error condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STOPPED: A stopped condition.
     *         </p>
     *         </li>
     * @see ExecutionResult
     */
    public String resultAsString() {
        return result;
    }

    /**
     * <p>
     * The run's start time.
     * </p>
     * 
     * @return The run's start time.
     */
    public Instant started() {
        return started;
    }

    /**
     * <p>
     * The run's stop time.
     * </p>
     * 
     * @return The run's stop time.
     */
    public Instant stopped() {
        return stopped;
    }

    /**
     * <p>
     * The run's result counters.
     * </p>
     * 
     * @return The run's result counters.
     */
    public Counters counters() {
        return counters;
    }

    /**
     * <p>
     * A message about the run's result.
     * </p>
     * 
     * @return A message about the run's result.
     */
    public String message() {
        return message;
    }

    /**
     * <p>
     * The total number of jobs for the run.
     * </p>
     * 
     * @return The total number of jobs for the run.
     */
    public Integer totalJobs() {
        return totalJobs;
    }

    /**
     * <p>
     * The total number of completed jobs.
     * </p>
     * 
     * @return The total number of completed jobs.
     */
    public Integer completedJobs() {
        return completedJobs;
    }

    /**
     * <p>
     * Specifies the billing method for a test run: <code>metered</code> or <code>unmetered</code>. If the parameter is
     * not specified, the default value is <code>metered</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #billingMethod}
     * will return {@link BillingMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #billingMethodAsString}.
     * </p>
     * 
     * @return Specifies the billing method for a test run: <code>metered</code> or <code>unmetered</code>. If the
     *         parameter is not specified, the default value is <code>metered</code>.
     * @see BillingMethod
     */
    public BillingMethod billingMethod() {
        return BillingMethod.fromValue(billingMethod);
    }

    /**
     * <p>
     * Specifies the billing method for a test run: <code>metered</code> or <code>unmetered</code>. If the parameter is
     * not specified, the default value is <code>metered</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #billingMethod}
     * will return {@link BillingMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #billingMethodAsString}.
     * </p>
     * 
     * @return Specifies the billing method for a test run: <code>metered</code> or <code>unmetered</code>. If the
     *         parameter is not specified, the default value is <code>metered</code>.
     * @see BillingMethod
     */
    public String billingMethodAsString() {
        return billingMethod;
    }

    /**
     * <p>
     * Represents the total (metered or unmetered) minutes used by the test run.
     * </p>
     * 
     * @return Represents the total (metered or unmetered) minutes used by the test run.
     */
    public DeviceMinutes deviceMinutes() {
        return deviceMinutes;
    }

    /**
     * <p>
     * The network profile being used for a test run.
     * </p>
     * 
     * @return The network profile being used for a test run.
     */
    public NetworkProfile networkProfile() {
        return networkProfile;
    }

    /**
     * <p>
     * Read-only URL for an object in S3 bucket where you can get the parsing results of the test package. If the test
     * package doesn't parse, the reason why it doesn't parse appears in the file that this URL points to.
     * </p>
     * 
     * @return Read-only URL for an object in S3 bucket where you can get the parsing results of the test package. If
     *         the test package doesn't parse, the reason why it doesn't parse appears in the file that this URL points
     *         to.
     */
    public String parsingResultUrl() {
        return parsingResultUrl;
    }

    /**
     * <p>
     * Supporting field for the result field. Set only if <code>result</code> is <code>SKIPPED</code>.
     * <code>PARSING_FAILED</code> if the result is skipped because of test package parsing failure.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resultCode} will
     * return {@link ExecutionResultCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resultCodeAsString}.
     * </p>
     * 
     * @return Supporting field for the result field. Set only if <code>result</code> is <code>SKIPPED</code>.
     *         <code>PARSING_FAILED</code> if the result is skipped because of test package parsing failure.
     * @see ExecutionResultCode
     */
    public ExecutionResultCode resultCode() {
        return ExecutionResultCode.fromValue(resultCode);
    }

    /**
     * <p>
     * Supporting field for the result field. Set only if <code>result</code> is <code>SKIPPED</code>.
     * <code>PARSING_FAILED</code> if the result is skipped because of test package parsing failure.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resultCode} will
     * return {@link ExecutionResultCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resultCodeAsString}.
     * </p>
     * 
     * @return Supporting field for the result field. Set only if <code>result</code> is <code>SKIPPED</code>.
     *         <code>PARSING_FAILED</code> if the result is skipped because of test package parsing failure.
     * @see ExecutionResultCode
     */
    public String resultCodeAsString() {
        return resultCode;
    }

    /**
     * <p>
     * Output <code>CustomerArtifactPaths</code> object for the test run.
     * </p>
     * 
     * @return Output <code>CustomerArtifactPaths</code> object for the test run.
     */
    public CustomerArtifactPaths customerArtifactPaths() {
        return customerArtifactPaths;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(created());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(started());
        hashCode = 31 * hashCode + Objects.hashCode(stopped());
        hashCode = 31 * hashCode + Objects.hashCode(counters());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(totalJobs());
        hashCode = 31 * hashCode + Objects.hashCode(completedJobs());
        hashCode = 31 * hashCode + Objects.hashCode(billingMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deviceMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(networkProfile());
        hashCode = 31 * hashCode + Objects.hashCode(parsingResultUrl());
        hashCode = 31 * hashCode + Objects.hashCode(resultCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(customerArtifactPaths());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Run)) {
            return false;
        }
        Run other = (Run) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(platformAsString(), other.platformAsString()) && Objects.equals(created(), other.created())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(resultAsString(), other.resultAsString()) && Objects.equals(started(), other.started())
                && Objects.equals(stopped(), other.stopped()) && Objects.equals(counters(), other.counters())
                && Objects.equals(message(), other.message()) && Objects.equals(totalJobs(), other.totalJobs())
                && Objects.equals(completedJobs(), other.completedJobs())
                && Objects.equals(billingMethodAsString(), other.billingMethodAsString())
                && Objects.equals(deviceMinutes(), other.deviceMinutes())
                && Objects.equals(networkProfile(), other.networkProfile())
                && Objects.equals(parsingResultUrl(), other.parsingResultUrl())
                && Objects.equals(resultCodeAsString(), other.resultCodeAsString())
                && Objects.equals(customerArtifactPaths(), other.customerArtifactPaths());
    }

    @Override
    public String toString() {
        return ToString.builder("Run").add("Arn", arn()).add("Name", name()).add("Type", typeAsString())
                .add("Platform", platformAsString()).add("Created", created()).add("Status", statusAsString())
                .add("Result", resultAsString()).add("Started", started()).add("Stopped", stopped()).add("Counters", counters())
                .add("Message", message()).add("TotalJobs", totalJobs()).add("CompletedJobs", completedJobs())
                .add("BillingMethod", billingMethodAsString()).add("DeviceMinutes", deviceMinutes())
                .add("NetworkProfile", networkProfile()).add("ParsingResultUrl", parsingResultUrl())
                .add("ResultCode", resultCodeAsString()).add("CustomerArtifactPaths", customerArtifactPaths()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.of(clazz.cast(arn()));
        case "name":
            return Optional.of(clazz.cast(name()));
        case "type":
            return Optional.of(clazz.cast(typeAsString()));
        case "platform":
            return Optional.of(clazz.cast(platformAsString()));
        case "created":
            return Optional.of(clazz.cast(created()));
        case "status":
            return Optional.of(clazz.cast(statusAsString()));
        case "result":
            return Optional.of(clazz.cast(resultAsString()));
        case "started":
            return Optional.of(clazz.cast(started()));
        case "stopped":
            return Optional.of(clazz.cast(stopped()));
        case "counters":
            return Optional.of(clazz.cast(counters()));
        case "message":
            return Optional.of(clazz.cast(message()));
        case "totalJobs":
            return Optional.of(clazz.cast(totalJobs()));
        case "completedJobs":
            return Optional.of(clazz.cast(completedJobs()));
        case "billingMethod":
            return Optional.of(clazz.cast(billingMethodAsString()));
        case "deviceMinutes":
            return Optional.of(clazz.cast(deviceMinutes()));
        case "networkProfile":
            return Optional.of(clazz.cast(networkProfile()));
        case "parsingResultUrl":
            return Optional.of(clazz.cast(parsingResultUrl()));
        case "resultCode":
            return Optional.of(clazz.cast(resultCodeAsString()));
        case "customerArtifactPaths":
            return Optional.of(clazz.cast(customerArtifactPaths()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RunMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Run> {
        /**
         * <p>
         * The run's ARN.
         * </p>
         * 
         * @param arn
         *        The run's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The run's name.
         * </p>
         * 
         * @param name
         *        The run's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The run's type.
         * </p>
         * <p>
         * Must be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * BUILTIN_FUZZ: The built-in fuzz type.
         * </p>
         * </li>
         * <li>
         * <p>
         * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it and
         * capturing screenshots at the same time.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_PYTHON: The Appium Python type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_PYTHON: The Appium Python type for Web apps.
         * </p>
         * </li>
         * <li>
         * <p>
         * CALABASH: The Calabash type.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTRUMENTATION: The Instrumentation type.
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATION: The uiautomation type.
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATOR: The uiautomator type.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST: The XCode test type.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST_UI: The XCode UI test type.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The run's type.</p>
         *        <p>
         *        Must be one of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        BUILTIN_FUZZ: The built-in fuzz type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it
         *        and capturing screenshots at the same time.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_PYTHON: The Appium Python type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_PYTHON: The Appium Python type for Web apps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CALABASH: The Calabash type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTRUMENTATION: The Instrumentation type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATION: The uiautomation type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATOR: The uiautomator type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST: The XCode test type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST_UI: The XCode UI test type.
         *        </p>
         *        </li>
         * @see TestType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestType
         */
        Builder type(String type);

        /**
         * <p>
         * The run's type.
         * </p>
         * <p>
         * Must be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * BUILTIN_FUZZ: The built-in fuzz type.
         * </p>
         * </li>
         * <li>
         * <p>
         * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it and
         * capturing screenshots at the same time.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_PYTHON: The Appium Python type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_PYTHON: The Appium Python type for Web apps.
         * </p>
         * </li>
         * <li>
         * <p>
         * CALABASH: The Calabash type.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTRUMENTATION: The Instrumentation type.
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATION: The uiautomation type.
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATOR: The uiautomator type.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST: The XCode test type.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST_UI: The XCode UI test type.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The run's type.</p>
         *        <p>
         *        Must be one of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        BUILTIN_FUZZ: The built-in fuzz type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it
         *        and capturing screenshots at the same time.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_PYTHON: The Appium Python type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_PYTHON: The Appium Python type for Web apps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CALABASH: The Calabash type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTRUMENTATION: The Instrumentation type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATION: The uiautomation type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATOR: The uiautomator type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST: The XCode test type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST_UI: The XCode UI test type.
         *        </p>
         *        </li>
         * @see TestType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestType
         */
        Builder type(TestType type);

        /**
         * <p>
         * The run's platform.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ANDROID: The Android platform.
         * </p>
         * </li>
         * <li>
         * <p>
         * IOS: The iOS platform.
         * </p>
         * </li>
         * </ul>
         * 
         * @param platform
         *        The run's platform.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        ANDROID: The Android platform.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IOS: The iOS platform.
         *        </p>
         *        </li>
         * @see DevicePlatform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DevicePlatform
         */
        Builder platform(String platform);

        /**
         * <p>
         * The run's platform.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ANDROID: The Android platform.
         * </p>
         * </li>
         * <li>
         * <p>
         * IOS: The iOS platform.
         * </p>
         * </li>
         * </ul>
         * 
         * @param platform
         *        The run's platform.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        ANDROID: The Android platform.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IOS: The iOS platform.
         *        </p>
         *        </li>
         * @see DevicePlatform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DevicePlatform
         */
        Builder platform(DevicePlatform platform);

        /**
         * <p>
         * When the run was created.
         * </p>
         * 
         * @param created
         *        When the run was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder created(Instant created);

        /**
         * <p>
         * The run's status.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING: A pending status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PENDING_CONCURRENCY: A pending concurrency status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PENDING_DEVICE: A pending device status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PROCESSING: A processing status.
         * </p>
         * </li>
         * <li>
         * <p>
         * SCHEDULING: A scheduling status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PREPARING: A preparing status.
         * </p>
         * </li>
         * <li>
         * <p>
         * RUNNING: A running status.
         * </p>
         * </li>
         * <li>
         * <p>
         * COMPLETED: A completed status.
         * </p>
         * </li>
         * <li>
         * <p>
         * STOPPING: A stopping status.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The run's status.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING: A pending status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PENDING_CONCURRENCY: A pending concurrency status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PENDING_DEVICE: A pending device status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PROCESSING: A processing status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SCHEDULING: A scheduling status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PREPARING: A preparing status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RUNNING: A running status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        COMPLETED: A completed status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOPPING: A stopping status.
         *        </p>
         *        </li>
         * @see ExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The run's status.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING: A pending status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PENDING_CONCURRENCY: A pending concurrency status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PENDING_DEVICE: A pending device status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PROCESSING: A processing status.
         * </p>
         * </li>
         * <li>
         * <p>
         * SCHEDULING: A scheduling status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PREPARING: A preparing status.
         * </p>
         * </li>
         * <li>
         * <p>
         * RUNNING: A running status.
         * </p>
         * </li>
         * <li>
         * <p>
         * COMPLETED: A completed status.
         * </p>
         * </li>
         * <li>
         * <p>
         * STOPPING: A stopping status.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The run's status.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING: A pending status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PENDING_CONCURRENCY: A pending concurrency status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PENDING_DEVICE: A pending device status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PROCESSING: A processing status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SCHEDULING: A scheduling status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PREPARING: A preparing status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RUNNING: A running status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        COMPLETED: A completed status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOPPING: A stopping status.
         *        </p>
         *        </li>
         * @see ExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder status(ExecutionStatus status);

        /**
         * <p>
         * The run's result.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING: A pending condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * PASSED: A passing condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * WARNED: A warning condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * FAILED: A failed condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * SKIPPED: A skipped condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * ERRORED: An error condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * STOPPED: A stopped condition.
         * </p>
         * </li>
         * </ul>
         * 
         * @param result
         *        The run's result.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING: A pending condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PASSED: A passing condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        WARNED: A warning condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FAILED: A failed condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SKIPPED: A skipped condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ERRORED: An error condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOPPED: A stopped condition.
         *        </p>
         *        </li>
         * @see ExecutionResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionResult
         */
        Builder result(String result);

        /**
         * <p>
         * The run's result.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING: A pending condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * PASSED: A passing condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * WARNED: A warning condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * FAILED: A failed condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * SKIPPED: A skipped condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * ERRORED: An error condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * STOPPED: A stopped condition.
         * </p>
         * </li>
         * </ul>
         * 
         * @param result
         *        The run's result.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING: A pending condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PASSED: A passing condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        WARNED: A warning condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FAILED: A failed condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SKIPPED: A skipped condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ERRORED: An error condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOPPED: A stopped condition.
         *        </p>
         *        </li>
         * @see ExecutionResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionResult
         */
        Builder result(ExecutionResult result);

        /**
         * <p>
         * The run's start time.
         * </p>
         * 
         * @param started
         *        The run's start time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder started(Instant started);

        /**
         * <p>
         * The run's stop time.
         * </p>
         * 
         * @param stopped
         *        The run's stop time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopped(Instant stopped);

        /**
         * <p>
         * The run's result counters.
         * </p>
         * 
         * @param counters
         *        The run's result counters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder counters(Counters counters);

        /**
         * <p>
         * The run's result counters.
         * </p>
         * This is a convenience that creates an instance of the {@link Counters.Builder} avoiding the need to create
         * one manually via {@link Counters#builder()}.
         *
         * When the {@link Consumer} completes, {@link Counters.Builder#build()} is called immediately and its result is
         * passed to {@link #counters(Counters)}.
         * 
         * @param counters
         *        a consumer that will call methods on {@link Counters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #counters(Counters)
         */
        default Builder counters(Consumer<Counters.Builder> counters) {
            return counters(Counters.builder().apply(counters).build());
        }

        /**
         * <p>
         * A message about the run's result.
         * </p>
         * 
         * @param message
         *        A message about the run's result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The total number of jobs for the run.
         * </p>
         * 
         * @param totalJobs
         *        The total number of jobs for the run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalJobs(Integer totalJobs);

        /**
         * <p>
         * The total number of completed jobs.
         * </p>
         * 
         * @param completedJobs
         *        The total number of completed jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completedJobs(Integer completedJobs);

        /**
         * <p>
         * Specifies the billing method for a test run: <code>metered</code> or <code>unmetered</code>. If the parameter
         * is not specified, the default value is <code>metered</code>.
         * </p>
         * 
         * @param billingMethod
         *        Specifies the billing method for a test run: <code>metered</code> or <code>unmetered</code>. If the
         *        parameter is not specified, the default value is <code>metered</code>.
         * @see BillingMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingMethod
         */
        Builder billingMethod(String billingMethod);

        /**
         * <p>
         * Specifies the billing method for a test run: <code>metered</code> or <code>unmetered</code>. If the parameter
         * is not specified, the default value is <code>metered</code>.
         * </p>
         * 
         * @param billingMethod
         *        Specifies the billing method for a test run: <code>metered</code> or <code>unmetered</code>. If the
         *        parameter is not specified, the default value is <code>metered</code>.
         * @see BillingMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingMethod
         */
        Builder billingMethod(BillingMethod billingMethod);

        /**
         * <p>
         * Represents the total (metered or unmetered) minutes used by the test run.
         * </p>
         * 
         * @param deviceMinutes
         *        Represents the total (metered or unmetered) minutes used by the test run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceMinutes(DeviceMinutes deviceMinutes);

        /**
         * <p>
         * Represents the total (metered or unmetered) minutes used by the test run.
         * </p>
         * This is a convenience that creates an instance of the {@link DeviceMinutes.Builder} avoiding the need to
         * create one manually via {@link DeviceMinutes#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeviceMinutes.Builder#build()} is called immediately and its
         * result is passed to {@link #deviceMinutes(DeviceMinutes)}.
         * 
         * @param deviceMinutes
         *        a consumer that will call methods on {@link DeviceMinutes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceMinutes(DeviceMinutes)
         */
        default Builder deviceMinutes(Consumer<DeviceMinutes.Builder> deviceMinutes) {
            return deviceMinutes(DeviceMinutes.builder().apply(deviceMinutes).build());
        }

        /**
         * <p>
         * The network profile being used for a test run.
         * </p>
         * 
         * @param networkProfile
         *        The network profile being used for a test run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkProfile(NetworkProfile networkProfile);

        /**
         * <p>
         * The network profile being used for a test run.
         * </p>
         * This is a convenience that creates an instance of the {@link NetworkProfile.Builder} avoiding the need to
         * create one manually via {@link NetworkProfile#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkProfile.Builder#build()} is called immediately and its
         * result is passed to {@link #networkProfile(NetworkProfile)}.
         * 
         * @param networkProfile
         *        a consumer that will call methods on {@link NetworkProfile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkProfile(NetworkProfile)
         */
        default Builder networkProfile(Consumer<NetworkProfile.Builder> networkProfile) {
            return networkProfile(NetworkProfile.builder().apply(networkProfile).build());
        }

        /**
         * <p>
         * Read-only URL for an object in S3 bucket where you can get the parsing results of the test package. If the
         * test package doesn't parse, the reason why it doesn't parse appears in the file that this URL points to.
         * </p>
         * 
         * @param parsingResultUrl
         *        Read-only URL for an object in S3 bucket where you can get the parsing results of the test package. If
         *        the test package doesn't parse, the reason why it doesn't parse appears in the file that this URL
         *        points to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parsingResultUrl(String parsingResultUrl);

        /**
         * <p>
         * Supporting field for the result field. Set only if <code>result</code> is <code>SKIPPED</code>.
         * <code>PARSING_FAILED</code> if the result is skipped because of test package parsing failure.
         * </p>
         * 
         * @param resultCode
         *        Supporting field for the result field. Set only if <code>result</code> is <code>SKIPPED</code>.
         *        <code>PARSING_FAILED</code> if the result is skipped because of test package parsing failure.
         * @see ExecutionResultCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionResultCode
         */
        Builder resultCode(String resultCode);

        /**
         * <p>
         * Supporting field for the result field. Set only if <code>result</code> is <code>SKIPPED</code>.
         * <code>PARSING_FAILED</code> if the result is skipped because of test package parsing failure.
         * </p>
         * 
         * @param resultCode
         *        Supporting field for the result field. Set only if <code>result</code> is <code>SKIPPED</code>.
         *        <code>PARSING_FAILED</code> if the result is skipped because of test package parsing failure.
         * @see ExecutionResultCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionResultCode
         */
        Builder resultCode(ExecutionResultCode resultCode);

        /**
         * <p>
         * Output <code>CustomerArtifactPaths</code> object for the test run.
         * </p>
         * 
         * @param customerArtifactPaths
         *        Output <code>CustomerArtifactPaths</code> object for the test run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerArtifactPaths(CustomerArtifactPaths customerArtifactPaths);

        /**
         * <p>
         * Output <code>CustomerArtifactPaths</code> object for the test run.
         * </p>
         * This is a convenience that creates an instance of the {@link CustomerArtifactPaths.Builder} avoiding the need
         * to create one manually via {@link CustomerArtifactPaths#builder()}.
         *
         * When the {@link Consumer} completes, {@link CustomerArtifactPaths.Builder#build()} is called immediately and
         * its result is passed to {@link #customerArtifactPaths(CustomerArtifactPaths)}.
         * 
         * @param customerArtifactPaths
         *        a consumer that will call methods on {@link CustomerArtifactPaths.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customerArtifactPaths(CustomerArtifactPaths)
         */
        default Builder customerArtifactPaths(Consumer<CustomerArtifactPaths.Builder> customerArtifactPaths) {
            return customerArtifactPaths(CustomerArtifactPaths.builder().apply(customerArtifactPaths).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String type;

        private String platform;

        private Instant created;

        private String status;

        private String result;

        private Instant started;

        private Instant stopped;

        private Counters counters;

        private String message;

        private Integer totalJobs;

        private Integer completedJobs;

        private String billingMethod;

        private DeviceMinutes deviceMinutes;

        private NetworkProfile networkProfile;

        private String parsingResultUrl;

        private String resultCode;

        private CustomerArtifactPaths customerArtifactPaths;

        private BuilderImpl() {
        }

        private BuilderImpl(Run model) {
            arn(model.arn);
            name(model.name);
            type(model.type);
            platform(model.platform);
            created(model.created);
            status(model.status);
            result(model.result);
            started(model.started);
            stopped(model.stopped);
            counters(model.counters);
            message(model.message);
            totalJobs(model.totalJobs);
            completedJobs(model.completedJobs);
            billingMethod(model.billingMethod);
            deviceMinutes(model.deviceMinutes);
            networkProfile(model.networkProfile);
            parsingResultUrl(model.parsingResultUrl);
            resultCode(model.resultCode);
            customerArtifactPaths(model.customerArtifactPaths);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TestType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getPlatform() {
            return platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(DevicePlatform platform) {
            this.platform(platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final Instant getCreated() {
            return created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExecutionStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getResult() {
            return result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        @Override
        public final Builder result(ExecutionResult result) {
            this.result(result.toString());
            return this;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        public final Instant getStarted() {
            return started;
        }

        @Override
        public final Builder started(Instant started) {
            this.started = started;
            return this;
        }

        public final void setStarted(Instant started) {
            this.started = started;
        }

        public final Instant getStopped() {
            return stopped;
        }

        @Override
        public final Builder stopped(Instant stopped) {
            this.stopped = stopped;
            return this;
        }

        public final void setStopped(Instant stopped) {
            this.stopped = stopped;
        }

        public final Counters.Builder getCounters() {
            return counters != null ? counters.toBuilder() : null;
        }

        @Override
        public final Builder counters(Counters counters) {
            this.counters = counters;
            return this;
        }

        public final void setCounters(Counters.BuilderImpl counters) {
            this.counters = counters != null ? counters.build() : null;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Integer getTotalJobs() {
            return totalJobs;
        }

        @Override
        public final Builder totalJobs(Integer totalJobs) {
            this.totalJobs = totalJobs;
            return this;
        }

        public final void setTotalJobs(Integer totalJobs) {
            this.totalJobs = totalJobs;
        }

        public final Integer getCompletedJobs() {
            return completedJobs;
        }

        @Override
        public final Builder completedJobs(Integer completedJobs) {
            this.completedJobs = completedJobs;
            return this;
        }

        public final void setCompletedJobs(Integer completedJobs) {
            this.completedJobs = completedJobs;
        }

        public final String getBillingMethod() {
            return billingMethod;
        }

        @Override
        public final Builder billingMethod(String billingMethod) {
            this.billingMethod = billingMethod;
            return this;
        }

        @Override
        public final Builder billingMethod(BillingMethod billingMethod) {
            this.billingMethod(billingMethod.toString());
            return this;
        }

        public final void setBillingMethod(String billingMethod) {
            this.billingMethod = billingMethod;
        }

        public final DeviceMinutes.Builder getDeviceMinutes() {
            return deviceMinutes != null ? deviceMinutes.toBuilder() : null;
        }

        @Override
        public final Builder deviceMinutes(DeviceMinutes deviceMinutes) {
            this.deviceMinutes = deviceMinutes;
            return this;
        }

        public final void setDeviceMinutes(DeviceMinutes.BuilderImpl deviceMinutes) {
            this.deviceMinutes = deviceMinutes != null ? deviceMinutes.build() : null;
        }

        public final NetworkProfile.Builder getNetworkProfile() {
            return networkProfile != null ? networkProfile.toBuilder() : null;
        }

        @Override
        public final Builder networkProfile(NetworkProfile networkProfile) {
            this.networkProfile = networkProfile;
            return this;
        }

        public final void setNetworkProfile(NetworkProfile.BuilderImpl networkProfile) {
            this.networkProfile = networkProfile != null ? networkProfile.build() : null;
        }

        public final String getParsingResultUrl() {
            return parsingResultUrl;
        }

        @Override
        public final Builder parsingResultUrl(String parsingResultUrl) {
            this.parsingResultUrl = parsingResultUrl;
            return this;
        }

        public final void setParsingResultUrl(String parsingResultUrl) {
            this.parsingResultUrl = parsingResultUrl;
        }

        public final String getResultCode() {
            return resultCode;
        }

        @Override
        public final Builder resultCode(String resultCode) {
            this.resultCode = resultCode;
            return this;
        }

        @Override
        public final Builder resultCode(ExecutionResultCode resultCode) {
            this.resultCode(resultCode.toString());
            return this;
        }

        public final void setResultCode(String resultCode) {
            this.resultCode = resultCode;
        }

        public final CustomerArtifactPaths.Builder getCustomerArtifactPaths() {
            return customerArtifactPaths != null ? customerArtifactPaths.toBuilder() : null;
        }

        @Override
        public final Builder customerArtifactPaths(CustomerArtifactPaths customerArtifactPaths) {
            this.customerArtifactPaths = customerArtifactPaths;
            return this;
        }

        public final void setCustomerArtifactPaths(CustomerArtifactPaths.BuilderImpl customerArtifactPaths) {
            this.customerArtifactPaths = customerArtifactPaths != null ? customerArtifactPaths.build() : null;
        }

        @Override
        public Run build() {
            return new Run(this);
        }
    }
}
