/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.transform.ScheduleRunConfigurationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the settings for a run. Includes things like location, radio states, auxiliary apps, and network profiles.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ScheduleRunConfiguration implements StructuredPojo,
        ToCopyableBuilder<ScheduleRunConfiguration.Builder, ScheduleRunConfiguration> {
    private final String extraDataPackageArn;

    private final String networkProfileArn;

    private final String locale;

    private final Location location;

    private final CustomerArtifactPaths customerArtifactPaths;

    private final Radios radios;

    private final List<String> auxiliaryApps;

    private final String billingMethod;

    private ScheduleRunConfiguration(BuilderImpl builder) {
        this.extraDataPackageArn = builder.extraDataPackageArn;
        this.networkProfileArn = builder.networkProfileArn;
        this.locale = builder.locale;
        this.location = builder.location;
        this.customerArtifactPaths = builder.customerArtifactPaths;
        this.radios = builder.radios;
        this.auxiliaryApps = builder.auxiliaryApps;
        this.billingMethod = builder.billingMethod;
    }

    /**
     * <p>
     * The ARN of the extra data for the run. The extra data is a .zip file that AWS Device Farm will extract to
     * external data for Android or the app's sandbox for iOS.
     * </p>
     * 
     * @return The ARN of the extra data for the run. The extra data is a .zip file that AWS Device Farm will extract to
     *         external data for Android or the app's sandbox for iOS.
     */
    public String extraDataPackageArn() {
        return extraDataPackageArn;
    }

    /**
     * <p>
     * Reserved for internal use.
     * </p>
     * 
     * @return Reserved for internal use.
     */
    public String networkProfileArn() {
        return networkProfileArn;
    }

    /**
     * <p>
     * Information about the locale that is used for the run.
     * </p>
     * 
     * @return Information about the locale that is used for the run.
     */
    public String locale() {
        return locale;
    }

    /**
     * <p>
     * Information about the location that is used for the run.
     * </p>
     * 
     * @return Information about the location that is used for the run.
     */
    public Location location() {
        return location;
    }

    /**
     * <p>
     * Input <code>CustomerArtifactPaths</code> object for the scheduled run configuration.
     * </p>
     * 
     * @return Input <code>CustomerArtifactPaths</code> object for the scheduled run configuration.
     */
    public CustomerArtifactPaths customerArtifactPaths() {
        return customerArtifactPaths;
    }

    /**
     * <p>
     * Information about the radio states for the run.
     * </p>
     * 
     * @return Information about the radio states for the run.
     */
    public Radios radios() {
        return radios;
    }

    /**
     * <p>
     * A list of auxiliary apps for the run.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of auxiliary apps for the run.
     */
    public List<String> auxiliaryApps() {
        return auxiliaryApps;
    }

    /**
     * <p>
     * Specifies the billing method for a test run: <code>metered</code> or <code>unmetered</code>. If the parameter is
     * not specified, the default value is <code>metered</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #billingMethod}
     * will return {@link BillingMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #billingMethodAsString}.
     * </p>
     * 
     * @return Specifies the billing method for a test run: <code>metered</code> or <code>unmetered</code>. If the
     *         parameter is not specified, the default value is <code>metered</code>.
     * @see BillingMethod
     */
    public BillingMethod billingMethod() {
        return BillingMethod.fromValue(billingMethod);
    }

    /**
     * <p>
     * Specifies the billing method for a test run: <code>metered</code> or <code>unmetered</code>. If the parameter is
     * not specified, the default value is <code>metered</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #billingMethod}
     * will return {@link BillingMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #billingMethodAsString}.
     * </p>
     * 
     * @return Specifies the billing method for a test run: <code>metered</code> or <code>unmetered</code>. If the
     *         parameter is not specified, the default value is <code>metered</code>.
     * @see BillingMethod
     */
    public String billingMethodAsString() {
        return billingMethod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(extraDataPackageArn());
        hashCode = 31 * hashCode + Objects.hashCode(networkProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(locale());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(customerArtifactPaths());
        hashCode = 31 * hashCode + Objects.hashCode(radios());
        hashCode = 31 * hashCode + Objects.hashCode(auxiliaryApps());
        hashCode = 31 * hashCode + Objects.hashCode(billingMethodAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduleRunConfiguration)) {
            return false;
        }
        ScheduleRunConfiguration other = (ScheduleRunConfiguration) obj;
        return Objects.equals(extraDataPackageArn(), other.extraDataPackageArn())
                && Objects.equals(networkProfileArn(), other.networkProfileArn()) && Objects.equals(locale(), other.locale())
                && Objects.equals(location(), other.location())
                && Objects.equals(customerArtifactPaths(), other.customerArtifactPaths())
                && Objects.equals(radios(), other.radios()) && Objects.equals(auxiliaryApps(), other.auxiliaryApps())
                && Objects.equals(billingMethodAsString(), other.billingMethodAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("ScheduleRunConfiguration").add("ExtraDataPackageArn", extraDataPackageArn())
                .add("NetworkProfileArn", networkProfileArn()).add("Locale", locale()).add("Location", location())
                .add("CustomerArtifactPaths", customerArtifactPaths()).add("Radios", radios())
                .add("AuxiliaryApps", auxiliaryApps()).add("BillingMethod", billingMethodAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "extraDataPackageArn":
            return Optional.of(clazz.cast(extraDataPackageArn()));
        case "networkProfileArn":
            return Optional.of(clazz.cast(networkProfileArn()));
        case "locale":
            return Optional.of(clazz.cast(locale()));
        case "location":
            return Optional.of(clazz.cast(location()));
        case "customerArtifactPaths":
            return Optional.of(clazz.cast(customerArtifactPaths()));
        case "radios":
            return Optional.of(clazz.cast(radios()));
        case "auxiliaryApps":
            return Optional.of(clazz.cast(auxiliaryApps()));
        case "billingMethod":
            return Optional.of(clazz.cast(billingMethodAsString()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ScheduleRunConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ScheduleRunConfiguration> {
        /**
         * <p>
         * The ARN of the extra data for the run. The extra data is a .zip file that AWS Device Farm will extract to
         * external data for Android or the app's sandbox for iOS.
         * </p>
         * 
         * @param extraDataPackageArn
         *        The ARN of the extra data for the run. The extra data is a .zip file that AWS Device Farm will extract
         *        to external data for Android or the app's sandbox for iOS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extraDataPackageArn(String extraDataPackageArn);

        /**
         * <p>
         * Reserved for internal use.
         * </p>
         * 
         * @param networkProfileArn
         *        Reserved for internal use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkProfileArn(String networkProfileArn);

        /**
         * <p>
         * Information about the locale that is used for the run.
         * </p>
         * 
         * @param locale
         *        Information about the locale that is used for the run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locale(String locale);

        /**
         * <p>
         * Information about the location that is used for the run.
         * </p>
         * 
         * @param location
         *        Information about the location that is used for the run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(Location location);

        /**
         * <p>
         * Information about the location that is used for the run.
         * </p>
         * This is a convenience that creates an instance of the {@link Location.Builder} avoiding the need to create
         * one manually via {@link Location#builder()}.
         *
         * When the {@link Consumer} completes, {@link Location.Builder#build()} is called immediately and its result is
         * passed to {@link #location(Location)}.
         * 
         * @param location
         *        a consumer that will call methods on {@link Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #location(Location)
         */
        default Builder location(Consumer<Location.Builder> location) {
            return location(Location.builder().apply(location).build());
        }

        /**
         * <p>
         * Input <code>CustomerArtifactPaths</code> object for the scheduled run configuration.
         * </p>
         * 
         * @param customerArtifactPaths
         *        Input <code>CustomerArtifactPaths</code> object for the scheduled run configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerArtifactPaths(CustomerArtifactPaths customerArtifactPaths);

        /**
         * <p>
         * Input <code>CustomerArtifactPaths</code> object for the scheduled run configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link CustomerArtifactPaths.Builder} avoiding the need
         * to create one manually via {@link CustomerArtifactPaths#builder()}.
         *
         * When the {@link Consumer} completes, {@link CustomerArtifactPaths.Builder#build()} is called immediately and
         * its result is passed to {@link #customerArtifactPaths(CustomerArtifactPaths)}.
         * 
         * @param customerArtifactPaths
         *        a consumer that will call methods on {@link CustomerArtifactPaths.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customerArtifactPaths(CustomerArtifactPaths)
         */
        default Builder customerArtifactPaths(Consumer<CustomerArtifactPaths.Builder> customerArtifactPaths) {
            return customerArtifactPaths(CustomerArtifactPaths.builder().apply(customerArtifactPaths).build());
        }

        /**
         * <p>
         * Information about the radio states for the run.
         * </p>
         * 
         * @param radios
         *        Information about the radio states for the run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder radios(Radios radios);

        /**
         * <p>
         * Information about the radio states for the run.
         * </p>
         * This is a convenience that creates an instance of the {@link Radios.Builder} avoiding the need to create one
         * manually via {@link Radios#builder()}.
         *
         * When the {@link Consumer} completes, {@link Radios.Builder#build()} is called immediately and its result is
         * passed to {@link #radios(Radios)}.
         * 
         * @param radios
         *        a consumer that will call methods on {@link Radios.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #radios(Radios)
         */
        default Builder radios(Consumer<Radios.Builder> radios) {
            return radios(Radios.builder().apply(radios).build());
        }

        /**
         * <p>
         * A list of auxiliary apps for the run.
         * </p>
         * 
         * @param auxiliaryApps
         *        A list of auxiliary apps for the run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auxiliaryApps(Collection<String> auxiliaryApps);

        /**
         * <p>
         * A list of auxiliary apps for the run.
         * </p>
         * 
         * @param auxiliaryApps
         *        A list of auxiliary apps for the run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auxiliaryApps(String... auxiliaryApps);

        /**
         * <p>
         * Specifies the billing method for a test run: <code>metered</code> or <code>unmetered</code>. If the parameter
         * is not specified, the default value is <code>metered</code>.
         * </p>
         * 
         * @param billingMethod
         *        Specifies the billing method for a test run: <code>metered</code> or <code>unmetered</code>. If the
         *        parameter is not specified, the default value is <code>metered</code>.
         * @see BillingMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingMethod
         */
        Builder billingMethod(String billingMethod);

        /**
         * <p>
         * Specifies the billing method for a test run: <code>metered</code> or <code>unmetered</code>. If the parameter
         * is not specified, the default value is <code>metered</code>.
         * </p>
         * 
         * @param billingMethod
         *        Specifies the billing method for a test run: <code>metered</code> or <code>unmetered</code>. If the
         *        parameter is not specified, the default value is <code>metered</code>.
         * @see BillingMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingMethod
         */
        Builder billingMethod(BillingMethod billingMethod);
    }

    static final class BuilderImpl implements Builder {
        private String extraDataPackageArn;

        private String networkProfileArn;

        private String locale;

        private Location location;

        private CustomerArtifactPaths customerArtifactPaths;

        private Radios radios;

        private List<String> auxiliaryApps;

        private String billingMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduleRunConfiguration model) {
            extraDataPackageArn(model.extraDataPackageArn);
            networkProfileArn(model.networkProfileArn);
            locale(model.locale);
            location(model.location);
            customerArtifactPaths(model.customerArtifactPaths);
            radios(model.radios);
            auxiliaryApps(model.auxiliaryApps);
            billingMethod(model.billingMethod);
        }

        public final String getExtraDataPackageArn() {
            return extraDataPackageArn;
        }

        @Override
        public final Builder extraDataPackageArn(String extraDataPackageArn) {
            this.extraDataPackageArn = extraDataPackageArn;
            return this;
        }

        public final void setExtraDataPackageArn(String extraDataPackageArn) {
            this.extraDataPackageArn = extraDataPackageArn;
        }

        public final String getNetworkProfileArn() {
            return networkProfileArn;
        }

        @Override
        public final Builder networkProfileArn(String networkProfileArn) {
            this.networkProfileArn = networkProfileArn;
            return this;
        }

        public final void setNetworkProfileArn(String networkProfileArn) {
            this.networkProfileArn = networkProfileArn;
        }

        public final String getLocale() {
            return locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        public final Location.Builder getLocation() {
            return location != null ? location.toBuilder() : null;
        }

        @Override
        public final Builder location(Location location) {
            this.location = location;
            return this;
        }

        public final void setLocation(Location.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        public final CustomerArtifactPaths.Builder getCustomerArtifactPaths() {
            return customerArtifactPaths != null ? customerArtifactPaths.toBuilder() : null;
        }

        @Override
        public final Builder customerArtifactPaths(CustomerArtifactPaths customerArtifactPaths) {
            this.customerArtifactPaths = customerArtifactPaths;
            return this;
        }

        public final void setCustomerArtifactPaths(CustomerArtifactPaths.BuilderImpl customerArtifactPaths) {
            this.customerArtifactPaths = customerArtifactPaths != null ? customerArtifactPaths.build() : null;
        }

        public final Radios.Builder getRadios() {
            return radios != null ? radios.toBuilder() : null;
        }

        @Override
        public final Builder radios(Radios radios) {
            this.radios = radios;
            return this;
        }

        public final void setRadios(Radios.BuilderImpl radios) {
            this.radios = radios != null ? radios.build() : null;
        }

        public final Collection<String> getAuxiliaryApps() {
            return auxiliaryApps;
        }

        @Override
        public final Builder auxiliaryApps(Collection<String> auxiliaryApps) {
            this.auxiliaryApps = AmazonResourceNamesCopier.copy(auxiliaryApps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder auxiliaryApps(String... auxiliaryApps) {
            auxiliaryApps(Arrays.asList(auxiliaryApps));
            return this;
        }

        public final void setAuxiliaryApps(Collection<String> auxiliaryApps) {
            this.auxiliaryApps = AmazonResourceNamesCopier.copy(auxiliaryApps);
        }

        public final String getBillingMethod() {
            return billingMethod;
        }

        @Override
        public final Builder billingMethod(String billingMethod) {
            this.billingMethod = billingMethod;
            return this;
        }

        @Override
        public final Builder billingMethod(BillingMethod billingMethod) {
            this.billingMethod(billingMethod.toString());
            return this;
        }

        public final void setBillingMethod(String billingMethod) {
            this.billingMethod = billingMethod;
        }

        @Override
        public ScheduleRunConfiguration build() {
            return new ScheduleRunConfiguration(this);
        }
    }
}
