/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.transform.UniqueProblemMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A collection of one or more problems, grouped by their result.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UniqueProblem implements StructuredPojo, ToCopyableBuilder<UniqueProblem.Builder, UniqueProblem> {
    private final String message;

    private final List<Problem> problems;

    private UniqueProblem(BuilderImpl builder) {
        this.message = builder.message;
        this.problems = builder.problems;
    }

    /**
     * <p>
     * A message about the unique problems' result.
     * </p>
     * 
     * @return A message about the unique problems' result.
     */
    public String message() {
        return message;
    }

    /**
     * <p>
     * Information about the problems.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the problems.
     */
    public List<Problem> problems() {
        return problems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(problems());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UniqueProblem)) {
            return false;
        }
        UniqueProblem other = (UniqueProblem) obj;
        return Objects.equals(message(), other.message()) && Objects.equals(problems(), other.problems());
    }

    @Override
    public String toString() {
        return ToString.builder("UniqueProblem").add("Message", message()).add("Problems", problems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "message":
            return Optional.of(clazz.cast(message()));
        case "problems":
            return Optional.of(clazz.cast(problems()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UniqueProblemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, UniqueProblem> {
        /**
         * <p>
         * A message about the unique problems' result.
         * </p>
         * 
         * @param message
         *        A message about the unique problems' result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * Information about the problems.
         * </p>
         * 
         * @param problems
         *        Information about the problems.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder problems(Collection<Problem> problems);

        /**
         * <p>
         * Information about the problems.
         * </p>
         * 
         * @param problems
         *        Information about the problems.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder problems(Problem... problems);

        /**
         * <p>
         * Information about the problems.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Problem>.Builder} avoiding the need to
         * create one manually via {@link List<Problem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Problem>.Builder#build()} is called immediately and its
         * result is passed to {@link #problems(List<Problem>)}.
         * 
         * @param problems
         *        a consumer that will call methods on {@link List<Problem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #problems(List<Problem>)
         */
        Builder problems(Consumer<Problem.Builder>... problems);
    }

    static final class BuilderImpl implements Builder {
        private String message;

        private List<Problem> problems;

        private BuilderImpl() {
        }

        private BuilderImpl(UniqueProblem model) {
            message(model.message);
            problems(model.problems);
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Collection<Problem.Builder> getProblems() {
            return problems != null ? problems.stream().map(Problem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder problems(Collection<Problem> problems) {
            this.problems = ProblemsCopier.copy(problems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder problems(Problem... problems) {
            problems(Arrays.asList(problems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder problems(Consumer<Problem.Builder>... problems) {
            problems(Stream.of(problems).map(c -> Problem.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProblems(Collection<Problem.BuilderImpl> problems) {
            this.problems = ProblemsCopier.copyFromBuilder(problems);
        }

        @Override
        public UniqueProblem build() {
            return new UniqueProblem(this);
        }
    }
}
