/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.transform;

import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.devicefarm.model.MonetaryAmount;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link MonetaryAmount} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class MonetaryAmountMarshaller {
    private static final MarshallingInfo<Double> AMOUNT_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("amount").isBinary(false).build();

    private static final MarshallingInfo<String> CURRENCYCODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("currencyCode").isBinary(false).build();

    private static final MonetaryAmountMarshaller INSTANCE = new MonetaryAmountMarshaller();

    private MonetaryAmountMarshaller() {
    }

    public static MonetaryAmountMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(MonetaryAmount monetaryAmount, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(monetaryAmount, "monetaryAmount");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(monetaryAmount.amount(), AMOUNT_BINDING);
            protocolMarshaller.marshall(monetaryAmount.currencyCodeAsString(), CURRENCYCODE_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
