/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.transform;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.model.RemoteAccessSession;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link RemoteAccessSession} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class RemoteAccessSessionMarshaller {
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").isBinary(false).build();

    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();

    private static final MarshallingInfo<Instant> CREATED_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("created").isBinary(false).build();

    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").isBinary(false).build();

    private static final MarshallingInfo<String> RESULT_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("result").isBinary(false).build();

    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("message").isBinary(false).build();

    private static final MarshallingInfo<Instant> STARTED_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("started").isBinary(false).build();

    private static final MarshallingInfo<Instant> STOPPED_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stopped").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> DEVICE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("device").isBinary(false).build();

    private static final MarshallingInfo<Boolean> REMOTEDEBUGENABLED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("remoteDebugEnabled").isBinary(false).build();

    private static final MarshallingInfo<String> HOSTADDRESS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hostAddress").isBinary(false).build();

    private static final MarshallingInfo<String> CLIENTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("clientId").isBinary(false).build();

    private static final MarshallingInfo<String> BILLINGMETHOD_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("billingMethod").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> DEVICEMINUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deviceMinutes")
            .isBinary(false).build();

    private static final MarshallingInfo<String> ENDPOINT_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("endpoint").isBinary(false).build();

    private static final MarshallingInfo<String> DEVICEUDID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deviceUdid").isBinary(false).build();

    private static final RemoteAccessSessionMarshaller INSTANCE = new RemoteAccessSessionMarshaller();

    private RemoteAccessSessionMarshaller() {
    }

    public static RemoteAccessSessionMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(RemoteAccessSession remoteAccessSession, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(remoteAccessSession, "remoteAccessSession");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(remoteAccessSession.arn(), ARN_BINDING);
            protocolMarshaller.marshall(remoteAccessSession.name(), NAME_BINDING);
            protocolMarshaller.marshall(remoteAccessSession.created(), CREATED_BINDING);
            protocolMarshaller.marshall(remoteAccessSession.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall(remoteAccessSession.resultAsString(), RESULT_BINDING);
            protocolMarshaller.marshall(remoteAccessSession.message(), MESSAGE_BINDING);
            protocolMarshaller.marshall(remoteAccessSession.started(), STARTED_BINDING);
            protocolMarshaller.marshall(remoteAccessSession.stopped(), STOPPED_BINDING);
            protocolMarshaller.marshall(remoteAccessSession.device(), DEVICE_BINDING);
            protocolMarshaller.marshall(remoteAccessSession.remoteDebugEnabled(), REMOTEDEBUGENABLED_BINDING);
            protocolMarshaller.marshall(remoteAccessSession.hostAddress(), HOSTADDRESS_BINDING);
            protocolMarshaller.marshall(remoteAccessSession.clientId(), CLIENTID_BINDING);
            protocolMarshaller.marshall(remoteAccessSession.billingMethodAsString(), BILLINGMETHOD_BINDING);
            protocolMarshaller.marshall(remoteAccessSession.deviceMinutes(), DEVICEMINUTES_BINDING);
            protocolMarshaller.marshall(remoteAccessSession.endpoint(), ENDPOINT_BINDING);
            protocolMarshaller.marshall(remoteAccessSession.deviceUdid(), DEVICEUDID_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
