/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstallToRemoteAccessSessionRequest
extends DeviceFarmRequest
implements ToCopyableBuilder<Builder, InstallToRemoteAccessSessionRequest> {
    private final String remoteAccessSessionArn;
    private final String appArn;

    private InstallToRemoteAccessSessionRequest(BuilderImpl builder) {
        super(builder);
        this.remoteAccessSessionArn = builder.remoteAccessSessionArn;
        this.appArn = builder.appArn;
    }

    public String remoteAccessSessionArn() {
        return this.remoteAccessSessionArn;
    }

    public String appArn() {
        return this.appArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteAccessSessionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.appArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstallToRemoteAccessSessionRequest)) {
            return false;
        }
        InstallToRemoteAccessSessionRequest other = (InstallToRemoteAccessSessionRequest)((Object)obj);
        return Objects.equals(this.remoteAccessSessionArn(), other.remoteAccessSessionArn()) && Objects.equals(this.appArn(), other.appArn());
    }

    public String toString() {
        return ToString.builder((String)"InstallToRemoteAccessSessionRequest").add("RemoteAccessSessionArn", (Object)this.remoteAccessSessionArn()).add("AppArn", (Object)this.appArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "remoteAccessSessionArn": {
                return Optional.of(clazz.cast(this.remoteAccessSessionArn()));
            }
            case "appArn": {
                return Optional.of(clazz.cast(this.appArn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DeviceFarmRequest.BuilderImpl
    implements Builder {
        private String remoteAccessSessionArn;
        private String appArn;

        private BuilderImpl() {
        }

        private BuilderImpl(InstallToRemoteAccessSessionRequest model) {
            super(model);
            this.remoteAccessSessionArn(model.remoteAccessSessionArn);
            this.appArn(model.appArn);
        }

        public final String getRemoteAccessSessionArn() {
            return this.remoteAccessSessionArn;
        }

        @Override
        public final Builder remoteAccessSessionArn(String remoteAccessSessionArn) {
            this.remoteAccessSessionArn = remoteAccessSessionArn;
            return this;
        }

        public final void setRemoteAccessSessionArn(String remoteAccessSessionArn) {
            this.remoteAccessSessionArn = remoteAccessSessionArn;
        }

        public final String getAppArn() {
            return this.appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public InstallToRemoteAccessSessionRequest build() {
            return new InstallToRemoteAccessSessionRequest(this);
        }
    }

    public static interface Builder
    extends DeviceFarmRequest.Builder,
    CopyableBuilder<Builder, InstallToRemoteAccessSessionRequest> {
        public Builder remoteAccessSessionArn(String var1);

        public Builder appArn(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

