/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmResponse;
import software.amazon.awssdk.services.devicefarm.model.DevicePool;
import software.amazon.awssdk.services.devicefarm.model.DevicePoolsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListDevicePoolsResponse
extends DeviceFarmResponse
implements ToCopyableBuilder<Builder, ListDevicePoolsResponse> {
    private final List<DevicePool> devicePools;
    private final String nextToken;

    private ListDevicePoolsResponse(BuilderImpl builder) {
        super(builder);
        this.devicePools = builder.devicePools;
        this.nextToken = builder.nextToken;
    }

    public List<DevicePool> devicePools() {
        return this.devicePools;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.devicePools());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDevicePoolsResponse)) {
            return false;
        }
        ListDevicePoolsResponse other = (ListDevicePoolsResponse)((Object)obj);
        return Objects.equals(this.devicePools(), other.devicePools()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListDevicePoolsResponse").add("DevicePools", this.devicePools()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "devicePools": {
                return Optional.of(clazz.cast(this.devicePools()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DeviceFarmResponse.BuilderImpl
    implements Builder {
        private List<DevicePool> devicePools;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDevicePoolsResponse model) {
            super(model);
            this.devicePools(model.devicePools);
            this.nextToken(model.nextToken);
        }

        public final Collection<DevicePool.Builder> getDevicePools() {
            return this.devicePools != null ? (Collection)this.devicePools.stream().map(DevicePool::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder devicePools(Collection<DevicePool> devicePools) {
            this.devicePools = DevicePoolsCopier.copy(devicePools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devicePools(DevicePool ... devicePools) {
            this.devicePools(Arrays.asList(devicePools));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devicePools(Consumer<DevicePool.Builder> ... devicePools) {
            this.devicePools(Stream.of(devicePools).map(c -> (DevicePool)((DevicePool.Builder)DevicePool.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDevicePools(Collection<DevicePool.BuilderImpl> devicePools) {
            this.devicePools = DevicePoolsCopier.copyFromBuilder(devicePools);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDevicePoolsResponse build() {
            return new ListDevicePoolsResponse(this);
        }
    }

    public static interface Builder
    extends DeviceFarmResponse.Builder,
    CopyableBuilder<Builder, ListDevicePoolsResponse> {
        public Builder devicePools(Collection<DevicePool> var1);

        public Builder devicePools(DevicePool ... var1);

        public Builder devicePools(Consumer<DevicePool.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

