/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.model.BillingMethod;
import software.amazon.awssdk.services.devicefarm.model.Device;
import software.amazon.awssdk.services.devicefarm.model.DeviceMinutes;
import software.amazon.awssdk.services.devicefarm.model.ExecutionResult;
import software.amazon.awssdk.services.devicefarm.model.ExecutionStatus;
import software.amazon.awssdk.services.devicefarm.transform.RemoteAccessSessionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RemoteAccessSession
implements StructuredPojo,
ToCopyableBuilder<Builder, RemoteAccessSession> {
    private final String arn;
    private final String name;
    private final Instant created;
    private final String status;
    private final String result;
    private final String message;
    private final Instant started;
    private final Instant stopped;
    private final Device device;
    private final Boolean remoteDebugEnabled;
    private final String hostAddress;
    private final String clientId;
    private final String billingMethod;
    private final DeviceMinutes deviceMinutes;
    private final String endpoint;
    private final String deviceUdid;

    private RemoteAccessSession(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.created = builder.created;
        this.status = builder.status;
        this.result = builder.result;
        this.message = builder.message;
        this.started = builder.started;
        this.stopped = builder.stopped;
        this.device = builder.device;
        this.remoteDebugEnabled = builder.remoteDebugEnabled;
        this.hostAddress = builder.hostAddress;
        this.clientId = builder.clientId;
        this.billingMethod = builder.billingMethod;
        this.deviceMinutes = builder.deviceMinutes;
        this.endpoint = builder.endpoint;
        this.deviceUdid = builder.deviceUdid;
    }

    public String arn() {
        return this.arn;
    }

    public String name() {
        return this.name;
    }

    public Instant created() {
        return this.created;
    }

    public ExecutionStatus status() {
        return ExecutionStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public ExecutionResult result() {
        return ExecutionResult.fromValue(this.result);
    }

    public String resultAsString() {
        return this.result;
    }

    public String message() {
        return this.message;
    }

    public Instant started() {
        return this.started;
    }

    public Instant stopped() {
        return this.stopped;
    }

    public Device device() {
        return this.device;
    }

    public Boolean remoteDebugEnabled() {
        return this.remoteDebugEnabled;
    }

    public String hostAddress() {
        return this.hostAddress;
    }

    public String clientId() {
        return this.clientId;
    }

    public BillingMethod billingMethod() {
        return BillingMethod.fromValue(this.billingMethod);
    }

    public String billingMethodAsString() {
        return this.billingMethod;
    }

    public DeviceMinutes deviceMinutes() {
        return this.deviceMinutes;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public String deviceUdid() {
        return this.deviceUdid;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.created());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.started());
        hashCode = 31 * hashCode + Objects.hashCode(this.stopped());
        hashCode = 31 * hashCode + Objects.hashCode(this.device());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteDebugEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceUdid());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoteAccessSession)) {
            return false;
        }
        RemoteAccessSession other = (RemoteAccessSession)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.created(), other.created()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.resultAsString(), other.resultAsString()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.started(), other.started()) && Objects.equals(this.stopped(), other.stopped()) && Objects.equals(this.device(), other.device()) && Objects.equals(this.remoteDebugEnabled(), other.remoteDebugEnabled()) && Objects.equals(this.hostAddress(), other.hostAddress()) && Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.billingMethodAsString(), other.billingMethodAsString()) && Objects.equals(this.deviceMinutes(), other.deviceMinutes()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.deviceUdid(), other.deviceUdid());
    }

    public String toString() {
        return ToString.builder((String)"RemoteAccessSession").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Created", (Object)this.created()).add("Status", (Object)this.statusAsString()).add("Result", (Object)this.resultAsString()).add("Message", (Object)this.message()).add("Started", (Object)this.started()).add("Stopped", (Object)this.stopped()).add("Device", (Object)this.device()).add("RemoteDebugEnabled", (Object)this.remoteDebugEnabled()).add("HostAddress", (Object)this.hostAddress()).add("ClientId", (Object)this.clientId()).add("BillingMethod", (Object)this.billingMethodAsString()).add("DeviceMinutes", (Object)this.deviceMinutes()).add("Endpoint", (Object)this.endpoint()).add("DeviceUdid", (Object)this.deviceUdid()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "created": {
                return Optional.of(clazz.cast(this.created()));
            }
            case "status": {
                return Optional.of(clazz.cast(this.statusAsString()));
            }
            case "result": {
                return Optional.of(clazz.cast(this.resultAsString()));
            }
            case "message": {
                return Optional.of(clazz.cast(this.message()));
            }
            case "started": {
                return Optional.of(clazz.cast(this.started()));
            }
            case "stopped": {
                return Optional.of(clazz.cast(this.stopped()));
            }
            case "device": {
                return Optional.of(clazz.cast(this.device()));
            }
            case "remoteDebugEnabled": {
                return Optional.of(clazz.cast(this.remoteDebugEnabled()));
            }
            case "hostAddress": {
                return Optional.of(clazz.cast(this.hostAddress()));
            }
            case "clientId": {
                return Optional.of(clazz.cast(this.clientId()));
            }
            case "billingMethod": {
                return Optional.of(clazz.cast(this.billingMethodAsString()));
            }
            case "deviceMinutes": {
                return Optional.of(clazz.cast(this.deviceMinutes()));
            }
            case "endpoint": {
                return Optional.of(clazz.cast(this.endpoint()));
            }
            case "deviceUdid": {
                return Optional.of(clazz.cast(this.deviceUdid()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RemoteAccessSessionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private Instant created;
        private String status;
        private String result;
        private String message;
        private Instant started;
        private Instant stopped;
        private Device device;
        private Boolean remoteDebugEnabled;
        private String hostAddress;
        private String clientId;
        private String billingMethod;
        private DeviceMinutes deviceMinutes;
        private String endpoint;
        private String deviceUdid;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoteAccessSession model) {
            this.arn(model.arn);
            this.name(model.name);
            this.created(model.created);
            this.status(model.status);
            this.result(model.result);
            this.message(model.message);
            this.started(model.started);
            this.stopped(model.stopped);
            this.device(model.device);
            this.remoteDebugEnabled(model.remoteDebugEnabled);
            this.hostAddress(model.hostAddress);
            this.clientId(model.clientId);
            this.billingMethod(model.billingMethod);
            this.deviceMinutes(model.deviceMinutes);
            this.endpoint(model.endpoint);
            this.deviceUdid(model.deviceUdid);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Instant getCreated() {
            return this.created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExecutionStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getResult() {
            return this.result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        @Override
        public final Builder result(ExecutionResult result) {
            this.result(result.toString());
            return this;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Instant getStarted() {
            return this.started;
        }

        @Override
        public final Builder started(Instant started) {
            this.started = started;
            return this;
        }

        public final void setStarted(Instant started) {
            this.started = started;
        }

        public final Instant getStopped() {
            return this.stopped;
        }

        @Override
        public final Builder stopped(Instant stopped) {
            this.stopped = stopped;
            return this;
        }

        public final void setStopped(Instant stopped) {
            this.stopped = stopped;
        }

        public final Device.Builder getDevice() {
            return this.device != null ? this.device.toBuilder() : null;
        }

        @Override
        public final Builder device(Device device) {
            this.device = device;
            return this;
        }

        public final void setDevice(Device.BuilderImpl device) {
            this.device = device != null ? device.build() : null;
        }

        public final Boolean getRemoteDebugEnabled() {
            return this.remoteDebugEnabled;
        }

        @Override
        public final Builder remoteDebugEnabled(Boolean remoteDebugEnabled) {
            this.remoteDebugEnabled = remoteDebugEnabled;
            return this;
        }

        public final void setRemoteDebugEnabled(Boolean remoteDebugEnabled) {
            this.remoteDebugEnabled = remoteDebugEnabled;
        }

        public final String getHostAddress() {
            return this.hostAddress;
        }

        @Override
        public final Builder hostAddress(String hostAddress) {
            this.hostAddress = hostAddress;
            return this;
        }

        public final void setHostAddress(String hostAddress) {
            this.hostAddress = hostAddress;
        }

        public final String getClientId() {
            return this.clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final String getBillingMethod() {
            return this.billingMethod;
        }

        @Override
        public final Builder billingMethod(String billingMethod) {
            this.billingMethod = billingMethod;
            return this;
        }

        @Override
        public final Builder billingMethod(BillingMethod billingMethod) {
            this.billingMethod(billingMethod.toString());
            return this;
        }

        public final void setBillingMethod(String billingMethod) {
            this.billingMethod = billingMethod;
        }

        public final DeviceMinutes.Builder getDeviceMinutes() {
            return this.deviceMinutes != null ? this.deviceMinutes.toBuilder() : null;
        }

        @Override
        public final Builder deviceMinutes(DeviceMinutes deviceMinutes) {
            this.deviceMinutes = deviceMinutes;
            return this;
        }

        public final void setDeviceMinutes(DeviceMinutes.BuilderImpl deviceMinutes) {
            this.deviceMinutes = deviceMinutes != null ? deviceMinutes.build() : null;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public final String getDeviceUdid() {
            return this.deviceUdid;
        }

        @Override
        public final Builder deviceUdid(String deviceUdid) {
            this.deviceUdid = deviceUdid;
            return this;
        }

        public final void setDeviceUdid(String deviceUdid) {
            this.deviceUdid = deviceUdid;
        }

        public RemoteAccessSession build() {
            return new RemoteAccessSession(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RemoteAccessSession> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder created(Instant var1);

        public Builder status(String var1);

        public Builder status(ExecutionStatus var1);

        public Builder result(String var1);

        public Builder result(ExecutionResult var1);

        public Builder message(String var1);

        public Builder started(Instant var1);

        public Builder stopped(Instant var1);

        public Builder device(Device var1);

        default public Builder device(Consumer<Device.Builder> device) {
            return this.device((Device)((Device.Builder)Device.builder().apply(device)).build());
        }

        public Builder remoteDebugEnabled(Boolean var1);

        public Builder hostAddress(String var1);

        public Builder clientId(String var1);

        public Builder billingMethod(String var1);

        public Builder billingMethod(BillingMethod var1);

        public Builder deviceMinutes(DeviceMinutes var1);

        default public Builder deviceMinutes(Consumer<DeviceMinutes.Builder> deviceMinutes) {
            return this.deviceMinutes((DeviceMinutes)((DeviceMinutes.Builder)DeviceMinutes.builder().apply(deviceMinutes)).build());
        }

        public Builder endpoint(String var1);

        public Builder deviceUdid(String var1);
    }
}

