/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.model.Problem;
import software.amazon.awssdk.services.devicefarm.model.ProblemsCopier;
import software.amazon.awssdk.services.devicefarm.transform.UniqueProblemMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UniqueProblem
implements StructuredPojo,
ToCopyableBuilder<Builder, UniqueProblem> {
    private final String message;
    private final List<Problem> problems;

    private UniqueProblem(BuilderImpl builder) {
        this.message = builder.message;
        this.problems = builder.problems;
    }

    public String message() {
        return this.message;
    }

    public List<Problem> problems() {
        return this.problems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.problems());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UniqueProblem)) {
            return false;
        }
        UniqueProblem other = (UniqueProblem)obj;
        return Objects.equals(this.message(), other.message()) && Objects.equals(this.problems(), other.problems());
    }

    public String toString() {
        return ToString.builder((String)"UniqueProblem").add("Message", (Object)this.message()).add("Problems", this.problems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "message": {
                return Optional.of(clazz.cast(this.message()));
            }
            case "problems": {
                return Optional.of(clazz.cast(this.problems()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UniqueProblemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String message;
        private List<Problem> problems;

        private BuilderImpl() {
        }

        private BuilderImpl(UniqueProblem model) {
            this.message(model.message);
            this.problems(model.problems);
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Collection<Problem.Builder> getProblems() {
            return this.problems != null ? (Collection)this.problems.stream().map(Problem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder problems(Collection<Problem> problems) {
            this.problems = ProblemsCopier.copy(problems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder problems(Problem ... problems) {
            this.problems(Arrays.asList(problems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder problems(Consumer<Problem.Builder> ... problems) {
            this.problems(Stream.of(problems).map(c -> (Problem)((Problem.Builder)Problem.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProblems(Collection<Problem.BuilderImpl> problems) {
            this.problems = ProblemsCopier.copyFromBuilder(problems);
        }

        public UniqueProblem build() {
            return new UniqueProblem(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UniqueProblem> {
        public Builder message(String var1);

        public Builder problems(Collection<Problem> var1);

        public Builder problems(Problem ... var1);

        public Builder problems(Consumer<Problem.Builder> ... var1);
    }
}

