/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.devicefarm.model.Project;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ProjectMarshaller {
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<Integer> DEFAULTJOBTIMEOUTMINUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("defaultJobTimeoutMinutes").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("created").isBinary(false).build();
    private static final ProjectMarshaller INSTANCE = new ProjectMarshaller();

    private ProjectMarshaller() {
    }

    public static ProjectMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Project project, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)project, (String)"project");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)project.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)project.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)project.defaultJobTimeoutMinutes(), DEFAULTJOBTIMEOUTMINUTES_BINDING);
            protocolMarshaller.marshall((Object)project.created(), CREATED_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

