/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.devicefarm.model.ArgumentException;
import software.amazon.awssdk.services.devicefarm.model.CreateDevicePoolRequest;
import software.amazon.awssdk.services.devicefarm.model.CreateDevicePoolResponse;
import software.amazon.awssdk.services.devicefarm.model.CreateInstanceProfileRequest;
import software.amazon.awssdk.services.devicefarm.model.CreateInstanceProfileResponse;
import software.amazon.awssdk.services.devicefarm.model.CreateNetworkProfileRequest;
import software.amazon.awssdk.services.devicefarm.model.CreateNetworkProfileResponse;
import software.amazon.awssdk.services.devicefarm.model.CreateProjectRequest;
import software.amazon.awssdk.services.devicefarm.model.CreateProjectResponse;
import software.amazon.awssdk.services.devicefarm.model.CreateRemoteAccessSessionRequest;
import software.amazon.awssdk.services.devicefarm.model.CreateRemoteAccessSessionResponse;
import software.amazon.awssdk.services.devicefarm.model.CreateUploadRequest;
import software.amazon.awssdk.services.devicefarm.model.CreateUploadResponse;
import software.amazon.awssdk.services.devicefarm.model.CreateVpceConfigurationRequest;
import software.amazon.awssdk.services.devicefarm.model.CreateVpceConfigurationResponse;
import software.amazon.awssdk.services.devicefarm.model.DeleteDevicePoolRequest;
import software.amazon.awssdk.services.devicefarm.model.DeleteDevicePoolResponse;
import software.amazon.awssdk.services.devicefarm.model.DeleteInstanceProfileRequest;
import software.amazon.awssdk.services.devicefarm.model.DeleteInstanceProfileResponse;
import software.amazon.awssdk.services.devicefarm.model.DeleteNetworkProfileRequest;
import software.amazon.awssdk.services.devicefarm.model.DeleteNetworkProfileResponse;
import software.amazon.awssdk.services.devicefarm.model.DeleteProjectRequest;
import software.amazon.awssdk.services.devicefarm.model.DeleteProjectResponse;
import software.amazon.awssdk.services.devicefarm.model.DeleteRemoteAccessSessionRequest;
import software.amazon.awssdk.services.devicefarm.model.DeleteRemoteAccessSessionResponse;
import software.amazon.awssdk.services.devicefarm.model.DeleteRunRequest;
import software.amazon.awssdk.services.devicefarm.model.DeleteRunResponse;
import software.amazon.awssdk.services.devicefarm.model.DeleteUploadRequest;
import software.amazon.awssdk.services.devicefarm.model.DeleteUploadResponse;
import software.amazon.awssdk.services.devicefarm.model.DeleteVpceConfigurationRequest;
import software.amazon.awssdk.services.devicefarm.model.DeleteVpceConfigurationResponse;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmException;
import software.amazon.awssdk.services.devicefarm.model.GetAccountSettingsRequest;
import software.amazon.awssdk.services.devicefarm.model.GetAccountSettingsResponse;
import software.amazon.awssdk.services.devicefarm.model.GetDeviceInstanceRequest;
import software.amazon.awssdk.services.devicefarm.model.GetDeviceInstanceResponse;
import software.amazon.awssdk.services.devicefarm.model.GetDevicePoolCompatibilityRequest;
import software.amazon.awssdk.services.devicefarm.model.GetDevicePoolCompatibilityResponse;
import software.amazon.awssdk.services.devicefarm.model.GetDevicePoolRequest;
import software.amazon.awssdk.services.devicefarm.model.GetDevicePoolResponse;
import software.amazon.awssdk.services.devicefarm.model.GetDeviceRequest;
import software.amazon.awssdk.services.devicefarm.model.GetDeviceResponse;
import software.amazon.awssdk.services.devicefarm.model.GetInstanceProfileRequest;
import software.amazon.awssdk.services.devicefarm.model.GetInstanceProfileResponse;
import software.amazon.awssdk.services.devicefarm.model.GetJobRequest;
import software.amazon.awssdk.services.devicefarm.model.GetJobResponse;
import software.amazon.awssdk.services.devicefarm.model.GetNetworkProfileRequest;
import software.amazon.awssdk.services.devicefarm.model.GetNetworkProfileResponse;
import software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusRequest;
import software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusResponse;
import software.amazon.awssdk.services.devicefarm.model.GetProjectRequest;
import software.amazon.awssdk.services.devicefarm.model.GetProjectResponse;
import software.amazon.awssdk.services.devicefarm.model.GetRemoteAccessSessionRequest;
import software.amazon.awssdk.services.devicefarm.model.GetRemoteAccessSessionResponse;
import software.amazon.awssdk.services.devicefarm.model.GetRunRequest;
import software.amazon.awssdk.services.devicefarm.model.GetRunResponse;
import software.amazon.awssdk.services.devicefarm.model.GetSuiteRequest;
import software.amazon.awssdk.services.devicefarm.model.GetSuiteResponse;
import software.amazon.awssdk.services.devicefarm.model.GetTestRequest;
import software.amazon.awssdk.services.devicefarm.model.GetTestResponse;
import software.amazon.awssdk.services.devicefarm.model.GetUploadRequest;
import software.amazon.awssdk.services.devicefarm.model.GetUploadResponse;
import software.amazon.awssdk.services.devicefarm.model.GetVpceConfigurationRequest;
import software.amazon.awssdk.services.devicefarm.model.GetVpceConfigurationResponse;
import software.amazon.awssdk.services.devicefarm.model.IdempotencyException;
import software.amazon.awssdk.services.devicefarm.model.InstallToRemoteAccessSessionRequest;
import software.amazon.awssdk.services.devicefarm.model.InstallToRemoteAccessSessionResponse;
import software.amazon.awssdk.services.devicefarm.model.InvalidOperationException;
import software.amazon.awssdk.services.devicefarm.model.LimitExceededException;
import software.amazon.awssdk.services.devicefarm.model.ListArtifactsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListArtifactsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListDeviceInstancesRequest;
import software.amazon.awssdk.services.devicefarm.model.ListDeviceInstancesResponse;
import software.amazon.awssdk.services.devicefarm.model.ListDevicePoolsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListDevicePoolsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListDevicesRequest;
import software.amazon.awssdk.services.devicefarm.model.ListDevicesResponse;
import software.amazon.awssdk.services.devicefarm.model.ListInstanceProfilesRequest;
import software.amazon.awssdk.services.devicefarm.model.ListInstanceProfilesResponse;
import software.amazon.awssdk.services.devicefarm.model.ListJobsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListJobsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListNetworkProfilesRequest;
import software.amazon.awssdk.services.devicefarm.model.ListNetworkProfilesResponse;
import software.amazon.awssdk.services.devicefarm.model.ListOfferingPromotionsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListOfferingPromotionsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListOfferingsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListOfferingsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListProjectsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListProjectsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListRemoteAccessSessionsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListRemoteAccessSessionsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListRunsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListRunsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListSamplesRequest;
import software.amazon.awssdk.services.devicefarm.model.ListSamplesResponse;
import software.amazon.awssdk.services.devicefarm.model.ListSuitesRequest;
import software.amazon.awssdk.services.devicefarm.model.ListSuitesResponse;
import software.amazon.awssdk.services.devicefarm.model.ListTestsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListTestsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListUniqueProblemsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListUniqueProblemsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListUploadsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListUploadsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListVpceConfigurationsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListVpceConfigurationsResponse;
import software.amazon.awssdk.services.devicefarm.model.NotEligibleException;
import software.amazon.awssdk.services.devicefarm.model.NotFoundException;
import software.amazon.awssdk.services.devicefarm.model.PurchaseOfferingRequest;
import software.amazon.awssdk.services.devicefarm.model.PurchaseOfferingResponse;
import software.amazon.awssdk.services.devicefarm.model.RenewOfferingRequest;
import software.amazon.awssdk.services.devicefarm.model.RenewOfferingResponse;
import software.amazon.awssdk.services.devicefarm.model.ScheduleRunRequest;
import software.amazon.awssdk.services.devicefarm.model.ScheduleRunResponse;
import software.amazon.awssdk.services.devicefarm.model.ServiceAccountException;
import software.amazon.awssdk.services.devicefarm.model.StopJobRequest;
import software.amazon.awssdk.services.devicefarm.model.StopJobResponse;
import software.amazon.awssdk.services.devicefarm.model.StopRemoteAccessSessionRequest;
import software.amazon.awssdk.services.devicefarm.model.StopRemoteAccessSessionResponse;
import software.amazon.awssdk.services.devicefarm.model.StopRunRequest;
import software.amazon.awssdk.services.devicefarm.model.StopRunResponse;
import software.amazon.awssdk.services.devicefarm.model.UpdateDeviceInstanceRequest;
import software.amazon.awssdk.services.devicefarm.model.UpdateDeviceInstanceResponse;
import software.amazon.awssdk.services.devicefarm.model.UpdateDevicePoolRequest;
import software.amazon.awssdk.services.devicefarm.model.UpdateDevicePoolResponse;
import software.amazon.awssdk.services.devicefarm.model.UpdateInstanceProfileRequest;
import software.amazon.awssdk.services.devicefarm.model.UpdateInstanceProfileResponse;
import software.amazon.awssdk.services.devicefarm.model.UpdateNetworkProfileRequest;
import software.amazon.awssdk.services.devicefarm.model.UpdateNetworkProfileResponse;
import software.amazon.awssdk.services.devicefarm.model.UpdateProjectRequest;
import software.amazon.awssdk.services.devicefarm.model.UpdateProjectResponse;
import software.amazon.awssdk.services.devicefarm.model.UpdateUploadRequest;
import software.amazon.awssdk.services.devicefarm.model.UpdateUploadResponse;
import software.amazon.awssdk.services.devicefarm.model.UpdateVpceConfigurationRequest;
import software.amazon.awssdk.services.devicefarm.model.UpdateVpceConfigurationResponse;
import software.amazon.awssdk.services.devicefarm.paginators.GetOfferingStatusIterable;
import software.amazon.awssdk.services.devicefarm.paginators.ListArtifactsIterable;
import software.amazon.awssdk.services.devicefarm.paginators.ListDevicePoolsIterable;
import software.amazon.awssdk.services.devicefarm.paginators.ListDevicesIterable;
import software.amazon.awssdk.services.devicefarm.paginators.ListJobsIterable;
import software.amazon.awssdk.services.devicefarm.paginators.ListOfferingTransactionsIterable;
import software.amazon.awssdk.services.devicefarm.paginators.ListOfferingsIterable;
import software.amazon.awssdk.services.devicefarm.paginators.ListProjectsIterable;
import software.amazon.awssdk.services.devicefarm.paginators.ListRunsIterable;
import software.amazon.awssdk.services.devicefarm.paginators.ListSamplesIterable;
import software.amazon.awssdk.services.devicefarm.paginators.ListSuitesIterable;
import software.amazon.awssdk.services.devicefarm.paginators.ListTestsIterable;
import software.amazon.awssdk.services.devicefarm.paginators.ListUniqueProblemsIterable;
import software.amazon.awssdk.services.devicefarm.paginators.ListUploadsIterable;

/**
 * Service client for accessing null. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * AWS Device Farm is a service that enables mobile app developers to test Android, iOS, and Fire OS apps on physical
 * phones, tablets, and other devices in the cloud.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface DeviceFarmClient extends SdkClient {
    String SERVICE_NAME = "devicefarm";

    /**
     * Create a {@link DeviceFarmClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static DeviceFarmClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link DeviceFarmClient}.
     */
    static DeviceFarmClientBuilder builder() {
        return new DefaultDeviceFarmClientBuilder();
    }

    /**
     * <p>
     * Creates a device pool.
     * </p>
     *
     * @param createDevicePoolRequest
     *        Represents a request to the create device pool operation.
     * @return Result of the CreateDevicePool operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.CreateDevicePool
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateDevicePool" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDevicePoolResponse createDevicePool(CreateDevicePoolRequest createDevicePoolRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a device pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDevicePoolRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDevicePoolRequest#builder()}
     * </p>
     *
     * @param createDevicePoolRequest
     *        A {@link Consumer} that will call methods on {@link CreateDevicePoolRequest.Builder} to create a request.
     *        Represents a request to the create device pool operation.
     * @return Result of the CreateDevicePool operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.CreateDevicePool
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateDevicePool" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDevicePoolResponse createDevicePool(Consumer<CreateDevicePoolRequest.Builder> createDevicePoolRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        return createDevicePool(CreateDevicePoolRequest.builder().applyMutation(createDevicePoolRequest).build());
    }

    /**
     * <p>
     * Creates a profile that can be applied to one or more private fleet device instances.
     * </p>
     *
     * @param createInstanceProfileRequest
     * @return Result of the CreateInstanceProfile operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.CreateInstanceProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateInstanceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateInstanceProfileResponse createInstanceProfile(CreateInstanceProfileRequest createInstanceProfileRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a profile that can be applied to one or more private fleet device instances.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInstanceProfileRequest.Builder} avoiding the
     * need to create one manually via {@link CreateInstanceProfileRequest#builder()}
     * </p>
     *
     * @param createInstanceProfileRequest
     *        A {@link Consumer} that will call methods on {@link CreateInstanceProfileRequest.Builder} to create a
     *        request.
     * @return Result of the CreateInstanceProfile operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.CreateInstanceProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateInstanceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateInstanceProfileResponse createInstanceProfile(
            Consumer<CreateInstanceProfileRequest.Builder> createInstanceProfileRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        return createInstanceProfile(CreateInstanceProfileRequest.builder().applyMutation(createInstanceProfileRequest).build());
    }

    /**
     * <p>
     * Creates a network profile.
     * </p>
     *
     * @param createNetworkProfileRequest
     * @return Result of the CreateNetworkProfile operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.CreateNetworkProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateNetworkProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateNetworkProfileResponse createNetworkProfile(CreateNetworkProfileRequest createNetworkProfileRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a network profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNetworkProfileRequest.Builder} avoiding the
     * need to create one manually via {@link CreateNetworkProfileRequest#builder()}
     * </p>
     *
     * @param createNetworkProfileRequest
     *        A {@link Consumer} that will call methods on {@link CreateNetworkProfileRequest.Builder} to create a
     *        request.
     * @return Result of the CreateNetworkProfile operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.CreateNetworkProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateNetworkProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateNetworkProfileResponse createNetworkProfile(
            Consumer<CreateNetworkProfileRequest.Builder> createNetworkProfileRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        return createNetworkProfile(CreateNetworkProfileRequest.builder().applyMutation(createNetworkProfileRequest).build());
    }

    /**
     * <p>
     * Creates a new project.
     * </p>
     *
     * @param createProjectRequest
     *        Represents a request to the create project operation.
     * @return Result of the CreateProject operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.CreateProject
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateProjectResponse createProject(CreateProjectRequest createProjectRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProjectRequest.Builder} avoiding the need to
     * create one manually via {@link CreateProjectRequest#builder()}
     * </p>
     *
     * @param createProjectRequest
     *        A {@link Consumer} that will call methods on {@link CreateProjectRequest.Builder} to create a request.
     *        Represents a request to the create project operation.
     * @return Result of the CreateProject operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.CreateProject
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateProjectResponse createProject(Consumer<CreateProjectRequest.Builder> createProjectRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        return createProject(CreateProjectRequest.builder().applyMutation(createProjectRequest).build());
    }

    /**
     * <p>
     * Specifies and starts a remote access session.
     * </p>
     *
     * @param createRemoteAccessSessionRequest
     *        Creates and submits a request to start a remote access session.
     * @return Result of the CreateRemoteAccessSession operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.CreateRemoteAccessSession
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateRemoteAccessSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateRemoteAccessSessionResponse createRemoteAccessSession(
            CreateRemoteAccessSessionRequest createRemoteAccessSessionRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Specifies and starts a remote access session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRemoteAccessSessionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateRemoteAccessSessionRequest#builder()}
     * </p>
     *
     * @param createRemoteAccessSessionRequest
     *        A {@link Consumer} that will call methods on {@link CreateRemoteAccessSessionRequest.Builder} to create a
     *        request. Creates and submits a request to start a remote access session.
     * @return Result of the CreateRemoteAccessSession operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.CreateRemoteAccessSession
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateRemoteAccessSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateRemoteAccessSessionResponse createRemoteAccessSession(
            Consumer<CreateRemoteAccessSessionRequest.Builder> createRemoteAccessSessionRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        return createRemoteAccessSession(CreateRemoteAccessSessionRequest.builder()
                .applyMutation(createRemoteAccessSessionRequest).build());
    }

    /**
     * <p>
     * Uploads an app or test scripts.
     * </p>
     *
     * @param createUploadRequest
     *        Represents a request to the create upload operation.
     * @return Result of the CreateUpload operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.CreateUpload
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateUpload" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateUploadResponse createUpload(CreateUploadRequest createUploadRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Uploads an app or test scripts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUploadRequest.Builder} avoiding the need to
     * create one manually via {@link CreateUploadRequest#builder()}
     * </p>
     *
     * @param createUploadRequest
     *        A {@link Consumer} that will call methods on {@link CreateUploadRequest.Builder} to create a request.
     *        Represents a request to the create upload operation.
     * @return Result of the CreateUpload operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.CreateUpload
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateUpload" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateUploadResponse createUpload(Consumer<CreateUploadRequest.Builder> createUploadRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        return createUpload(CreateUploadRequest.builder().applyMutation(createUploadRequest).build());
    }

    /**
     * <p>
     * Creates a configuration record in Device Farm for your Amazon Virtual Private Cloud (VPC) endpoint.
     * </p>
     *
     * @param createVpceConfigurationRequest
     * @return Result of the CreateVPCEConfiguration operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.CreateVPCEConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateVPCEConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateVpceConfigurationResponse createVPCEConfiguration(CreateVpceConfigurationRequest createVpceConfigurationRequest)
            throws ArgumentException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a configuration record in Device Farm for your Amazon Virtual Private Cloud (VPC) endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVpceConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link CreateVpceConfigurationRequest#builder()}
     * </p>
     *
     * @param createVpceConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link CreateVPCEConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the CreateVPCEConfiguration operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.CreateVPCEConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateVPCEConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateVpceConfigurationResponse createVPCEConfiguration(
            Consumer<CreateVpceConfigurationRequest.Builder> createVpceConfigurationRequest) throws ArgumentException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        return createVPCEConfiguration(CreateVpceConfigurationRequest.builder().applyMutation(createVpceConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a device pool given the pool ARN. Does not allow deletion of curated pools owned by the system.
     * </p>
     *
     * @param deleteDevicePoolRequest
     *        Represents a request to the delete device pool operation.
     * @return Result of the DeleteDevicePool operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.DeleteDevicePool
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteDevicePool" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDevicePoolResponse deleteDevicePool(DeleteDevicePoolRequest deleteDevicePoolRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a device pool given the pool ARN. Does not allow deletion of curated pools owned by the system.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDevicePoolRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDevicePoolRequest#builder()}
     * </p>
     *
     * @param deleteDevicePoolRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDevicePoolRequest.Builder} to create a request.
     *        Represents a request to the delete device pool operation.
     * @return Result of the DeleteDevicePool operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.DeleteDevicePool
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteDevicePool" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDevicePoolResponse deleteDevicePool(Consumer<DeleteDevicePoolRequest.Builder> deleteDevicePoolRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        return deleteDevicePool(DeleteDevicePoolRequest.builder().applyMutation(deleteDevicePoolRequest).build());
    }

    /**
     * <p>
     * Deletes a profile that can be applied to one or more private device instances.
     * </p>
     *
     * @param deleteInstanceProfileRequest
     * @return Result of the DeleteInstanceProfile operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.DeleteInstanceProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteInstanceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteInstanceProfileResponse deleteInstanceProfile(DeleteInstanceProfileRequest deleteInstanceProfileRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a profile that can be applied to one or more private device instances.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInstanceProfileRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteInstanceProfileRequest#builder()}
     * </p>
     *
     * @param deleteInstanceProfileRequest
     *        A {@link Consumer} that will call methods on {@link DeleteInstanceProfileRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteInstanceProfile operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.DeleteInstanceProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteInstanceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteInstanceProfileResponse deleteInstanceProfile(
            Consumer<DeleteInstanceProfileRequest.Builder> deleteInstanceProfileRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        return deleteInstanceProfile(DeleteInstanceProfileRequest.builder().applyMutation(deleteInstanceProfileRequest).build());
    }

    /**
     * <p>
     * Deletes a network profile.
     * </p>
     *
     * @param deleteNetworkProfileRequest
     * @return Result of the DeleteNetworkProfile operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.DeleteNetworkProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteNetworkProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteNetworkProfileResponse deleteNetworkProfile(DeleteNetworkProfileRequest deleteNetworkProfileRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a network profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNetworkProfileRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteNetworkProfileRequest#builder()}
     * </p>
     *
     * @param deleteNetworkProfileRequest
     *        A {@link Consumer} that will call methods on {@link DeleteNetworkProfileRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteNetworkProfile operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.DeleteNetworkProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteNetworkProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteNetworkProfileResponse deleteNetworkProfile(
            Consumer<DeleteNetworkProfileRequest.Builder> deleteNetworkProfileRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        return deleteNetworkProfile(DeleteNetworkProfileRequest.builder().applyMutation(deleteNetworkProfileRequest).build());
    }

    /**
     * <p>
     * Deletes an AWS Device Farm project, given the project ARN.
     * </p>
     * <p>
     * <b>Note</b> Deleting this resource does not stop an in-progress run.
     * </p>
     *
     * @param deleteProjectRequest
     *        Represents a request to the delete project operation.
     * @return Result of the DeleteProject operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.DeleteProject
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteProject" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteProjectResponse deleteProject(DeleteProjectRequest deleteProjectRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an AWS Device Farm project, given the project ARN.
     * </p>
     * <p>
     * <b>Note</b> Deleting this resource does not stop an in-progress run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProjectRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteProjectRequest#builder()}
     * </p>
     *
     * @param deleteProjectRequest
     *        A {@link Consumer} that will call methods on {@link DeleteProjectRequest.Builder} to create a request.
     *        Represents a request to the delete project operation.
     * @return Result of the DeleteProject operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.DeleteProject
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteProject" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteProjectResponse deleteProject(Consumer<DeleteProjectRequest.Builder> deleteProjectRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        return deleteProject(DeleteProjectRequest.builder().applyMutation(deleteProjectRequest).build());
    }

    /**
     * <p>
     * Deletes a completed remote access session and its results.
     * </p>
     *
     * @param deleteRemoteAccessSessionRequest
     *        Represents the request to delete the specified remote access session.
     * @return Result of the DeleteRemoteAccessSession operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.DeleteRemoteAccessSession
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteRemoteAccessSession"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRemoteAccessSessionResponse deleteRemoteAccessSession(
            DeleteRemoteAccessSessionRequest deleteRemoteAccessSessionRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a completed remote access session and its results.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRemoteAccessSessionRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteRemoteAccessSessionRequest#builder()}
     * </p>
     *
     * @param deleteRemoteAccessSessionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRemoteAccessSessionRequest.Builder} to create a
     *        request. Represents the request to delete the specified remote access session.
     * @return Result of the DeleteRemoteAccessSession operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.DeleteRemoteAccessSession
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteRemoteAccessSession"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRemoteAccessSessionResponse deleteRemoteAccessSession(
            Consumer<DeleteRemoteAccessSessionRequest.Builder> deleteRemoteAccessSessionRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        return deleteRemoteAccessSession(DeleteRemoteAccessSessionRequest.builder()
                .applyMutation(deleteRemoteAccessSessionRequest).build());
    }

    /**
     * <p>
     * Deletes the run, given the run ARN.
     * </p>
     * <p>
     * <b>Note</b> Deleting this resource does not stop an in-progress run.
     * </p>
     *
     * @param deleteRunRequest
     *        Represents a request to the delete run operation.
     * @return Result of the DeleteRun operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.DeleteRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteRun" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteRunResponse deleteRun(DeleteRunRequest deleteRunRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the run, given the run ARN.
     * </p>
     * <p>
     * <b>Note</b> Deleting this resource does not stop an in-progress run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRunRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteRunRequest#builder()}
     * </p>
     *
     * @param deleteRunRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRunRequest.Builder} to create a request.
     *        Represents a request to the delete run operation.
     * @return Result of the DeleteRun operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.DeleteRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteRun" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteRunResponse deleteRun(Consumer<DeleteRunRequest.Builder> deleteRunRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        return deleteRun(DeleteRunRequest.builder().applyMutation(deleteRunRequest).build());
    }

    /**
     * <p>
     * Deletes an upload given the upload ARN.
     * </p>
     *
     * @param deleteUploadRequest
     *        Represents a request to the delete upload operation.
     * @return Result of the DeleteUpload operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.DeleteUpload
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteUpload" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteUploadResponse deleteUpload(DeleteUploadRequest deleteUploadRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an upload given the upload ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUploadRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteUploadRequest#builder()}
     * </p>
     *
     * @param deleteUploadRequest
     *        A {@link Consumer} that will call methods on {@link DeleteUploadRequest.Builder} to create a request.
     *        Represents a request to the delete upload operation.
     * @return Result of the DeleteUpload operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.DeleteUpload
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteUpload" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteUploadResponse deleteUpload(Consumer<DeleteUploadRequest.Builder> deleteUploadRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        return deleteUpload(DeleteUploadRequest.builder().applyMutation(deleteUploadRequest).build());
    }

    /**
     * <p>
     * Deletes a configuration for your Amazon Virtual Private Cloud (VPC) endpoint.
     * </p>
     *
     * @param deleteVpceConfigurationRequest
     * @return Result of the DeleteVPCEConfiguration operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws InvalidOperationException
     *         There was an error with the update request, or you do not have sufficient permissions to update this VPC
     *         endpoint configuration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.DeleteVPCEConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteVPCEConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteVpceConfigurationResponse deleteVPCEConfiguration(DeleteVpceConfigurationRequest deleteVpceConfigurationRequest)
            throws ArgumentException, NotFoundException, ServiceAccountException, InvalidOperationException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a configuration for your Amazon Virtual Private Cloud (VPC) endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVpceConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteVpceConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteVpceConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVPCEConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteVPCEConfiguration operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws InvalidOperationException
     *         There was an error with the update request, or you do not have sufficient permissions to update this VPC
     *         endpoint configuration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.DeleteVPCEConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteVPCEConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteVpceConfigurationResponse deleteVPCEConfiguration(
            Consumer<DeleteVpceConfigurationRequest.Builder> deleteVpceConfigurationRequest) throws ArgumentException,
            NotFoundException, ServiceAccountException, InvalidOperationException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        return deleteVPCEConfiguration(DeleteVpceConfigurationRequest.builder().applyMutation(deleteVpceConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Returns the number of unmetered iOS and/or unmetered Android devices that have been purchased by the account.
     * </p>
     *
     * @return Result of the GetAccountSettings operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetAccountSettings
     * @see #getAccountSettings(GetAccountSettingsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetAccountSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default GetAccountSettingsResponse getAccountSettings() throws ArgumentException, NotFoundException, LimitExceededException,
            ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        return getAccountSettings(GetAccountSettingsRequest.builder().build());
    }

    /**
     * <p>
     * Returns the number of unmetered iOS and/or unmetered Android devices that have been purchased by the account.
     * </p>
     *
     * @param getAccountSettingsRequest
     *        Represents the request sent to retrieve the account settings.
     * @return Result of the GetAccountSettings operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetAccountSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetAccountSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default GetAccountSettingsResponse getAccountSettings(GetAccountSettingsRequest getAccountSettingsRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the number of unmetered iOS and/or unmetered Android devices that have been purchased by the account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccountSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link GetAccountSettingsRequest#builder()}
     * </p>
     *
     * @param getAccountSettingsRequest
     *        A {@link Consumer} that will call methods on {@link GetAccountSettingsRequest.Builder} to create a
     *        request. Represents the request sent to retrieve the account settings.
     * @return Result of the GetAccountSettings operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetAccountSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetAccountSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default GetAccountSettingsResponse getAccountSettings(Consumer<GetAccountSettingsRequest.Builder> getAccountSettingsRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        return getAccountSettings(GetAccountSettingsRequest.builder().applyMutation(getAccountSettingsRequest).build());
    }

    /**
     * <p>
     * Gets information about a unique device type.
     * </p>
     *
     * @param getDeviceRequest
     *        Represents a request to the get device request.
     * @return Result of the GetDevice operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDeviceResponse getDevice(GetDeviceRequest getDeviceRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a unique device type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeviceRequest.Builder} avoiding the need to
     * create one manually via {@link GetDeviceRequest#builder()}
     * </p>
     *
     * @param getDeviceRequest
     *        A {@link Consumer} that will call methods on {@link GetDeviceRequest.Builder} to create a request.
     *        Represents a request to the get device request.
     * @return Result of the GetDevice operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDeviceResponse getDevice(Consumer<GetDeviceRequest.Builder> getDeviceRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        return getDevice(GetDeviceRequest.builder().applyMutation(getDeviceRequest).build());
    }

    /**
     * <p>
     * Returns information about a device instance belonging to a private device fleet.
     * </p>
     *
     * @param getDeviceInstanceRequest
     * @return Result of the GetDeviceInstance operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetDeviceInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetDeviceInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default GetDeviceInstanceResponse getDeviceInstance(GetDeviceInstanceRequest getDeviceInstanceRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a device instance belonging to a private device fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeviceInstanceRequest.Builder} avoiding the need
     * to create one manually via {@link GetDeviceInstanceRequest#builder()}
     * </p>
     *
     * @param getDeviceInstanceRequest
     *        A {@link Consumer} that will call methods on {@link GetDeviceInstanceRequest.Builder} to create a request.
     * @return Result of the GetDeviceInstance operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetDeviceInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetDeviceInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default GetDeviceInstanceResponse getDeviceInstance(Consumer<GetDeviceInstanceRequest.Builder> getDeviceInstanceRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        return getDeviceInstance(GetDeviceInstanceRequest.builder().applyMutation(getDeviceInstanceRequest).build());
    }

    /**
     * <p>
     * Gets information about a device pool.
     * </p>
     *
     * @param getDevicePoolRequest
     *        Represents a request to the get device pool operation.
     * @return Result of the GetDevicePool operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetDevicePool
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetDevicePool" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDevicePoolResponse getDevicePool(GetDevicePoolRequest getDevicePoolRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a device pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDevicePoolRequest.Builder} avoiding the need to
     * create one manually via {@link GetDevicePoolRequest#builder()}
     * </p>
     *
     * @param getDevicePoolRequest
     *        A {@link Consumer} that will call methods on {@link GetDevicePoolRequest.Builder} to create a request.
     *        Represents a request to the get device pool operation.
     * @return Result of the GetDevicePool operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetDevicePool
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetDevicePool" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDevicePoolResponse getDevicePool(Consumer<GetDevicePoolRequest.Builder> getDevicePoolRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        return getDevicePool(GetDevicePoolRequest.builder().applyMutation(getDevicePoolRequest).build());
    }

    /**
     * <p>
     * Gets information about compatibility with a device pool.
     * </p>
     *
     * @param getDevicePoolCompatibilityRequest
     *        Represents a request to the get device pool compatibility operation.
     * @return Result of the GetDevicePoolCompatibility operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetDevicePoolCompatibility
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetDevicePoolCompatibility"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDevicePoolCompatibilityResponse getDevicePoolCompatibility(
            GetDevicePoolCompatibilityRequest getDevicePoolCompatibilityRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about compatibility with a device pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDevicePoolCompatibilityRequest.Builder} avoiding
     * the need to create one manually via {@link GetDevicePoolCompatibilityRequest#builder()}
     * </p>
     *
     * @param getDevicePoolCompatibilityRequest
     *        A {@link Consumer} that will call methods on {@link GetDevicePoolCompatibilityRequest.Builder} to create a
     *        request. Represents a request to the get device pool compatibility operation.
     * @return Result of the GetDevicePoolCompatibility operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetDevicePoolCompatibility
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetDevicePoolCompatibility"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDevicePoolCompatibilityResponse getDevicePoolCompatibility(
            Consumer<GetDevicePoolCompatibilityRequest.Builder> getDevicePoolCompatibilityRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        return getDevicePoolCompatibility(GetDevicePoolCompatibilityRequest.builder()
                .applyMutation(getDevicePoolCompatibilityRequest).build());
    }

    /**
     * <p>
     * Returns information about the specified instance profile.
     * </p>
     *
     * @param getInstanceProfileRequest
     * @return Result of the GetInstanceProfile operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetInstanceProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetInstanceProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default GetInstanceProfileResponse getInstanceProfile(GetInstanceProfileRequest getInstanceProfileRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the specified instance profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInstanceProfileRequest.Builder} avoiding the
     * need to create one manually via {@link GetInstanceProfileRequest#builder()}
     * </p>
     *
     * @param getInstanceProfileRequest
     *        A {@link Consumer} that will call methods on {@link GetInstanceProfileRequest.Builder} to create a
     *        request.
     * @return Result of the GetInstanceProfile operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetInstanceProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetInstanceProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default GetInstanceProfileResponse getInstanceProfile(Consumer<GetInstanceProfileRequest.Builder> getInstanceProfileRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        return getInstanceProfile(GetInstanceProfileRequest.builder().applyMutation(getInstanceProfileRequest).build());
    }

    /**
     * <p>
     * Gets information about a job.
     * </p>
     *
     * @param getJobRequest
     *        Represents a request to the get job operation.
     * @return Result of the GetJob operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetJob" target="_top">AWS API
     *      Documentation</a>
     */
    default GetJobResponse getJob(GetJobRequest getJobRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetJobRequest.Builder} avoiding the need to create
     * one manually via {@link GetJobRequest#builder()}
     * </p>
     *
     * @param getJobRequest
     *        A {@link Consumer} that will call methods on {@link GetJobRequest.Builder} to create a request. Represents
     *        a request to the get job operation.
     * @return Result of the GetJob operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetJob" target="_top">AWS API
     *      Documentation</a>
     */
    default GetJobResponse getJob(Consumer<GetJobRequest.Builder> getJobRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        return getJob(GetJobRequest.builder().applyMutation(getJobRequest).build());
    }

    /**
     * <p>
     * Returns information about a network profile.
     * </p>
     *
     * @param getNetworkProfileRequest
     * @return Result of the GetNetworkProfile operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetNetworkProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetNetworkProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default GetNetworkProfileResponse getNetworkProfile(GetNetworkProfileRequest getNetworkProfileRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a network profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNetworkProfileRequest.Builder} avoiding the need
     * to create one manually via {@link GetNetworkProfileRequest#builder()}
     * </p>
     *
     * @param getNetworkProfileRequest
     *        A {@link Consumer} that will call methods on {@link GetNetworkProfileRequest.Builder} to create a request.
     * @return Result of the GetNetworkProfile operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetNetworkProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetNetworkProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default GetNetworkProfileResponse getNetworkProfile(Consumer<GetNetworkProfileRequest.Builder> getNetworkProfileRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        return getNetworkProfile(GetNetworkProfileRequest.builder().applyMutation(getNetworkProfileRequest).build());
    }

    /**
     * <p>
     * Gets the current status and future status of all offerings purchased by an AWS account. The response indicates
     * how many offerings are currently available and the offerings that will be available in the next period. The API
     * returns a <code>NotEligible</code> error if the user is not permitted to invoke the operation. Please contact <a
     * href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you believe that you
     * should be able to invoke this operation.
     * </p>
     *
     * @return Result of the GetOfferingStatus operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws NotEligibleException
     *         Exception gets thrown when a user is not eligible to perform the specified transaction.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetOfferingStatus
     * @see #getOfferingStatus(GetOfferingStatusRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetOfferingStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default GetOfferingStatusResponse getOfferingStatus() throws ArgumentException, NotFoundException, NotEligibleException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        return getOfferingStatus(GetOfferingStatusRequest.builder().build());
    }

    /**
     * <p>
     * Gets the current status and future status of all offerings purchased by an AWS account. The response indicates
     * how many offerings are currently available and the offerings that will be available in the next period. The API
     * returns a <code>NotEligible</code> error if the user is not permitted to invoke the operation. Please contact <a
     * href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you believe that you
     * should be able to invoke this operation.
     * </p>
     *
     * @param getOfferingStatusRequest
     *        Represents the request to retrieve the offering status for the specified customer or account.
     * @return Result of the GetOfferingStatus operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws NotEligibleException
     *         Exception gets thrown when a user is not eligible to perform the specified transaction.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetOfferingStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetOfferingStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default GetOfferingStatusResponse getOfferingStatus(GetOfferingStatusRequest getOfferingStatusRequest)
            throws ArgumentException, NotFoundException, NotEligibleException, LimitExceededException, ServiceAccountException,
            AwsServiceException, SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the current status and future status of all offerings purchased by an AWS account. The response indicates
     * how many offerings are currently available and the offerings that will be available in the next period. The API
     * returns a <code>NotEligible</code> error if the user is not permitted to invoke the operation. Please contact <a
     * href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you believe that you
     * should be able to invoke this operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOfferingStatusRequest.Builder} avoiding the need
     * to create one manually via {@link GetOfferingStatusRequest#builder()}
     * </p>
     *
     * @param getOfferingStatusRequest
     *        A {@link Consumer} that will call methods on {@link GetOfferingStatusRequest.Builder} to create a request.
     *        Represents the request to retrieve the offering status for the specified customer or account.
     * @return Result of the GetOfferingStatus operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws NotEligibleException
     *         Exception gets thrown when a user is not eligible to perform the specified transaction.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetOfferingStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetOfferingStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default GetOfferingStatusResponse getOfferingStatus(Consumer<GetOfferingStatusRequest.Builder> getOfferingStatusRequest)
            throws ArgumentException, NotFoundException, NotEligibleException, LimitExceededException, ServiceAccountException,
            AwsServiceException, SdkClientException, DeviceFarmException {
        return getOfferingStatus(GetOfferingStatusRequest.builder().applyMutation(getOfferingStatusRequest).build());
    }

    /**
     * <p>
     * Gets the current status and future status of all offerings purchased by an AWS account. The response indicates
     * how many offerings are currently available and the offerings that will be available in the next period. The API
     * returns a <code>NotEligible</code> error if the user is not permitted to invoke the operation. Please contact <a
     * href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you believe that you
     * should be able to invoke this operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getOfferingStatus(software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.GetOfferingStatusIterable responses = client.getOfferingStatusPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.GetOfferingStatusIterable responses = client
     *             .getOfferingStatusPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.GetOfferingStatusIterable responses = client.getOfferingStatusPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getOfferingStatus(software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws NotEligibleException
     *         Exception gets thrown when a user is not eligible to perform the specified transaction.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetOfferingStatus
     * @see #getOfferingStatusPaginator(GetOfferingStatusRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetOfferingStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default GetOfferingStatusIterable getOfferingStatusPaginator() throws ArgumentException, NotFoundException,
            NotEligibleException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        return getOfferingStatusPaginator(GetOfferingStatusRequest.builder().build());
    }

    /**
     * <p>
     * Gets the current status and future status of all offerings purchased by an AWS account. The response indicates
     * how many offerings are currently available and the offerings that will be available in the next period. The API
     * returns a <code>NotEligible</code> error if the user is not permitted to invoke the operation. Please contact <a
     * href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you believe that you
     * should be able to invoke this operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getOfferingStatus(software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.GetOfferingStatusIterable responses = client.getOfferingStatusPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.GetOfferingStatusIterable responses = client
     *             .getOfferingStatusPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.GetOfferingStatusIterable responses = client.getOfferingStatusPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getOfferingStatus(software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param getOfferingStatusRequest
     *        Represents the request to retrieve the offering status for the specified customer or account.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws NotEligibleException
     *         Exception gets thrown when a user is not eligible to perform the specified transaction.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetOfferingStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetOfferingStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default GetOfferingStatusIterable getOfferingStatusPaginator(GetOfferingStatusRequest getOfferingStatusRequest)
            throws ArgumentException, NotFoundException, NotEligibleException, LimitExceededException, ServiceAccountException,
            AwsServiceException, SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the current status and future status of all offerings purchased by an AWS account. The response indicates
     * how many offerings are currently available and the offerings that will be available in the next period. The API
     * returns a <code>NotEligible</code> error if the user is not permitted to invoke the operation. Please contact <a
     * href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you believe that you
     * should be able to invoke this operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getOfferingStatus(software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.GetOfferingStatusIterable responses = client.getOfferingStatusPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.GetOfferingStatusIterable responses = client
     *             .getOfferingStatusPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.GetOfferingStatusIterable responses = client.getOfferingStatusPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getOfferingStatus(software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOfferingStatusRequest.Builder} avoiding the need
     * to create one manually via {@link GetOfferingStatusRequest#builder()}
     * </p>
     *
     * @param getOfferingStatusRequest
     *        A {@link Consumer} that will call methods on {@link GetOfferingStatusRequest.Builder} to create a request.
     *        Represents the request to retrieve the offering status for the specified customer or account.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws NotEligibleException
     *         Exception gets thrown when a user is not eligible to perform the specified transaction.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetOfferingStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetOfferingStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default GetOfferingStatusIterable getOfferingStatusPaginator(
            Consumer<GetOfferingStatusRequest.Builder> getOfferingStatusRequest) throws ArgumentException, NotFoundException,
            NotEligibleException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        return getOfferingStatusPaginator(GetOfferingStatusRequest.builder().applyMutation(getOfferingStatusRequest).build());
    }

    /**
     * <p>
     * Gets information about a project.
     * </p>
     *
     * @param getProjectRequest
     *        Represents a request to the get project operation.
     * @return Result of the GetProject operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetProject
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetProject" target="_top">AWS API
     *      Documentation</a>
     */
    default GetProjectResponse getProject(GetProjectRequest getProjectRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetProjectRequest.Builder} avoiding the need to
     * create one manually via {@link GetProjectRequest#builder()}
     * </p>
     *
     * @param getProjectRequest
     *        A {@link Consumer} that will call methods on {@link GetProjectRequest.Builder} to create a request.
     *        Represents a request to the get project operation.
     * @return Result of the GetProject operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetProject
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetProject" target="_top">AWS API
     *      Documentation</a>
     */
    default GetProjectResponse getProject(Consumer<GetProjectRequest.Builder> getProjectRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        return getProject(GetProjectRequest.builder().applyMutation(getProjectRequest).build());
    }

    /**
     * <p>
     * Returns a link to a currently running remote access session.
     * </p>
     *
     * @param getRemoteAccessSessionRequest
     *        Represents the request to get information about the specified remote access session.
     * @return Result of the GetRemoteAccessSession operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetRemoteAccessSession
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetRemoteAccessSession"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRemoteAccessSessionResponse getRemoteAccessSession(GetRemoteAccessSessionRequest getRemoteAccessSessionRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a link to a currently running remote access session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRemoteAccessSessionRequest.Builder} avoiding the
     * need to create one manually via {@link GetRemoteAccessSessionRequest#builder()}
     * </p>
     *
     * @param getRemoteAccessSessionRequest
     *        A {@link Consumer} that will call methods on {@link GetRemoteAccessSessionRequest.Builder} to create a
     *        request. Represents the request to get information about the specified remote access session.
     * @return Result of the GetRemoteAccessSession operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetRemoteAccessSession
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetRemoteAccessSession"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRemoteAccessSessionResponse getRemoteAccessSession(
            Consumer<GetRemoteAccessSessionRequest.Builder> getRemoteAccessSessionRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        return getRemoteAccessSession(GetRemoteAccessSessionRequest.builder().applyMutation(getRemoteAccessSessionRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about a run.
     * </p>
     *
     * @param getRunRequest
     *        Represents a request to the get run operation.
     * @return Result of the GetRun operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetRun" target="_top">AWS API
     *      Documentation</a>
     */
    default GetRunResponse getRun(GetRunRequest getRunRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRunRequest.Builder} avoiding the need to create
     * one manually via {@link GetRunRequest#builder()}
     * </p>
     *
     * @param getRunRequest
     *        A {@link Consumer} that will call methods on {@link GetRunRequest.Builder} to create a request. Represents
     *        a request to the get run operation.
     * @return Result of the GetRun operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetRun" target="_top">AWS API
     *      Documentation</a>
     */
    default GetRunResponse getRun(Consumer<GetRunRequest.Builder> getRunRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        return getRun(GetRunRequest.builder().applyMutation(getRunRequest).build());
    }

    /**
     * <p>
     * Gets information about a suite.
     * </p>
     *
     * @param getSuiteRequest
     *        Represents a request to the get suite operation.
     * @return Result of the GetSuite operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetSuite
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetSuite" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSuiteResponse getSuite(GetSuiteRequest getSuiteRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a suite.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSuiteRequest.Builder} avoiding the need to
     * create one manually via {@link GetSuiteRequest#builder()}
     * </p>
     *
     * @param getSuiteRequest
     *        A {@link Consumer} that will call methods on {@link GetSuiteRequest.Builder} to create a request.
     *        Represents a request to the get suite operation.
     * @return Result of the GetSuite operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetSuite
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetSuite" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSuiteResponse getSuite(Consumer<GetSuiteRequest.Builder> getSuiteRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        return getSuite(GetSuiteRequest.builder().applyMutation(getSuiteRequest).build());
    }

    /**
     * <p>
     * Gets information about a test.
     * </p>
     *
     * @param getTestRequest
     *        Represents a request to the get test operation.
     * @return Result of the GetTest operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetTest
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetTest" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTestResponse getTest(GetTestRequest getTestRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a test.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTestRequest.Builder} avoiding the need to create
     * one manually via {@link GetTestRequest#builder()}
     * </p>
     *
     * @param getTestRequest
     *        A {@link Consumer} that will call methods on {@link GetTestRequest.Builder} to create a request.
     *        Represents a request to the get test operation.
     * @return Result of the GetTest operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetTest
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetTest" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTestResponse getTest(Consumer<GetTestRequest.Builder> getTestRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        return getTest(GetTestRequest.builder().applyMutation(getTestRequest).build());
    }

    /**
     * <p>
     * Gets information about an upload.
     * </p>
     *
     * @param getUploadRequest
     *        Represents a request to the get upload operation.
     * @return Result of the GetUpload operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetUpload
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetUpload" target="_top">AWS API
     *      Documentation</a>
     */
    default GetUploadResponse getUpload(GetUploadRequest getUploadRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about an upload.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUploadRequest.Builder} avoiding the need to
     * create one manually via {@link GetUploadRequest#builder()}
     * </p>
     *
     * @param getUploadRequest
     *        A {@link Consumer} that will call methods on {@link GetUploadRequest.Builder} to create a request.
     *        Represents a request to the get upload operation.
     * @return Result of the GetUpload operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetUpload
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetUpload" target="_top">AWS API
     *      Documentation</a>
     */
    default GetUploadResponse getUpload(Consumer<GetUploadRequest.Builder> getUploadRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        return getUpload(GetUploadRequest.builder().applyMutation(getUploadRequest).build());
    }

    /**
     * <p>
     * Returns information about the configuration settings for your Amazon Virtual Private Cloud (VPC) endpoint.
     * </p>
     *
     * @param getVpceConfigurationRequest
     * @return Result of the GetVPCEConfiguration operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetVPCEConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetVPCEConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetVpceConfigurationResponse getVPCEConfiguration(GetVpceConfigurationRequest getVpceConfigurationRequest)
            throws ArgumentException, NotFoundException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the configuration settings for your Amazon Virtual Private Cloud (VPC) endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVpceConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link GetVpceConfigurationRequest#builder()}
     * </p>
     *
     * @param getVpceConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetVPCEConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the GetVPCEConfiguration operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetVPCEConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetVPCEConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetVpceConfigurationResponse getVPCEConfiguration(
            Consumer<GetVpceConfigurationRequest.Builder> getVpceConfigurationRequest) throws ArgumentException,
            NotFoundException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        return getVPCEConfiguration(GetVpceConfigurationRequest.builder().applyMutation(getVpceConfigurationRequest).build());
    }

    /**
     * <p>
     * Installs an application to the device in a remote access session. For Android applications, the file must be in
     * .apk format. For iOS applications, the file must be in .ipa format.
     * </p>
     *
     * @param installToRemoteAccessSessionRequest
     *        Represents the request to install an Android application (in .apk format) or an iOS application (in .ipa
     *        format) as part of a remote access session.
     * @return Result of the InstallToRemoteAccessSession operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.InstallToRemoteAccessSession
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/InstallToRemoteAccessSession"
     *      target="_top">AWS API Documentation</a>
     */
    default InstallToRemoteAccessSessionResponse installToRemoteAccessSession(
            InstallToRemoteAccessSessionRequest installToRemoteAccessSessionRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Installs an application to the device in a remote access session. For Android applications, the file must be in
     * .apk format. For iOS applications, the file must be in .ipa format.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InstallToRemoteAccessSessionRequest.Builder}
     * avoiding the need to create one manually via {@link InstallToRemoteAccessSessionRequest#builder()}
     * </p>
     *
     * @param installToRemoteAccessSessionRequest
     *        A {@link Consumer} that will call methods on {@link InstallToRemoteAccessSessionRequest.Builder} to create
     *        a request. Represents the request to install an Android application (in .apk format) or an iOS application
     *        (in .ipa format) as part of a remote access session.
     * @return Result of the InstallToRemoteAccessSession operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.InstallToRemoteAccessSession
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/InstallToRemoteAccessSession"
     *      target="_top">AWS API Documentation</a>
     */
    default InstallToRemoteAccessSessionResponse installToRemoteAccessSession(
            Consumer<InstallToRemoteAccessSessionRequest.Builder> installToRemoteAccessSessionRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        return installToRemoteAccessSession(InstallToRemoteAccessSessionRequest.builder()
                .applyMutation(installToRemoteAccessSessionRequest).build());
    }

    /**
     * <p>
     * Gets information about artifacts.
     * </p>
     *
     * @param listArtifactsRequest
     *        Represents a request to the list artifacts operation.
     * @return Result of the ListArtifacts operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListArtifacts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListArtifacts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListArtifactsResponse listArtifacts(ListArtifactsRequest listArtifactsRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about artifacts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListArtifactsRequest.Builder} avoiding the need to
     * create one manually via {@link ListArtifactsRequest#builder()}
     * </p>
     *
     * @param listArtifactsRequest
     *        A {@link Consumer} that will call methods on {@link ListArtifactsRequest.Builder} to create a request.
     *        Represents a request to the list artifacts operation.
     * @return Result of the ListArtifacts operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListArtifacts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListArtifacts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListArtifactsResponse listArtifacts(Consumer<ListArtifactsRequest.Builder> listArtifactsRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        return listArtifacts(ListArtifactsRequest.builder().applyMutation(listArtifactsRequest).build());
    }

    /**
     * <p>
     * Gets information about artifacts.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listArtifacts(software.amazon.awssdk.services.devicefarm.model.ListArtifactsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListArtifactsIterable responses = client.listArtifactsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.ListArtifactsIterable responses = client
     *             .listArtifactsPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.ListArtifactsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListArtifactsIterable responses = client.listArtifactsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listArtifacts(software.amazon.awssdk.services.devicefarm.model.ListArtifactsRequest)} operation.</b>
     * </p>
     *
     * @param listArtifactsRequest
     *        Represents a request to the list artifacts operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListArtifacts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListArtifacts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListArtifactsIterable listArtifactsPaginator(ListArtifactsRequest listArtifactsRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about artifacts.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listArtifacts(software.amazon.awssdk.services.devicefarm.model.ListArtifactsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListArtifactsIterable responses = client.listArtifactsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.ListArtifactsIterable responses = client
     *             .listArtifactsPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.ListArtifactsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListArtifactsIterable responses = client.listArtifactsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listArtifacts(software.amazon.awssdk.services.devicefarm.model.ListArtifactsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListArtifactsRequest.Builder} avoiding the need to
     * create one manually via {@link ListArtifactsRequest#builder()}
     * </p>
     *
     * @param listArtifactsRequest
     *        A {@link Consumer} that will call methods on {@link ListArtifactsRequest.Builder} to create a request.
     *        Represents a request to the list artifacts operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListArtifacts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListArtifacts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListArtifactsIterable listArtifactsPaginator(Consumer<ListArtifactsRequest.Builder> listArtifactsRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        return listArtifactsPaginator(ListArtifactsRequest.builder().applyMutation(listArtifactsRequest).build());
    }

    /**
     * <p>
     * Returns information about the private device instances associated with one or more AWS accounts.
     * </p>
     *
     * @return Result of the ListDeviceInstances operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListDeviceInstances
     * @see #listDeviceInstances(ListDeviceInstancesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDeviceInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDeviceInstancesResponse listDeviceInstances() throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        return listDeviceInstances(ListDeviceInstancesRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about the private device instances associated with one or more AWS accounts.
     * </p>
     *
     * @param listDeviceInstancesRequest
     * @return Result of the ListDeviceInstances operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListDeviceInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDeviceInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDeviceInstancesResponse listDeviceInstances(ListDeviceInstancesRequest listDeviceInstancesRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the private device instances associated with one or more AWS accounts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeviceInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link ListDeviceInstancesRequest#builder()}
     * </p>
     *
     * @param listDeviceInstancesRequest
     *        A {@link Consumer} that will call methods on {@link ListDeviceInstancesRequest.Builder} to create a
     *        request.
     * @return Result of the ListDeviceInstances operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListDeviceInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDeviceInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDeviceInstancesResponse listDeviceInstances(
            Consumer<ListDeviceInstancesRequest.Builder> listDeviceInstancesRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        return listDeviceInstances(ListDeviceInstancesRequest.builder().applyMutation(listDeviceInstancesRequest).build());
    }

    /**
     * <p>
     * Gets information about device pools.
     * </p>
     *
     * @param listDevicePoolsRequest
     *        Represents the result of a list device pools request.
     * @return Result of the ListDevicePools operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListDevicePools
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDevicePools" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDevicePoolsResponse listDevicePools(ListDevicePoolsRequest listDevicePoolsRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about device pools.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDevicePoolsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDevicePoolsRequest#builder()}
     * </p>
     *
     * @param listDevicePoolsRequest
     *        A {@link Consumer} that will call methods on {@link ListDevicePoolsRequest.Builder} to create a request.
     *        Represents the result of a list device pools request.
     * @return Result of the ListDevicePools operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListDevicePools
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDevicePools" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDevicePoolsResponse listDevicePools(Consumer<ListDevicePoolsRequest.Builder> listDevicePoolsRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        return listDevicePools(ListDevicePoolsRequest.builder().applyMutation(listDevicePoolsRequest).build());
    }

    /**
     * <p>
     * Gets information about device pools.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDevicePools(software.amazon.awssdk.services.devicefarm.model.ListDevicePoolsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListDevicePoolsIterable responses = client.listDevicePoolsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.ListDevicePoolsIterable responses = client
     *             .listDevicePoolsPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.ListDevicePoolsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListDevicePoolsIterable responses = client.listDevicePoolsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDevicePools(software.amazon.awssdk.services.devicefarm.model.ListDevicePoolsRequest)} operation.</b>
     * </p>
     *
     * @param listDevicePoolsRequest
     *        Represents the result of a list device pools request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListDevicePools
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDevicePools" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDevicePoolsIterable listDevicePoolsPaginator(ListDevicePoolsRequest listDevicePoolsRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about device pools.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDevicePools(software.amazon.awssdk.services.devicefarm.model.ListDevicePoolsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListDevicePoolsIterable responses = client.listDevicePoolsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.ListDevicePoolsIterable responses = client
     *             .listDevicePoolsPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.ListDevicePoolsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListDevicePoolsIterable responses = client.listDevicePoolsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDevicePools(software.amazon.awssdk.services.devicefarm.model.ListDevicePoolsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDevicePoolsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDevicePoolsRequest#builder()}
     * </p>
     *
     * @param listDevicePoolsRequest
     *        A {@link Consumer} that will call methods on {@link ListDevicePoolsRequest.Builder} to create a request.
     *        Represents the result of a list device pools request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListDevicePools
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDevicePools" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDevicePoolsIterable listDevicePoolsPaginator(Consumer<ListDevicePoolsRequest.Builder> listDevicePoolsRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        return listDevicePoolsPaginator(ListDevicePoolsRequest.builder().applyMutation(listDevicePoolsRequest).build());
    }

    /**
     * <p>
     * Gets information about unique device types.
     * </p>
     *
     * @return Result of the ListDevices operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListDevices
     * @see #listDevices(ListDevicesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDevicesResponse listDevices() throws ArgumentException, NotFoundException, LimitExceededException,
            ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        return listDevices(ListDevicesRequest.builder().build());
    }

    /**
     * <p>
     * Gets information about unique device types.
     * </p>
     *
     * @param listDevicesRequest
     *        Represents the result of a list devices request.
     * @return Result of the ListDevices operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListDevices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDevicesResponse listDevices(ListDevicesRequest listDevicesRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about unique device types.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDevicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListDevicesRequest#builder()}
     * </p>
     *
     * @param listDevicesRequest
     *        A {@link Consumer} that will call methods on {@link ListDevicesRequest.Builder} to create a request.
     *        Represents the result of a list devices request.
     * @return Result of the ListDevices operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListDevices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDevicesResponse listDevices(Consumer<ListDevicesRequest.Builder> listDevicesRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        return listDevices(ListDevicesRequest.builder().applyMutation(listDevicesRequest).build());
    }

    /**
     * <p>
     * Gets information about unique device types.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDevices(software.amazon.awssdk.services.devicefarm.model.ListDevicesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListDevicesIterable responses = client.listDevicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.ListDevicesIterable responses = client.listDevicesPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.ListDevicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListDevicesIterable responses = client.listDevicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDevices(software.amazon.awssdk.services.devicefarm.model.ListDevicesRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListDevices
     * @see #listDevicesPaginator(ListDevicesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDevicesIterable listDevicesPaginator() throws ArgumentException, NotFoundException, LimitExceededException,
            ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        return listDevicesPaginator(ListDevicesRequest.builder().build());
    }

    /**
     * <p>
     * Gets information about unique device types.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDevices(software.amazon.awssdk.services.devicefarm.model.ListDevicesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListDevicesIterable responses = client.listDevicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.ListDevicesIterable responses = client.listDevicesPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.ListDevicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListDevicesIterable responses = client.listDevicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDevices(software.amazon.awssdk.services.devicefarm.model.ListDevicesRequest)} operation.</b>
     * </p>
     *
     * @param listDevicesRequest
     *        Represents the result of a list devices request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListDevices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDevicesIterable listDevicesPaginator(ListDevicesRequest listDevicesRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about unique device types.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDevices(software.amazon.awssdk.services.devicefarm.model.ListDevicesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListDevicesIterable responses = client.listDevicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.ListDevicesIterable responses = client.listDevicesPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.ListDevicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListDevicesIterable responses = client.listDevicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDevices(software.amazon.awssdk.services.devicefarm.model.ListDevicesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDevicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListDevicesRequest#builder()}
     * </p>
     *
     * @param listDevicesRequest
     *        A {@link Consumer} that will call methods on {@link ListDevicesRequest.Builder} to create a request.
     *        Represents the result of a list devices request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListDevices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDevicesIterable listDevicesPaginator(Consumer<ListDevicesRequest.Builder> listDevicesRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        return listDevicesPaginator(ListDevicesRequest.builder().applyMutation(listDevicesRequest).build());
    }

    /**
     * <p>
     * Returns information about all the instance profiles in an AWS account.
     * </p>
     *
     * @return Result of the ListInstanceProfiles operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListInstanceProfiles
     * @see #listInstanceProfiles(ListInstanceProfilesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListInstanceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstanceProfilesResponse listInstanceProfiles() throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        return listInstanceProfiles(ListInstanceProfilesRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about all the instance profiles in an AWS account.
     * </p>
     *
     * @param listInstanceProfilesRequest
     * @return Result of the ListInstanceProfiles operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListInstanceProfiles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListInstanceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstanceProfilesResponse listInstanceProfiles(ListInstanceProfilesRequest listInstanceProfilesRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about all the instance profiles in an AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstanceProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link ListInstanceProfilesRequest#builder()}
     * </p>
     *
     * @param listInstanceProfilesRequest
     *        A {@link Consumer} that will call methods on {@link ListInstanceProfilesRequest.Builder} to create a
     *        request.
     * @return Result of the ListInstanceProfiles operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListInstanceProfiles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListInstanceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstanceProfilesResponse listInstanceProfiles(
            Consumer<ListInstanceProfilesRequest.Builder> listInstanceProfilesRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        return listInstanceProfiles(ListInstanceProfilesRequest.builder().applyMutation(listInstanceProfilesRequest).build());
    }

    /**
     * <p>
     * Gets information about jobs for a given test run.
     * </p>
     *
     * @param listJobsRequest
     *        Represents a request to the list jobs operation.
     * @return Result of the ListJobs operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobsResponse listJobs(ListJobsRequest listJobsRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about jobs for a given test run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListJobsRequest#builder()}
     * </p>
     *
     * @param listJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListJobsRequest.Builder} to create a request.
     *        Represents a request to the list jobs operation.
     * @return Result of the ListJobs operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobsResponse listJobs(Consumer<ListJobsRequest.Builder> listJobsRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        return listJobs(ListJobsRequest.builder().applyMutation(listJobsRequest).build());
    }

    /**
     * <p>
     * Gets information about jobs for a given test run.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listJobs(software.amazon.awssdk.services.devicefarm.model.ListJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.ListJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJobs(software.amazon.awssdk.services.devicefarm.model.ListJobsRequest)} operation.</b>
     * </p>
     *
     * @param listJobsRequest
     *        Represents a request to the list jobs operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobsIterable listJobsPaginator(ListJobsRequest listJobsRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about jobs for a given test run.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listJobs(software.amazon.awssdk.services.devicefarm.model.ListJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.ListJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJobs(software.amazon.awssdk.services.devicefarm.model.ListJobsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListJobsRequest#builder()}
     * </p>
     *
     * @param listJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListJobsRequest.Builder} to create a request.
     *        Represents a request to the list jobs operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobsIterable listJobsPaginator(Consumer<ListJobsRequest.Builder> listJobsRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        return listJobsPaginator(ListJobsRequest.builder().applyMutation(listJobsRequest).build());
    }

    /**
     * <p>
     * Returns the list of available network profiles.
     * </p>
     *
     * @param listNetworkProfilesRequest
     * @return Result of the ListNetworkProfiles operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListNetworkProfiles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListNetworkProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default ListNetworkProfilesResponse listNetworkProfiles(ListNetworkProfilesRequest listNetworkProfilesRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of available network profiles.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNetworkProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link ListNetworkProfilesRequest#builder()}
     * </p>
     *
     * @param listNetworkProfilesRequest
     *        A {@link Consumer} that will call methods on {@link ListNetworkProfilesRequest.Builder} to create a
     *        request.
     * @return Result of the ListNetworkProfiles operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListNetworkProfiles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListNetworkProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default ListNetworkProfilesResponse listNetworkProfiles(
            Consumer<ListNetworkProfilesRequest.Builder> listNetworkProfilesRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        return listNetworkProfiles(ListNetworkProfilesRequest.builder().applyMutation(listNetworkProfilesRequest).build());
    }

    /**
     * <p>
     * Returns a list of offering promotions. Each offering promotion record contains the ID and description of the
     * promotion. The API returns a <code>NotEligible</code> error if the caller is not permitted to invoke the
     * operation. Contact <a href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if
     * you believe that you should be able to invoke this operation.
     * </p>
     *
     * @return Result of the ListOfferingPromotions operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws NotEligibleException
     *         Exception gets thrown when a user is not eligible to perform the specified transaction.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListOfferingPromotions
     * @see #listOfferingPromotions(ListOfferingPromotionsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferingPromotions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOfferingPromotionsResponse listOfferingPromotions() throws ArgumentException, NotFoundException,
            NotEligibleException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        return listOfferingPromotions(ListOfferingPromotionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of offering promotions. Each offering promotion record contains the ID and description of the
     * promotion. The API returns a <code>NotEligible</code> error if the caller is not permitted to invoke the
     * operation. Contact <a href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if
     * you believe that you should be able to invoke this operation.
     * </p>
     *
     * @param listOfferingPromotionsRequest
     * @return Result of the ListOfferingPromotions operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws NotEligibleException
     *         Exception gets thrown when a user is not eligible to perform the specified transaction.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListOfferingPromotions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferingPromotions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOfferingPromotionsResponse listOfferingPromotions(ListOfferingPromotionsRequest listOfferingPromotionsRequest)
            throws ArgumentException, NotFoundException, NotEligibleException, LimitExceededException, ServiceAccountException,
            AwsServiceException, SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of offering promotions. Each offering promotion record contains the ID and description of the
     * promotion. The API returns a <code>NotEligible</code> error if the caller is not permitted to invoke the
     * operation. Contact <a href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if
     * you believe that you should be able to invoke this operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOfferingPromotionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListOfferingPromotionsRequest#builder()}
     * </p>
     *
     * @param listOfferingPromotionsRequest
     *        A {@link Consumer} that will call methods on {@link ListOfferingPromotionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListOfferingPromotions operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws NotEligibleException
     *         Exception gets thrown when a user is not eligible to perform the specified transaction.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListOfferingPromotions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferingPromotions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOfferingPromotionsResponse listOfferingPromotions(
            Consumer<ListOfferingPromotionsRequest.Builder> listOfferingPromotionsRequest) throws ArgumentException,
            NotFoundException, NotEligibleException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        return listOfferingPromotions(ListOfferingPromotionsRequest.builder().applyMutation(listOfferingPromotionsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of all historical purchases, renewals, and system renewal transactions for an AWS account. The
     * list is paginated and ordered by a descending timestamp (most recent transactions are first). The API returns a
     * <code>NotEligible</code> error if the user is not permitted to invoke the operation. Please contact <a
     * href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you believe that you
     * should be able to invoke this operation.
     * </p>
     *
     * @return Result of the ListOfferingTransactions operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws NotEligibleException
     *         Exception gets thrown when a user is not eligible to perform the specified transaction.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListOfferingTransactions
     * @see #listOfferingTransactions(ListOfferingTransactionsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferingTransactions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOfferingTransactionsResponse listOfferingTransactions() throws ArgumentException, NotFoundException,
            NotEligibleException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        return listOfferingTransactions(ListOfferingTransactionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of all historical purchases, renewals, and system renewal transactions for an AWS account. The
     * list is paginated and ordered by a descending timestamp (most recent transactions are first). The API returns a
     * <code>NotEligible</code> error if the user is not permitted to invoke the operation. Please contact <a
     * href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you believe that you
     * should be able to invoke this operation.
     * </p>
     *
     * @param listOfferingTransactionsRequest
     *        Represents the request to list the offering transaction history.
     * @return Result of the ListOfferingTransactions operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws NotEligibleException
     *         Exception gets thrown when a user is not eligible to perform the specified transaction.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListOfferingTransactions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferingTransactions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOfferingTransactionsResponse listOfferingTransactions(
            ListOfferingTransactionsRequest listOfferingTransactionsRequest) throws ArgumentException, NotFoundException,
            NotEligibleException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all historical purchases, renewals, and system renewal transactions for an AWS account. The
     * list is paginated and ordered by a descending timestamp (most recent transactions are first). The API returns a
     * <code>NotEligible</code> error if the user is not permitted to invoke the operation. Please contact <a
     * href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you believe that you
     * should be able to invoke this operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOfferingTransactionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListOfferingTransactionsRequest#builder()}
     * </p>
     *
     * @param listOfferingTransactionsRequest
     *        A {@link Consumer} that will call methods on {@link ListOfferingTransactionsRequest.Builder} to create a
     *        request. Represents the request to list the offering transaction history.
     * @return Result of the ListOfferingTransactions operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws NotEligibleException
     *         Exception gets thrown when a user is not eligible to perform the specified transaction.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListOfferingTransactions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferingTransactions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOfferingTransactionsResponse listOfferingTransactions(
            Consumer<ListOfferingTransactionsRequest.Builder> listOfferingTransactionsRequest) throws ArgumentException,
            NotFoundException, NotEligibleException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        return listOfferingTransactions(ListOfferingTransactionsRequest.builder().applyMutation(listOfferingTransactionsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of all historical purchases, renewals, and system renewal transactions for an AWS account. The
     * list is paginated and ordered by a descending timestamp (most recent transactions are first). The API returns a
     * <code>NotEligible</code> error if the user is not permitted to invoke the operation. Please contact <a
     * href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you believe that you
     * should be able to invoke this operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listOfferingTransactions(software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListOfferingTransactionsIterable responses = client.listOfferingTransactionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.ListOfferingTransactionsIterable responses = client
     *             .listOfferingTransactionsPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListOfferingTransactionsIterable responses = client.listOfferingTransactionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOfferingTransactions(software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws NotEligibleException
     *         Exception gets thrown when a user is not eligible to perform the specified transaction.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListOfferingTransactions
     * @see #listOfferingTransactionsPaginator(ListOfferingTransactionsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferingTransactions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOfferingTransactionsIterable listOfferingTransactionsPaginator() throws ArgumentException, NotFoundException,
            NotEligibleException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        return listOfferingTransactionsPaginator(ListOfferingTransactionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of all historical purchases, renewals, and system renewal transactions for an AWS account. The
     * list is paginated and ordered by a descending timestamp (most recent transactions are first). The API returns a
     * <code>NotEligible</code> error if the user is not permitted to invoke the operation. Please contact <a
     * href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you believe that you
     * should be able to invoke this operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listOfferingTransactions(software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListOfferingTransactionsIterable responses = client.listOfferingTransactionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.ListOfferingTransactionsIterable responses = client
     *             .listOfferingTransactionsPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListOfferingTransactionsIterable responses = client.listOfferingTransactionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOfferingTransactions(software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOfferingTransactionsRequest
     *        Represents the request to list the offering transaction history.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws NotEligibleException
     *         Exception gets thrown when a user is not eligible to perform the specified transaction.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListOfferingTransactions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferingTransactions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOfferingTransactionsIterable listOfferingTransactionsPaginator(
            ListOfferingTransactionsRequest listOfferingTransactionsRequest) throws ArgumentException, NotFoundException,
            NotEligibleException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all historical purchases, renewals, and system renewal transactions for an AWS account. The
     * list is paginated and ordered by a descending timestamp (most recent transactions are first). The API returns a
     * <code>NotEligible</code> error if the user is not permitted to invoke the operation. Please contact <a
     * href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you believe that you
     * should be able to invoke this operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listOfferingTransactions(software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListOfferingTransactionsIterable responses = client.listOfferingTransactionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.ListOfferingTransactionsIterable responses = client
     *             .listOfferingTransactionsPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListOfferingTransactionsIterable responses = client.listOfferingTransactionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOfferingTransactions(software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOfferingTransactionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListOfferingTransactionsRequest#builder()}
     * </p>
     *
     * @param listOfferingTransactionsRequest
     *        A {@link Consumer} that will call methods on {@link ListOfferingTransactionsRequest.Builder} to create a
     *        request. Represents the request to list the offering transaction history.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws NotEligibleException
     *         Exception gets thrown when a user is not eligible to perform the specified transaction.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListOfferingTransactions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferingTransactions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOfferingTransactionsIterable listOfferingTransactionsPaginator(
            Consumer<ListOfferingTransactionsRequest.Builder> listOfferingTransactionsRequest) throws ArgumentException,
            NotFoundException, NotEligibleException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        return listOfferingTransactionsPaginator(ListOfferingTransactionsRequest.builder()
                .applyMutation(listOfferingTransactionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of products or offerings that the user can manage through the API. Each offering record indicates
     * the recurring price per unit and the frequency for that offering. The API returns a <code>NotEligible</code>
     * error if the user is not permitted to invoke the operation. Please contact <a
     * href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you believe that you
     * should be able to invoke this operation.
     * </p>
     *
     * @return Result of the ListOfferings operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws NotEligibleException
     *         Exception gets thrown when a user is not eligible to perform the specified transaction.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListOfferings
     * @see #listOfferings(ListOfferingsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOfferingsResponse listOfferings() throws ArgumentException, NotFoundException, NotEligibleException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        return listOfferings(ListOfferingsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of products or offerings that the user can manage through the API. Each offering record indicates
     * the recurring price per unit and the frequency for that offering. The API returns a <code>NotEligible</code>
     * error if the user is not permitted to invoke the operation. Please contact <a
     * href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you believe that you
     * should be able to invoke this operation.
     * </p>
     *
     * @param listOfferingsRequest
     *        Represents the request to list all offerings.
     * @return Result of the ListOfferings operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws NotEligibleException
     *         Exception gets thrown when a user is not eligible to perform the specified transaction.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListOfferings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOfferingsResponse listOfferings(ListOfferingsRequest listOfferingsRequest) throws ArgumentException,
            NotFoundException, NotEligibleException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of products or offerings that the user can manage through the API. Each offering record indicates
     * the recurring price per unit and the frequency for that offering. The API returns a <code>NotEligible</code>
     * error if the user is not permitted to invoke the operation. Please contact <a
     * href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you believe that you
     * should be able to invoke this operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOfferingsRequest.Builder} avoiding the need to
     * create one manually via {@link ListOfferingsRequest#builder()}
     * </p>
     *
     * @param listOfferingsRequest
     *        A {@link Consumer} that will call methods on {@link ListOfferingsRequest.Builder} to create a request.
     *        Represents the request to list all offerings.
     * @return Result of the ListOfferings operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws NotEligibleException
     *         Exception gets thrown when a user is not eligible to perform the specified transaction.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListOfferings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOfferingsResponse listOfferings(Consumer<ListOfferingsRequest.Builder> listOfferingsRequest)
            throws ArgumentException, NotFoundException, NotEligibleException, LimitExceededException, ServiceAccountException,
            AwsServiceException, SdkClientException, DeviceFarmException {
        return listOfferings(ListOfferingsRequest.builder().applyMutation(listOfferingsRequest).build());
    }

    /**
     * <p>
     * Returns a list of products or offerings that the user can manage through the API. Each offering record indicates
     * the recurring price per unit and the frequency for that offering. The API returns a <code>NotEligible</code>
     * error if the user is not permitted to invoke the operation. Please contact <a
     * href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you believe that you
     * should be able to invoke this operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listOfferings(software.amazon.awssdk.services.devicefarm.model.ListOfferingsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListOfferingsIterable responses = client.listOfferingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.ListOfferingsIterable responses = client
     *             .listOfferingsPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.ListOfferingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListOfferingsIterable responses = client.listOfferingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOfferings(software.amazon.awssdk.services.devicefarm.model.ListOfferingsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws NotEligibleException
     *         Exception gets thrown when a user is not eligible to perform the specified transaction.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListOfferings
     * @see #listOfferingsPaginator(ListOfferingsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOfferingsIterable listOfferingsPaginator() throws ArgumentException, NotFoundException, NotEligibleException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        return listOfferingsPaginator(ListOfferingsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of products or offerings that the user can manage through the API. Each offering record indicates
     * the recurring price per unit and the frequency for that offering. The API returns a <code>NotEligible</code>
     * error if the user is not permitted to invoke the operation. Please contact <a
     * href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you believe that you
     * should be able to invoke this operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listOfferings(software.amazon.awssdk.services.devicefarm.model.ListOfferingsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListOfferingsIterable responses = client.listOfferingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.ListOfferingsIterable responses = client
     *             .listOfferingsPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.ListOfferingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListOfferingsIterable responses = client.listOfferingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOfferings(software.amazon.awssdk.services.devicefarm.model.ListOfferingsRequest)} operation.</b>
     * </p>
     *
     * @param listOfferingsRequest
     *        Represents the request to list all offerings.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws NotEligibleException
     *         Exception gets thrown when a user is not eligible to perform the specified transaction.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListOfferings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOfferingsIterable listOfferingsPaginator(ListOfferingsRequest listOfferingsRequest) throws ArgumentException,
            NotFoundException, NotEligibleException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of products or offerings that the user can manage through the API. Each offering record indicates
     * the recurring price per unit and the frequency for that offering. The API returns a <code>NotEligible</code>
     * error if the user is not permitted to invoke the operation. Please contact <a
     * href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you believe that you
     * should be able to invoke this operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listOfferings(software.amazon.awssdk.services.devicefarm.model.ListOfferingsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListOfferingsIterable responses = client.listOfferingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.ListOfferingsIterable responses = client
     *             .listOfferingsPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.ListOfferingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListOfferingsIterable responses = client.listOfferingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOfferings(software.amazon.awssdk.services.devicefarm.model.ListOfferingsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOfferingsRequest.Builder} avoiding the need to
     * create one manually via {@link ListOfferingsRequest#builder()}
     * </p>
     *
     * @param listOfferingsRequest
     *        A {@link Consumer} that will call methods on {@link ListOfferingsRequest.Builder} to create a request.
     *        Represents the request to list all offerings.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws NotEligibleException
     *         Exception gets thrown when a user is not eligible to perform the specified transaction.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListOfferings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOfferingsIterable listOfferingsPaginator(Consumer<ListOfferingsRequest.Builder> listOfferingsRequest)
            throws ArgumentException, NotFoundException, NotEligibleException, LimitExceededException, ServiceAccountException,
            AwsServiceException, SdkClientException, DeviceFarmException {
        return listOfferingsPaginator(ListOfferingsRequest.builder().applyMutation(listOfferingsRequest).build());
    }

    /**
     * <p>
     * Gets information about projects.
     * </p>
     *
     * @return Result of the ListProjects operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListProjects
     * @see #listProjects(ListProjectsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProjectsResponse listProjects() throws ArgumentException, NotFoundException, LimitExceededException,
            ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        return listProjects(ListProjectsRequest.builder().build());
    }

    /**
     * <p>
     * Gets information about projects.
     * </p>
     *
     * @param listProjectsRequest
     *        Represents a request to the list projects operation.
     * @return Result of the ListProjects operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListProjects
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProjectsResponse listProjects(ListProjectsRequest listProjectsRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about projects.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProjectsRequest.Builder} avoiding the need to
     * create one manually via {@link ListProjectsRequest#builder()}
     * </p>
     *
     * @param listProjectsRequest
     *        A {@link Consumer} that will call methods on {@link ListProjectsRequest.Builder} to create a request.
     *        Represents a request to the list projects operation.
     * @return Result of the ListProjects operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListProjects
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProjectsResponse listProjects(Consumer<ListProjectsRequest.Builder> listProjectsRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        return listProjects(ListProjectsRequest.builder().applyMutation(listProjectsRequest).build());
    }

    /**
     * <p>
     * Gets information about projects.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listProjects(software.amazon.awssdk.services.devicefarm.model.ListProjectsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.ListProjectsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjects(software.amazon.awssdk.services.devicefarm.model.ListProjectsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListProjects
     * @see #listProjectsPaginator(ListProjectsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProjectsIterable listProjectsPaginator() throws ArgumentException, NotFoundException, LimitExceededException,
            ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        return listProjectsPaginator(ListProjectsRequest.builder().build());
    }

    /**
     * <p>
     * Gets information about projects.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listProjects(software.amazon.awssdk.services.devicefarm.model.ListProjectsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.ListProjectsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjects(software.amazon.awssdk.services.devicefarm.model.ListProjectsRequest)} operation.</b>
     * </p>
     *
     * @param listProjectsRequest
     *        Represents a request to the list projects operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListProjects
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProjectsIterable listProjectsPaginator(ListProjectsRequest listProjectsRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about projects.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listProjects(software.amazon.awssdk.services.devicefarm.model.ListProjectsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.ListProjectsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjects(software.amazon.awssdk.services.devicefarm.model.ListProjectsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProjectsRequest.Builder} avoiding the need to
     * create one manually via {@link ListProjectsRequest#builder()}
     * </p>
     *
     * @param listProjectsRequest
     *        A {@link Consumer} that will call methods on {@link ListProjectsRequest.Builder} to create a request.
     *        Represents a request to the list projects operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListProjects
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProjectsIterable listProjectsPaginator(Consumer<ListProjectsRequest.Builder> listProjectsRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        return listProjectsPaginator(ListProjectsRequest.builder().applyMutation(listProjectsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all currently running remote access sessions.
     * </p>
     *
     * @param listRemoteAccessSessionsRequest
     *        Represents the request to return information about the remote access session.
     * @return Result of the ListRemoteAccessSessions operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListRemoteAccessSessions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListRemoteAccessSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRemoteAccessSessionsResponse listRemoteAccessSessions(
            ListRemoteAccessSessionsRequest listRemoteAccessSessionsRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all currently running remote access sessions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRemoteAccessSessionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListRemoteAccessSessionsRequest#builder()}
     * </p>
     *
     * @param listRemoteAccessSessionsRequest
     *        A {@link Consumer} that will call methods on {@link ListRemoteAccessSessionsRequest.Builder} to create a
     *        request. Represents the request to return information about the remote access session.
     * @return Result of the ListRemoteAccessSessions operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListRemoteAccessSessions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListRemoteAccessSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRemoteAccessSessionsResponse listRemoteAccessSessions(
            Consumer<ListRemoteAccessSessionsRequest.Builder> listRemoteAccessSessionsRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        return listRemoteAccessSessions(ListRemoteAccessSessionsRequest.builder().applyMutation(listRemoteAccessSessionsRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about runs, given an AWS Device Farm project ARN.
     * </p>
     *
     * @param listRunsRequest
     *        Represents a request to the list runs operation.
     * @return Result of the ListRuns operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListRuns
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRunsResponse listRuns(ListRunsRequest listRunsRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about runs, given an AWS Device Farm project ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRunsRequest.Builder} avoiding the need to
     * create one manually via {@link ListRunsRequest#builder()}
     * </p>
     *
     * @param listRunsRequest
     *        A {@link Consumer} that will call methods on {@link ListRunsRequest.Builder} to create a request.
     *        Represents a request to the list runs operation.
     * @return Result of the ListRuns operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListRuns
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRunsResponse listRuns(Consumer<ListRunsRequest.Builder> listRunsRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        return listRuns(ListRunsRequest.builder().applyMutation(listRunsRequest).build());
    }

    /**
     * <p>
     * Gets information about runs, given an AWS Device Farm project ARN.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listRuns(software.amazon.awssdk.services.devicefarm.model.ListRunsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListRunsIterable responses = client.listRunsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.ListRunsIterable responses = client.listRunsPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.ListRunsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListRunsIterable responses = client.listRunsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRuns(software.amazon.awssdk.services.devicefarm.model.ListRunsRequest)} operation.</b>
     * </p>
     *
     * @param listRunsRequest
     *        Represents a request to the list runs operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListRuns
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRunsIterable listRunsPaginator(ListRunsRequest listRunsRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about runs, given an AWS Device Farm project ARN.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listRuns(software.amazon.awssdk.services.devicefarm.model.ListRunsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListRunsIterable responses = client.listRunsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.ListRunsIterable responses = client.listRunsPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.ListRunsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListRunsIterable responses = client.listRunsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRuns(software.amazon.awssdk.services.devicefarm.model.ListRunsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRunsRequest.Builder} avoiding the need to
     * create one manually via {@link ListRunsRequest#builder()}
     * </p>
     *
     * @param listRunsRequest
     *        A {@link Consumer} that will call methods on {@link ListRunsRequest.Builder} to create a request.
     *        Represents a request to the list runs operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListRuns
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRunsIterable listRunsPaginator(Consumer<ListRunsRequest.Builder> listRunsRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        return listRunsPaginator(ListRunsRequest.builder().applyMutation(listRunsRequest).build());
    }

    /**
     * <p>
     * Gets information about samples, given an AWS Device Farm project ARN
     * </p>
     *
     * @param listSamplesRequest
     *        Represents a request to the list samples operation.
     * @return Result of the ListSamples operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListSamples
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListSamples" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSamplesResponse listSamples(ListSamplesRequest listSamplesRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about samples, given an AWS Device Farm project ARN
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSamplesRequest.Builder} avoiding the need to
     * create one manually via {@link ListSamplesRequest#builder()}
     * </p>
     *
     * @param listSamplesRequest
     *        A {@link Consumer} that will call methods on {@link ListSamplesRequest.Builder} to create a request.
     *        Represents a request to the list samples operation.
     * @return Result of the ListSamples operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListSamples
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListSamples" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSamplesResponse listSamples(Consumer<ListSamplesRequest.Builder> listSamplesRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        return listSamples(ListSamplesRequest.builder().applyMutation(listSamplesRequest).build());
    }

    /**
     * <p>
     * Gets information about samples, given an AWS Device Farm project ARN
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listSamples(software.amazon.awssdk.services.devicefarm.model.ListSamplesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListSamplesIterable responses = client.listSamplesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.ListSamplesIterable responses = client.listSamplesPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.ListSamplesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListSamplesIterable responses = client.listSamplesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSamples(software.amazon.awssdk.services.devicefarm.model.ListSamplesRequest)} operation.</b>
     * </p>
     *
     * @param listSamplesRequest
     *        Represents a request to the list samples operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListSamples
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListSamples" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSamplesIterable listSamplesPaginator(ListSamplesRequest listSamplesRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about samples, given an AWS Device Farm project ARN
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listSamples(software.amazon.awssdk.services.devicefarm.model.ListSamplesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListSamplesIterable responses = client.listSamplesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.ListSamplesIterable responses = client.listSamplesPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.ListSamplesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListSamplesIterable responses = client.listSamplesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSamples(software.amazon.awssdk.services.devicefarm.model.ListSamplesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSamplesRequest.Builder} avoiding the need to
     * create one manually via {@link ListSamplesRequest#builder()}
     * </p>
     *
     * @param listSamplesRequest
     *        A {@link Consumer} that will call methods on {@link ListSamplesRequest.Builder} to create a request.
     *        Represents a request to the list samples operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListSamples
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListSamples" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSamplesIterable listSamplesPaginator(Consumer<ListSamplesRequest.Builder> listSamplesRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        return listSamplesPaginator(ListSamplesRequest.builder().applyMutation(listSamplesRequest).build());
    }

    /**
     * <p>
     * Gets information about test suites for a given job.
     * </p>
     *
     * @param listSuitesRequest
     *        Represents a request to the list suites operation.
     * @return Result of the ListSuites operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListSuites
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListSuites" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSuitesResponse listSuites(ListSuitesRequest listSuitesRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about test suites for a given job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSuitesRequest.Builder} avoiding the need to
     * create one manually via {@link ListSuitesRequest#builder()}
     * </p>
     *
     * @param listSuitesRequest
     *        A {@link Consumer} that will call methods on {@link ListSuitesRequest.Builder} to create a request.
     *        Represents a request to the list suites operation.
     * @return Result of the ListSuites operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListSuites
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListSuites" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSuitesResponse listSuites(Consumer<ListSuitesRequest.Builder> listSuitesRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        return listSuites(ListSuitesRequest.builder().applyMutation(listSuitesRequest).build());
    }

    /**
     * <p>
     * Gets information about test suites for a given job.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listSuites(software.amazon.awssdk.services.devicefarm.model.ListSuitesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListSuitesIterable responses = client.listSuitesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.ListSuitesIterable responses = client.listSuitesPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.ListSuitesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListSuitesIterable responses = client.listSuitesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSuites(software.amazon.awssdk.services.devicefarm.model.ListSuitesRequest)} operation.</b>
     * </p>
     *
     * @param listSuitesRequest
     *        Represents a request to the list suites operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListSuites
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListSuites" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSuitesIterable listSuitesPaginator(ListSuitesRequest listSuitesRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about test suites for a given job.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listSuites(software.amazon.awssdk.services.devicefarm.model.ListSuitesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListSuitesIterable responses = client.listSuitesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.ListSuitesIterable responses = client.listSuitesPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.ListSuitesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListSuitesIterable responses = client.listSuitesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSuites(software.amazon.awssdk.services.devicefarm.model.ListSuitesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSuitesRequest.Builder} avoiding the need to
     * create one manually via {@link ListSuitesRequest#builder()}
     * </p>
     *
     * @param listSuitesRequest
     *        A {@link Consumer} that will call methods on {@link ListSuitesRequest.Builder} to create a request.
     *        Represents a request to the list suites operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListSuites
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListSuites" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSuitesIterable listSuitesPaginator(Consumer<ListSuitesRequest.Builder> listSuitesRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        return listSuitesPaginator(ListSuitesRequest.builder().applyMutation(listSuitesRequest).build());
    }

    /**
     * <p>
     * Gets information about tests in a given test suite.
     * </p>
     *
     * @param listTestsRequest
     *        Represents a request to the list tests operation.
     * @return Result of the ListTests operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListTests
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTests" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTestsResponse listTests(ListTestsRequest listTestsRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about tests in a given test suite.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTestsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTestsRequest#builder()}
     * </p>
     *
     * @param listTestsRequest
     *        A {@link Consumer} that will call methods on {@link ListTestsRequest.Builder} to create a request.
     *        Represents a request to the list tests operation.
     * @return Result of the ListTests operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListTests
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTests" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTestsResponse listTests(Consumer<ListTestsRequest.Builder> listTestsRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        return listTests(ListTestsRequest.builder().applyMutation(listTestsRequest).build());
    }

    /**
     * <p>
     * Gets information about tests in a given test suite.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTests(software.amazon.awssdk.services.devicefarm.model.ListTestsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListTestsIterable responses = client.listTestsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.ListTestsIterable responses = client.listTestsPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.ListTestsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListTestsIterable responses = client.listTestsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTests(software.amazon.awssdk.services.devicefarm.model.ListTestsRequest)} operation.</b>
     * </p>
     *
     * @param listTestsRequest
     *        Represents a request to the list tests operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListTests
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTests" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTestsIterable listTestsPaginator(ListTestsRequest listTestsRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about tests in a given test suite.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTests(software.amazon.awssdk.services.devicefarm.model.ListTestsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListTestsIterable responses = client.listTestsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.ListTestsIterable responses = client.listTestsPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.ListTestsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListTestsIterable responses = client.listTestsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTests(software.amazon.awssdk.services.devicefarm.model.ListTestsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTestsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTestsRequest#builder()}
     * </p>
     *
     * @param listTestsRequest
     *        A {@link Consumer} that will call methods on {@link ListTestsRequest.Builder} to create a request.
     *        Represents a request to the list tests operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListTests
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTests" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTestsIterable listTestsPaginator(Consumer<ListTestsRequest.Builder> listTestsRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        return listTestsPaginator(ListTestsRequest.builder().applyMutation(listTestsRequest).build());
    }

    /**
     * <p>
     * Gets information about unique problems.
     * </p>
     *
     * @param listUniqueProblemsRequest
     *        Represents a request to the list unique problems operation.
     * @return Result of the ListUniqueProblems operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListUniqueProblems
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListUniqueProblems" target="_top">AWS
     *      API Documentation</a>
     */
    default ListUniqueProblemsResponse listUniqueProblems(ListUniqueProblemsRequest listUniqueProblemsRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about unique problems.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUniqueProblemsRequest.Builder} avoiding the
     * need to create one manually via {@link ListUniqueProblemsRequest#builder()}
     * </p>
     *
     * @param listUniqueProblemsRequest
     *        A {@link Consumer} that will call methods on {@link ListUniqueProblemsRequest.Builder} to create a
     *        request. Represents a request to the list unique problems operation.
     * @return Result of the ListUniqueProblems operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListUniqueProblems
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListUniqueProblems" target="_top">AWS
     *      API Documentation</a>
     */
    default ListUniqueProblemsResponse listUniqueProblems(Consumer<ListUniqueProblemsRequest.Builder> listUniqueProblemsRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        return listUniqueProblems(ListUniqueProblemsRequest.builder().applyMutation(listUniqueProblemsRequest).build());
    }

    /**
     * <p>
     * Gets information about unique problems.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listUniqueProblems(software.amazon.awssdk.services.devicefarm.model.ListUniqueProblemsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListUniqueProblemsIterable responses = client.listUniqueProblemsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.ListUniqueProblemsIterable responses = client
     *             .listUniqueProblemsPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.ListUniqueProblemsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListUniqueProblemsIterable responses = client.listUniqueProblemsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUniqueProblems(software.amazon.awssdk.services.devicefarm.model.ListUniqueProblemsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listUniqueProblemsRequest
     *        Represents a request to the list unique problems operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListUniqueProblems
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListUniqueProblems" target="_top">AWS
     *      API Documentation</a>
     */
    default ListUniqueProblemsIterable listUniqueProblemsPaginator(ListUniqueProblemsRequest listUniqueProblemsRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about unique problems.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listUniqueProblems(software.amazon.awssdk.services.devicefarm.model.ListUniqueProblemsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListUniqueProblemsIterable responses = client.listUniqueProblemsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.ListUniqueProblemsIterable responses = client
     *             .listUniqueProblemsPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.ListUniqueProblemsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListUniqueProblemsIterable responses = client.listUniqueProblemsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUniqueProblems(software.amazon.awssdk.services.devicefarm.model.ListUniqueProblemsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUniqueProblemsRequest.Builder} avoiding the
     * need to create one manually via {@link ListUniqueProblemsRequest#builder()}
     * </p>
     *
     * @param listUniqueProblemsRequest
     *        A {@link Consumer} that will call methods on {@link ListUniqueProblemsRequest.Builder} to create a
     *        request. Represents a request to the list unique problems operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListUniqueProblems
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListUniqueProblems" target="_top">AWS
     *      API Documentation</a>
     */
    default ListUniqueProblemsIterable listUniqueProblemsPaginator(
            Consumer<ListUniqueProblemsRequest.Builder> listUniqueProblemsRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        return listUniqueProblemsPaginator(ListUniqueProblemsRequest.builder().applyMutation(listUniqueProblemsRequest).build());
    }

    /**
     * <p>
     * Gets information about uploads, given an AWS Device Farm project ARN.
     * </p>
     *
     * @param listUploadsRequest
     *        Represents a request to the list uploads operation.
     * @return Result of the ListUploads operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListUploads
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListUploads" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUploadsResponse listUploads(ListUploadsRequest listUploadsRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about uploads, given an AWS Device Farm project ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUploadsRequest.Builder} avoiding the need to
     * create one manually via {@link ListUploadsRequest#builder()}
     * </p>
     *
     * @param listUploadsRequest
     *        A {@link Consumer} that will call methods on {@link ListUploadsRequest.Builder} to create a request.
     *        Represents a request to the list uploads operation.
     * @return Result of the ListUploads operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListUploads
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListUploads" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUploadsResponse listUploads(Consumer<ListUploadsRequest.Builder> listUploadsRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        return listUploads(ListUploadsRequest.builder().applyMutation(listUploadsRequest).build());
    }

    /**
     * <p>
     * Gets information about uploads, given an AWS Device Farm project ARN.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listUploads(software.amazon.awssdk.services.devicefarm.model.ListUploadsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListUploadsIterable responses = client.listUploadsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.ListUploadsIterable responses = client.listUploadsPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.ListUploadsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListUploadsIterable responses = client.listUploadsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUploads(software.amazon.awssdk.services.devicefarm.model.ListUploadsRequest)} operation.</b>
     * </p>
     *
     * @param listUploadsRequest
     *        Represents a request to the list uploads operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListUploads
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListUploads" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUploadsIterable listUploadsPaginator(ListUploadsRequest listUploadsRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about uploads, given an AWS Device Farm project ARN.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listUploads(software.amazon.awssdk.services.devicefarm.model.ListUploadsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListUploadsIterable responses = client.listUploadsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.ListUploadsIterable responses = client.listUploadsPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.ListUploadsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListUploadsIterable responses = client.listUploadsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUploads(software.amazon.awssdk.services.devicefarm.model.ListUploadsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUploadsRequest.Builder} avoiding the need to
     * create one manually via {@link ListUploadsRequest#builder()}
     * </p>
     *
     * @param listUploadsRequest
     *        A {@link Consumer} that will call methods on {@link ListUploadsRequest.Builder} to create a request.
     *        Represents a request to the list uploads operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListUploads
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListUploads" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUploadsIterable listUploadsPaginator(Consumer<ListUploadsRequest.Builder> listUploadsRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        return listUploadsPaginator(ListUploadsRequest.builder().applyMutation(listUploadsRequest).build());
    }

    /**
     * <p>
     * Returns information about all Amazon Virtual Private Cloud (VPC) endpoint configurations in the AWS account.
     * </p>
     *
     * @param listVpceConfigurationsRequest
     * @return Result of the ListVPCEConfigurations operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListVPCEConfigurations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListVPCEConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVpceConfigurationsResponse listVPCEConfigurations(ListVpceConfigurationsRequest listVpceConfigurationsRequest)
            throws ArgumentException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about all Amazon Virtual Private Cloud (VPC) endpoint configurations in the AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVpceConfigurationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListVpceConfigurationsRequest#builder()}
     * </p>
     *
     * @param listVpceConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link ListVPCEConfigurationsRequest.Builder} to create a
     *        request.
     * @return Result of the ListVPCEConfigurations operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListVPCEConfigurations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListVPCEConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVpceConfigurationsResponse listVPCEConfigurations(
            Consumer<ListVpceConfigurationsRequest.Builder> listVpceConfigurationsRequest) throws ArgumentException,
            ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        return listVPCEConfigurations(ListVpceConfigurationsRequest.builder().applyMutation(listVpceConfigurationsRequest)
                .build());
    }

    /**
     * <p>
     * Immediately purchases offerings for an AWS account. Offerings renew with the latest total purchased quantity for
     * an offering, unless the renewal was overridden. The API returns a <code>NotEligible</code> error if the user is
     * not permitted to invoke the operation. Please contact <a
     * href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you believe that you
     * should be able to invoke this operation.
     * </p>
     *
     * @param purchaseOfferingRequest
     *        Represents a request for a purchase offering.
     * @return Result of the PurchaseOffering operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws NotEligibleException
     *         Exception gets thrown when a user is not eligible to perform the specified transaction.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.PurchaseOffering
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/PurchaseOffering" target="_top">AWS
     *      API Documentation</a>
     */
    default PurchaseOfferingResponse purchaseOffering(PurchaseOfferingRequest purchaseOfferingRequest) throws ArgumentException,
            NotFoundException, NotEligibleException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Immediately purchases offerings for an AWS account. Offerings renew with the latest total purchased quantity for
     * an offering, unless the renewal was overridden. The API returns a <code>NotEligible</code> error if the user is
     * not permitted to invoke the operation. Please contact <a
     * href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you believe that you
     * should be able to invoke this operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PurchaseOfferingRequest.Builder} avoiding the need
     * to create one manually via {@link PurchaseOfferingRequest#builder()}
     * </p>
     *
     * @param purchaseOfferingRequest
     *        A {@link Consumer} that will call methods on {@link PurchaseOfferingRequest.Builder} to create a request.
     *        Represents a request for a purchase offering.
     * @return Result of the PurchaseOffering operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws NotEligibleException
     *         Exception gets thrown when a user is not eligible to perform the specified transaction.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.PurchaseOffering
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/PurchaseOffering" target="_top">AWS
     *      API Documentation</a>
     */
    default PurchaseOfferingResponse purchaseOffering(Consumer<PurchaseOfferingRequest.Builder> purchaseOfferingRequest)
            throws ArgumentException, NotFoundException, NotEligibleException, LimitExceededException, ServiceAccountException,
            AwsServiceException, SdkClientException, DeviceFarmException {
        return purchaseOffering(PurchaseOfferingRequest.builder().applyMutation(purchaseOfferingRequest).build());
    }

    /**
     * <p>
     * Explicitly sets the quantity of devices to renew for an offering, starting from the <code>effectiveDate</code> of
     * the next period. The API returns a <code>NotEligible</code> error if the user is not permitted to invoke the
     * operation. Please contact <a
     * href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you believe that you
     * should be able to invoke this operation.
     * </p>
     *
     * @param renewOfferingRequest
     *        A request representing an offering renewal.
     * @return Result of the RenewOffering operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws NotEligibleException
     *         Exception gets thrown when a user is not eligible to perform the specified transaction.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.RenewOffering
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/RenewOffering" target="_top">AWS API
     *      Documentation</a>
     */
    default RenewOfferingResponse renewOffering(RenewOfferingRequest renewOfferingRequest) throws ArgumentException,
            NotFoundException, NotEligibleException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Explicitly sets the quantity of devices to renew for an offering, starting from the <code>effectiveDate</code> of
     * the next period. The API returns a <code>NotEligible</code> error if the user is not permitted to invoke the
     * operation. Please contact <a
     * href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you believe that you
     * should be able to invoke this operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RenewOfferingRequest.Builder} avoiding the need to
     * create one manually via {@link RenewOfferingRequest#builder()}
     * </p>
     *
     * @param renewOfferingRequest
     *        A {@link Consumer} that will call methods on {@link RenewOfferingRequest.Builder} to create a request. A
     *        request representing an offering renewal.
     * @return Result of the RenewOffering operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws NotEligibleException
     *         Exception gets thrown when a user is not eligible to perform the specified transaction.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.RenewOffering
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/RenewOffering" target="_top">AWS API
     *      Documentation</a>
     */
    default RenewOfferingResponse renewOffering(Consumer<RenewOfferingRequest.Builder> renewOfferingRequest)
            throws ArgumentException, NotFoundException, NotEligibleException, LimitExceededException, ServiceAccountException,
            AwsServiceException, SdkClientException, DeviceFarmException {
        return renewOffering(RenewOfferingRequest.builder().applyMutation(renewOfferingRequest).build());
    }

    /**
     * <p>
     * Schedules a run.
     * </p>
     *
     * @param scheduleRunRequest
     *        Represents a request to the schedule run operation.
     * @return Result of the ScheduleRun operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws IdempotencyException
     *         An entity with the same name already exists.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ScheduleRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ScheduleRun" target="_top">AWS API
     *      Documentation</a>
     */
    default ScheduleRunResponse scheduleRun(ScheduleRunRequest scheduleRunRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, IdempotencyException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Schedules a run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ScheduleRunRequest.Builder} avoiding the need to
     * create one manually via {@link ScheduleRunRequest#builder()}
     * </p>
     *
     * @param scheduleRunRequest
     *        A {@link Consumer} that will call methods on {@link ScheduleRunRequest.Builder} to create a request.
     *        Represents a request to the schedule run operation.
     * @return Result of the ScheduleRun operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws IdempotencyException
     *         An entity with the same name already exists.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ScheduleRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ScheduleRun" target="_top">AWS API
     *      Documentation</a>
     */
    default ScheduleRunResponse scheduleRun(Consumer<ScheduleRunRequest.Builder> scheduleRunRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, IdempotencyException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        return scheduleRun(ScheduleRunRequest.builder().applyMutation(scheduleRunRequest).build());
    }

    /**
     * <p>
     * Initiates a stop request for the current job. AWS Device Farm will immediately stop the job on the device where
     * tests have not started executing, and you will not be billed for this device. On the device where tests have
     * started executing, Setup Suite and Teardown Suite tests will run to completion before stopping execution on the
     * device. You will be billed for Setup, Teardown, and any tests that were in progress or already completed.
     * </p>
     *
     * @param stopJobRequest
     * @return Result of the StopJob operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.StopJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/StopJob" target="_top">AWS API
     *      Documentation</a>
     */
    default StopJobResponse stopJob(StopJobRequest stopJobRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initiates a stop request for the current job. AWS Device Farm will immediately stop the job on the device where
     * tests have not started executing, and you will not be billed for this device. On the device where tests have
     * started executing, Setup Suite and Teardown Suite tests will run to completion before stopping execution on the
     * device. You will be billed for Setup, Teardown, and any tests that were in progress or already completed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopJobRequest.Builder} avoiding the need to create
     * one manually via {@link StopJobRequest#builder()}
     * </p>
     *
     * @param stopJobRequest
     *        A {@link Consumer} that will call methods on {@link StopJobRequest.Builder} to create a request.
     * @return Result of the StopJob operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.StopJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/StopJob" target="_top">AWS API
     *      Documentation</a>
     */
    default StopJobResponse stopJob(Consumer<StopJobRequest.Builder> stopJobRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        return stopJob(StopJobRequest.builder().applyMutation(stopJobRequest).build());
    }

    /**
     * <p>
     * Ends a specified remote access session.
     * </p>
     *
     * @param stopRemoteAccessSessionRequest
     *        Represents the request to stop the remote access session.
     * @return Result of the StopRemoteAccessSession operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.StopRemoteAccessSession
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/StopRemoteAccessSession"
     *      target="_top">AWS API Documentation</a>
     */
    default StopRemoteAccessSessionResponse stopRemoteAccessSession(StopRemoteAccessSessionRequest stopRemoteAccessSessionRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Ends a specified remote access session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopRemoteAccessSessionRequest.Builder} avoiding
     * the need to create one manually via {@link StopRemoteAccessSessionRequest#builder()}
     * </p>
     *
     * @param stopRemoteAccessSessionRequest
     *        A {@link Consumer} that will call methods on {@link StopRemoteAccessSessionRequest.Builder} to create a
     *        request. Represents the request to stop the remote access session.
     * @return Result of the StopRemoteAccessSession operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.StopRemoteAccessSession
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/StopRemoteAccessSession"
     *      target="_top">AWS API Documentation</a>
     */
    default StopRemoteAccessSessionResponse stopRemoteAccessSession(
            Consumer<StopRemoteAccessSessionRequest.Builder> stopRemoteAccessSessionRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        return stopRemoteAccessSession(StopRemoteAccessSessionRequest.builder().applyMutation(stopRemoteAccessSessionRequest)
                .build());
    }

    /**
     * <p>
     * Initiates a stop request for the current test run. AWS Device Farm will immediately stop the run on devices where
     * tests have not started executing, and you will not be billed for these devices. On devices where tests have
     * started executing, Setup Suite and Teardown Suite tests will run to completion before stopping execution on those
     * devices. You will be billed for Setup, Teardown, and any tests that were in progress or already completed.
     * </p>
     *
     * @param stopRunRequest
     *        Represents the request to stop a specific run.
     * @return Result of the StopRun operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.StopRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/StopRun" target="_top">AWS API
     *      Documentation</a>
     */
    default StopRunResponse stopRun(StopRunRequest stopRunRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initiates a stop request for the current test run. AWS Device Farm will immediately stop the run on devices where
     * tests have not started executing, and you will not be billed for these devices. On devices where tests have
     * started executing, Setup Suite and Teardown Suite tests will run to completion before stopping execution on those
     * devices. You will be billed for Setup, Teardown, and any tests that were in progress or already completed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopRunRequest.Builder} avoiding the need to create
     * one manually via {@link StopRunRequest#builder()}
     * </p>
     *
     * @param stopRunRequest
     *        A {@link Consumer} that will call methods on {@link StopRunRequest.Builder} to create a request.
     *        Represents the request to stop a specific run.
     * @return Result of the StopRun operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.StopRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/StopRun" target="_top">AWS API
     *      Documentation</a>
     */
    default StopRunResponse stopRun(Consumer<StopRunRequest.Builder> stopRunRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        return stopRun(StopRunRequest.builder().applyMutation(stopRunRequest).build());
    }

    /**
     * <p>
     * Updates information about an existing private device instance.
     * </p>
     *
     * @param updateDeviceInstanceRequest
     * @return Result of the UpdateDeviceInstance operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.UpdateDeviceInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateDeviceInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDeviceInstanceResponse updateDeviceInstance(UpdateDeviceInstanceRequest updateDeviceInstanceRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates information about an existing private device instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDeviceInstanceRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateDeviceInstanceRequest#builder()}
     * </p>
     *
     * @param updateDeviceInstanceRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDeviceInstanceRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateDeviceInstance operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.UpdateDeviceInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateDeviceInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDeviceInstanceResponse updateDeviceInstance(
            Consumer<UpdateDeviceInstanceRequest.Builder> updateDeviceInstanceRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        return updateDeviceInstance(UpdateDeviceInstanceRequest.builder().applyMutation(updateDeviceInstanceRequest).build());
    }

    /**
     * <p>
     * Modifies the name, description, and rules in a device pool given the attributes and the pool ARN. Rule updates
     * are all-or-nothing, meaning they can only be updated as a whole (or not at all).
     * </p>
     *
     * @param updateDevicePoolRequest
     *        Represents a request to the update device pool operation.
     * @return Result of the UpdateDevicePool operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.UpdateDevicePool
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateDevicePool" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateDevicePoolResponse updateDevicePool(UpdateDevicePoolRequest updateDevicePoolRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the name, description, and rules in a device pool given the attributes and the pool ARN. Rule updates
     * are all-or-nothing, meaning they can only be updated as a whole (or not at all).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDevicePoolRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateDevicePoolRequest#builder()}
     * </p>
     *
     * @param updateDevicePoolRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDevicePoolRequest.Builder} to create a request.
     *        Represents a request to the update device pool operation.
     * @return Result of the UpdateDevicePool operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.UpdateDevicePool
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateDevicePool" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateDevicePoolResponse updateDevicePool(Consumer<UpdateDevicePoolRequest.Builder> updateDevicePoolRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        return updateDevicePool(UpdateDevicePoolRequest.builder().applyMutation(updateDevicePoolRequest).build());
    }

    /**
     * <p>
     * Updates information about an existing private device instance profile.
     * </p>
     *
     * @param updateInstanceProfileRequest
     * @return Result of the UpdateInstanceProfile operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.UpdateInstanceProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateInstanceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateInstanceProfileResponse updateInstanceProfile(UpdateInstanceProfileRequest updateInstanceProfileRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates information about an existing private device instance profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateInstanceProfileRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateInstanceProfileRequest#builder()}
     * </p>
     *
     * @param updateInstanceProfileRequest
     *        A {@link Consumer} that will call methods on {@link UpdateInstanceProfileRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateInstanceProfile operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.UpdateInstanceProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateInstanceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateInstanceProfileResponse updateInstanceProfile(
            Consumer<UpdateInstanceProfileRequest.Builder> updateInstanceProfileRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        return updateInstanceProfile(UpdateInstanceProfileRequest.builder().applyMutation(updateInstanceProfileRequest).build());
    }

    /**
     * <p>
     * Updates the network profile with specific settings.
     * </p>
     *
     * @param updateNetworkProfileRequest
     * @return Result of the UpdateNetworkProfile operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.UpdateNetworkProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateNetworkProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateNetworkProfileResponse updateNetworkProfile(UpdateNetworkProfileRequest updateNetworkProfileRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the network profile with specific settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateNetworkProfileRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateNetworkProfileRequest#builder()}
     * </p>
     *
     * @param updateNetworkProfileRequest
     *        A {@link Consumer} that will call methods on {@link UpdateNetworkProfileRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateNetworkProfile operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.UpdateNetworkProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateNetworkProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateNetworkProfileResponse updateNetworkProfile(
            Consumer<UpdateNetworkProfileRequest.Builder> updateNetworkProfileRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        return updateNetworkProfile(UpdateNetworkProfileRequest.builder().applyMutation(updateNetworkProfileRequest).build());
    }

    /**
     * <p>
     * Modifies the specified project name, given the project ARN and a new name.
     * </p>
     *
     * @param updateProjectRequest
     *        Represents a request to the update project operation.
     * @return Result of the UpdateProject operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.UpdateProject
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateProject" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateProjectResponse updateProject(UpdateProjectRequest updateProjectRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the specified project name, given the project ARN and a new name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProjectRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateProjectRequest#builder()}
     * </p>
     *
     * @param updateProjectRequest
     *        A {@link Consumer} that will call methods on {@link UpdateProjectRequest.Builder} to create a request.
     *        Represents a request to the update project operation.
     * @return Result of the UpdateProject operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.UpdateProject
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateProject" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateProjectResponse updateProject(Consumer<UpdateProjectRequest.Builder> updateProjectRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        return updateProject(UpdateProjectRequest.builder().applyMutation(updateProjectRequest).build());
    }

    /**
     * <p>
     * Update an uploaded test specification (test spec).
     * </p>
     *
     * @param updateUploadRequest
     * @return Result of the UpdateUpload operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.UpdateUpload
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateUpload" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateUploadResponse updateUpload(UpdateUploadRequest updateUploadRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update an uploaded test specification (test spec).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUploadRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateUploadRequest#builder()}
     * </p>
     *
     * @param updateUploadRequest
     *        A {@link Consumer} that will call methods on {@link UpdateUploadRequest.Builder} to create a request.
     * @return Result of the UpdateUpload operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.UpdateUpload
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateUpload" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateUploadResponse updateUpload(Consumer<UpdateUploadRequest.Builder> updateUploadRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        return updateUpload(UpdateUploadRequest.builder().applyMutation(updateUploadRequest).build());
    }

    /**
     * <p>
     * Updates information about an existing Amazon Virtual Private Cloud (VPC) endpoint configuration.
     * </p>
     *
     * @param updateVpceConfigurationRequest
     * @return Result of the UpdateVPCEConfiguration operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws InvalidOperationException
     *         There was an error with the update request, or you do not have sufficient permissions to update this VPC
     *         endpoint configuration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.UpdateVPCEConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateVPCEConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateVpceConfigurationResponse updateVPCEConfiguration(UpdateVpceConfigurationRequest updateVpceConfigurationRequest)
            throws ArgumentException, NotFoundException, ServiceAccountException, InvalidOperationException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates information about an existing Amazon Virtual Private Cloud (VPC) endpoint configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateVpceConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateVpceConfigurationRequest#builder()}
     * </p>
     *
     * @param updateVpceConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateVPCEConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateVPCEConfiguration operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws InvalidOperationException
     *         There was an error with the update request, or you do not have sufficient permissions to update this VPC
     *         endpoint configuration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.UpdateVPCEConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateVPCEConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateVpceConfigurationResponse updateVPCEConfiguration(
            Consumer<UpdateVpceConfigurationRequest.Builder> updateVpceConfigurationRequest) throws ArgumentException,
            NotFoundException, ServiceAccountException, InvalidOperationException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        return updateVPCEConfiguration(UpdateVpceConfigurationRequest.builder().applyMutation(updateVpceConfigurationRequest)
                .build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("devicefarm");
    }
}
