/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.transform.ArtifactMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a test. Examples of artifacts include logs and screenshots.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Artifact implements StructuredPojo, ToCopyableBuilder<Artifact.Builder, Artifact> {
    private final String arn;

    private final String name;

    private final String type;

    private final String extension;

    private final String url;

    private Artifact(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.type = builder.type;
        this.extension = builder.extension;
        this.url = builder.url;
    }

    /**
     * <p>
     * The artifact's ARN.
     * </p>
     * 
     * @return The artifact's ARN.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The artifact's name.
     * </p>
     * 
     * @return The artifact's name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The artifact's type.
     * </p>
     * <p>
     * Allowed values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * UNKNOWN: An unknown type.
     * </p>
     * </li>
     * <li>
     * <p>
     * SCREENSHOT: The screenshot type.
     * </p>
     * </li>
     * <li>
     * <p>
     * DEVICE_LOG: The device log type.
     * </p>
     * </li>
     * <li>
     * <p>
     * MESSAGE_LOG: The message log type.
     * </p>
     * </li>
     * <li>
     * <p>
     * RESULT_LOG: The result log type.
     * </p>
     * </li>
     * <li>
     * <p>
     * SERVICE_LOG: The service log type.
     * </p>
     * </li>
     * <li>
     * <p>
     * WEBKIT_LOG: The web kit log type.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTRUMENTATION_OUTPUT: The instrumentation type.
     * </p>
     * </li>
     * <li>
     * <p>
     * EXERCISER_MONKEY_OUTPUT: For Android, the artifact (log) generated by an Android fuzz test.
     * </p>
     * </li>
     * <li>
     * <p>
     * CALABASH_JSON_OUTPUT: The Calabash JSON output type.
     * </p>
     * </li>
     * <li>
     * <p>
     * CALABASH_PRETTY_OUTPUT: The Calabash pretty output type.
     * </p>
     * </li>
     * <li>
     * <p>
     * CALABASH_STANDARD_OUTPUT: The Calabash standard output type.
     * </p>
     * </li>
     * <li>
     * <p>
     * CALABASH_JAVA_XML_OUTPUT: The Calabash Java XML output type.
     * </p>
     * </li>
     * <li>
     * <p>
     * AUTOMATION_OUTPUT: The automation output type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_SERVER_OUTPUT: The Appium server output type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_OUTPUT: The Appium Java output type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_XML_OUTPUT: The Appium Java XML output type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_PYTHON_OUTPUT: The Appium Python output type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_PYTHON_XML_OUTPUT: The Appium Python XML output type.
     * </p>
     * </li>
     * <li>
     * <p>
     * EXPLORER_EVENT_LOG: The Explorer event log output type.
     * </p>
     * </li>
     * <li>
     * <p>
     * EXPLORER_SUMMARY_LOG: The Explorer summary log output type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPLICATION_CRASH_REPORT: The application crash report output type.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST_LOG: The XCode test output type.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ArtifactType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The artifact's type.</p>
     *         <p>
     *         Allowed values include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         UNKNOWN: An unknown type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SCREENSHOT: The screenshot type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DEVICE_LOG: The device log type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MESSAGE_LOG: The message log type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RESULT_LOG: The result log type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SERVICE_LOG: The service log type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WEBKIT_LOG: The web kit log type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTRUMENTATION_OUTPUT: The instrumentation type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EXERCISER_MONKEY_OUTPUT: For Android, the artifact (log) generated by an Android fuzz test.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CALABASH_JSON_OUTPUT: The Calabash JSON output type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CALABASH_PRETTY_OUTPUT: The Calabash pretty output type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CALABASH_STANDARD_OUTPUT: The Calabash standard output type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CALABASH_JAVA_XML_OUTPUT: The Calabash Java XML output type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AUTOMATION_OUTPUT: The automation output type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_SERVER_OUTPUT: The Appium server output type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_OUTPUT: The Appium Java output type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_XML_OUTPUT: The Appium Java XML output type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_PYTHON_OUTPUT: The Appium Python output type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_PYTHON_XML_OUTPUT: The Appium Python XML output type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EXPLORER_EVENT_LOG: The Explorer event log output type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EXPLORER_SUMMARY_LOG: The Explorer summary log output type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPLICATION_CRASH_REPORT: The application crash report output type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST_LOG: The XCode test output type.
     *         </p>
     *         </li>
     * @see ArtifactType
     */
    public ArtifactType type() {
        return ArtifactType.fromValue(type);
    }

    /**
     * <p>
     * The artifact's type.
     * </p>
     * <p>
     * Allowed values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * UNKNOWN: An unknown type.
     * </p>
     * </li>
     * <li>
     * <p>
     * SCREENSHOT: The screenshot type.
     * </p>
     * </li>
     * <li>
     * <p>
     * DEVICE_LOG: The device log type.
     * </p>
     * </li>
     * <li>
     * <p>
     * MESSAGE_LOG: The message log type.
     * </p>
     * </li>
     * <li>
     * <p>
     * RESULT_LOG: The result log type.
     * </p>
     * </li>
     * <li>
     * <p>
     * SERVICE_LOG: The service log type.
     * </p>
     * </li>
     * <li>
     * <p>
     * WEBKIT_LOG: The web kit log type.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTRUMENTATION_OUTPUT: The instrumentation type.
     * </p>
     * </li>
     * <li>
     * <p>
     * EXERCISER_MONKEY_OUTPUT: For Android, the artifact (log) generated by an Android fuzz test.
     * </p>
     * </li>
     * <li>
     * <p>
     * CALABASH_JSON_OUTPUT: The Calabash JSON output type.
     * </p>
     * </li>
     * <li>
     * <p>
     * CALABASH_PRETTY_OUTPUT: The Calabash pretty output type.
     * </p>
     * </li>
     * <li>
     * <p>
     * CALABASH_STANDARD_OUTPUT: The Calabash standard output type.
     * </p>
     * </li>
     * <li>
     * <p>
     * CALABASH_JAVA_XML_OUTPUT: The Calabash Java XML output type.
     * </p>
     * </li>
     * <li>
     * <p>
     * AUTOMATION_OUTPUT: The automation output type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_SERVER_OUTPUT: The Appium server output type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_OUTPUT: The Appium Java output type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_XML_OUTPUT: The Appium Java XML output type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_PYTHON_OUTPUT: The Appium Python output type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_PYTHON_XML_OUTPUT: The Appium Python XML output type.
     * </p>
     * </li>
     * <li>
     * <p>
     * EXPLORER_EVENT_LOG: The Explorer event log output type.
     * </p>
     * </li>
     * <li>
     * <p>
     * EXPLORER_SUMMARY_LOG: The Explorer summary log output type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPLICATION_CRASH_REPORT: The application crash report output type.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST_LOG: The XCode test output type.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ArtifactType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The artifact's type.</p>
     *         <p>
     *         Allowed values include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         UNKNOWN: An unknown type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SCREENSHOT: The screenshot type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DEVICE_LOG: The device log type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MESSAGE_LOG: The message log type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RESULT_LOG: The result log type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SERVICE_LOG: The service log type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WEBKIT_LOG: The web kit log type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTRUMENTATION_OUTPUT: The instrumentation type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EXERCISER_MONKEY_OUTPUT: For Android, the artifact (log) generated by an Android fuzz test.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CALABASH_JSON_OUTPUT: The Calabash JSON output type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CALABASH_PRETTY_OUTPUT: The Calabash pretty output type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CALABASH_STANDARD_OUTPUT: The Calabash standard output type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CALABASH_JAVA_XML_OUTPUT: The Calabash Java XML output type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AUTOMATION_OUTPUT: The automation output type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_SERVER_OUTPUT: The Appium server output type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_OUTPUT: The Appium Java output type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_XML_OUTPUT: The Appium Java XML output type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_PYTHON_OUTPUT: The Appium Python output type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_PYTHON_XML_OUTPUT: The Appium Python XML output type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EXPLORER_EVENT_LOG: The Explorer event log output type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EXPLORER_SUMMARY_LOG: The Explorer summary log output type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPLICATION_CRASH_REPORT: The application crash report output type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST_LOG: The XCode test output type.
     *         </p>
     *         </li>
     * @see ArtifactType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The artifact's file extension.
     * </p>
     * 
     * @return The artifact's file extension.
     */
    public String extension() {
        return extension;
    }

    /**
     * <p>
     * The pre-signed Amazon S3 URL that can be used with a corresponding GET request to download the artifact's file.
     * </p>
     * 
     * @return The pre-signed Amazon S3 URL that can be used with a corresponding GET request to download the artifact's
     *         file.
     */
    public String url() {
        return url;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(extension());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Artifact)) {
            return false;
        }
        Artifact other = (Artifact) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(extension(), other.extension())
                && Objects.equals(url(), other.url());
    }

    @Override
    public String toString() {
        return ToString.builder("Artifact").add("Arn", arn()).add("Name", name()).add("Type", typeAsString())
                .add("Extension", extension()).add("Url", url()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "extension":
            return Optional.ofNullable(clazz.cast(extension()));
        case "url":
            return Optional.ofNullable(clazz.cast(url()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ArtifactMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Artifact> {
        /**
         * <p>
         * The artifact's ARN.
         * </p>
         * 
         * @param arn
         *        The artifact's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The artifact's name.
         * </p>
         * 
         * @param name
         *        The artifact's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The artifact's type.
         * </p>
         * <p>
         * Allowed values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * UNKNOWN: An unknown type.
         * </p>
         * </li>
         * <li>
         * <p>
         * SCREENSHOT: The screenshot type.
         * </p>
         * </li>
         * <li>
         * <p>
         * DEVICE_LOG: The device log type.
         * </p>
         * </li>
         * <li>
         * <p>
         * MESSAGE_LOG: The message log type.
         * </p>
         * </li>
         * <li>
         * <p>
         * RESULT_LOG: The result log type.
         * </p>
         * </li>
         * <li>
         * <p>
         * SERVICE_LOG: The service log type.
         * </p>
         * </li>
         * <li>
         * <p>
         * WEBKIT_LOG: The web kit log type.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTRUMENTATION_OUTPUT: The instrumentation type.
         * </p>
         * </li>
         * <li>
         * <p>
         * EXERCISER_MONKEY_OUTPUT: For Android, the artifact (log) generated by an Android fuzz test.
         * </p>
         * </li>
         * <li>
         * <p>
         * CALABASH_JSON_OUTPUT: The Calabash JSON output type.
         * </p>
         * </li>
         * <li>
         * <p>
         * CALABASH_PRETTY_OUTPUT: The Calabash pretty output type.
         * </p>
         * </li>
         * <li>
         * <p>
         * CALABASH_STANDARD_OUTPUT: The Calabash standard output type.
         * </p>
         * </li>
         * <li>
         * <p>
         * CALABASH_JAVA_XML_OUTPUT: The Calabash Java XML output type.
         * </p>
         * </li>
         * <li>
         * <p>
         * AUTOMATION_OUTPUT: The automation output type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_SERVER_OUTPUT: The Appium server output type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_OUTPUT: The Appium Java output type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_XML_OUTPUT: The Appium Java XML output type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_PYTHON_OUTPUT: The Appium Python output type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_PYTHON_XML_OUTPUT: The Appium Python XML output type.
         * </p>
         * </li>
         * <li>
         * <p>
         * EXPLORER_EVENT_LOG: The Explorer event log output type.
         * </p>
         * </li>
         * <li>
         * <p>
         * EXPLORER_SUMMARY_LOG: The Explorer summary log output type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPLICATION_CRASH_REPORT: The application crash report output type.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST_LOG: The XCode test output type.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The artifact's type.</p>
         *        <p>
         *        Allowed values include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        UNKNOWN: An unknown type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SCREENSHOT: The screenshot type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DEVICE_LOG: The device log type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        MESSAGE_LOG: The message log type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RESULT_LOG: The result log type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SERVICE_LOG: The service log type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        WEBKIT_LOG: The web kit log type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTRUMENTATION_OUTPUT: The instrumentation type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        EXERCISER_MONKEY_OUTPUT: For Android, the artifact (log) generated by an Android fuzz test.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CALABASH_JSON_OUTPUT: The Calabash JSON output type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CALABASH_PRETTY_OUTPUT: The Calabash pretty output type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CALABASH_STANDARD_OUTPUT: The Calabash standard output type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CALABASH_JAVA_XML_OUTPUT: The Calabash Java XML output type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AUTOMATION_OUTPUT: The automation output type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_SERVER_OUTPUT: The Appium server output type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_OUTPUT: The Appium Java output type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_XML_OUTPUT: The Appium Java XML output type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_PYTHON_OUTPUT: The Appium Python output type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_PYTHON_XML_OUTPUT: The Appium Python XML output type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        EXPLORER_EVENT_LOG: The Explorer event log output type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        EXPLORER_SUMMARY_LOG: The Explorer summary log output type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPLICATION_CRASH_REPORT: The application crash report output type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST_LOG: The XCode test output type.
         *        </p>
         *        </li>
         * @see ArtifactType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArtifactType
         */
        Builder type(String type);

        /**
         * <p>
         * The artifact's type.
         * </p>
         * <p>
         * Allowed values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * UNKNOWN: An unknown type.
         * </p>
         * </li>
         * <li>
         * <p>
         * SCREENSHOT: The screenshot type.
         * </p>
         * </li>
         * <li>
         * <p>
         * DEVICE_LOG: The device log type.
         * </p>
         * </li>
         * <li>
         * <p>
         * MESSAGE_LOG: The message log type.
         * </p>
         * </li>
         * <li>
         * <p>
         * RESULT_LOG: The result log type.
         * </p>
         * </li>
         * <li>
         * <p>
         * SERVICE_LOG: The service log type.
         * </p>
         * </li>
         * <li>
         * <p>
         * WEBKIT_LOG: The web kit log type.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTRUMENTATION_OUTPUT: The instrumentation type.
         * </p>
         * </li>
         * <li>
         * <p>
         * EXERCISER_MONKEY_OUTPUT: For Android, the artifact (log) generated by an Android fuzz test.
         * </p>
         * </li>
         * <li>
         * <p>
         * CALABASH_JSON_OUTPUT: The Calabash JSON output type.
         * </p>
         * </li>
         * <li>
         * <p>
         * CALABASH_PRETTY_OUTPUT: The Calabash pretty output type.
         * </p>
         * </li>
         * <li>
         * <p>
         * CALABASH_STANDARD_OUTPUT: The Calabash standard output type.
         * </p>
         * </li>
         * <li>
         * <p>
         * CALABASH_JAVA_XML_OUTPUT: The Calabash Java XML output type.
         * </p>
         * </li>
         * <li>
         * <p>
         * AUTOMATION_OUTPUT: The automation output type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_SERVER_OUTPUT: The Appium server output type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_OUTPUT: The Appium Java output type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_XML_OUTPUT: The Appium Java XML output type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_PYTHON_OUTPUT: The Appium Python output type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_PYTHON_XML_OUTPUT: The Appium Python XML output type.
         * </p>
         * </li>
         * <li>
         * <p>
         * EXPLORER_EVENT_LOG: The Explorer event log output type.
         * </p>
         * </li>
         * <li>
         * <p>
         * EXPLORER_SUMMARY_LOG: The Explorer summary log output type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPLICATION_CRASH_REPORT: The application crash report output type.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST_LOG: The XCode test output type.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The artifact's type.</p>
         *        <p>
         *        Allowed values include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        UNKNOWN: An unknown type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SCREENSHOT: The screenshot type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DEVICE_LOG: The device log type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        MESSAGE_LOG: The message log type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RESULT_LOG: The result log type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SERVICE_LOG: The service log type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        WEBKIT_LOG: The web kit log type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTRUMENTATION_OUTPUT: The instrumentation type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        EXERCISER_MONKEY_OUTPUT: For Android, the artifact (log) generated by an Android fuzz test.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CALABASH_JSON_OUTPUT: The Calabash JSON output type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CALABASH_PRETTY_OUTPUT: The Calabash pretty output type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CALABASH_STANDARD_OUTPUT: The Calabash standard output type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CALABASH_JAVA_XML_OUTPUT: The Calabash Java XML output type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AUTOMATION_OUTPUT: The automation output type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_SERVER_OUTPUT: The Appium server output type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_OUTPUT: The Appium Java output type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_XML_OUTPUT: The Appium Java XML output type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_PYTHON_OUTPUT: The Appium Python output type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_PYTHON_XML_OUTPUT: The Appium Python XML output type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        EXPLORER_EVENT_LOG: The Explorer event log output type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        EXPLORER_SUMMARY_LOG: The Explorer summary log output type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPLICATION_CRASH_REPORT: The application crash report output type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST_LOG: The XCode test output type.
         *        </p>
         *        </li>
         * @see ArtifactType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArtifactType
         */
        Builder type(ArtifactType type);

        /**
         * <p>
         * The artifact's file extension.
         * </p>
         * 
         * @param extension
         *        The artifact's file extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extension(String extension);

        /**
         * <p>
         * The pre-signed Amazon S3 URL that can be used with a corresponding GET request to download the artifact's
         * file.
         * </p>
         * 
         * @param url
         *        The pre-signed Amazon S3 URL that can be used with a corresponding GET request to download the
         *        artifact's file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String type;

        private String extension;

        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(Artifact model) {
            arn(model.arn);
            name(model.name);
            type(model.type);
            extension(model.extension);
            url(model.url);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ArtifactType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getExtension() {
            return extension;
        }

        @Override
        public final Builder extension(String extension) {
            this.extension = extension;
            return this;
        }

        public final void setExtension(String extension) {
            this.extension = extension;
        }

        public final String getUrl() {
            return url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public Artifact build() {
            return new Artifact(this);
        }
    }
}
