/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the result of a create device pool request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDevicePoolResponse extends DeviceFarmResponse implements
        ToCopyableBuilder<CreateDevicePoolResponse.Builder, CreateDevicePoolResponse> {
    private final DevicePool devicePool;

    private CreateDevicePoolResponse(BuilderImpl builder) {
        super(builder);
        this.devicePool = builder.devicePool;
    }

    /**
     * <p>
     * The newly created device pool.
     * </p>
     * 
     * @return The newly created device pool.
     */
    public DevicePool devicePool() {
        return devicePool;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(devicePool());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDevicePoolResponse)) {
            return false;
        }
        CreateDevicePoolResponse other = (CreateDevicePoolResponse) obj;
        return Objects.equals(devicePool(), other.devicePool());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateDevicePoolResponse").add("DevicePool", devicePool()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "devicePool":
            return Optional.ofNullable(clazz.cast(devicePool()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends DeviceFarmResponse.Builder, CopyableBuilder<Builder, CreateDevicePoolResponse> {
        /**
         * <p>
         * The newly created device pool.
         * </p>
         * 
         * @param devicePool
         *        The newly created device pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devicePool(DevicePool devicePool);

        /**
         * <p>
         * The newly created device pool.
         * </p>
         * This is a convenience that creates an instance of the {@link DevicePool.Builder} avoiding the need to create
         * one manually via {@link DevicePool#builder()}.
         *
         * When the {@link Consumer} completes, {@link DevicePool.Builder#build()} is called immediately and its result
         * is passed to {@link #devicePool(DevicePool)}.
         * 
         * @param devicePool
         *        a consumer that will call methods on {@link DevicePool.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #devicePool(DevicePool)
         */
        default Builder devicePool(Consumer<DevicePool.Builder> devicePool) {
            return devicePool(DevicePool.builder().applyMutation(devicePool).build());
        }
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private DevicePool devicePool;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDevicePoolResponse model) {
            super(model);
            devicePool(model.devicePool);
        }

        public final DevicePool.Builder getDevicePool() {
            return devicePool != null ? devicePool.toBuilder() : null;
        }

        @Override
        public final Builder devicePool(DevicePool devicePool) {
            this.devicePool = devicePool;
            return this;
        }

        public final void setDevicePool(DevicePool.BuilderImpl devicePool) {
            this.devicePool = devicePool != null ? devicePool.build() : null;
        }

        @Override
        public CreateDevicePoolResponse build() {
            return new CreateDevicePoolResponse(this);
        }
    }
}
