/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateInstanceProfileRequest extends DeviceFarmRequest implements
        ToCopyableBuilder<CreateInstanceProfileRequest.Builder, CreateInstanceProfileRequest> {
    private final String name;

    private final String description;

    private final Boolean packageCleanup;

    private final List<String> excludeAppPackagesFromCleanup;

    private final Boolean rebootAfterUse;

    private CreateInstanceProfileRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.packageCleanup = builder.packageCleanup;
        this.excludeAppPackagesFromCleanup = builder.excludeAppPackagesFromCleanup;
        this.rebootAfterUse = builder.rebootAfterUse;
    }

    /**
     * <p>
     * The name of your instance profile.
     * </p>
     * 
     * @return The name of your instance profile.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The description of your instance profile.
     * </p>
     * 
     * @return The description of your instance profile.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * When set to <code>true</code>, Device Farm will remove app packages after a test run. The default value is
     * <code>false</code> for private devices.
     * </p>
     * 
     * @return When set to <code>true</code>, Device Farm will remove app packages after a test run. The default value
     *         is <code>false</code> for private devices.
     */
    public Boolean packageCleanup() {
        return packageCleanup;
    }

    /**
     * <p>
     * An array of strings specifying the list of app packages that should not be cleaned up from the device after a
     * test run is over.
     * </p>
     * <p>
     * The list of packages is only considered if you set <code>packageCleanup</code> to <code>true</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of strings specifying the list of app packages that should not be cleaned up from the device
     *         after a test run is over.</p>
     *         <p>
     *         The list of packages is only considered if you set <code>packageCleanup</code> to <code>true</code>.
     */
    public List<String> excludeAppPackagesFromCleanup() {
        return excludeAppPackagesFromCleanup;
    }

    /**
     * <p>
     * When set to <code>true</code>, Device Farm will reboot the instance after a test run. The default value is
     * <code>true</code>.
     * </p>
     * 
     * @return When set to <code>true</code>, Device Farm will reboot the instance after a test run. The default value
     *         is <code>true</code>.
     */
    public Boolean rebootAfterUse() {
        return rebootAfterUse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(packageCleanup());
        hashCode = 31 * hashCode + Objects.hashCode(excludeAppPackagesFromCleanup());
        hashCode = 31 * hashCode + Objects.hashCode(rebootAfterUse());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInstanceProfileRequest)) {
            return false;
        }
        CreateInstanceProfileRequest other = (CreateInstanceProfileRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(packageCleanup(), other.packageCleanup())
                && Objects.equals(excludeAppPackagesFromCleanup(), other.excludeAppPackagesFromCleanup())
                && Objects.equals(rebootAfterUse(), other.rebootAfterUse());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateInstanceProfileRequest").add("Name", name()).add("Description", description())
                .add("PackageCleanup", packageCleanup()).add("ExcludeAppPackagesFromCleanup", excludeAppPackagesFromCleanup())
                .add("RebootAfterUse", rebootAfterUse()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "packageCleanup":
            return Optional.ofNullable(clazz.cast(packageCleanup()));
        case "excludeAppPackagesFromCleanup":
            return Optional.ofNullable(clazz.cast(excludeAppPackagesFromCleanup()));
        case "rebootAfterUse":
            return Optional.ofNullable(clazz.cast(rebootAfterUse()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends DeviceFarmRequest.Builder, CopyableBuilder<Builder, CreateInstanceProfileRequest> {
        /**
         * <p>
         * The name of your instance profile.
         * </p>
         * 
         * @param name
         *        The name of your instance profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of your instance profile.
         * </p>
         * 
         * @param description
         *        The description of your instance profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * When set to <code>true</code>, Device Farm will remove app packages after a test run. The default value is
         * <code>false</code> for private devices.
         * </p>
         * 
         * @param packageCleanup
         *        When set to <code>true</code>, Device Farm will remove app packages after a test run. The default
         *        value is <code>false</code> for private devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageCleanup(Boolean packageCleanup);

        /**
         * <p>
         * An array of strings specifying the list of app packages that should not be cleaned up from the device after a
         * test run is over.
         * </p>
         * <p>
         * The list of packages is only considered if you set <code>packageCleanup</code> to <code>true</code>.
         * </p>
         * 
         * @param excludeAppPackagesFromCleanup
         *        An array of strings specifying the list of app packages that should not be cleaned up from the device
         *        after a test run is over.</p>
         *        <p>
         *        The list of packages is only considered if you set <code>packageCleanup</code> to <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeAppPackagesFromCleanup(Collection<String> excludeAppPackagesFromCleanup);

        /**
         * <p>
         * An array of strings specifying the list of app packages that should not be cleaned up from the device after a
         * test run is over.
         * </p>
         * <p>
         * The list of packages is only considered if you set <code>packageCleanup</code> to <code>true</code>.
         * </p>
         * 
         * @param excludeAppPackagesFromCleanup
         *        An array of strings specifying the list of app packages that should not be cleaned up from the device
         *        after a test run is over.</p>
         *        <p>
         *        The list of packages is only considered if you set <code>packageCleanup</code> to <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeAppPackagesFromCleanup(String... excludeAppPackagesFromCleanup);

        /**
         * <p>
         * When set to <code>true</code>, Device Farm will reboot the instance after a test run. The default value is
         * <code>true</code>.
         * </p>
         * 
         * @param rebootAfterUse
         *        When set to <code>true</code>, Device Farm will reboot the instance after a test run. The default
         *        value is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rebootAfterUse(Boolean rebootAfterUse);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DeviceFarmRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private Boolean packageCleanup;

        private List<String> excludeAppPackagesFromCleanup = DefaultSdkAutoConstructList.getInstance();

        private Boolean rebootAfterUse;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInstanceProfileRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            packageCleanup(model.packageCleanup);
            excludeAppPackagesFromCleanup(model.excludeAppPackagesFromCleanup);
            rebootAfterUse(model.rebootAfterUse);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getPackageCleanup() {
            return packageCleanup;
        }

        @Override
        public final Builder packageCleanup(Boolean packageCleanup) {
            this.packageCleanup = packageCleanup;
            return this;
        }

        public final void setPackageCleanup(Boolean packageCleanup) {
            this.packageCleanup = packageCleanup;
        }

        public final Collection<String> getExcludeAppPackagesFromCleanup() {
            return excludeAppPackagesFromCleanup;
        }

        @Override
        public final Builder excludeAppPackagesFromCleanup(Collection<String> excludeAppPackagesFromCleanup) {
            this.excludeAppPackagesFromCleanup = PackageIdsCopier.copy(excludeAppPackagesFromCleanup);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeAppPackagesFromCleanup(String... excludeAppPackagesFromCleanup) {
            excludeAppPackagesFromCleanup(Arrays.asList(excludeAppPackagesFromCleanup));
            return this;
        }

        public final void setExcludeAppPackagesFromCleanup(Collection<String> excludeAppPackagesFromCleanup) {
            this.excludeAppPackagesFromCleanup = PackageIdsCopier.copy(excludeAppPackagesFromCleanup);
        }

        public final Boolean getRebootAfterUse() {
            return rebootAfterUse;
        }

        @Override
        public final Builder rebootAfterUse(Boolean rebootAfterUse) {
            this.rebootAfterUse = rebootAfterUse;
            return this;
        }

        public final void setRebootAfterUse(Boolean rebootAfterUse) {
            this.rebootAfterUse = rebootAfterUse;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateInstanceProfileRequest build() {
            return new CreateInstanceProfileRequest(this);
        }
    }
}
