/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateInstanceProfileResponse extends DeviceFarmResponse implements
        ToCopyableBuilder<CreateInstanceProfileResponse.Builder, CreateInstanceProfileResponse> {
    private final InstanceProfile instanceProfile;

    private CreateInstanceProfileResponse(BuilderImpl builder) {
        super(builder);
        this.instanceProfile = builder.instanceProfile;
    }

    /**
     * <p>
     * An object containing information about your instance profile.
     * </p>
     * 
     * @return An object containing information about your instance profile.
     */
    public InstanceProfile instanceProfile() {
        return instanceProfile;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceProfile());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInstanceProfileResponse)) {
            return false;
        }
        CreateInstanceProfileResponse other = (CreateInstanceProfileResponse) obj;
        return Objects.equals(instanceProfile(), other.instanceProfile());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateInstanceProfileResponse").add("InstanceProfile", instanceProfile()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instanceProfile":
            return Optional.ofNullable(clazz.cast(instanceProfile()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends DeviceFarmResponse.Builder, CopyableBuilder<Builder, CreateInstanceProfileResponse> {
        /**
         * <p>
         * An object containing information about your instance profile.
         * </p>
         * 
         * @param instanceProfile
         *        An object containing information about your instance profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceProfile(InstanceProfile instanceProfile);

        /**
         * <p>
         * An object containing information about your instance profile.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceProfile.Builder} avoiding the need to
         * create one manually via {@link InstanceProfile#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceProfile.Builder#build()} is called immediately and its
         * result is passed to {@link #instanceProfile(InstanceProfile)}.
         * 
         * @param instanceProfile
         *        a consumer that will call methods on {@link InstanceProfile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceProfile(InstanceProfile)
         */
        default Builder instanceProfile(Consumer<InstanceProfile.Builder> instanceProfile) {
            return instanceProfile(InstanceProfile.builder().applyMutation(instanceProfile).build());
        }
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private InstanceProfile instanceProfile;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInstanceProfileResponse model) {
            super(model);
            instanceProfile(model.instanceProfile);
        }

        public final InstanceProfile.Builder getInstanceProfile() {
            return instanceProfile != null ? instanceProfile.toBuilder() : null;
        }

        @Override
        public final Builder instanceProfile(InstanceProfile instanceProfile) {
            this.instanceProfile = instanceProfile;
            return this;
        }

        public final void setInstanceProfile(InstanceProfile.BuilderImpl instanceProfile) {
            this.instanceProfile = instanceProfile != null ? instanceProfile.build() : null;
        }

        @Override
        public CreateInstanceProfileResponse build() {
            return new CreateInstanceProfileResponse(this);
        }
    }
}
