/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the result of a create upload request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateUploadResponse extends DeviceFarmResponse implements
        ToCopyableBuilder<CreateUploadResponse.Builder, CreateUploadResponse> {
    private final Upload upload;

    private CreateUploadResponse(BuilderImpl builder) {
        super(builder);
        this.upload = builder.upload;
    }

    /**
     * <p>
     * The newly created upload.
     * </p>
     * 
     * @return The newly created upload.
     */
    public Upload upload() {
        return upload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(upload());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUploadResponse)) {
            return false;
        }
        CreateUploadResponse other = (CreateUploadResponse) obj;
        return Objects.equals(upload(), other.upload());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateUploadResponse").add("Upload", upload()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "upload":
            return Optional.ofNullable(clazz.cast(upload()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends DeviceFarmResponse.Builder, CopyableBuilder<Builder, CreateUploadResponse> {
        /**
         * <p>
         * The newly created upload.
         * </p>
         * 
         * @param upload
         *        The newly created upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upload(Upload upload);

        /**
         * <p>
         * The newly created upload.
         * </p>
         * This is a convenience that creates an instance of the {@link Upload.Builder} avoiding the need to create one
         * manually via {@link Upload#builder()}.
         *
         * When the {@link Consumer} completes, {@link Upload.Builder#build()} is called immediately and its result is
         * passed to {@link #upload(Upload)}.
         * 
         * @param upload
         *        a consumer that will call methods on {@link Upload.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #upload(Upload)
         */
        default Builder upload(Consumer<Upload.Builder> upload) {
            return upload(Upload.builder().applyMutation(upload).build());
        }
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private Upload upload;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUploadResponse model) {
            super(model);
            upload(model.upload);
        }

        public final Upload.Builder getUpload() {
            return upload != null ? upload.toBuilder() : null;
        }

        @Override
        public final Builder upload(Upload upload) {
            this.upload = upload;
            return this;
        }

        public final void setUpload(Upload.BuilderImpl upload) {
            this.upload = upload != null ? upload.build() : null;
        }

        @Override
        public CreateUploadResponse build() {
            return new CreateUploadResponse(this);
        }
    }
}
