/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVpceConfigurationRequest extends DeviceFarmRequest implements
        ToCopyableBuilder<CreateVpceConfigurationRequest.Builder, CreateVpceConfigurationRequest> {
    private final String vpceConfigurationName;

    private final String vpceServiceName;

    private final String serviceDnsName;

    private final String vpceConfigurationDescription;

    private CreateVpceConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.vpceConfigurationName = builder.vpceConfigurationName;
        this.vpceServiceName = builder.vpceServiceName;
        this.serviceDnsName = builder.serviceDnsName;
        this.vpceConfigurationDescription = builder.vpceConfigurationDescription;
    }

    /**
     * <p>
     * The friendly name you give to your VPC endpoint configuration, to manage your configurations more easily.
     * </p>
     * 
     * @return The friendly name you give to your VPC endpoint configuration, to manage your configurations more easily.
     */
    public String vpceConfigurationName() {
        return vpceConfigurationName;
    }

    /**
     * <p>
     * The name of the VPC endpoint service running inside your AWS account that you want Device Farm to test.
     * </p>
     * 
     * @return The name of the VPC endpoint service running inside your AWS account that you want Device Farm to test.
     */
    public String vpceServiceName() {
        return vpceServiceName;
    }

    /**
     * <p>
     * The DNS name of the service running in your VPC that you want Device Farm to test.
     * </p>
     * 
     * @return The DNS name of the service running in your VPC that you want Device Farm to test.
     */
    public String serviceDnsName() {
        return serviceDnsName;
    }

    /**
     * <p>
     * An optional description, providing more details about your VPC endpoint configuration.
     * </p>
     * 
     * @return An optional description, providing more details about your VPC endpoint configuration.
     */
    public String vpceConfigurationDescription() {
        return vpceConfigurationDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpceConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(vpceServiceName());
        hashCode = 31 * hashCode + Objects.hashCode(serviceDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(vpceConfigurationDescription());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpceConfigurationRequest)) {
            return false;
        }
        CreateVpceConfigurationRequest other = (CreateVpceConfigurationRequest) obj;
        return Objects.equals(vpceConfigurationName(), other.vpceConfigurationName())
                && Objects.equals(vpceServiceName(), other.vpceServiceName())
                && Objects.equals(serviceDnsName(), other.serviceDnsName())
                && Objects.equals(vpceConfigurationDescription(), other.vpceConfigurationDescription());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateVpceConfigurationRequest").add("VpceConfigurationName", vpceConfigurationName())
                .add("VpceServiceName", vpceServiceName()).add("ServiceDnsName", serviceDnsName())
                .add("VpceConfigurationDescription", vpceConfigurationDescription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vpceConfigurationName":
            return Optional.ofNullable(clazz.cast(vpceConfigurationName()));
        case "vpceServiceName":
            return Optional.ofNullable(clazz.cast(vpceServiceName()));
        case "serviceDnsName":
            return Optional.ofNullable(clazz.cast(serviceDnsName()));
        case "vpceConfigurationDescription":
            return Optional.ofNullable(clazz.cast(vpceConfigurationDescription()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends DeviceFarmRequest.Builder, CopyableBuilder<Builder, CreateVpceConfigurationRequest> {
        /**
         * <p>
         * The friendly name you give to your VPC endpoint configuration, to manage your configurations more easily.
         * </p>
         * 
         * @param vpceConfigurationName
         *        The friendly name you give to your VPC endpoint configuration, to manage your configurations more
         *        easily.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpceConfigurationName(String vpceConfigurationName);

        /**
         * <p>
         * The name of the VPC endpoint service running inside your AWS account that you want Device Farm to test.
         * </p>
         * 
         * @param vpceServiceName
         *        The name of the VPC endpoint service running inside your AWS account that you want Device Farm to
         *        test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpceServiceName(String vpceServiceName);

        /**
         * <p>
         * The DNS name of the service running in your VPC that you want Device Farm to test.
         * </p>
         * 
         * @param serviceDnsName
         *        The DNS name of the service running in your VPC that you want Device Farm to test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceDnsName(String serviceDnsName);

        /**
         * <p>
         * An optional description, providing more details about your VPC endpoint configuration.
         * </p>
         * 
         * @param vpceConfigurationDescription
         *        An optional description, providing more details about your VPC endpoint configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpceConfigurationDescription(String vpceConfigurationDescription);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DeviceFarmRequest.BuilderImpl implements Builder {
        private String vpceConfigurationName;

        private String vpceServiceName;

        private String serviceDnsName;

        private String vpceConfigurationDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpceConfigurationRequest model) {
            super(model);
            vpceConfigurationName(model.vpceConfigurationName);
            vpceServiceName(model.vpceServiceName);
            serviceDnsName(model.serviceDnsName);
            vpceConfigurationDescription(model.vpceConfigurationDescription);
        }

        public final String getVpceConfigurationName() {
            return vpceConfigurationName;
        }

        @Override
        public final Builder vpceConfigurationName(String vpceConfigurationName) {
            this.vpceConfigurationName = vpceConfigurationName;
            return this;
        }

        public final void setVpceConfigurationName(String vpceConfigurationName) {
            this.vpceConfigurationName = vpceConfigurationName;
        }

        public final String getVpceServiceName() {
            return vpceServiceName;
        }

        @Override
        public final Builder vpceServiceName(String vpceServiceName) {
            this.vpceServiceName = vpceServiceName;
            return this;
        }

        public final void setVpceServiceName(String vpceServiceName) {
            this.vpceServiceName = vpceServiceName;
        }

        public final String getServiceDnsName() {
            return serviceDnsName;
        }

        @Override
        public final Builder serviceDnsName(String serviceDnsName) {
            this.serviceDnsName = serviceDnsName;
            return this;
        }

        public final void setServiceDnsName(String serviceDnsName) {
            this.serviceDnsName = serviceDnsName;
        }

        public final String getVpceConfigurationDescription() {
            return vpceConfigurationDescription;
        }

        @Override
        public final Builder vpceConfigurationDescription(String vpceConfigurationDescription) {
            this.vpceConfigurationDescription = vpceConfigurationDescription;
            return this;
        }

        public final void setVpceConfigurationDescription(String vpceConfigurationDescription) {
            this.vpceConfigurationDescription = vpceConfigurationDescription;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVpceConfigurationRequest build() {
            return new CreateVpceConfigurationRequest(this);
        }
    }
}
