/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.devicefarm.transform.CustomerArtifactPathsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A JSON object specifying the paths where the artifacts generated by the customer's tests, on the device or in the
 * test environment, will be pulled from.
 * </p>
 * <p>
 * Specify <code>deviceHostPaths</code> and optionally specify either <code>iosPaths</code> or <code>androidPaths</code>
 * .
 * </p>
 * <p>
 * For web app tests, you can specify both <code>iosPaths</code> and <code>androidPaths</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomerArtifactPaths implements StructuredPojo,
        ToCopyableBuilder<CustomerArtifactPaths.Builder, CustomerArtifactPaths> {
    private final List<String> iosPaths;

    private final List<String> androidPaths;

    private final List<String> deviceHostPaths;

    private CustomerArtifactPaths(BuilderImpl builder) {
        this.iosPaths = builder.iosPaths;
        this.androidPaths = builder.androidPaths;
        this.deviceHostPaths = builder.deviceHostPaths;
    }

    /**
     * <p>
     * Comma-separated list of paths on the iOS device where the artifacts generated by the customer's tests will be
     * pulled from.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Comma-separated list of paths on the iOS device where the artifacts generated by the customer's tests
     *         will be pulled from.
     */
    public List<String> iosPaths() {
        return iosPaths;
    }

    /**
     * <p>
     * Comma-separated list of paths on the Android device where the artifacts generated by the customer's tests will be
     * pulled from.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Comma-separated list of paths on the Android device where the artifacts generated by the customer's tests
     *         will be pulled from.
     */
    public List<String> androidPaths() {
        return androidPaths;
    }

    /**
     * <p>
     * Comma-separated list of paths in the test execution environment where the artifacts generated by the customer's
     * tests will be pulled from.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Comma-separated list of paths in the test execution environment where the artifacts generated by the
     *         customer's tests will be pulled from.
     */
    public List<String> deviceHostPaths() {
        return deviceHostPaths;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(iosPaths());
        hashCode = 31 * hashCode + Objects.hashCode(androidPaths());
        hashCode = 31 * hashCode + Objects.hashCode(deviceHostPaths());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomerArtifactPaths)) {
            return false;
        }
        CustomerArtifactPaths other = (CustomerArtifactPaths) obj;
        return Objects.equals(iosPaths(), other.iosPaths()) && Objects.equals(androidPaths(), other.androidPaths())
                && Objects.equals(deviceHostPaths(), other.deviceHostPaths());
    }

    @Override
    public String toString() {
        return ToString.builder("CustomerArtifactPaths").add("IosPaths", iosPaths()).add("AndroidPaths", androidPaths())
                .add("DeviceHostPaths", deviceHostPaths()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "iosPaths":
            return Optional.ofNullable(clazz.cast(iosPaths()));
        case "androidPaths":
            return Optional.ofNullable(clazz.cast(androidPaths()));
        case "deviceHostPaths":
            return Optional.ofNullable(clazz.cast(deviceHostPaths()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CustomerArtifactPathsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, CustomerArtifactPaths> {
        /**
         * <p>
         * Comma-separated list of paths on the iOS device where the artifacts generated by the customer's tests will be
         * pulled from.
         * </p>
         * 
         * @param iosPaths
         *        Comma-separated list of paths on the iOS device where the artifacts generated by the customer's tests
         *        will be pulled from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iosPaths(Collection<String> iosPaths);

        /**
         * <p>
         * Comma-separated list of paths on the iOS device where the artifacts generated by the customer's tests will be
         * pulled from.
         * </p>
         * 
         * @param iosPaths
         *        Comma-separated list of paths on the iOS device where the artifacts generated by the customer's tests
         *        will be pulled from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iosPaths(String... iosPaths);

        /**
         * <p>
         * Comma-separated list of paths on the Android device where the artifacts generated by the customer's tests
         * will be pulled from.
         * </p>
         * 
         * @param androidPaths
         *        Comma-separated list of paths on the Android device where the artifacts generated by the customer's
         *        tests will be pulled from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder androidPaths(Collection<String> androidPaths);

        /**
         * <p>
         * Comma-separated list of paths on the Android device where the artifacts generated by the customer's tests
         * will be pulled from.
         * </p>
         * 
         * @param androidPaths
         *        Comma-separated list of paths on the Android device where the artifacts generated by the customer's
         *        tests will be pulled from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder androidPaths(String... androidPaths);

        /**
         * <p>
         * Comma-separated list of paths in the test execution environment where the artifacts generated by the
         * customer's tests will be pulled from.
         * </p>
         * 
         * @param deviceHostPaths
         *        Comma-separated list of paths in the test execution environment where the artifacts generated by the
         *        customer's tests will be pulled from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceHostPaths(Collection<String> deviceHostPaths);

        /**
         * <p>
         * Comma-separated list of paths in the test execution environment where the artifacts generated by the
         * customer's tests will be pulled from.
         * </p>
         * 
         * @param deviceHostPaths
         *        Comma-separated list of paths in the test execution environment where the artifacts generated by the
         *        customer's tests will be pulled from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceHostPaths(String... deviceHostPaths);
    }

    static final class BuilderImpl implements Builder {
        private List<String> iosPaths = DefaultSdkAutoConstructList.getInstance();

        private List<String> androidPaths = DefaultSdkAutoConstructList.getInstance();

        private List<String> deviceHostPaths = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CustomerArtifactPaths model) {
            iosPaths(model.iosPaths);
            androidPaths(model.androidPaths);
            deviceHostPaths(model.deviceHostPaths);
        }

        public final Collection<String> getIosPaths() {
            return iosPaths;
        }

        @Override
        public final Builder iosPaths(Collection<String> iosPaths) {
            this.iosPaths = IosPathsCopier.copy(iosPaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder iosPaths(String... iosPaths) {
            iosPaths(Arrays.asList(iosPaths));
            return this;
        }

        public final void setIosPaths(Collection<String> iosPaths) {
            this.iosPaths = IosPathsCopier.copy(iosPaths);
        }

        public final Collection<String> getAndroidPaths() {
            return androidPaths;
        }

        @Override
        public final Builder androidPaths(Collection<String> androidPaths) {
            this.androidPaths = AndroidPathsCopier.copy(androidPaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder androidPaths(String... androidPaths) {
            androidPaths(Arrays.asList(androidPaths));
            return this;
        }

        public final void setAndroidPaths(Collection<String> androidPaths) {
            this.androidPaths = AndroidPathsCopier.copy(androidPaths);
        }

        public final Collection<String> getDeviceHostPaths() {
            return deviceHostPaths;
        }

        @Override
        public final Builder deviceHostPaths(Collection<String> deviceHostPaths) {
            this.deviceHostPaths = DeviceHostPathsCopier.copy(deviceHostPaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceHostPaths(String... deviceHostPaths) {
            deviceHostPaths(Arrays.asList(deviceHostPaths));
            return this;
        }

        public final void setDeviceHostPaths(Collection<String> deviceHostPaths) {
            this.deviceHostPaths = DeviceHostPathsCopier.copy(deviceHostPaths);
        }

        @Override
        public CustomerArtifactPaths build() {
            return new CustomerArtifactPaths(this);
        }
    }
}
