/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetVpceConfigurationResponse extends DeviceFarmResponse implements
        ToCopyableBuilder<GetVpceConfigurationResponse.Builder, GetVpceConfigurationResponse> {
    private final VPCEConfiguration vpceConfiguration;

    private GetVpceConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.vpceConfiguration = builder.vpceConfiguration;
    }

    /**
     * <p>
     * An object containing information about your VPC endpoint configuration.
     * </p>
     * 
     * @return An object containing information about your VPC endpoint configuration.
     */
    public VPCEConfiguration vpceConfiguration() {
        return vpceConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpceConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetVpceConfigurationResponse)) {
            return false;
        }
        GetVpceConfigurationResponse other = (GetVpceConfigurationResponse) obj;
        return Objects.equals(vpceConfiguration(), other.vpceConfiguration());
    }

    @Override
    public String toString() {
        return ToString.builder("GetVpceConfigurationResponse").add("VpceConfiguration", vpceConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vpceConfiguration":
            return Optional.ofNullable(clazz.cast(vpceConfiguration()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends DeviceFarmResponse.Builder, CopyableBuilder<Builder, GetVpceConfigurationResponse> {
        /**
         * <p>
         * An object containing information about your VPC endpoint configuration.
         * </p>
         * 
         * @param vpceConfiguration
         *        An object containing information about your VPC endpoint configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpceConfiguration(VPCEConfiguration vpceConfiguration);

        /**
         * <p>
         * An object containing information about your VPC endpoint configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link VPCEConfiguration.Builder} avoiding the need to
         * create one manually via {@link VPCEConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link VPCEConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #vpceConfiguration(VPCEConfiguration)}.
         * 
         * @param vpceConfiguration
         *        a consumer that will call methods on {@link VPCEConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpceConfiguration(VPCEConfiguration)
         */
        default Builder vpceConfiguration(Consumer<VPCEConfiguration.Builder> vpceConfiguration) {
            return vpceConfiguration(VPCEConfiguration.builder().applyMutation(vpceConfiguration).build());
        }
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private VPCEConfiguration vpceConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetVpceConfigurationResponse model) {
            super(model);
            vpceConfiguration(model.vpceConfiguration);
        }

        public final VPCEConfiguration.Builder getVpceConfiguration() {
            return vpceConfiguration != null ? vpceConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder vpceConfiguration(VPCEConfiguration vpceConfiguration) {
            this.vpceConfiguration = vpceConfiguration;
            return this;
        }

        public final void setVpceConfiguration(VPCEConfiguration.BuilderImpl vpceConfiguration) {
            this.vpceConfiguration = vpceConfiguration != null ? vpceConfiguration.build() : null;
        }

        @Override
        public GetVpceConfigurationResponse build() {
            return new GetVpceConfigurationResponse(this);
        }
    }
}
