/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.transform.JobMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a device.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Job implements StructuredPojo, ToCopyableBuilder<Job.Builder, Job> {
    private final String arn;

    private final String name;

    private final String type;

    private final Instant created;

    private final String status;

    private final String result;

    private final Instant started;

    private final Instant stopped;

    private final Counters counters;

    private final String message;

    private final Device device;

    private final String instanceArn;

    private final DeviceMinutes deviceMinutes;

    private final String videoEndpoint;

    private final Boolean videoCapture;

    private Job(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.type = builder.type;
        this.created = builder.created;
        this.status = builder.status;
        this.result = builder.result;
        this.started = builder.started;
        this.stopped = builder.stopped;
        this.counters = builder.counters;
        this.message = builder.message;
        this.device = builder.device;
        this.instanceArn = builder.instanceArn;
        this.deviceMinutes = builder.deviceMinutes;
        this.videoEndpoint = builder.videoEndpoint;
        this.videoCapture = builder.videoCapture;
    }

    /**
     * <p>
     * The job's ARN.
     * </p>
     * 
     * @return The job's ARN.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The job's name.
     * </p>
     * 
     * @return The job's name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The job's type.
     * </p>
     * <p>
     * Allowed values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * BUILTIN_FUZZ: The built-in fuzz type.
     * </p>
     * </li>
     * <li>
     * <p>
     * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it and
     * capturing screenshots at the same time.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_PYTHON: The Appium Python type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_PYTHON: The Appium Python type for Web apps.
     * </p>
     * </li>
     * <li>
     * <p>
     * CALABASH: The Calabash type.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTRUMENTATION: The Instrumentation type.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATION: The uiautomation type.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATOR: The uiautomator type.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST: The XCode test type.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST_UI: The XCode UI test type.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TestType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The job's type.</p>
     *         <p>
     *         Allowed values include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         BUILTIN_FUZZ: The built-in fuzz type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it and
     *         capturing screenshots at the same time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_PYTHON: The Appium Python type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_PYTHON: The Appium Python type for Web apps.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CALABASH: The Calabash type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTRUMENTATION: The Instrumentation type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UIAUTOMATION: The uiautomation type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UIAUTOMATOR: The uiautomator type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST: The XCode test type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST_UI: The XCode UI test type.
     *         </p>
     *         </li>
     * @see TestType
     */
    public TestType type() {
        return TestType.fromValue(type);
    }

    /**
     * <p>
     * The job's type.
     * </p>
     * <p>
     * Allowed values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * BUILTIN_FUZZ: The built-in fuzz type.
     * </p>
     * </li>
     * <li>
     * <p>
     * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it and
     * capturing screenshots at the same time.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_PYTHON: The Appium Python type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_PYTHON: The Appium Python type for Web apps.
     * </p>
     * </li>
     * <li>
     * <p>
     * CALABASH: The Calabash type.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTRUMENTATION: The Instrumentation type.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATION: The uiautomation type.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATOR: The uiautomator type.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST: The XCode test type.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST_UI: The XCode UI test type.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TestType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The job's type.</p>
     *         <p>
     *         Allowed values include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         BUILTIN_FUZZ: The built-in fuzz type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it and
     *         capturing screenshots at the same time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_PYTHON: The Appium Python type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_PYTHON: The Appium Python type for Web apps.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CALABASH: The Calabash type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTRUMENTATION: The Instrumentation type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UIAUTOMATION: The uiautomation type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UIAUTOMATOR: The uiautomator type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST: The XCode test type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST_UI: The XCode UI test type.
     *         </p>
     *         </li>
     * @see TestType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * When the job was created.
     * </p>
     * 
     * @return When the job was created.
     */
    public Instant created() {
        return created;
    }

    /**
     * <p>
     * The job's status.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING: A pending status.
     * </p>
     * </li>
     * <li>
     * <p>
     * PENDING_CONCURRENCY: A pending concurrency status.
     * </p>
     * </li>
     * <li>
     * <p>
     * PENDING_DEVICE: A pending device status.
     * </p>
     * </li>
     * <li>
     * <p>
     * PROCESSING: A processing status.
     * </p>
     * </li>
     * <li>
     * <p>
     * SCHEDULING: A scheduling status.
     * </p>
     * </li>
     * <li>
     * <p>
     * PREPARING: A preparing status.
     * </p>
     * </li>
     * <li>
     * <p>
     * RUNNING: A running status.
     * </p>
     * </li>
     * <li>
     * <p>
     * COMPLETED: A completed status.
     * </p>
     * </li>
     * <li>
     * <p>
     * STOPPING: A stopping status.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The job's status.</p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         PENDING: A pending status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PENDING_CONCURRENCY: A pending concurrency status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PENDING_DEVICE: A pending device status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PROCESSING: A processing status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SCHEDULING: A scheduling status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PREPARING: A preparing status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RUNNING: A running status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         COMPLETED: A completed status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STOPPING: A stopping status.
     *         </p>
     *         </li>
     * @see ExecutionStatus
     */
    public ExecutionStatus status() {
        return ExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * The job's status.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING: A pending status.
     * </p>
     * </li>
     * <li>
     * <p>
     * PENDING_CONCURRENCY: A pending concurrency status.
     * </p>
     * </li>
     * <li>
     * <p>
     * PENDING_DEVICE: A pending device status.
     * </p>
     * </li>
     * <li>
     * <p>
     * PROCESSING: A processing status.
     * </p>
     * </li>
     * <li>
     * <p>
     * SCHEDULING: A scheduling status.
     * </p>
     * </li>
     * <li>
     * <p>
     * PREPARING: A preparing status.
     * </p>
     * </li>
     * <li>
     * <p>
     * RUNNING: A running status.
     * </p>
     * </li>
     * <li>
     * <p>
     * COMPLETED: A completed status.
     * </p>
     * </li>
     * <li>
     * <p>
     * STOPPING: A stopping status.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The job's status.</p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         PENDING: A pending status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PENDING_CONCURRENCY: A pending concurrency status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PENDING_DEVICE: A pending device status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PROCESSING: A processing status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SCHEDULING: A scheduling status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PREPARING: A preparing status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RUNNING: A running status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         COMPLETED: A completed status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STOPPING: A stopping status.
     *         </p>
     *         </li>
     * @see ExecutionStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The job's result.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING: A pending condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * PASSED: A passing condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * WARNED: A warning condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED: A failed condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * SKIPPED: A skipped condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * ERRORED: An error condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * STOPPED: A stopped condition.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #result} will
     * return {@link ExecutionResult#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resultAsString}.
     * </p>
     * 
     * @return The job's result.</p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         PENDING: A pending condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PASSED: A passing condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WARNED: A warning condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FAILED: A failed condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SKIPPED: A skipped condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ERRORED: An error condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STOPPED: A stopped condition.
     *         </p>
     *         </li>
     * @see ExecutionResult
     */
    public ExecutionResult result() {
        return ExecutionResult.fromValue(result);
    }

    /**
     * <p>
     * The job's result.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING: A pending condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * PASSED: A passing condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * WARNED: A warning condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED: A failed condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * SKIPPED: A skipped condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * ERRORED: An error condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * STOPPED: A stopped condition.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #result} will
     * return {@link ExecutionResult#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resultAsString}.
     * </p>
     * 
     * @return The job's result.</p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         PENDING: A pending condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PASSED: A passing condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WARNED: A warning condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FAILED: A failed condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SKIPPED: A skipped condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ERRORED: An error condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STOPPED: A stopped condition.
     *         </p>
     *         </li>
     * @see ExecutionResult
     */
    public String resultAsString() {
        return result;
    }

    /**
     * <p>
     * The job's start time.
     * </p>
     * 
     * @return The job's start time.
     */
    public Instant started() {
        return started;
    }

    /**
     * <p>
     * The job's stop time.
     * </p>
     * 
     * @return The job's stop time.
     */
    public Instant stopped() {
        return stopped;
    }

    /**
     * <p>
     * The job's result counters.
     * </p>
     * 
     * @return The job's result counters.
     */
    public Counters counters() {
        return counters;
    }

    /**
     * <p>
     * A message about the job's result.
     * </p>
     * 
     * @return A message about the job's result.
     */
    public String message() {
        return message;
    }

    /**
     * <p>
     * The device (phone or tablet).
     * </p>
     * 
     * @return The device (phone or tablet).
     */
    public Device device() {
        return device;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the instance.
     */
    public String instanceArn() {
        return instanceArn;
    }

    /**
     * <p>
     * Represents the total (metered or unmetered) minutes used by the job.
     * </p>
     * 
     * @return Represents the total (metered or unmetered) minutes used by the job.
     */
    public DeviceMinutes deviceMinutes() {
        return deviceMinutes;
    }

    /**
     * <p>
     * The endpoint for streaming device video.
     * </p>
     * 
     * @return The endpoint for streaming device video.
     */
    public String videoEndpoint() {
        return videoEndpoint;
    }

    /**
     * <p>
     * This value is set to true if video capture is enabled; otherwise, it is set to false.
     * </p>
     * 
     * @return This value is set to true if video capture is enabled; otherwise, it is set to false.
     */
    public Boolean videoCapture() {
        return videoCapture;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(created());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(started());
        hashCode = 31 * hashCode + Objects.hashCode(stopped());
        hashCode = 31 * hashCode + Objects.hashCode(counters());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(device());
        hashCode = 31 * hashCode + Objects.hashCode(instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(deviceMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(videoEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(videoCapture());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Job)) {
            return false;
        }
        Job other = (Job) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(created(), other.created())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(resultAsString(), other.resultAsString()) && Objects.equals(started(), other.started())
                && Objects.equals(stopped(), other.stopped()) && Objects.equals(counters(), other.counters())
                && Objects.equals(message(), other.message()) && Objects.equals(device(), other.device())
                && Objects.equals(instanceArn(), other.instanceArn()) && Objects.equals(deviceMinutes(), other.deviceMinutes())
                && Objects.equals(videoEndpoint(), other.videoEndpoint()) && Objects.equals(videoCapture(), other.videoCapture());
    }

    @Override
    public String toString() {
        return ToString.builder("Job").add("Arn", arn()).add("Name", name()).add("Type", typeAsString())
                .add("Created", created()).add("Status", statusAsString()).add("Result", resultAsString())
                .add("Started", started()).add("Stopped", stopped()).add("Counters", counters()).add("Message", message())
                .add("Device", device()).add("InstanceArn", instanceArn()).add("DeviceMinutes", deviceMinutes())
                .add("VideoEndpoint", videoEndpoint()).add("VideoCapture", videoCapture()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "created":
            return Optional.ofNullable(clazz.cast(created()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "result":
            return Optional.ofNullable(clazz.cast(resultAsString()));
        case "started":
            return Optional.ofNullable(clazz.cast(started()));
        case "stopped":
            return Optional.ofNullable(clazz.cast(stopped()));
        case "counters":
            return Optional.ofNullable(clazz.cast(counters()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "device":
            return Optional.ofNullable(clazz.cast(device()));
        case "instanceArn":
            return Optional.ofNullable(clazz.cast(instanceArn()));
        case "deviceMinutes":
            return Optional.ofNullable(clazz.cast(deviceMinutes()));
        case "videoEndpoint":
            return Optional.ofNullable(clazz.cast(videoEndpoint()));
        case "videoCapture":
            return Optional.ofNullable(clazz.cast(videoCapture()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Job> {
        /**
         * <p>
         * The job's ARN.
         * </p>
         * 
         * @param arn
         *        The job's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The job's name.
         * </p>
         * 
         * @param name
         *        The job's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The job's type.
         * </p>
         * <p>
         * Allowed values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * BUILTIN_FUZZ: The built-in fuzz type.
         * </p>
         * </li>
         * <li>
         * <p>
         * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it and
         * capturing screenshots at the same time.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_PYTHON: The Appium Python type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_PYTHON: The Appium Python type for Web apps.
         * </p>
         * </li>
         * <li>
         * <p>
         * CALABASH: The Calabash type.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTRUMENTATION: The Instrumentation type.
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATION: The uiautomation type.
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATOR: The uiautomator type.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST: The XCode test type.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST_UI: The XCode UI test type.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The job's type.</p>
         *        <p>
         *        Allowed values include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        BUILTIN_FUZZ: The built-in fuzz type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it
         *        and capturing screenshots at the same time.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_PYTHON: The Appium Python type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_PYTHON: The Appium Python type for Web apps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CALABASH: The Calabash type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTRUMENTATION: The Instrumentation type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATION: The uiautomation type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATOR: The uiautomator type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST: The XCode test type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST_UI: The XCode UI test type.
         *        </p>
         *        </li>
         * @see TestType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestType
         */
        Builder type(String type);

        /**
         * <p>
         * The job's type.
         * </p>
         * <p>
         * Allowed values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * BUILTIN_FUZZ: The built-in fuzz type.
         * </p>
         * </li>
         * <li>
         * <p>
         * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it and
         * capturing screenshots at the same time.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_PYTHON: The Appium Python type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_PYTHON: The Appium Python type for Web apps.
         * </p>
         * </li>
         * <li>
         * <p>
         * CALABASH: The Calabash type.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTRUMENTATION: The Instrumentation type.
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATION: The uiautomation type.
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATOR: The uiautomator type.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST: The XCode test type.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST_UI: The XCode UI test type.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The job's type.</p>
         *        <p>
         *        Allowed values include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        BUILTIN_FUZZ: The built-in fuzz type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it
         *        and capturing screenshots at the same time.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_PYTHON: The Appium Python type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_PYTHON: The Appium Python type for Web apps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CALABASH: The Calabash type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTRUMENTATION: The Instrumentation type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATION: The uiautomation type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATOR: The uiautomator type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST: The XCode test type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST_UI: The XCode UI test type.
         *        </p>
         *        </li>
         * @see TestType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestType
         */
        Builder type(TestType type);

        /**
         * <p>
         * When the job was created.
         * </p>
         * 
         * @param created
         *        When the job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder created(Instant created);

        /**
         * <p>
         * The job's status.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING: A pending status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PENDING_CONCURRENCY: A pending concurrency status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PENDING_DEVICE: A pending device status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PROCESSING: A processing status.
         * </p>
         * </li>
         * <li>
         * <p>
         * SCHEDULING: A scheduling status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PREPARING: A preparing status.
         * </p>
         * </li>
         * <li>
         * <p>
         * RUNNING: A running status.
         * </p>
         * </li>
         * <li>
         * <p>
         * COMPLETED: A completed status.
         * </p>
         * </li>
         * <li>
         * <p>
         * STOPPING: A stopping status.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The job's status.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING: A pending status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PENDING_CONCURRENCY: A pending concurrency status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PENDING_DEVICE: A pending device status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PROCESSING: A processing status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SCHEDULING: A scheduling status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PREPARING: A preparing status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RUNNING: A running status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        COMPLETED: A completed status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOPPING: A stopping status.
         *        </p>
         *        </li>
         * @see ExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The job's status.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING: A pending status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PENDING_CONCURRENCY: A pending concurrency status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PENDING_DEVICE: A pending device status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PROCESSING: A processing status.
         * </p>
         * </li>
         * <li>
         * <p>
         * SCHEDULING: A scheduling status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PREPARING: A preparing status.
         * </p>
         * </li>
         * <li>
         * <p>
         * RUNNING: A running status.
         * </p>
         * </li>
         * <li>
         * <p>
         * COMPLETED: A completed status.
         * </p>
         * </li>
         * <li>
         * <p>
         * STOPPING: A stopping status.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The job's status.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING: A pending status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PENDING_CONCURRENCY: A pending concurrency status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PENDING_DEVICE: A pending device status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PROCESSING: A processing status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SCHEDULING: A scheduling status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PREPARING: A preparing status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RUNNING: A running status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        COMPLETED: A completed status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOPPING: A stopping status.
         *        </p>
         *        </li>
         * @see ExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder status(ExecutionStatus status);

        /**
         * <p>
         * The job's result.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING: A pending condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * PASSED: A passing condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * WARNED: A warning condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * FAILED: A failed condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * SKIPPED: A skipped condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * ERRORED: An error condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * STOPPED: A stopped condition.
         * </p>
         * </li>
         * </ul>
         * 
         * @param result
         *        The job's result.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING: A pending condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PASSED: A passing condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        WARNED: A warning condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FAILED: A failed condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SKIPPED: A skipped condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ERRORED: An error condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOPPED: A stopped condition.
         *        </p>
         *        </li>
         * @see ExecutionResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionResult
         */
        Builder result(String result);

        /**
         * <p>
         * The job's result.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING: A pending condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * PASSED: A passing condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * WARNED: A warning condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * FAILED: A failed condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * SKIPPED: A skipped condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * ERRORED: An error condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * STOPPED: A stopped condition.
         * </p>
         * </li>
         * </ul>
         * 
         * @param result
         *        The job's result.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING: A pending condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PASSED: A passing condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        WARNED: A warning condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FAILED: A failed condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SKIPPED: A skipped condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ERRORED: An error condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOPPED: A stopped condition.
         *        </p>
         *        </li>
         * @see ExecutionResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionResult
         */
        Builder result(ExecutionResult result);

        /**
         * <p>
         * The job's start time.
         * </p>
         * 
         * @param started
         *        The job's start time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder started(Instant started);

        /**
         * <p>
         * The job's stop time.
         * </p>
         * 
         * @param stopped
         *        The job's stop time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopped(Instant stopped);

        /**
         * <p>
         * The job's result counters.
         * </p>
         * 
         * @param counters
         *        The job's result counters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder counters(Counters counters);

        /**
         * <p>
         * The job's result counters.
         * </p>
         * This is a convenience that creates an instance of the {@link Counters.Builder} avoiding the need to create
         * one manually via {@link Counters#builder()}.
         *
         * When the {@link Consumer} completes, {@link Counters.Builder#build()} is called immediately and its result is
         * passed to {@link #counters(Counters)}.
         * 
         * @param counters
         *        a consumer that will call methods on {@link Counters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #counters(Counters)
         */
        default Builder counters(Consumer<Counters.Builder> counters) {
            return counters(Counters.builder().applyMutation(counters).build());
        }

        /**
         * <p>
         * A message about the job's result.
         * </p>
         * 
         * @param message
         *        A message about the job's result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The device (phone or tablet).
         * </p>
         * 
         * @param device
         *        The device (phone or tablet).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder device(Device device);

        /**
         * <p>
         * The device (phone or tablet).
         * </p>
         * This is a convenience that creates an instance of the {@link Device.Builder} avoiding the need to create one
         * manually via {@link Device#builder()}.
         *
         * When the {@link Consumer} completes, {@link Device.Builder#build()} is called immediately and its result is
         * passed to {@link #device(Device)}.
         * 
         * @param device
         *        a consumer that will call methods on {@link Device.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #device(Device)
         */
        default Builder device(Consumer<Device.Builder> device) {
            return device(Device.builder().applyMutation(device).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param instanceArn
         *        The Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceArn(String instanceArn);

        /**
         * <p>
         * Represents the total (metered or unmetered) minutes used by the job.
         * </p>
         * 
         * @param deviceMinutes
         *        Represents the total (metered or unmetered) minutes used by the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceMinutes(DeviceMinutes deviceMinutes);

        /**
         * <p>
         * Represents the total (metered or unmetered) minutes used by the job.
         * </p>
         * This is a convenience that creates an instance of the {@link DeviceMinutes.Builder} avoiding the need to
         * create one manually via {@link DeviceMinutes#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeviceMinutes.Builder#build()} is called immediately and its
         * result is passed to {@link #deviceMinutes(DeviceMinutes)}.
         * 
         * @param deviceMinutes
         *        a consumer that will call methods on {@link DeviceMinutes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceMinutes(DeviceMinutes)
         */
        default Builder deviceMinutes(Consumer<DeviceMinutes.Builder> deviceMinutes) {
            return deviceMinutes(DeviceMinutes.builder().applyMutation(deviceMinutes).build());
        }

        /**
         * <p>
         * The endpoint for streaming device video.
         * </p>
         * 
         * @param videoEndpoint
         *        The endpoint for streaming device video.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder videoEndpoint(String videoEndpoint);

        /**
         * <p>
         * This value is set to true if video capture is enabled; otherwise, it is set to false.
         * </p>
         * 
         * @param videoCapture
         *        This value is set to true if video capture is enabled; otherwise, it is set to false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder videoCapture(Boolean videoCapture);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String type;

        private Instant created;

        private String status;

        private String result;

        private Instant started;

        private Instant stopped;

        private Counters counters;

        private String message;

        private Device device;

        private String instanceArn;

        private DeviceMinutes deviceMinutes;

        private String videoEndpoint;

        private Boolean videoCapture;

        private BuilderImpl() {
        }

        private BuilderImpl(Job model) {
            arn(model.arn);
            name(model.name);
            type(model.type);
            created(model.created);
            status(model.status);
            result(model.result);
            started(model.started);
            stopped(model.stopped);
            counters(model.counters);
            message(model.message);
            device(model.device);
            instanceArn(model.instanceArn);
            deviceMinutes(model.deviceMinutes);
            videoEndpoint(model.videoEndpoint);
            videoCapture(model.videoCapture);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TestType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Instant getCreated() {
            return created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExecutionStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getResult() {
            return result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        @Override
        public final Builder result(ExecutionResult result) {
            this.result(result.toString());
            return this;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        public final Instant getStarted() {
            return started;
        }

        @Override
        public final Builder started(Instant started) {
            this.started = started;
            return this;
        }

        public final void setStarted(Instant started) {
            this.started = started;
        }

        public final Instant getStopped() {
            return stopped;
        }

        @Override
        public final Builder stopped(Instant stopped) {
            this.stopped = stopped;
            return this;
        }

        public final void setStopped(Instant stopped) {
            this.stopped = stopped;
        }

        public final Counters.Builder getCounters() {
            return counters != null ? counters.toBuilder() : null;
        }

        @Override
        public final Builder counters(Counters counters) {
            this.counters = counters;
            return this;
        }

        public final void setCounters(Counters.BuilderImpl counters) {
            this.counters = counters != null ? counters.build() : null;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Device.Builder getDevice() {
            return device != null ? device.toBuilder() : null;
        }

        @Override
        public final Builder device(Device device) {
            this.device = device;
            return this;
        }

        public final void setDevice(Device.BuilderImpl device) {
            this.device = device != null ? device.build() : null;
        }

        public final String getInstanceArn() {
            return instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        public final DeviceMinutes.Builder getDeviceMinutes() {
            return deviceMinutes != null ? deviceMinutes.toBuilder() : null;
        }

        @Override
        public final Builder deviceMinutes(DeviceMinutes deviceMinutes) {
            this.deviceMinutes = deviceMinutes;
            return this;
        }

        public final void setDeviceMinutes(DeviceMinutes.BuilderImpl deviceMinutes) {
            this.deviceMinutes = deviceMinutes != null ? deviceMinutes.build() : null;
        }

        public final String getVideoEndpoint() {
            return videoEndpoint;
        }

        @Override
        public final Builder videoEndpoint(String videoEndpoint) {
            this.videoEndpoint = videoEndpoint;
            return this;
        }

        public final void setVideoEndpoint(String videoEndpoint) {
            this.videoEndpoint = videoEndpoint;
        }

        public final Boolean getVideoCapture() {
            return videoCapture;
        }

        @Override
        public final Builder videoCapture(Boolean videoCapture) {
            this.videoCapture = videoCapture;
            return this;
        }

        public final void setVideoCapture(Boolean videoCapture) {
            this.videoCapture = videoCapture;
        }

        @Override
        public Job build() {
            return new Job(this);
        }
    }
}
