/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the result of a list artifacts operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListArtifactsResponse extends DeviceFarmResponse implements
        ToCopyableBuilder<ListArtifactsResponse.Builder, ListArtifactsResponse> {
    private final List<Artifact> artifacts;

    private final String nextToken;

    private ListArtifactsResponse(BuilderImpl builder) {
        super(builder);
        this.artifacts = builder.artifacts;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about the artifacts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the artifacts.
     */
    public List<Artifact> artifacts() {
        return artifacts;
    }

    /**
     * <p>
     * If the number of items that are returned is significantly large, this is an identifier that is also returned,
     * which can be used in a subsequent call to this operation to return the next set of items in the list.
     * </p>
     * 
     * @return If the number of items that are returned is significantly large, this is an identifier that is also
     *         returned, which can be used in a subsequent call to this operation to return the next set of items in the
     *         list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(artifacts());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListArtifactsResponse)) {
            return false;
        }
        ListArtifactsResponse other = (ListArtifactsResponse) obj;
        return Objects.equals(artifacts(), other.artifacts()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListArtifactsResponse").add("Artifacts", artifacts()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "artifacts":
            return Optional.ofNullable(clazz.cast(artifacts()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends DeviceFarmResponse.Builder, CopyableBuilder<Builder, ListArtifactsResponse> {
        /**
         * <p>
         * Information about the artifacts.
         * </p>
         * 
         * @param artifacts
         *        Information about the artifacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifacts(Collection<Artifact> artifacts);

        /**
         * <p>
         * Information about the artifacts.
         * </p>
         * 
         * @param artifacts
         *        Information about the artifacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifacts(Artifact... artifacts);

        /**
         * <p>
         * Information about the artifacts.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Artifact>.Builder} avoiding the need to
         * create one manually via {@link List<Artifact>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Artifact>.Builder#build()} is called immediately and its
         * result is passed to {@link #artifacts(List<Artifact>)}.
         * 
         * @param artifacts
         *        a consumer that will call methods on {@link List<Artifact>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #artifacts(List<Artifact>)
         */
        Builder artifacts(Consumer<Artifact.Builder>... artifacts);

        /**
         * <p>
         * If the number of items that are returned is significantly large, this is an identifier that is also returned,
         * which can be used in a subsequent call to this operation to return the next set of items in the list.
         * </p>
         * 
         * @param nextToken
         *        If the number of items that are returned is significantly large, this is an identifier that is also
         *        returned, which can be used in a subsequent call to this operation to return the next set of items in
         *        the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private List<Artifact> artifacts = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListArtifactsResponse model) {
            super(model);
            artifacts(model.artifacts);
            nextToken(model.nextToken);
        }

        public final Collection<Artifact.Builder> getArtifacts() {
            return artifacts != null ? artifacts.stream().map(Artifact::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder artifacts(Collection<Artifact> artifacts) {
            this.artifacts = ArtifactsCopier.copy(artifacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder artifacts(Artifact... artifacts) {
            artifacts(Arrays.asList(artifacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder artifacts(Consumer<Artifact.Builder>... artifacts) {
            artifacts(Stream.of(artifacts).map(c -> Artifact.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setArtifacts(Collection<Artifact.BuilderImpl> artifacts) {
            this.artifacts = ArtifactsCopier.copyFromBuilder(artifacts);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListArtifactsResponse build() {
            return new ListArtifactsResponse(this);
        }
    }
}
