/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDeviceInstancesResponse extends DeviceFarmResponse implements
        ToCopyableBuilder<ListDeviceInstancesResponse.Builder, ListDeviceInstancesResponse> {
    private final List<DeviceInstance> deviceInstances;

    private final String nextToken;

    private ListDeviceInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.deviceInstances = builder.deviceInstances;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * An object containing information about your device instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An object containing information about your device instances.
     */
    public List<DeviceInstance> deviceInstances() {
        return deviceInstances;
    }

    /**
     * <p>
     * An identifier that can be used in the next call to this operation to return the next set of items in the list.
     * </p>
     * 
     * @return An identifier that can be used in the next call to this operation to return the next set of items in the
     *         list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deviceInstances());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeviceInstancesResponse)) {
            return false;
        }
        ListDeviceInstancesResponse other = (ListDeviceInstancesResponse) obj;
        return Objects.equals(deviceInstances(), other.deviceInstances()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListDeviceInstancesResponse").add("DeviceInstances", deviceInstances())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deviceInstances":
            return Optional.ofNullable(clazz.cast(deviceInstances()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends DeviceFarmResponse.Builder, CopyableBuilder<Builder, ListDeviceInstancesResponse> {
        /**
         * <p>
         * An object containing information about your device instances.
         * </p>
         * 
         * @param deviceInstances
         *        An object containing information about your device instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceInstances(Collection<DeviceInstance> deviceInstances);

        /**
         * <p>
         * An object containing information about your device instances.
         * </p>
         * 
         * @param deviceInstances
         *        An object containing information about your device instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceInstances(DeviceInstance... deviceInstances);

        /**
         * <p>
         * An object containing information about your device instances.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DeviceInstance>.Builder} avoiding the need
         * to create one manually via {@link List<DeviceInstance>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DeviceInstance>.Builder#build()} is called immediately and
         * its result is passed to {@link #deviceInstances(List<DeviceInstance>)}.
         * 
         * @param deviceInstances
         *        a consumer that will call methods on {@link List<DeviceInstance>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceInstances(List<DeviceInstance>)
         */
        Builder deviceInstances(Consumer<DeviceInstance.Builder>... deviceInstances);

        /**
         * <p>
         * An identifier that can be used in the next call to this operation to return the next set of items in the
         * list.
         * </p>
         * 
         * @param nextToken
         *        An identifier that can be used in the next call to this operation to return the next set of items in
         *        the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private List<DeviceInstance> deviceInstances = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeviceInstancesResponse model) {
            super(model);
            deviceInstances(model.deviceInstances);
            nextToken(model.nextToken);
        }

        public final Collection<DeviceInstance.Builder> getDeviceInstances() {
            return deviceInstances != null ? deviceInstances.stream().map(DeviceInstance::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder deviceInstances(Collection<DeviceInstance> deviceInstances) {
            this.deviceInstances = DeviceInstancesCopier.copy(deviceInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceInstances(DeviceInstance... deviceInstances) {
            deviceInstances(Arrays.asList(deviceInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceInstances(Consumer<DeviceInstance.Builder>... deviceInstances) {
            deviceInstances(Stream.of(deviceInstances).map(c -> DeviceInstance.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDeviceInstances(Collection<DeviceInstance.BuilderImpl> deviceInstances) {
            this.deviceInstances = DeviceInstancesCopier.copyFromBuilder(deviceInstances);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDeviceInstancesResponse build() {
            return new ListDeviceInstancesResponse(this);
        }
    }
}
